#include "config.h"
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <sys/time.h>
#include <allegro.h>
#include "domin.h"
#include "albgi.h"
#include "dsound.h"
#include "fonts.h"

#define NUM_BAR_MUL 12
#define NUM_BAR_X 64
#define FLAIR_MS 8000.
#define FADE_MS 3200.
#define SCROLLON_MS 800.

extern BITMAP *buffer, *domin_splash;

void domin_intro() {
	set_mood(GM_TITLE);
        float dir_flipflop = 1.0;
	BITMAP *cutter = create_bitmap(NUM_BAR_X, NUM_BAR_MUL);
	static float bar_mul[NUM_BAR_MUL] = {
		-1.208,1.410,
		-1.307,1.277,
		-1.250,1.331,
		-1.100,1.675,
		-1.470,1.200,
		-1.500,1.090
	};
        static char *credits[] = {
        	"Code: Eric Killeen",
        	"Graphics: Jason Killeen",
        	"Sound FX: Eric Killeen",
        	"Music: Eric Killeen",
        	"Emotional Support: Nathan \"Big Nate\" Killeen",
        	"Graphics Lib: Allegro (http://alleg.sf.net/)",
        	"Mod playing Lib: DUMB (http://dumb.sf.net/)",
        	"HAVE FUN!",
        	0
        };
	int start_ms = ms_count;
	float t;
	clear_to_color(cutter,1);
	textout_centre_ex(cutter, font, "DOMIN", NUM_BAR_X / 2, 0, 0, -1);
	int psiz = SCREEN_W / NUM_BAR_X;
        do {
               	clear(buffer);
               	// set_trans_blender(0,0,0,0x10);
                //draw_trans_sprite(buffer,domin_splash,0,0);
               	//for (int x = 2; x < SCREEN_W; x += 4) vline(buffer,x,0,SCREEN_H,GhostGreen);
                t = (FLAIR_MS - (ms_count - start_ms)) / FLAIR_MS;
                if (t < 0.) t = 0.;
        	for (int y = 0; y < NUM_BAR_MUL; y++) for (int x = 0; x < NUM_BAR_X; x++) {
			if (getpixel(cutter,x,y) == 0) {
				int ox = (psiz * x) + (int)(floor(bar_mul[y] * SCREEN_W * t));
				int oy = (psiz * y) + SCREEN_H / 3;
				blit(domin_splash,buffer,ox,oy,ox,oy,psiz,psiz);
			}
        	}
		check_sound();
                if (keypressed()) goto exit_domin_intro;
                blit(buffer, screen, 0,0,0,0, SCREEN_W, SCREEN_H);
        } while (t > 0.);
        for (char **str=credits; *str; str++) {
        	start_ms = ms_count;
        	do {
                	check_sound();
                	if (keypressed()) goto exit_domin_intro;
        	} while (ms_count - start_ms < 400);
        	start_ms = ms_count;
        	do {
        		t = (SCROLLON_MS - (ms_count - start_ms)) / SCROLLON_MS;
                	if (t < 0.) t = 0.;
                	int oy = 2 * SCREEN_H / 3;
                        int ox = (int)(floor((SCREEN_W / 2.) + ( SCREEN_W  * t * dir_flipflop)));
                        rectfill(buffer,0,oy, SCREEN_W, oy + 20, Black);
                        textout_centre_ex(buffer, &font_bold, *str, ox, oy, White, -1);
                        blit(buffer, screen, 0,0,0,0, SCREEN_W, SCREEN_H);
			check_sound();
                	if (keypressed()) goto exit_domin_intro;

        	} while (t > 0.);
        	start_ms = ms_count;
        	do {
                	check_sound();
                	if (keypressed()) goto exit_domin_intro;
        	} while (ms_count - start_ms < 1200);
        	start_ms = ms_count;
        	do {
        		t = 1. - ((SCROLLON_MS - (ms_count - start_ms)) / SCROLLON_MS);
                	int oy = 2 * SCREEN_H / 3;
                        int ox = (int)(floor((SCREEN_W / 2.) + ( SCREEN_W * t * dir_flipflop)));
                        rectfill(buffer,0,oy, SCREEN_W, oy + 20, Black);
                        textout_centre_ex(buffer, &font_bold, *str, ox, oy, White, -1);
                        blit(buffer, screen, 0,0,0,0, SCREEN_W, SCREEN_H);
			check_sound();
                	if (keypressed()) goto exit_domin_intro;
        	} while (t < 1.);
                dir_flipflop *= -1.0;
        }
        start_ms = ms_count;
        do {
                t = (FADE_MS - (ms_count - start_ms)) / FADE_MS;
                if (t < 0.) t = 0.;
		clear(buffer);
               	set_trans_blender(0,0,0,255 - (int)floor(254. * t));
                draw_trans_sprite(buffer,domin_splash,0,0);
               	if (t < 0.) t = 0.;
        	for (int y = 0; y < NUM_BAR_MUL; y++) for (int x = 0; x < NUM_BAR_X; x++) {
			if (getpixel(cutter,x,y) == 0) {
				int ox = (psiz * x);
				int oy = (psiz * y) + SCREEN_H / 3;
				blit(domin_splash,buffer,ox,oy,ox,oy,psiz,psiz);
			}
        	}
		check_sound();
                if (keypressed()) goto exit_domin_intro;
                blit(buffer, screen, 0,0,0,0, SCREEN_W, SCREEN_H);
        } while (t > 0.);
exit_domin_intro:
        blit(domin_splash,buffer, 0,0,0,0, SCREEN_W, SCREEN_H);
	blit(domin_splash,screen, 0,0,0,0, SCREEN_W, SCREEN_H);
	destroy_bitmap(cutter);
}

