#ifndef _domin_h
#define _domin_h 1

#define maxsq           12
#define maxplayers      6
#define maxpiecesowned  7
#define numele          17
#define activeele       12
//897-0473
#define normalele       6
#define NUMLOGENTS	33

#define DOMIN_AI(f) void f(ai_move &move, BOARD *brd, int cplayer, int ai_var)
#define DOMIN_AI_LE DOMIN_AI((*))


typedef enum ptyp {
  none, wind, wood, rock, fire, water, ice, metal, ltning, anti, morph, xenon,
  wild, cross, skip, reverse, schange, bonus
};

typedef enum crosstyp {
     ct_none, ct_random, ct_one_xenon, ct_x2, ct_new_hand,
     ct_swap_cards, ct_gamble12, ct_three_wilds, ct_all_xenon,
     ct_clear, ct_gamble18, ct_two_lightnigs, ct_x3,
     ct_plus_two, ct_plus_five, ct_plus_ten, ct_double_or_nothing
};

typedef struct spot {
  ptyp t; int w, m; struct aspath *frame; int time_chk, do_sound, sound_time_chk, sound_vol;
};

typedef struct ai_move {
  int play_card, play_x, play_y, cross_choice, wild_choice,
  gamble_choice, season_choice, worst_enemy, hate_element, swap_with;
};

class BOARD {
   private:
     spot board[maxsq][maxsq];
     int  lmap[maxsq][maxsq];
     int  scores[maxplayers + 1];
     int  push(int t1, int t2, int x, int y, int ox, int oy);
     int  affectaround(int x, int y, int ox, int oy, int aff);
     void actoncard(int x, int y);
     void lightning_mark(int x, int y);
     void lightning_actoncard(int x, int y);
     void recalcscores();
   public:
     void draw();
     BOARD *copy();
     spot get_spot(int x, int y, int &off_board);
     int  whatis(int x, int y);
     int  put_spot(spot card, int x, int y);
     void save_scores(int *sk);
     void clear_of(int remove);
     void season_change(int sc);
     BOARD(int do_init = 1);
};


typedef class GAMELOG {
   private:
      int dirty;
      char *glog[NUMLOGENTS];
   public:
      GAMELOG() { for (int c = 0; c <NUMLOGENTS; c++) glog[c] = NULL; printf("gamelog created\n");};
      ~GAMELOG() { for (int c = 0; c <NUMLOGENTS; c++) if (glog[c]) free(glog[c] ); };
      void add(char *s);
      void draw();
};

typedef struct playertyp {
  char name[26];
  DOMIN_AI( (*ai_func)); int ai_var; void *ai_user_data; int ai_user_data_size;
  int k,  p, otr;
  spot got[maxpiecesowned];
};

extern int numsq, piecesowned, numplayers, msize, ai_wait_timing, fast_spinner,
          ai_test, enable_sound, enable_music, sound_vol,
          music_vol, music_buffer_size,  music_freq,
          default_screen_w, default_screen_h, prefer_windowed;
extern char music_dir[200], data_dir[200], scr_shot_dir[200], home_dir[200];
extern playertyp player[maxplayers + 1];
extern volatile int ms_count;
void check_screen_shot();
void game_rest(int ms);
void reinit_graphics();

#endif
