#include "config.h"
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <sys/time.h>
#include <allegro.h>
#include "domin.h"
#include "domin_ai.h"
#include "albgi.h"
#include "qfe.h"
#include "dsound.h"
#include "anim.h"
#include "fonts.h"

typedef struct pointtype { int x, y;};
int moves =0;
DATAFILE *sprites;
BITMAP *buffer;
int numsq = 6, piecesowned = 3, numplayers = 2, msize = 3;
int ai_test, ai_wait_timing,  enable_sound, enable_music, fast_spinner,
    sound_vol, music_vol, music_buffer_size,  music_freq,
    default_screen_w, default_screen_h, prefer_windowed;


char music_dir[200], data_dir[200], scr_shot_dir[200], home_dir[200] = "./";

int carddrop, player_cards_left = 90;
playertyp player[maxplayers + 1];
int cplayer, playdir;

#ifdef NEW_SPRITES
#define BORDER_EDGE 6
#define sqwid (((BITMAP *)(sprites[0].dat))->w + BORDER_EDGE)
#define sqhi (((BITMAP *)(sprites[0].dat))->h + BORDER_EDGE)
#define GAMELOG_X (SCREEN_W - 190)
static int top = 20, left = 20;
#else
static int sqwid = 38, sqhi = 25, top = 20, left = 20;
#endif

static char dominstr[] = "Domin v" VERSION " by Eric Killeen 1997, 2004";
static int  want_to_quit;

volatile int ms_count = 0, fps = 0, frame_count = 0;;

int do_scr_shot;

static spot emptysq = {
  none, 0, 1
};

static char *piecestr[] = {
  "empty", "wind", "wood", "rock", "fire", "water", "ice", "metal",
  "lightning", "antimatter", "morph", "xenon", "wild", "cross", "skip",
  "reverse", "season change", "bonus"
};


ptyp activitym[activeele + 1][activeele + 1] = {
         /*(none,wind  ,wood ,rock ,fire  ,water,ice  ,metal,ltning,anti,morph ,xenon,wild)*/
/*none*/  { none, wind, wood, rock, fire, water, ice,   metal, none, none, none, xenon,   wild },
/*wind*/  { none, wind, wood, rock, fire, ice,   ice,   metal, none, none, none, xenon,    wild },
/*wood*/  { none, none, wood, rock, fire, wood,  ice,   metal, none, none, none, xenon,    wild },
/*rock*/  { none, wind, wood, rock, fire, water, ice,   metal, none, none, none, xenon,    wild },
/*fire*/  { none, wind, fire, rock, fire, water, water, metal, none, none, none,    xenon, wild },
/*water*/ { none, wind, wood, rock, none, water, ice,   none, none, none, none, xenon,    wild },
/*ice*/   { none, wind, none, none, fire, water, ice,   metal, none, none, none, xenon,    wild },
/*metal*/ { none, wind, wood, none, fire, water, none,  metal, none, none, none, xenon,    wild },
/*ltng*/  { none, water,fire, none, fire, wind,  water, metal, ltning, none, none,    xenon, wild },
/*anti*/  { none, none, none, none, none, none, none, none, none, anti, none, xenon,    none },
/*morph*/ { none, morph, morph, morph, morph,    morph, morph, morph, none, none, none,   xenon, wild },
/*xenon*/ { none, wind, wood, rock, fire, water, ice,   metal, none, none, none, xenon,   wild },
/*wild*/  { none, wind, wood, rock, fire, water, ice,   metal, none, none, none, xenon,   wild }
};


int card_points[numele + 1] = {
  0, 1, 3, 3, 2, 1, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3
};

int pcolors[numele + 1], playerc[maxplayers + 1];




static struct ai_move npc_move;
static int tiredofplaying;
static int moscol, mosrow, mosbut;
static int choice;
static int gamedone;
static int insubhelp;


static BITMAP *picture[numele +1];
static BITMAP *mouse_arrow;
BITMAP *domin_splash, *domin_play_arrow;

static void draw_spot(spot *WITH, int x, int y, int force_dirty);


BOARD *gameboard;
GAMELOG *gamelog;

//============================================================================
void GAMELOG::add(char *s) {
	free(glog[NUMLOGENTS-1]);
	for (int c = NUMLOGENTS-1; c > 0; c--) glog[c] = glog[c - 1];
	glog[0] = strdup(s);
	printf("> %s\n", glog[0]);
}

void GAMELOG::draw() {
	if (!ai_test) {
	blit(domin_splash, buffer, GAMELOG_X, top, GAMELOG_X,  top , 220, SCREEN_H - top);
        drawing_mode(DRAW_MODE_TRANS, NULL, 0,0);
	for (int cy = 0; cy < NUMLOGENTS; cy++) {
             if (glog[cy]) {
   		int inten = 255 - (cy < NUMLOGENTS - 8 ? 0 : (NUMLOGENTS - cy) * 32);
		set_trans_blender(inten,inten,inten,inten );
	  	textout_ex(buffer, &font_super_micro, glog[cy], GAMELOG_X, SCREEN_H - (60 + (cy * 12)), White, -1);
	     }
	}
	solid_mode();
	}
}

//============================================================================
BOARD::BOARD(int do_init) {
  if (do_init) for (int cx = 0; cx < numsq; cx++) for (int cy = 0; cy < numsq; cy++) {
      spot *WITH = &board[cx][cy];
      WITH->t = ptyp(_randint(40));
      if (WITH->t > normalele) WITH->t = none;
      WITH->frame = ani_start_list[WITH->t];
      WITH->time_chk = ms_count;
      WITH->do_sound = -1;
      WITH->sound_vol = WITH->sound_time_chk = 0;
      WITH->m = 1;
      WITH->w = 0;
  }
  recalcscores();
}

BOARD *BOARD::copy() {
        BOARD *bc = new BOARD();
        memcpy((void *)bc->board, (void *)board, sizeof board);
	return (bc);
}

static int between(int i, int lo, int hi) { return (lo <= i && i <= hi);}

void BOARD::draw() {
	for (int cx = 0; cx < numsq; cx++) {
		for (int cy = 0; cy < numsq; cy++) {
			spot *WITH = &board[cx][cy];
			draw_spot(WITH,(cx) * sqwid + left, (cy) * sqhi + top, 0);
		}
	}
	/*
	drawplayershand();   //white
	SetColor(LightGray);
	SetTextJustify(RightText, TopText);
	OutTextXY(SCREEN_W - 5, SCREEN_H - 15, "press [f1] for help.");
	*/
}

spot BOARD::get_spot(int x, int y, int &off_board) {
  if ( x < 0 || y < 0 || x >= numsq || y >= numsq ) {
    off_board = true;
    return emptysq;
  } else {
    off_board = false;
    return (board[x][y]);
  }
}

int  BOARD::whatis(int x, int y) {
  return ( x < 0 || y < 0 || x >= numsq || y >= numsq ? none : board[x][y].t );
}


int BOARD::push(int t1, int t2, int x, int y, int ox, int oy) {
  int off_board, dumby;
  if (whatis(x,y) != t2) return 0;
  spot sp = get_spot(x + ox, y + oy, off_board);
  spot *WITH = &board[x][y];
  if (sp.t == none) {
         put_spot(get_spot(x,y,dumby), x + ox, y + oy);
         WITH->w = 0;
         WITH->t = none;
         WITH->frame =  ani_matrix[t1][t2];
 	 WITH->time_chk = ms_count;
 	 WITH->sound_time_chk =(
 	     ((WITH->do_sound = sound_matrix[t1][t2].sidx) < 0) ? 0 :
 	     sound_matrix[t1][t2].timer + ms_count
 	 );
 	 WITH->sound_vol = 64;
 	 return 1;
  } else { //show splash only.
         WITH->frame =  ani_start_list[t2];
 	 WITH->time_chk = ms_count;
 	 WITH->sound_time_chk =(
 	     ((WITH->do_sound = sound_matrix[t1][t2].sidx) < 0) ? 0 :
 	     sound_matrix[t1][t2].timer + ms_count
 	 );
 	 WITH->sound_vol = 64;
 	 affectaround(x, y, ox, oy, true);
 	 return 0;
  }
}

int BOARD::affectaround(int x, int y, int ox, int oy, int aff) {
  int t1, t2;
  if ((t1 = whatis(x, y)) == none || (t2 = whatis(x + ox, y + oy)) == none) return 0;
  int changed = 0;
  if (aff) {
    ptyp jj = activitym[t1][t2];
    spot *WITH = &board[x + ox][y + oy];
    if (jj != WITH->t) {
      WITH->w = (jj == none ? 0 : board[x][y].w);
      WITH->t = jj;
      if (aspath *kk = ani_matrix[( t1 <= morph ? t1 : 0)][( t2 <= metal ? t2 : 0)]) {
	WITH->frame = kk;
	WITH->time_chk = ms_count;
	WITH->sound_time_chk =( t1 > ltning || t2 > metal ? 0 :
 	     ((WITH->do_sound = sound_matrix[t1][t2].sidx) < 0) ? 0 :
 	     sound_matrix[t1][t2].timer + ms_count
 	);
        WITH->sound_vol = 32;
      }
      changed = 1;
    }
    switch (t1) {
    case rock: push(rock, water, x + ox, y + oy, ox, oy);  break;
    case wind: push(wind, fire,  x + ox, y + oy, ox, oy);  break;
    }
  } else {
    ptyp jj = activitym[t2][t1];
    spot *WITH = &board[x][y];
    if (jj != WITH->t) {
      WITH->w = (jj == none ? 0 : board[x + ox][y + oy].w);
      WITH->t = jj;
      if (aspath *kk = ani_matrix[( t2 <= morph ? t2 : 0)][( t1 <= metal ? t1 : 0)]) {
	WITH->frame = kk;
	WITH->time_chk = ms_count;
	WITH->sound_time_chk =( t2 > ltning || t1 > metal ? 0 :
 	     ((WITH->do_sound = sound_matrix[t2][t1].sidx) < 0) ? 0 :
 	     sound_matrix[t1][t2].timer + ms_count
 	);
 	WITH->sound_vol = 84;
	changed = 1;
      }
    }
  }
  return changed;
}


void BOARD::actoncard(int x, int y) {
  affectaround(x, y, 0, -1, true);
  affectaround(x, y, 1, 0, true);
  affectaround(x, y, 0, 1, true);
  affectaround(x, y, -1, 0, true);
  affectaround(x, y, 0, -1, false) ||
    affectaround(x, y, 1, 0, false) ||
    affectaround(x, y, 0, 1, false) ||
    affectaround(x, y, -1, 0, false); // short-circuit eval
}


void BOARD::lightning_mark(int x, int y) {
	int t1;
  	if ((t1 = whatis(x, y)) != none && lmap[x][y] == 0) {
		lmap[x][y] = 1;
    		if (t1 == metal) {
        		lightning_mark(x + 1, y    );
        		lightning_mark(x - 1, y    );
        		lightning_mark(x,     y + 1);
        		lightning_mark(x,     y - 1);
    		}
  	}
}


void BOARD::lightning_actoncard(int x, int y) {
  memset(lmap,0,sizeof lmap);
  lmap[x][y] = 2; // doesn't zap itself
  lightning_mark(x + 1, y    );
  lightning_mark(x - 1, y    );
  lightning_mark(x,     y + 1);
  lightning_mark(x,     y - 1);
  for (int yc = 0; yc < numsq; yc++) for (int xc = 0; xc < numsq; xc++) {
  	if (lmap[xc][yc] == 1) affectaround(x, y, xc - x, yc - y, true);
  }
}


int  BOARD::put_spot(spot card, int x, int y) {
        if ( x < 0 || y < 0 || x >= numsq || y >= numsq) return 0;
	board[x][y] = card;
	spot *WITH = &board[x][y];
	WITH->frame = ani_start_list[WITH->t];
        WITH->time_chk = ms_count;
        WITH->sound_time_chk =(
 	     ((WITH->do_sound = put_sound_list[(int) card.t]) < 0) ? 0 : ms_count
 	);
 	WITH->sound_vol = 255;
        if (WITH->t == ltning) {
           lightning_actoncard(x, y);
        } else actoncard(x, y);
        if (WITH->t == ltning || WITH->t == anti) { WITH->t = none; WITH->w = 0; }
        recalcscores();
	return 1;
}

void BOARD::recalcscores() {
  gamedone = true;
  for (int c = 0; c <= numplayers; c++)  player[c].p = 0;
  for (int x = 0; x < numsq; x++) for (int y = 0; y < numsq; y++) {
      spot *WITH = &board[x][y];
      if (WITH->t == morph) {
	WITH->t = ptyp(_randint(normalele) + 1);
	WITH->frame = ani_start_list[WITH->t];
        WITH->time_chk = ms_count;
//	drawchange(x, y);
      }
      if (WITH->t == none) gamedone = false;
      if (WITH->w > 0)	player[WITH->w].p += WITH->m * card_points[WITH->t];
  }
  for (int c = 1; c <= numplayers; c++) {
    while (player[c].p + player[c].otr < 0)
      player[c].otr++;
  }
  for (int c = 0; c <= numplayers; c++)  {
        scores[c] = player[c].p + player[c].otr;
       // printf("%s : %i\n",player[c].name,scores[c]);
  }
}

void BOARD::save_scores(int *sk) {
    for (int c = 0; c <= numplayers; c++) sk[c] = scores[c];
}

void BOARD::clear_of(int remove) {
    for (int cx = 0; cx < numsq; cx++) for (int cy = 0; cy < numsq; cy++) {
        spot *WITH = &board[cx][cy];
	if (WITH->t == remove) {
           WITH->frame = ani_matrix[anti][( WITH->t <= metal ? WITH->t : 0)];
           WITH->t = none;
           WITH->w = 0;
 	   WITH->time_chk = ms_count;
      }
    }
    recalcscores();
}

void BOARD::season_change(int sc) {
  //         No Change;Spring;Summer;Fall;Winter
  int bal[] = {none,   water, ice,   wood, water};
  int efl[] = {none,   wood,  fire,  ice,  wind};
  int t2 = bal[sc];
  int t1 = efl[sc];
  ptyp jj = activitym[t1][t2];
  if (sc > 0) for (int y = 0; y < numsq; y++) for (int x = 0; x < numsq; x++) {
    spot *WITH = &board[x][y];
    if (WITH->t == t2) {
      if (jj == none) WITH->w = 0;
      WITH->t = jj;
      if (aspath *kk = ani_matrix[t1][t2]) {
	WITH->frame = kk;
	WITH->time_chk = ms_count;
      }
    }
  }
}


//============================================================================
static void endprog(char *s) {
  set_gfx_mode(GFX_TEXT, 0,0,0,0);
  puts(s);
  exit(0);
}


//============================================================================
void outstr(char *s) {
  SetFillStyle(1, Black);
  SetColor(White);
  SetTextJustify(CenterText, CenterText);
  Bar(0, 0, SCREEN_W, top - 1);
  OutTextXY(SCREEN_W / 2, top / 2, s);
}




static int getimages() {
	if ( !(sprites = load_datafile(DOMIN_DAT)) ) {
	#ifdef NEW_SPRITES
		if ( !(sprites = load_datafile("domin2j.dat")) )
	#endif
		{
			allegro_message("Unable to load required Datafile: " DOMIN_DAT);
                        return 0;
		}
	}
        for (int c = 0; c <= numele; c++) {
		picture[c] = (BITMAP *)sprites[ani_loop_list[c]->idx].dat;
	}

	domin_splash = (BITMAP *) sprites[SPR_SPLASH_BMP].dat;
	domin_play_arrow = (BITMAP *) sprites[SPR_ARROW_BMP].dat;
	if (domin_splash->w != SCREEN_W || domin_splash->h != SCREEN_H ) {
        	BITMAP *tb = create_bitmap(SCREEN_W,SCREEN_H);
        	stretch_blit(domin_splash, tb, 0,0, domin_splash->w, domin_splash->h, 0,0, tb->w, tb->h);
        	destroy_bitmap(domin_splash);
		(BITMAP *) sprites[SPR_SPLASH_BMP].dat = domin_splash = tb;
	}
	return 1;
}

static void down_scale(double sf) {
	if (sf >= 1.0 ||sf <=0) return;
        int nw = (int)(floor(sqwid * sf))-BORDER_EDGE;
        int nh = (int)(floor(sqhi * sf))-BORDER_EDGE;
	for (int c=0; c < SPR_COUNT; c++) if (c != SPR_SPLASH_BMP && c != SPR_ARROW_BMP) {
		BITMAP *spr = (BITMAP *) sprites[c].dat;
        	BITMAP *tb = create_bitmap(nw,nh);
        	stretch_blit(spr, tb, 0,0, spr->w, spr->h, 0,0, tb->w, tb->h);
        	destroy_bitmap(spr);
		(BITMAP *) sprites[c].dat = tb;
	}
}

static void check_scale() {
	double scale = 1.0;
	double cs;
	if ( (cs = (GAMELOG_X - 2. * left) / (numsq * sqwid)) < scale ) scale = cs;
	printf("scaleW1:%f\n",cs);
	if ( (cs = (GAMELOG_X - 2. * left) / (piecesowned * sqwid + player_cards_left + 32)) < scale ) scale = cs;
	printf("scaleW2:%f\n",cs);
	if ( (cs = (SCREEN_H - top - 60.) / ((numsq + numplayers) * sqhi)) < scale ) scale = cs;
	printf("scaleH:%f\n",cs);
        down_scale(scale);
}


void reinit_graphics() {
        destroy_bitmap(buffer);
        buffer = create_bitmap(SCREEN_W, SCREEN_H);
	unload_datafile(sprites);
        getimages();
	check_scale();
	blit(domin_splash, buffer, 0,0,0,0, SCREEN_W, SCREEN_H);
}

static void draw_spot(spot *WITH, int x, int y, int force_dirty) {
  char STR1[256];
  char STR2[256];
  int di = 3;
  if (!WITH) return;
  if (WITH->sound_time_chk && ms_count >= WITH->sound_time_chk) {
    do_sound(WITH->do_sound, x, y, WITH->sound_vol);
    WITH->sound_time_chk = 0;
  }

  if (WITH->frame && WITH->frame->ms > 0 && ms_count - WITH->time_chk >  WITH->frame->ms) {
	if (WITH->frame->next) {
		force_dirty = 1;
		WITH->frame = WITH->frame->next;
	} else if (WITH->frame->iam < 0) {
		force_dirty = 1;
		WITH->frame++;
	} else WITH->frame = NULL;
	WITH->time_chk = ms_count;
  }
  if (1 || force_dirty) {
	SetFillStyle(1, pcolors[WITH->t]);
	Bar(x, y, x+ sqwid, y + sqhi);
	if (WITH->frame) {
		BITMAP *spr = (BITMAP *)sprites[WITH->frame->idx].dat;
		draw_sprite( buffer, spr, x + di, y + di);
	}
	SetColor(playerc[WITH->w]);
	Rectangle(x + di, y + di, x + sqwid - di, y + sqhi - di);
	SetTextJustify(RightText, BottomText);
	if (WITH->m != 1 && WITH->t != none) {
		sprintf(STR2, "x%i", WITH->m);
		OutTextXY(x + sqwid - di - 2, y +sqhi - di - 2, STR2);
	}
	SetTextJustify(LeftText, TopText);
	sprintf(STR1, "%i", card_points[WITH->t]);
	if (card_points[WITH->t] != 0) OutTextXY(x + di + 2, y + di + 2, STR1);
  }
}


//============================================================================
/*
static void drawchange(int cx, int cy) {
  char STR1[256];
  char STR2[256];
  spot *WITH = &board[cx-1][cy-1];

  draw_spot(WITH, (cx - 1) * sqwid + left, (cy - 1) * sqhi + top, 1);
}
*/


//============================================================================



static void drawplayershand() {
  static pointtype star[10] = {
    { 0, -4 },
    { 1, -1 },
    { 5, -1 },
    { 2, 1 },
    { 2, 4 },
    { 0, 2 },
    { -2, 4 },
    { -2, 1 },
    { -5, -1 },
    { -1, -1 }
  };
if (!ai_test) {
  pointtype ta[10];
  char STR[28];
  int bc = numsq * sqhi + top;
  carddrop = bc + (SCREEN_H - bc) / 2 - (numplayers * sqhi) / 2;
  SetFillStyle(1, Black);
  blit(domin_splash, buffer, 0, carddrop, 0, carddrop, player_cards_left, sqhi * (numplayers));
  blit(domin_splash, buffer, player_cards_left-16, carddrop-5, player_cards_left-16, carddrop-5, sqwid * (piecesowned), 5);
  blit(domin_splash, buffer,
           piecesowned * sqwid + player_cards_left, carddrop,
           piecesowned * sqwid + player_cards_left, carddrop, 32,
	    sqhi * (numplayers)
  );
  for (int cy = 1; cy <= numplayers; cy++) {
    playertyp *PL = &player[cy];
    SetColor(playerc[cy]);
    SetTextJustify(LeftText, TopText);
    sprintf(STR, "%s:", PL->name);
    OutTextXY(0, (cy -1) * sqhi + carddrop, STR);
    sprintf(STR, "$%5i", (PL->p + PL->otr) );
    OutTextXY(0, (cy - 1) * sqhi + carddrop + 12, STR);
    for (int cx = 0; cx < piecesowned; cx++) {
      spot *WITH = &player[cy].got[cx];
      draw_spot(WITH, cx * sqwid + player_cards_left, (cy-1) * sqhi + carddrop, 0);
    }
  }
  for (int c = 0; c <= 9; c++) {
    ta[c].x = star[c].x + (choice) * sqwid + player_cards_left;
    ta[c].y = star[c].y + (cplayer-1) * sqhi + carddrop;
  }
  SetFillStyle(1, White);
  polygon(buffer, 10, (const int *)ta, playerc[cplayer]);
  void (*dsf)(BITMAP *, BITMAP *, int, int) = (playdir < 0 ? draw_sprite : draw_sprite_v_flip) ;
  dsf(buffer, domin_play_arrow, piecesowned * sqwid + player_cards_left,
      (cplayer-1) * sqhi + carddrop
  );
}
}

//============================================================================
static void drawcard(char who, char which) {
  spot *WITH = &player[who].got[which];
  int r = _randint(numele * 2) + 1;
  if (r <= numele) WITH->t = ptyp(r);
  else {
    WITH->t = ptyp(r % normalele + 1);
  }
  WITH->w = who;
  WITH->m = _randint(18) + 1;
  if (WITH->m > 3 || WITH->t > normalele) WITH->m = 1;
  WITH->frame = ani_loop_list[WITH->t];
  WITH->time_chk = ms_count;
}

//============================================================================
static void setupgame() {
  choice = 0;
  cplayer = 1;
  playdir = 1;
  #ifdef _WIN32
		clock_t rseed = clock(); srand((unsigned int)(rseed));
  #else
	        timeval rseed; gettimeofday(&rseed, NULL); srandom(rseed.tv_usec);
  #endif
  check_scale();
  for (int who = 1; who <= numplayers; who++) {
    for (int which = 0; which < piecesowned; which++) drawcard(who, which);
    player[who].otr = player[who].p = 0;
  }
}


void check_screen_shot() {
	if (key[KEY_F12]) do_scr_shot = 1;
	if (!key[KEY_F12] && do_scr_shot == 1) {
		char gws[200];int i = 1;
		do {
			snprintf(gws, sizeof gws, "%sdomin%03i.bmp", scr_shot_dir, i);
			if (i++ > 99) break;
		} while (exists(gws));
		save_bitmap(gws,screen,NULL);
		do_scr_shot = 0;
	}
}


//============================================================================
static int blinkmouse() {
	static pointtype arrow[7] = {
		{ 0, 0 },
		{ 3, 7 },
		{ 4, 5 },
		{ 7, 9 },
		{ 9, 7 },
		{ 5, 4 },
		{ 7, 3 }
	};
        if (!ai_test) {
	pointtype ta[7];

	mosbut = mouse_b;
	moscol = mouse_x;
	mosrow = mouse_y;

	for (char c = 0; c <= 6; c++) {
		ta[c].x = arrow[c].x * msize;
		ta[c].y = arrow[c].y * msize;
	}
	clear_to_color(mouse_arrow, bitmap_mask_color(mouse_arrow));
	polygon(mouse_arrow, 7, (const int *)ta, playerc[cplayer]);
        set_mouse_sprite(mouse_arrow);
        show_mouse(buffer);
        blit(buffer,screen,0,  0,  0,   0, SCREEN_W, SCREEN_H);        
        scare_mouse();
	show_mouse(screen);
	check_screen_shot();
	unscare_mouse();
	if (!ai_test) {  check_sound(); rest(10); }
	if (mosbut) while (mouse_b) {  check_sound(); rest(10); }
	return (mosbut != 0);
        }
        return (0);
}

void game_rest(int ms) {
  if (!ai_test) {
  int pause_till = ms_count + ms;
  while (ms_count < pause_till) {
         check_sound();
         gameboard->draw();
         drawplayershand();
         gamelog->draw();
         blinkmouse();
         check_sound();
      }
  } else {
      check_sound();
      gameboard->draw();
      drawplayershand();
      gamelog->draw();
      blinkmouse();
      check_sound();
  }
}

void game_rest_nodraw(int ms) {
  if (!ai_test) {
  int pause_till = ms_count + ms;
  while (ms_count < pause_till) {
         check_sound();
         rest(10);
      }
  } else {
      check_sound();
  }
}


typedef char ph[3];


#define askhi           50
#define askwid          140
#define qbar            20

#define butwid          80

#define buthi           15
#define bdn             20


//============================================================================
static int askyn(char *s) {
  int Result;
  int decided = false;
  int sw  = 6;
  BITMAP *p = create_bitmap(askwid * 2 +sw+1, askhi * 2+sw+1 );

  blit(buffer,p, SCREEN_W / 2 - askwid, SCREEN_H / 2 - askhi, 0,0, p->w, p->h);
  do {
      check_sound();
      int rs = SCREEN_W / 2 + askwid;
      int bs = SCREEN_H / 2 + askhi;
      int ts = SCREEN_H / 2 - askhi;
      int ls = SCREEN_W / 2 - askwid;
      //                          S1             S2               X       Y
      blit(domin_splash, buffer, rs,      ts+sw, rs,      ts+sw, sw,      bs-ts);
      blit(domin_splash, buffer, ls + sw, bs+1,  ls + sw, bs+1,  rs - ls, sw);
      
      gameboard->draw();
      drawplayershand();
      gamelog->draw();
      SetFillStyle(1, Purple);
      SetColor(White);
      SetTextJustify(CenterText, TopText);
      drawing_mode(DRAW_MODE_TRANS, NULL, 0,0);
      set_trans_blender(90, 90, 90, 90);
      int shc = makecol(20,20,20);
      rectfill(buffer,rs, ts+sw,rs+sw,bs,shc);
      rectfill(buffer,ls + sw, bs+1,rs+sw,bs+sw,shc);
      solid_mode();

      Bar(rs,ts,ls,bs);

      OutTextXY(SCREEN_W / 2, SCREEN_H / 2 - askhi + 5, s);
      SetFillStyle(1, BluishPurple);
      Bar(SCREEN_W / 2 - askwid, SCREEN_H / 2 - askhi + qbar, SCREEN_W / 2 + askwid,
         SCREEN_H / 2 + askhi);
      SetFillStyle(1, LightGray);
      Bar(SCREEN_W / 2 + 2, SCREEN_H / 2 + bdn, SCREEN_W / 2 + butwid, SCREEN_H / 2 + bdn + buthi);
      Bar(SCREEN_W / 2 - 2, SCREEN_H / 2 + bdn, SCREEN_W / 2 - butwid, SCREEN_H / 2 + bdn + buthi);
      SetTextJustify(CenterText, CenterText);
      OutTextXY(SCREEN_W / 2 - butwid / 2 - 2, SCREEN_H / 2 + bdn + buthi / 2, "yes");
      OutTextXY(SCREEN_W / 2 + butwid / 2 + 2, SCREEN_H / 2 + bdn + buthi / 2, "no");
      Rectangle(ls + 2,ts + 2, rs - 2, bs - 2);

      if (key[KEY_Y]) {
	Result = true;
	decided = true;
      }
      if (key[KEY_N]) {
	Result = false;
	decided = true;
      }


    if (blinkmouse() & between(moscol, SCREEN_W / 2 - butwid, SCREEN_W / 2 + butwid) &
	between(mosrow, SCREEN_H / 2 + bdn, SCREEN_H / 2 + bdn + buthi)) {
      Result = (moscol < SCREEN_W / 2);
      decided = true;
    }
  } while (!decided);
  blit(p,buffer,0,0,SCREEN_W / 2 - askwid, SCREEN_H / 2 - askhi,p->w,p->h);
  destroy_bitmap(p);
  return Result;
}

#undef askhi
#undef askwid
#undef qbar
#undef butwid
#undef buthi
#undef bdn


//============================================================================
static void nextplayer() {
  choice = 0;
  outstr(dominstr);
  cplayer += playdir;
  if (cplayer > numplayers) cplayer -= numplayers;
  if (cplayer < 1) cplayer += numplayers;
  if (labs(playdir) == 2) playdir /= 2;
}


//============================================================================



#define btnsp           20

#define btnhi           (btnsp - 3)

#define hwid            70


//============================================================================

#undef btnsp
#undef btnhi
#undef hwid



//============================================================================
static int getelechoice() {
   int ele = 0;
   qdlg("Element",
                 ADIME_ALIGN_CENTRE, ADIME_ALIGN_CENTRE, 160,
                 "%vlist[]",
                 &ele,
                 &piecestr[1],
                 7
  );
  return (ele + 1);
}


struct acttyp {
  char s[26];
  char c, w;
};


#define hwid            120
#define btnsp           30

#define btnhi           (btnsp - 3)

#define buyy            12
#define spinnerpos      16


#define radius          40
#define netcolor        LightRed
#define backcolor       DarkGray
#define sqcolor         Blue


#define sqwid_          40

//==============================proc=======================================
static void clearscr() {
  blit(domin_splash,buffer,0,0,0,0,domin_splash->w,domin_splash->h);
  // gameboard->draw();
}

//==============================proc=======================================
static void givecards(char num, ptyp what, char who) {
  for (int c = 0; c < num; c++) {
    spot *WITH = &player[who].got[c];
    WITH->t = what;
    WITH->frame = ani_loop_list[WITH->t];
    WITH->time_chk = ms_count;
    WITH->m = 1;
  }
}

//==============================proc=======================================
static void newmultiply(char mul) {
  for (int c = 0; c < piecesowned; c++) {
    spot *WITH = &player[cplayer].got[c];
    if (WITH->t <= 6) WITH->m = mul;
  }
}

//==============================proc=======================================
static void addpts(int num) {
  player[cplayer].otr += num;
}

//==============================func=======================================
static int pick_enemy() {
  char *player_list[maxplayers];
  int ix = 0;
  for (int p = 1; p <= numplayers; p++) if (p != cplayer) {
     player_list[ix] = player[p].name; ix++;
  }
  int mc = 0;
  qdlg("which player?",
                 ADIME_ALIGN_CENTRE, ADIME_ALIGN_CENTRE, 200,
                 "%vlist[]",
                 &mc,
                 player_list,
                 numplayers - 1
  );
  mc++; // 0th in list = player 1
  return (mc < cplayer ? mc: mc + 1);
}

static acttyp spinner_list[spinnerpos + 1] = {
    { "nothing", 0, 8 },
    { "random", 1, 0 },
    { "fill enemy with xenon", 2, 5 },
    { "cards x2", 3, 5 },
    { "get new hand", 4, 4 },
    { "swap cards with enemy", 5, 5 },
    { "12 point gamble", 6, 2 },
    { "3 wilds", 7, 3 },
    { "fill all with xenon", 8, 1 },
    { "clear board of card", 9, 1 },
    { "18 point gamble", 10, 0 },
    { "2 lightnigs", 11, 1 },
    { "cards x3", 12, 1 },
    { "+2 points", 255, 8 },
    { "+5 points", 255, 5 },
    { "+10 points", 255, 2 },
    { "double or nothing", 255, 15 }
};


//==============================proc=======================================
static int spinner() {
  int biggestnum = 0;
  int n;
  int centery = 75;
  int ox, oy;
  char STR2[30];
  double ang = _randint(100) / (_randint(100) + 1.0);
  int centerx = SCREEN_W / 2;

  BITMAP *p = create_bitmap(2*radius,2*radius);

  blit(buffer,p,centerx - radius, centery - radius,0,0,p->w,p->h);

  SetFillStyle(1, sqcolor);
  Bar(centerx - radius, centery - radius, centerx + radius, centery + radius);
  SetFillStyle(1, backcolor);
  SetColor(backcolor);
  circlefill(buffer,centerx,centery,radius,backcolor);
  for (int c = 0; c <= spinnerpos; c++) biggestnum += spinner_list[c].w;
  int FORLIM = _randint(10) + 100;
  for (int c = _randint(30) + 1; c <= FORLIM; c++) {
    SetColor(netcolor);
    ox = (int)(floor(cos(ang) * (radius - 3) + centerx + 0.5));
    oy = (int)(floor(sin(ang) * (radius - 3) + centery + 0.5));
    Line(centerx, centery, ox, oy);
    blinkmouse();
    if (!fast_spinner) game_rest_nodraw(ai_test ? 0 : c); // no sprites!
    int v = _randint(biggestnum) + 1;
    int b = 0;
    n = -1;
    do {
      n++;
      b += spinner_list[n].w;
    } while (v > b);
    outstr(spinner_list[n].s);
    SetColor(backcolor);
    Line(centerx, centery, ox, oy);
    ang += 0.3;
  }
  SetColor(netcolor);
  Line(centerx, centery, ox, oy);
  sprintf(STR2, "[%s]", spinner_list[n].s);
  outstr(STR2);
//  printf("should get: %s\n",STR2);
  blinkmouse();
  game_rest_nodraw(ai_test ? : 1200); // no sprites!
  outstr("");
  blit(p,buffer,0,0,centerx - radius, centery - radius, p->h,p->w);
  destroy_bitmap(p);
  return n;
}

#undef radius
#undef netcolor
#undef backcolor
#undef sqcolor

//==============================proc=======================================
static void doubleornothing(char *say) {
  int dbl = 0;
  int gambl = 0;
  playertyp *WITH = &player[cplayer];
  int max_bet = MID(0, WITH->p + WITH->otr, 10);
  if ( player[cplayer].ai_func ) {
      gambl = MID(0, npc_move.gamble_choice, max_bet);
  } else {
      char edit[80];
      sprintf(edit,"Amount [0-%i]: %%pint[0,%i]%%buttonrow[OK;CTRL+O;ENTER]",max_bet,max_bet);
      adime_lowlevel_dialogf("How much do you want to bet?",
                 ADIME_ALIGN_CENTRE, ADIME_ALIGN_CENTRE, 200,
                 edit,
                 &gambl,
                 ok_adime
      );
  }
  if (gambl == 0) { if ( !player[cplayer].ai_func ) outstr("You big wimp!"); return; }
  int v = _randint(10);
  for (int c = 1; c <= v + 50; c++) {
    game_rest(c * 5);
    dbl = !dbl;
    if (dbl)
      outstr("win");
    else
      outstr("lose");
  }
  if (dbl)
    outstr("[win]");
  else
    outstr("[lose]");
  blinkmouse();
  game_rest(500);
  if (say) {
     if (dbl) {
        sprintf(say, "%s won $%i!",  player[cplayer].name, gambl);
        outstr(say);
        addpts(gambl);
     } else {
        sprintf(say, "%s lost $%i.", player[cplayer].name, gambl);
        outstr(say);
        addpts(-gambl);
    }
  }
  blinkmouse();
  game_rest(500);
  outstr("");
}

#undef sqwid_



//==============================proc=======================================
static void gamble(int amount, int of_amount, char *say) {
  int v;
  char STR1[256];
  for (int c = 1; c <= 50; c++) {
    game_rest(c * 5);
    v = _randint(amount + 1);
    sprintf(STR1, "you get :  $%i", v);
    outstr(STR1);
    blinkmouse();
  }
  sprintf(STR1, "[you get :  $%i]",  v);
  outstr(STR1);
  blinkmouse();
  if (say) {
    int a = amount - of_amount;
    if (a == 0) sprintf(say, "%s broke even gambling.", player[cplayer].name);
    else if (a>0) sprintf(say, "%s won $%i gambling.", player[cplayer].name, a);
    else sprintf(say, "%s lost $%i gambling.", player[cplayer].name, -a);
  }
  game_rest(500);
  outstr("");
  player[cplayer].otr += v;
}


//===========================***actspecial***=================================
static void actspecial(char *say) {
  char *menu[] =  {
     " $0. nothing", " $1. random", " $2. fill enemy with xenon", " $3. cards x2", " $4. get new hand",
     " $5. swap cards with enemy", " $6. 12 point gamble", " $7. 3 wilds", " $8. fill all with xenon",
     " $9. clear board of card", "$10. 18 point gamble", "$11. 2 lightnigs", "$12. cards x3"
  };

  playertyp *WITH1 = &player[cplayer];

  int count;
  int mc = 0;
  int af = MID(0, WITH1->p + WITH1->otr + 1, 13);
  if ( player[cplayer].ai_func ) {
      mc = npc_move.cross_choice;
      if (mc < 0 || mc > af) mc = 0;
  } else {
      qdlg("wacha want?",
                 ADIME_ALIGN_CENTRE, ADIME_ALIGN_CENTRE, 240,
                 "%vlist[]",
                 &mc,
                 menu,
                 af
      );
  }
  int pick;
  char *rt_list[] = {"takes", "recieves"};
  int i_spinned = (mc == ct_random);

  addpts(-mc);
  if (mc == ct_random) {
    clearscr();  mc = spinner();
    printf("spinner = %i\n", mc);
  }
  switch (mc) {
  case ct_none: if (say) sprintf(say, "%s %s nothing from the cross.", player[cplayer].name, rt_list[i_spinned]); break;
  case ct_one_xenon:
    pick = ( player[cplayer].ai_func ?  npc_move.worst_enemy : pick_enemy());
    givecards(piecesowned, xenon, pick );
    if (say) sprintf(say, "%s fills %s with xenon.", player[cplayer].name, player[pick].name);
    break;

  case ct_x2:
     newmultiply(2);
     if (say) sprintf(say, "%s recieves a x2 multiplier on all natural cards.", player[cplayer].name);
     break;

  case ct_new_hand:
    for (count = 1; count <= piecesowned; count++) drawcard(cplayer, count);
    if (say) sprintf(say, "%s %s a new hand from the cross.", player[cplayer].name, rt_list[i_spinned]);
    break;

  case ct_swap_cards:
    pick = ( player[cplayer].ai_func ?  npc_move.swap_with : pick_enemy());
    for (count = 0; count < piecesowned; count++) {
      spot sp = player[pick].got[count];
      player[pick].got[count] = player[cplayer].got[count];
      player[cplayer].got[count] = sp;
      player[cplayer].got[count].w = cplayer;
      player[pick].got[count].w = pick;
    }
    if (say) sprintf(say, "%s forcefully swaps cards with %s.", player[cplayer].name, player[pick].name);

    break;

  case ct_gamble12: gamble(12,mc, say); break;

  case ct_three_wilds:
  	givecards(3, wild, cplayer);
  	if (say) sprintf(say, "%s %s 3 wild cards from the cross.", player[cplayer].name, rt_list[i_spinned]);
  break;

  case ct_all_xenon:
    for (count = 1; count <= numplayers; count++) if (count != cplayer) {
	givecards(piecesowned, xenon, count);
    }
    if (say) sprintf(say, "%s fills all enemys with xenon.", player[cplayer].name);
    break;

  case ct_clear:
    clearscr();
    pick = ( player[cplayer].ai_func ?  npc_move.hate_element : getelechoice() );
    gameboard->clear_of(pick);
    if (say) sprintf(say, "%s cleared the board of all %ss.", player[cplayer].name, piecestr[pick]);
    break;

  case ct_gamble18: gamble(18, mc, say);  break;
  case ct_two_lightnigs:
    givecards(2, ltning, cplayer);
    if (say) sprintf(say, "%s %s two lightning cards from the cross.", player[cplayer].name, rt_list[i_spinned]);
    break;
  case ct_x3: newmultiply(3);  if (say) sprintf(say, "%s recieves a x3 multiplier on all natural cards.", player[cplayer].name); break;
  case ct_plus_two: addpts(2); if (say) sprintf(say, "%s recieves a +2 bonus.", player[cplayer].name); break;
  case ct_plus_five: addpts(5); if (say) sprintf(say, "%s recieves a +5 bonus.", player[cplayer].name); break;
  case ct_plus_ten: addpts(10); if (say) sprintf(say, "%s recieves a +10 bonus.", player[cplayer].name);break;
  case ct_double_or_nothing: doubleornothing(say);  break;
  }
  clearscr();
}

#undef hwid
#undef btnsp
#undef btnhi
#undef buyy
#undef spinnerpos


static void doseasonchange(char *say) {
   int sc = 0;
     if ( player[cplayer].ai_func ) {
      sc = npc_move.season_choice;
      if (sc < 0 || sc > 4) sc = 0;
  } else {
      qdlg("Season Change",
                 ADIME_ALIGN_CENTRE, ADIME_ALIGN_CENTRE, 140,
                 "%list[,No Change;Spring;Summer;Fall;Winter]"
                 ,
                 &sc
      );
  }
  gameboard->season_change(sc);
  char *sl[] = {NULL, "spring","summer","fall","winter"};
  if (say) {
  	if (sc) sprintf(say, "%s changes the season to %s.", player[cplayer].name, sl[sc]);
  	else  sprintf(say, "%s forfits season change.", player[cplayer].name);
  }
}

extern int my_ai_rest;
void blinky_screen_of_death();
int sound_options_dlg(DIALOG *d);

int try_turn(int &deal_col, int &deal_row) {
  int ok_move;
//  if (moves++ == 50) blinky_screen_of_death();
  if (player[cplayer].ai_func) {
      gameboard->draw();
      drawplayershand();
      gamelog->draw();
      blinkmouse();
      // memset((void *)&npc_move, 0, sizeof npc_move);
      my_ai_rest = ai_wait_timing;
      player[cplayer].ai_func(npc_move, gameboard, cplayer, player[cplayer].ai_var);
      deal_col = npc_move.play_x;
      deal_row = npc_move.play_y;
      choice = npc_move.play_card;
  } else do {
    ok_move = 1;
    int ssk_up = 1;
    do {
        gameboard->draw();
        drawplayershand();
        gamelog->draw();
        if (key[KEY_ESC] || want_to_quit) {
  	   tiredofplaying = askyn("are you shure you want to quit?");
  	   if (tiredofplaying) return 0;
  	   want_to_quit = 0;
	   break;
        }
        if (key[KEY_F1]) {
	   insubhelp = false;
	   // showhelp("domin.doc");
	   gameboard->draw();
       }
        if (key[KEY_F2]) {
           sound_options_dlg(NULL);
	   break;
        }
    } while (! blinkmouse() );
    if (between(mosrow, top, top + sqhi * numsq) & between(moscol, left, left + sqwid * numsq)) {
      // on board!
      deal_row = (mosrow - top) / sqhi;
      deal_col = (moscol - left) / sqwid;
      if (gameboard->whatis(deal_col,deal_row) != none) ok_move = 0;
      switch (player[cplayer].got[choice].t) {
	case cross:  case bonus: case schange:
	case skip: case reverse:
	  ok_move = 0; break;
	default:;
      }
   } else if (between(moscol, player_cards_left, player_cards_left + (piecesowned) * sqwid) &
             between(mosrow,  (cplayer-1) * sqhi + carddrop, cplayer * sqhi + carddrop + sqhi)
          ) {
      // on player's hand
 	  choice = (moscol - player_cards_left) / (sqwid ? sqwid : 1);
	  switch (player[cplayer].got[choice].t) {
	  case cross: case bonus:  case schange:
	  case skip:  case reverse:
	      break;
	  default: ok_move = 0;
	  }
    } else ok_move = 0;
  } while (!ok_move);
  return 1;
}


//============================================================================
static void playgame() {
  char wisco = 0;
  char winner;
  int tie;
  char STR1[32];
  int deal_col, deal_row;
  tiredofplaying = false;
  gameboard->draw();
  outstr(dominstr);
  printf("playgame\n");
  set_mood(GM_FIGHT);
  while (!(tiredofplaying || gamedone)) {
        if (try_turn(deal_col, deal_row)) {
             char ts[200];
             if (player[cplayer].got[choice].t <= activeele) {
              if (player[cplayer].got[choice].t == wild) {
                player[cplayer].got[choice].t = (ptyp)(
                   player[cplayer].ai_func ?  npc_move.wild_choice : getelechoice()
                );
		snprintf(ts, sizeof ts,"%s places a wild (%s) at [%i,%i].", player[cplayer].name,
		  piecestr[(int)player[cplayer].got[choice].t], deal_col,deal_row
		);
              } else {
                snprintf(ts, sizeof ts,"%s places a %s at [%i,%i].", player[cplayer].name,
		  piecestr[(int)player[cplayer].got[choice].t], deal_col,deal_row
		);
              }
              gameboard->put_spot(player[cplayer].got[choice],deal_col,deal_row);
              do_sound(put_sound_list[(int)player[cplayer].got[choice].t], deal_col, deal_row, 255);
  	      drawcard(cplayer, choice);
  	      nextplayer();
	      // outstr(dominstr);
	    } else {
	      int element_x = player[cplayer].got[choice].t;
              drawcard(cplayer, choice);
	      drawplayershand();
	      blinkmouse();
              snprintf(ts, sizeof ts,"%s plays a %s.", player[cplayer].name,
		  piecestr[element_x]
              );
	      switch (element_x) {
	      case cross: actspecial(ts);  break;
	      case bonus:  player[cplayer].otr += 5; break;
	      case schange: doseasonchange(ts);  break;
	      case skip:  if (labs(playdir) == 1) playdir *= 2;   break;
	      case reverse: playdir *= -1; break;
	      default:;
	      }
	      do_sound(put_sound_list[element_x], numsq/2, numsq/2, 255);
	   }
	   gamelog->add(ts);
	}
        drawplayershand();
        blinkmouse();
  }
  if (!gamedone) return;
  for (char pon = 1; pon <= numplayers; pon++) {
    playertyp *WITH = &player[pon];
    int psco = WITH->p + WITH->otr;
    if (psco == wisco) tie = true;
    else if (psco > wisco) {
      wisco = psco;
      winner = pon;
      tie = false;
    }
  }
  if (!ai_test) set_mood(player[winner].ai_func == NULL ? GM_WIN : GM_LOSE);
  if (tie) outstr("tied game.");
  else {
    sprintf(STR1, "%s wins!", player[winner].name);
    outstr(STR1);
  }
  tiredofplaying = (ai_test ? 0 : !askyn("do you want to play again?"));
}


static void run_ai_test() {
           FILE *ai_test_handle;
           numplayers = 2;
           carddrop =  SCREEN_H / 2 - 12 * numplayers;
           if ( (ai_test_handle = fopen ( "ai_results.txt" , "w" )) ) {
           	int big_test_num = 0;
                for (int aione = 2; aione < NUM_AI_NAMES - 1; aione++) {
                    for (int aitwo = aione + 1; aitwo < NUM_AI_NAMES; aitwo++) {
                    	big_test_num++;
                        int tests_to_run = 20;
                        int aione_wins = 0, aitwo_wins = 0;
                        int aione_points = 0, aitwo_points = 0;
                        player[1].ai_func = ai_list[aione].ai_func;
   			player[1].ai_var  = ai_list[aione].ai_var;
   			strncpy(player[1].name, ai_name_list[aione], sizeof player[1].name);
                        player[2].ai_func = ai_list[aitwo].ai_func;
   			player[2].ai_var  = ai_list[aitwo].ai_var;
   			strncpy(player[2].name, ai_name_list[aitwo], sizeof player[2].name);
   			fprintf(ai_test_handle, "%s VS. %s\n", ai_name_list[aione], ai_name_list[aitwo]);
                        for (int test_num = 0; test_num < tests_to_run; test_num++) {
                                int sk[maxplayers];
				setupgame();
				cplayer = test_num % 2 + 1;
				gameboard = new BOARD();
				gamelog = new GAMELOG();
				playgame();
				if (tiredofplaying) goto quit_ai_test;
				gameboard->save_scores(sk);
                                fprintf(ai_test_handle, "  %3i %3i\n", sk[1], sk[2]);
                                if (sk[1] > sk[2]) aione_wins++;
                                if (sk[1] < sk[2]) aitwo_wins++;
                                aione_points +=  sk[1];
                                aitwo_points +=  sk[2];
                                clear(screen);
                                textprintf_ex(screen, font, 50, 75, Blue, Black,
                                        "Test %i round %i.", big_test_num, test_num
                        	);

                                textprintf_ex(screen, font, 50, 100, Green, Black,
                                        "%s won %i%% scoring %i%% of the points.",
                        		ai_name_list[aione], 100 * aione_wins / (test_num + 1),
                                	100 * aione_points / (aione_points + aitwo_points)
                        	);
                        	textprintf_ex(screen, font, 50, 120, Red, Black,
                        		"%s won %i%% scoring %i%% of the points.",
                        		ai_name_list[aitwo], 100 * aitwo_wins / (test_num + 1),
                                	100 * aitwo_points / (aione_points + aitwo_points)
                        	);
                        	// rest(800);
				delete gamelog;
				delete gameboard;
                        }
                        fprintf(ai_test_handle, "%s won %i%% scoring %i%% of the points.\n",
                        	ai_name_list[aione], 100 * aione_wins / tests_to_run,
                                100 * aione_points / (aione_points + aitwo_points)
                        );
                        fprintf(ai_test_handle, "%s won %i%% scoring %i%% of the points.\n\n",
                        	ai_name_list[aitwo], 100 * aitwo_wins / tests_to_run,
                                100 * aitwo_points / (aione_points + aitwo_points)
                        );
                    }
                }
quit_ai_test:   fclose(ai_test_handle);
           }
}

void my_close_button_callback() {
  want_to_quit = 1;
}

void ten_ms_counter(void) {
	if ( (( ms_count += 10) % 1000) == 0) {
		fps = frame_count;
		frame_count = 0;
	}
}
END_OF_FUNCTION(ten_ms_counter);

void domin_intro();

int main(int argc, char *argv[]) {
	printf("Domin II - Written by Eric Killeen\n");
	allegro_init();
	getstartupvals();
	printf("Startupvals OK.\n");
	int cd = desktop_color_depth();
      	set_color_depth( (cd < 15 ? 16 : cd) );
	if ( set_gfx_mode(
        	( prefer_windowed ? GFX_AUTODETECT_WINDOWED : GFX_AUTODETECT),
        	default_screen_w, default_screen_h, 0, 0) < 0
	)   {
		 allegro_message( "Could not set video mode. Reason: %s\n", allegro_error );
	}
	set_display_switch_mode(SWITCH_BACKGROUND); //keep running when switched away
	set_window_title("Domin");
	set_close_button_callback(my_close_button_callback);
	set_color_conversion(COLORCONV_TOTAL);
	fixup_datafile(font_data);
	install_timer(); //allegro timer req'd for mouse/midi
	install_keyboard();
	install_mouse();
	init_sound();
        mouse_arrow = create_bitmap(10*msize,10*msize);
	install_int(ten_ms_counter, 10);
	buffer = create_bitmap(SCREEN_W, SCREEN_H);
	printf("Basic Allegro Init OK.\n");
	if (!getimages()) return 1;
	printf("Load Images OK.\n");
	clearscr();
	// blit(buffer,screen,0,0,0,0,SCREEN_W,SCREEN_H);
        if (adime_init() != 0) {
           set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
           allegro_message("Error initializing Adime.\n");
           exit(1);
        }
        albgi_init();
	printf("alBGI Init OK.\n");
	tiredofplaying = false;
	if (ai_test) run_ai_test();
        else {
           domin_intro();
           qfe_gamesetup();
           do {
		setupgame();
		gameboard = new BOARD();
		gamelog = new GAMELOG();
		playgame();
		delete gamelog;
		delete gameboard;
 	  } while (!tiredofplaying);
 	}
	endprog("bye.");
	exit(EXIT_SUCCESS);
}

END_OF_MAIN();


// End.

