#include "config.h"
#include <stdio.h>
#include <string.h>
#include <allegro.h>
#include <adime.h>
#include "albgi.h"
#include "domin.h"
#include "fonts.h"

extern BITMAP *buffer;

int DarkGray,LightGray,Green,Brown,Red,Blue,Cyan,Magenta,
    White,Black,LightCyan,Yellow,LightGreen,
    LightRed,LightBlue,LightMagenta,
    BluishPurple,Purple, GhostGreen;
int global_color;
int global_fscolor;
int global_textjustify;
int global_vtextjustify;
int pen_x, pen_y;

#define font &font_bold

void SetTextJustify(int h, int v) {
   global_textjustify = (h);
   global_vtextjustify = v;
}

void OutTextXY(int x, int y, char *s) {
   int vj = (text_height(font)-2) * global_vtextjustify / 2;
   switch (global_textjustify) {
   case 0:
      textout_ex(buffer, font, s, x, y - vj, global_color, -1);
      pen_x = x + text_length(font, s); pen_y =y;
      break;
   case 1:
      textout_centre_ex(buffer, font, s, x, y - vj, global_color, -1);
      pen_x = x; pen_y =y;
      break;
   case 2:
      textout_right_ex(buffer, font, s, x, y - vj, global_color, -1);
      pen_x = x - text_length(font, s); pen_y =y;
      break;
   }
}

void OutText(char *s) {
   int vj = text_height(font) * global_vtextjustify / 4;
   switch (global_textjustify) {
   case 0:
      textout_ex(buffer, font, s, pen_x, pen_y - vj, global_color, -1);
      pen_x += text_length(font, s);
      break;
   case 1:
      textout_centre_ex(buffer, font, s, pen_x, pen_y - vj, global_color, -1);
      break;
   case 2:
      textout_right_ex(buffer, font, s, pen_x, pen_y - vj, global_color, -1);
      pen_x -= text_length(font, s);
      break;
   }
}

#define MC(c,r,g,b) (c = makecol(0x ## r,0x ## g,0x ## b))

extern int pcolors[], playerc[];

void albgi_init() {
   pcolors[none] = MC(DarkGray,40,40,40);
   pcolors[wind] = MC(LightGray,a0,a0,a0);
   pcolors[wood] = MC(Green,1e,af,16);
   pcolors[rock] = MC(Brown,a3,64,16);
   pcolors[fire] = MC(Red,af,19,16);
   pcolors[water] = MC(Blue,16,3a,af);
   pcolors[ice] = MC(Cyan,16,a5,af);
   pcolors[metal] = MC(White,ff,ff,ff);
   pcolors[ltning] = MC(Yellow, e5,ff,21);
   pcolors[anti] = MC(LightCyan,1e,ed,df);
   pcolors[morph] =  MC(Magenta,af,16,96);
   pcolors[xenon] = MC(LightBlue,29,1e,ed);
   pcolors[wild] = MC(LightMagenta,ed,1e,ca);
   pcolors[cross]  = MC(BluishPurple,68,11,db);
   pcolors[skip] = MC(LightRed,ed,1e,1e);
   pcolors[reverse] = MC(Purple,a3,23,ff);
   pcolors[schange] = MC(GhostGreen,be,d3,9e);
   pcolors[bonus]  = MC(LightGreen, 1e,ed,33);
   MC(Black,00,00,00);
   playerc[0] = Black;
   playerc[1] = LightGreen;
   playerc[2] = LightRed;
   playerc[3] = LightBlue;
   playerc[4] = Yellow;
   playerc[5] = LightCyan;
   playerc[6] = LightMagenta;
   #define ADC(ac,col) ( (adime_ ## ac ## _rgb.r = getr(col) ) | \
                         (adime_ ## ac ## _rgb.g = getg(col) ) | \
                         (adime_ ## ac ## _rgb.b = getb(col) ) )
/*
   ADC(text,Blue);
   ADC(disabled_text, LightBlue);
   ADC(error_text, LightGreen);

   ADC(dark_shadow, Cyan);
   // title_text 
   // title_shadow title_highlight

   ADC(highlight, Blue);
   ADC(border,LightMagenta);
*/
   ADC(shadow, Blue);
   ADC(light_highlight, LightBlue);
   ADC(edit_field, GhostGreen);
   ADC(background,BluishPurple);
   ADC(button,BluishPurple);
   ADC(title_background,Purple);
   adime_font = &font_tiny;
   adime_title_font = &font_bold;
   adime_button_font = &font_bold;

}
