#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <allegro.h>
#ifdef _WIN32
       #include <winalleg.h>
       #include <windows.h>
#else
        #include <pthread.h>
#endif
#include <sys/time.h>
#include "domin.h"

#define sqr(x) ((x)*(x))
#define dist(x,y,x2,y2) sqrt(((x)-(x2))*((x)-(x2)) + ((y)-(y2))*((y)-(y2)) )
#define z_dist(x,y) sqrt((x)*(x) + (y)*(y) )

static int frame_count;

static int *wiggle_x;
static int XCenter = 320;
static int YCenter = 240;
static int Yflip;
static 	BITMAP *pixim;





static void parabend_bmp(BITMAP *buffer, int *rx, int *ry) {
	if (rx==0 && ry ==0) return;
	int psize = bitmap_color_depth(buffer);
	if (psize==15) psize = 2; else psize /= 8;
	if (rx) for (int c = 0; c<buffer->h;c++ ) {
		int ssi,sbi,fi,ti;
		int xlen = abs(*rx) * psize;
		int blen = ( buffer->w - abs(*rx) ) * psize;
		if (*rx>0) {
			fi = 0; ti = xlen;
			ssi = blen; sbi = 0;
		} else {
			ti = 0; fi = xlen;
			sbi = blen; ssi = 0;
		}
		void *tb = malloc(xlen);
		memcpy(  tb,                           (void *)&buffer->line[c][ssi], xlen);
		memmove( (void *)&buffer->line[c][ti], (void *)&buffer->line[c][fi], blen);
		memcpy(  (void *)&buffer->line[c][sbi], tb, xlen);
		rx++;
		free(tb);
	}
/*
	if (ry) {
		int ssi,sbi,fi,ti;
		int ylen = abs(ry) * sizeof(unsigned char *);
		int blen = ( buffer->h - abs(ry) ) * sizeof(unsigned char *);
		if (ry>0) {
			fi = 0; ti = abs(ry);
			ssi =  buffer->h - abs(ry); sbi = 0;
		} else {
			ti = 0; fi = abs(ry);
			sbi =  buffer->h - abs(ry); ssi = 0;
		}
		void *tb = malloc(ylen);
		memcpy(  tb,                         (void *)&buffer->line[ssi],   ylen);
		memmove( (void *)&buffer->line[ti],  (void *)&buffer->line[fi], blen);
		memcpy(  (void *)&buffer->line[sbi], tb, ylen);
		free(tb);
	}
*/
}

static int *init_para_x(BITMAP *buffer) {
	return (int *) memset((char *)malloc(buffer->h * sizeof (int)),0,buffer->h * sizeof (int));
}


static void para_clear(int *para, int wid) {
	memset((char *)para, 0, wid * sizeof (int));
}

static void para_add(int *para, int wid, int z, int add) {
	if (z>=0 && z<wid) para[z] += add;
}

static void para_apply_saw(int *para, int wid, int z0, int z1, int zh) {
        if (z0 == z1) {
        	para_add(para, wid, z0, zh);
        	return;
        }
	int zd = (z0<z1?1:-1);
	float slope = zh / fabs(z0-z1);
	float n = 0;
	for (int i = z0; i != z1 + zd; i+=zd, n++) para_add(para, wid, i, (int)(slope * n));
}


static int old_mouse_x,old_mouse_y;

static void PRINT() {
//		show_mouse(pixim);
		int mx = mouse_x;
		int my = mouse_y;
		int msiz = 16; (void)msiz;
		old_mouse_x = mx;
		old_mouse_y = my;
		acquire_screen();
		blit(pixim, screen, 0, 0, 0, 0,SCREEN_W,SCREEN_H);
		release_screen();
		show_mouse(NULL);
}


static void render () {
	int clb =  ((((ms_count * 9) & 1023) ) / 512 );
        int clfn =  ((((ms_count * 3) & 1023) ) / 342 );
	int clf = !clb;
	int rgbm[5] = {0,0,255,0,0};
	//int rgbm[5] = {255,255,0,255,255};
	int clm[2];
	char *saying[] =  {
		"Windows has peformed an ILLEGAL OPERATION at",
                "memory location 0197:78011f41 in KERN32.dll.  It",
                "has become unstable or busy and is detecting",
                "a FAT32 error.  System files are unreadable by",
                "operating system durring a bad command or file",
                "name.  All data apears to be lost or corrupted",
                "and this will all require you to kick your dog.",
        	0
        };
	clm[0] = makecol(0,0,0);
	clm[1] = makecol(rgbm[clfn],rgbm[clfn+1],rgbm[clfn+2]);
	clear_to_color(pixim, clm[clb]);
	int xc =  ((((ms_count ) & 1023) * 800 ) / 1023 );
	//rectfill(pixim, xc,200, xc+100, 280, clm[clf]);
	//rectfill(pixim, 240,xc, 340, xc+80, clm[clf]);
	rectfill(pixim, 0,xc, SCREEN_W, xc+80, clm[clf]);
	int yo = 220 +rand()%4;
	for (char **cp = saying; *cp; cp++, yo += 12)
           textout_ex(pixim, font, *cp, 110+rand()%4, yo, clm[clf],-1);
	para_clear(wiggle_x, SCREEN_H);
	para_apply_saw(wiggle_x, SCREEN_H, xc - 20, xc, 30);
        para_apply_saw(wiggle_x, SCREEN_H, xc + 100, xc + 80, -30);
	parabend_bmp(pixim, wiggle_x, NULL);
}

void refresh_scr() {
	render();
	vsync();
	PRINT();
	frame_count++;
}



void blinky_screen_of_death() {
	int hResult = -1; // this stores return values of functions we access.
	int cd = desktop_color_depth();
	if (cd<15) set_color_depth(16); else set_color_depth(cd);
	int d_width, d_height;
	get_desktop_resolution(&d_width, &d_height);
	hResult = set_gfx_mode( GFX_AUTODETECT_FULLSCREEN, 2* XCenter, 2*YCenter, 0, 0);
	if( hResult < 0 )   {
		hResult = set_gfx_mode( GFX_AUTODETECT, 2* XCenter, 2*YCenter, 0, 0 );
		if( hResult < 0 ) {
			printf( "Could not set video mode. Reason: %s\n", allegro_error );
		}
	}
	pixim = create_bitmap(SCREEN_W, SCREEN_H);
	wiggle_x = init_para_x(pixim);
	Yflip = SCREEN_H;
	install_timer(); //allegro timer req'd for mouse/midi
        while (! keypressed() ) {
                refresh_scr();
        }
	if ( set_gfx_mode(
        	( prefer_windowed ? GFX_AUTODETECT_WINDOWED : GFX_AUTODETECT),
        	default_screen_w, default_screen_h, 0, 0) < 0
	)   {
		 allegro_message( "Could not set video mode. Reason: %s\n", allegro_error );
	}

}





