#include <stdio.h>
#include <string.h>
#include <math.h>
#include <sys/time.h>
#include <allegro.h>
#include "domin.h"
#include "domin_ai.h"

// Read Only Stuff.
// extern int cplayer, playdir;
extern int card_points[numele + 1];
extern int activitym[activeele + 1][activeele + 1];
// extern BOARD *brd;
void outstr(char *s);

int ai_depth = 0;

int my_ai_rest;
//BOARD *cb;

DOMIN_AI(ai_stoopid) {
  ai_depth++;
  if ( my_ai_rest ) { game_rest(my_ai_rest); my_ai_rest = 0; }
  int wtf_counter = 16;
  do {
     move.play_card = rand() % piecesowned;
     move.play_x = rand() % numsq;
     move.play_y = rand() % numsq;
     wtf_counter--;
  } while ( brd->whatis(move.play_x, move.play_y) != none && wtf_counter);
  if (wtf_counter == 0 ) {
  	for (move.play_x = 0; move.play_x < numsq; move.play_x++)
  	for (move.play_y = 0; move.play_y < numsq; move.play_y++)
  	 if (brd->whatis(move.play_x, move.play_y) != none) goto nm_wtf_was_wrong;
	move.play_x = move.play_y = -1;
nm_wtf_was_wrong: ;	
  }
  do { move.swap_with = move.worst_enemy = ( rand() % numplayers + 1); } while (move.swap_with == cplayer);
  move.cross_choice = 1;
  move.hate_element = move.wild_choice = rand() % metal + 1;
  move.gamble_choice = 5;
  move.season_choice = rand() % 5;
  if (ai_depth == 1) {
	char ts[200];
        snprintf(ts,sizeof ts, "Stoopid Move %i (of %i) to %i,%i",
        	move.play_card, piecesowned, move.play_x, move.play_y
	);
        outstr(ts);
  }
  ai_depth--;
}

#define CHK_GOOD_MOVE(vvv...) if ( sk_diff > legal_move) { \
                                       move.play_card = c; \
                                       move.play_x = x;    \
                                       move.play_y = y;    \
                                       legal_move = sk_diff;\
                                       vvv; \
                                }

static int std_morph_eval( BOARD *brd, int cplayer, int *sk, int NPM, int x, int y) {
      int sk_diff = 0;
      int dumby; spot t_card[4];
      t_card[0] = brd->get_spot(x + 1, y,    dumby);
      t_card[1] = brd->get_spot(x - 1, y,    dumby);
      t_card[2] = brd->get_spot(x,     y + 1,dumby);
      t_card[3] = brd->get_spot(x,     y - 1,dumby);
      for (int i = 0; i < 4; i++) sk_diff +=
           t_card[i].m *
           (card_points[t_card[i].t] * (t_card[i].w == cplayer ? -1 : 1) +
           (t_card[i].t == none || t_card[i].t == xenon ? 0 : 2)
      );
      return (sk_diff * NPM);
}

static int sparky_eval( BOARD *brd, int cplayer, int *sk, int t, int m, int x, int y) {
         // this evaluation method only cares about points.
        int NPM = 10;
        if (t == morph) std_morph_eval(brd, cplayer, sk, NPM, x, y);
	int sk_prime[numplayers];
	BOARD *bc = brd->copy();
        spot w_card;
        w_card.w = cplayer;
        w_card.t = (ptyp)t; w_card.m = m;
        bc->put_spot(w_card, x, y);
        bc->save_scores(sk_prime);
        int sk_diff = sk_prime[cplayer] - sk[cplayer];
        for (int i = 1; i  <= numplayers; i++) if (i != cplayer) sk_diff += (sk[i] - sk_prime[i]);
        sk_diff *= NPM;
        if (t == xenon) sk_diff = 5;
        delete bc;
        return sk_diff;
}


static int boshika_eval( BOARD *brd, int cplayer, int *sk, int t, int m, int x, int y) {
        // this evaluation method weights moves to tight spaces higher.
        int NPM = 10;
        if (t == morph) std_morph_eval(brd, cplayer, sk, NPM, x, y);
	int sk_prime[numplayers];
      	spot t_card[4]; int off_board[4];
	BOARD *bc = brd->copy();
        spot w_card;
        w_card.w = cplayer;
        w_card.t = (ptyp)t; w_card.m = m;
        bc->put_spot(w_card, x, y);
        bc->save_scores(sk_prime);
        int sk_diff = sk_prime[cplayer] - sk[cplayer];
        for (int i = 1; i  <= numplayers; i++) if (i != cplayer) sk_diff += (sk[i] - sk_prime[i]);
        sk_diff *= NPM;
        if (t != ltning && t != anti) {
                t_card[0] = bc->get_spot(x + 1, y,     off_board[0]);
                t_card[1] = bc->get_spot(x - 1, y,     off_board[1]);
                t_card[2] = bc->get_spot(x,     y + 1, off_board[2]);
                t_card[3] = bc->get_spot(x,     y - 1, off_board[3]);
                for (int i = 0; i < 4; i++) sk_diff += (
                      t == xenon ?
                      ( (t_card[i].w == cplayer ? 2  : -1 ) * card_points[t_card[i].t] * t_card[i].m ) :
                      ( off_board[i] ? 2 : ( t_card[i].t ? 1 : 0) )
                );
        }
        delete bc;
        return sk_diff;
}

static int hole_bonus(  BOARD *bc, int cplayer, int x, int y) {
        int friendly_freedom_points[5] = {0,5,8,-12,18};
        int hostile_freedom_points[5] =  {0,0,-6,-8,-15};
        spot t_card[4]; int off_board[4]; int dumby;
	spot w_card = bc->get_spot( x, y, dumby);
	if (w_card.m * card_points[w_card.t] < 3 ) return 0;
        t_card[0] = bc->get_spot(x + 1, y,     off_board[0]);
        t_card[1] = bc->get_spot(x - 1, y,     off_board[1]);
        t_card[2] = bc->get_spot(x,     y + 1, off_board[2]);
        t_card[3] = bc->get_spot(x,     y - 1, off_board[3]);
        int sr = 0, sc = 0;
        for (int i = 0; i < 4; i++) {
            sr += ( t_card[i].t == xenon || off_board[i] ? 2 : 0 );
            if ( t_card[i].t != none || off_board[i] ) sc++;
        }
        if (sc == 3 && w_card.w == cplayer) {
                // if enemys cant hurt us lets assume that we acn take the move without penalty.
        	for (int p = 0; p < numplayers; p++) if (p != cplayer) for (int c = 0; c < piecesowned; c++) {
			int t2 = (int) w_card.t;
			int t1 = (int)player[p].got[c].t;
    			if (activitym[t1][t2] != w_card.t) goto no_safe_inc;
		}
		sc++;
no_safe_inc: ;
        }
	return ( w_card.w == cplayer ?
	    friendly_freedom_points[sc] + sr + (w_card.m < 2 ? 0 : w_card.m == 2 ? 10 : 25) :
	    hostile_freedom_points[sc] - sr - (w_card.m < 2 ? 0 : w_card.m == 2 ? 10 : 25)
	);
}

static int hole_bonus2(BOARD *bc, int cplayer, int x, int y) {
        int friendly_freedom_points[5] = {0,5,8,-12,18};
        int hostile_freedom_points[5] =  {0,0,-6,-8,-15};
        spot t_card[4]; int off_board[4]; int dumby;
	spot w_card = bc->get_spot( x, y, dumby);
	if (w_card.m * card_points[w_card.t] < 3 ) return 0;
        t_card[0] = bc->get_spot(x + 1, y,     off_board[0]);
        t_card[1] = bc->get_spot(x - 1, y,     off_board[1]);
        t_card[2] = bc->get_spot(x,     y + 1, off_board[2]);
        t_card[3] = bc->get_spot(x,     y - 1, off_board[3]);
        int sr = 0, sc = 0;
        for (int i = 0; i < 4; i++) {
            sr += ( t_card[i].t == xenon || off_board[i] ? 2 : 0 );
            if ( t_card[i].t != none || off_board[i] ) sc++;
        }
        if (sc == 3 && w_card.w == cplayer) {
                // if enemys cant hurt us lets assume that we acn take the move without penalty.
        	for (int p = 0; p < numplayers; p++) if (p != cplayer) for (int c = 0; c < piecesowned; c++) {
			int t2 = (int) w_card.t;
			int t1 = (int)player[p].got[c].t;
    			if (activitym[t1][t2] != w_card.t) goto no_safe_inc;
		}
		sc++;
no_safe_inc: ;
        }
	return ( w_card.w == cplayer ?
	    friendly_freedom_points[sc] + sr + (w_card.m < 2 ? 0 : w_card.m == 2 ? 10 : 25) :
	    hostile_freedom_points[sc] - sr - (w_card.m < 2 ? 0 : w_card.m == 2 ? 10 : 25)
	);
}

static int hole_eval(BOARD *brd, int cplayer, int *sk, int t, int m, int x, int y) {
	// this evaluation method trys to (suround/avoid surounding)
	// high value pieces (friendly/hostile pieces) with blockers
        int NPM = 10;
        if (t == morph) std_morph_eval(brd, cplayer, sk, NPM, x, y);
        int sk_prime[numplayers];
	BOARD *bc = brd->copy();
        spot w_card;
        w_card.w = cplayer;
        w_card.t = (ptyp)t; w_card.m = m;
        bc->put_spot(w_card, x, y);
        bc->save_scores(sk_prime);
        int sk_diff = sk_prime[cplayer] - sk[cplayer];
        for (int i = 1; i  <= numplayers; i++) if (i != cplayer) sk_diff += (sk[i] - sk_prime[i]);
        sk_diff *= NPM;
        if (t != ltning && t != anti) {
             sk_diff +=
                hole_bonus(bc, cplayer, x,     y) +
                hole_bonus(bc, cplayer, x + 1, y) +
                hole_bonus(bc, cplayer, x - 1, y) +
                hole_bonus(bc, cplayer, x,     y + 1) +
                hole_bonus(bc, cplayer, x,     y - 1);
        }
        delete bc;
        return sk_diff;
}

struct {
   char *name;
   int (*nsq_proc)(BOARD *brd, int cplayer, int *sk, int t, int m, int x, int y);
   int NPM, cutthroat;
} exoskeleton_list[] = {
   {"sparky",  sparky_eval, 10, 0},
   {"boshika", boshika_eval, 10, 0},
   {"holes",   hole_eval, 10, 1}
};

#define TV() if (ai_depth == 1) { printf("[%03i]", sk_diff); if (x == numsq -1) {printf("\n");} }
#define IL() if (ai_depth == 1) { printf("[...]"); if (x == numsq -1) {printf("\n");} }

#define DC() if (ai_depth == 1) { printf("\ncard #%i:\n",c); }



DOMIN_AI(ai_exoskeleton) {	
	// this procedure implements several move rating based AIs.
	ai_depth++;
	int cross_value = 50;
	int free_value = 100;
        ai_stoopid(move, brd, cplayer, 0); // does legal move if none good exist.
        int sk[numplayers], sk_prime[numplayers];
        brd->save_scores(sk);
        for (int c = 1; c <= numplayers; c++) if (c != cplayer && sk[move.worst_enemy] < sk[c]) move.worst_enemy = c;
        int legal_move = -200;
        int (*eval)(BOARD *brd, int cplayer, int *sk, int t, int m, int x, int y) = exoskeleton_list[ai_var].nsq_proc;
        int cutthroat = exoskeleton_list[ai_var].cutthroat;
        // char *who_am_i = exoskeleton_list[ai_var].name;
        int empty_count = 0;
        if (cutthroat)  for (int y = 0; y < numsq; y++) for (int x = 0; x < numsq; x++) {
             if (brd->whatis(x,y) == none) empty_count++;
        }
        int  constrictor = (cutthroat && empty_count * 2 + 5 < sk[cplayer] - sk[move.worst_enemy]);
        int  staller = (cutthroat && empty_count * 2 < sk[move.worst_enemy] - sk[cplayer]);
        for (int c = 0; c < piecesowned; c++) {
        	DC();
                if (ai_depth == 1 && (player[cplayer].got[c].t == bonus || player[cplayer].got[c].t == skip ||  player[cplayer].got[c].t == reverse && legal_move < free_value)) {
                     move.play_card = c;
                     move.play_x = move.play_y = -1;
                     legal_move = 100;
                } else if (ai_depth == 1 && (player[cplayer].got[c].t == cross && legal_move < cross_value)) {
                     move.play_card = c;
                     move.play_x = move.play_y = -1;
                     legal_move = 50;
                } else if (player[cplayer].got[c].t <= metal ||
                    player[cplayer].got[c].t == ltning ||
                    player[cplayer].got[c].t == anti ||
                    player[cplayer].got[c].t == morph ||
                    player[cplayer].got[c].t == xenon
                ) {
                	int sk_diff = 0;
                        for (int y = 0; y < numsq; y++) for (int x = 0; x < numsq; x++) if (brd->whatis(x,y) == none) {
                                sk_diff = eval(brd, cplayer, sk, player[cplayer].got[c].t, player[cplayer].got[c].m, x, y);
                                int nempty_count = 0;
				for (int yc = 0; yc < numsq; yc++) for (int xc = 0; xc < numsq; xc++) {
             				if (brd->whatis(xc,yc) == none) nempty_count++;
        			}
                                if (constrictor) {
                                        if (nempty_count > empty_count) sk_diff += 25;
                                        else if (nempty_count < empty_count) {
                                        	sk_diff -= 18 * (empty_count - nempty_count);
                                	}
                                } else if (staller) {
                                        if (nempty_count > empty_count) sk_diff -= 18;
                                        else if (nempty_count < empty_count) {
                                        	sk_diff += 15 * (empty_count - nempty_count);
                                	}
                                }
                                TV();
                                CHK_GOOD_MOVE();
                        } else { IL(); }
                } else if (player[cplayer].got[c].t == wild) {
                        for (int morph2 = 1; morph2 <= metal; morph2++) {
                                for (int h = 0; h < piecesowned; h++) if (player[cplayer].got[h].t == morph2) goto i_already_have_one;
                                 for (int y = 0; y < numsq; y++) for (int x = 0; x < numsq; x++) if (brd->whatis(x,y) == none) {
                                 	int sk_diff = eval(brd, cplayer, sk, morph2, 1, x, y);
                                 	CHK_GOOD_MOVE(move.wild_choice = morph2);
                                }
                        i_already_have_one: ;
                        }
                }  else if (player[cplayer].got[c].t == schange) {
                        for (int s = 1; s <= 4; s++) {
                                        BOARD *bc = brd->copy();
                                        bc->season_change(s);
                                        bc->save_scores(sk_prime);
                                        int sk_diff = sk_prime[cplayer] - sk[cplayer]; // -1 encourages to save season changes
                                        for (int i = 1; i  <= numplayers; i++) if (i != cplayer) sk_diff += (sk[i] - sk_prime[i]);
                                        sk_diff *= 10;
                                        if (sk_diff > legal_move) {
                                                move.play_card = c;
                                                move.season_choice = s;
                                                legal_move = sk_diff;
                                        }
                                        delete bc;
                        }
                }
        }
        /*
        char ts[200];
        snprintf(ts,sizeof ts, "%s Move %i to %i,%i for %i",
        	who_am_i, move.play_card,  move.play_x, move.play_y, legal_move
	);
        outstr(ts);
        */
        ai_depth--;
}



/*
DOMIN_AI(ai_sparky2) {
	ai_depth++;
        ai_stoopid(move, brd, cplayer, 0); // does legal move if none good exist.
        int sk[numplayers], sk_prime[numplayers];
        brd->save_scores(sk);
        for (int c = 1; c <= numplayers; c++) if (c != cplayer && sk[move.worst_enemy] < sk[c]) move.worst_enemy = c;
        int legal_move = -100;
        for (int c = 0; c < piecesowned; c++) {
                if (ai_depth == 1 && (player[cplayer].got[c].t == bonus || player[cplayer].got[c].t == skip ||  player[cplayer].got[c].t == reverse)) {
                     move.play_card = c;
                     move.play_x = move.play_y = -1;
                     legal_move = 100;
                } else if (player[cplayer].got[c].t <= metal || player[cplayer].got[c].t == ltning ||  player[cplayer].got[c].t == anti) {
                        for (int x = 0; x < numsq; x++) for (int y = 0; y < numsq; y++) if (brd->whatis(x,y) == none) {
                                ai_move taim;
                                BOARD *bc = brd->copy();
                                bc->put_spot(player[cplayer].got[c],x,y);
                                ai_exoskeleton(taim, bc, move.worst_enemy, 0);
                                bc->save_scores(sk_prime);
                                int sk_diff = sk_prime[cplayer] - sk[cplayer];
                                for (int i = 1; i <= numplayers; i++) if (i != cplayer) sk_diff += (sk[i] - sk_prime[i]);
                                if (sk_diff > legal_move) {
                                        move.play_card = c;
                                        move.play_x = x;
                                        move.play_y = y;
                                        legal_move = sk_diff;
                                }
                                delete bc;
                        }
                } else if (player[cplayer].got[c].t == wild) {
                        for (int morph2 = 1; morph2 <= metal; morph2++) {
                                for (int h = 0; h < piecesowned; h++) if (player[cplayer].got[h].t == morph2) goto i_already_have_one;
                                for (int x = 0; x < numsq; x++) for (int y = 0; y < numsq; y++) if (brd->whatis(x,y) == none) {
                                        ai_move taim;
                                        BOARD *bc = brd->copy();
                                        spot t_card = player[cplayer].got[c];
                                        t_card.t = (ptyp)morph2;
                                        bc->put_spot(t_card, x, y);
	                                ai_exoskeleton(taim, bc, move.worst_enemy, 0);
                                        bc->save_scores(sk_prime);
                                        int sk_diff = sk_prime[cplayer] - sk[cplayer];
                                        for (int i = 1; i  <= numplayers; i++) if (i != cplayer) sk_diff += (sk[i] - sk_prime[i]);
                                        if (sk_diff > legal_move) {
                                                move.play_card = c;
                                                move.play_x = x;
                                                move.play_y = y;
                                                move.wild_choice = morph2;
                                                legal_move = sk_diff;
                                        }
                                        delete bc;
                                }
                        i_already_have_one: ;
                        }
                }  else if (player[cplayer].got[c].t == schange) {
                        for (int s = 1; s <= 4; s++) {
                                        ai_move taim;
                                        BOARD *bc = brd->copy();
                                        brd->season_change(s);
                                        int temp_cplayer = cplayer;
                                        cplayer = move.worst_enemy;
                                        ai_sparky(taim);
                                        cplayer = temp_cplayer;
                                        brd->save_scores(sk_prime);
                                        int sk_diff = sk_prime[cplayer] - sk[cplayer] - 1; // -1 encourages to save season changes
                                        for (int i = 1; i  <= numplayers; i++) if (i != cplayer) sk_diff += (sk[i] - sk_prime[i]);
                                        if (sk_diff > legal_move) {
                                                move.play_card = c;
                                                move.season_choice = s;
                                                legal_move = sk_diff;
                                        }
                                        delete brd;
                                        brd = bc;
                        }
                }  else if (player[cplayer].got[c].t == morph) {
                        for (int x = 0; x < numsq; x++) for (int y = 0; y < numsq; y++) if (brd->whatis(x,y) == none) {
                                int sk_diff = 0;
                                int dumby; spot t_card[4];
                                t_card[0] = brd->get_spot(x + 1, y,    dumby);
                                t_card[1] = brd->get_spot(x - 1, y,    dumby);
                                t_card[2] = brd->get_spot(x,     y + 1,dumby);
                                t_card[3] = brd->get_spot(x,     y - 1,dumby);
                                for (int i = 0; i < 4; i++) sk_diff +=
                                        t_card[i].m *
                                        (card_points[t_card[i].t] * (t_card[i].w == cplayer ? -1 : 1) +
                                        (t_card[i].t == none || t_card[i].t == xenon ? 0 : 2));
                                if (sk_diff > legal_move) {
                                        move.play_card = c;
                                        move.play_x = x;
                                        move.play_y = y;
                                        legal_move = sk_diff;
                                }
                        }
                }
        }        
        char ts[200];
        snprintf(ts,sizeof ts, "Sparky2 Move %i to %i,%i for %i",
        	move.play_card,  move.play_x, move.play_y, legal_move
	);
        outstr(ts);
        ai_depth--;
}
*/


char *ai_name_list[NUM_AI_NAMES] =   {"Human", "Stoopid",     "Sparky",    /* "Sparky II", */             "Holes",           "Mega-X"};
ai_container ai_list[NUM_AI_NAMES] = {{NULL,0},{ai_stoopid,0},{ai_exoskeleton,0}, /* {ai_sparky2,0}, */ {ai_exoskeleton,2}, {ai_exoskeleton,1}};


