#include "config.h"
#include <stdio.h>
#include <string.h>
#include <allegro.h>
#include "domin.h"
#include "sounds.h"
#include "anim.h"

#define NF 250
#define E(idx,ms,iam,next) {SPR_ ## idx ## _BMP,ms,iam,next}
#define A(idx,ms) {SPR_ ## idx ## _BMP,ms,-1,NULL}
#define UNLOOPED(t,spr) aspath ani_ ## t ## _loop[] = { E(spr, 0, t, NULL) };

/******************** ani loops ****************************/

UNLOOPED(none,BLANK)

#define ani_scorched_loop ani_none_loop
#define ani_dust_loop ani_none_loop
#define ani_rusted_loop ani_none_loop


aspath ani_wind_loop[] = {
  A(WIND1,150),
  A(WIND2,150),
  A(WIND3,150),
  E(WIND2,150,wind, ani_wind_loop)
};

aspath ani_wood_loop[] = {
  A(TREE1, 1200),
  E(TREE2,  320, wood, ani_wood_loop)
};

UNLOOPED(rock,ROCK)

aspath ani_fire_loop[] = {
  A(FIRE1, NF),
  A(FIRE2, NF),
  E(FIRE3, NF, fire, ani_fire_loop)
};

aspath ani_water_loop[] = {
  A(WATER1, 800),
  E(WATER2, 800, water, ani_water_loop)
};

UNLOOPED(ice,ICE)

UNLOOPED(metal,METAL)

#define LTT 120
aspath ani_ltning_loop[] = {
  A(LIGHTINING2, LTT),
  A(LIGHTINING3, LTT),
  A(LIGHTINING4, LTT),
  A(LIGHTINING5, LTT),
  A(LIGHTINING6, LTT),
  A(LIGHTINING5, LTT),
  A(LIGHTINING4, LTT),
  E(LIGHTINING3, LTT, ltning, ani_ltning_loop)
};
#undef LTT

aspath ani_anti_loop[] = {
  A(ANTIMATER1, NF),
  A(ANTIMATER2, NF),
  A(ANTIMATER3, NF),
  E(ANTIMATER4, NF,anti,ani_anti_loop),
};

#define MT 160
aspath ani_morph_loop[] = {
  A(MORPH1, MT),
  A(MORPH2, MT),
  A(MORPH3, MT),
  A(MORPH4, MT),
  A(MORPH5, MT),
  A(MORPH4, MT),
  A(MORPH3, MT),
  E(MORPH2, MT, morph, ani_morph_loop)
};
#undef MT

UNLOOPED(xenon, XENON)

aspath ani_wild_loop[] = {
  A(WILD1, NF),
  A(WILD2, NF),
  A(WILD3, NF),
  A(WILD4, NF),
  A(WILD3, NF),
  E(WILD2, NF, wild, ani_wild_loop)
};

aspath ani_cross_loop[] = {
  A(CROSS1, NF),
  A(CROSS2, NF),
  A(CROSS3, NF),
  A(CROSS4, NF),
  A(CROSS5, NF),
  E(CROSS6, 800, cross, ani_cross_loop)
};

aspath ani_skip_loop[] = {
  A(SKIP1, NF),
  A(SKIP2, NF),
  A(SKIP3, NF),
  E(SKIP2, NF, skip, ani_skip_loop)
};

aspath ani_reverse_loop[] = {
  A(REVERSE1, NF),
  A(REVERSE2, NF),
  A(REVERSE3, NF),
  A(REVERSE4, NF),
  A(REVERSE5, NF),
  E(REVERSE6, NF, reverse, ani_reverse_loop)
};

#define SCT1 310
#define SCT2 150
aspath ani_schange_loop[] = {
  A(SEASONCHANGE1, SCT1),
  A(SEASONCHANGE2, SCT2),
  A(SEASONCHANGE3, SCT1),
  A(SEASONCHANGE4, SCT2),
  A(SEASONCHANGE5, SCT1),
  A(SEASONCHANGE6, SCT2),
  A(SEASONCHANGE7, SCT1),
  E(SEASONCHANGE8, SCT2, schange, ani_schange_loop)
};
#undef SCT1
#undef SCT2


UNLOOPED(bonus, BONUS)

#define L(x) ani_ ## x ## _loop
aspath *ani_loop_list[] = {
  L(none), L(wind), L(wood), L(rock),L(fire), L(water),
  L(ice),L(metal),L(ltning),L(anti),L(morph), L(xenon),
  L(wild), L(cross), L(skip), L(reverse),
  L(schange), L(bonus)
};
#undef L


/******************** ani starts ****************************/

aspath ani_wind_start[] = {
  A(WINDGROW1, NF),
  A(WINDGROW2, NF),
  E(WIND3, NF, wind, ani_wind_loop)
};


aspath ani_wood_start[] = {
  A(TREEGROW1, NF),
  A(TREEGROW2, NF),
  E(TREEGROW3, NF, wood, ani_wood_loop),
};

aspath ani_rock_start[] = {
  A(ROCKRISE1, 330),
  A(ROCKRISE2, 330),
  E(ROCKRISE3, 330, rock, ani_rock_loop),};

aspath ani_fire_start[] = {
  A(FIREDIE4, NF),
  A(FIRELITE1, NF),
  E(FIRELITE2, NF, fire, ani_fire_loop)
};


aspath ani_water_start[] = {
 A(WATERDRY3, NF),
 A(WATERDRY2, NF),
 E(WATERDRY1, NF, water, ani_water_loop),
};

aspath ani_ice_start[] = {
 A(ICEMAKE1, NF),
 A(ICEMAKE2, NF),
 E(ICEMELT1, NF, water, ani_ice_loop),
};

aspath ani_metal_start[] = {
 A(METALFALL1, NF),
 A(METALFALL2, NF),
 A(METALFALL3, NF),
 E(METALFALL4, NF, water, ani_metal_loop),
};


#define LTT 100
aspath ani_ltning_start[] = {
  A(LIGHTINING1, LTT),
  A(LIGHTINING2, LTT),
  A(LIGHTINING3, LTT),
  A(LIGHTINING4, LTT),
  A(LIGHTINING5, LTT),
  A(LIGHTINING6, LTT),
  E(LIGHTINING7, LTT, none, ani_none_loop)
};
#undef LTT

aspath ani_anti_start[] = {
  A(ANTIMATER1, 150),
  A(ANTIMATER2, 150),
  A(ANTIMATER3, 150),
  A(ANTIMATER4, 150),
  A(ANTIMATER1, 150),
  A(ANTIMATER2, 150),
  A(ANTIMATER3, 150),
  E(ANTIMATER4, 150, none, ani_none_loop)
};


#define MT 160
aspath ani_morph_start[] = {
  A(MORPH1, MT),
  A(MORPH2, MT),
  A(MORPH3, MT),
  A(MORPH4, MT),
  E(MORPH5, MT, none, ani_none_loop)
};
#undef MT

aspath ani_xenon_start[] = {
  E(XENONGROW, 300, xenon, ani_xenon_loop)
};

#define L(x) ani_ ## x ## _start
aspath *ani_start_list[] = {
  ani_none_loop, L(wind), L(wood), L(rock),L(fire), L(water),
  L(ice),L(metal),L(ltning),L(anti),L(morph), L(xenon),
  // L(wild), L(cross), L(skip), L(reverse),
  // L(schange), L(bonus)
};
#undef L


/******************** substance change ani's ****************************/

aspath ani_drown_fire[] = {
  A(FIREDIE1, NF),
  A(FIREDIE2, NF),
  A(FIREDIE3, NF),
  E(FIREDIE4, NF, none, ani_scorched_loop)
};

aspath ani_melt_ice[] = {
  A(ICEMELT1, NF),
  A(ICEMELT2, NF),
  E(ICEMELT3, NF, water, ani_water_loop)
};

aspath ani_freeze_water[] = {
  A(ICEMELT3, NF),
  A(ICEMELT2, NF),
  E(ICEMELT1, NF, ice, ani_ice_loop)
};

aspath ani_crack_rock[] = {
  A(ROCK, NF * 2),
  A(ROCKBREAK1, NF),
  A(ROCKBREAK2, NF),
  E(ROCKBREAK3, NF, none, ani_dust_loop)
};

aspath ani_freeze_rock[] = {
  A(ROCKFREEZE1, NF),
  A(ROCKFREEZE2, NF),
  A(ROCKFREEZE3, NF),
  A(ROCKFREEZE4, NF),
  A(ROCKFREEZE5, NF),
  E(ROCKFREEZE6, NF, none, ani_dust_loop)
};

aspath ani_frost_tree[] = {
  A(TREEDIE1,NF),
  A(TREEDIE2,NF),
  A(TREEDIE3,NF),
  A(TREEDIE4,NF),
  E(TREEDIE5,NF, none, ani_none_loop),
};

aspath ani_burn_tree[] = {
  A(TREEBURN1, NF),
  A(TREEBURN2, NF),
  A(TREEBURN3, NF),
  E(TREEBURN4, NF, fire, ani_fire_loop)
};

aspath ani_kill_wind[] = {
  A(WIND3, NF),
  A(WINDGROW2, NF),
  A(WIND3, NF),
  A(WINDGROW2, NF),
  E(WINDGROW1, NF, none, ani_none_loop)
};

aspath ani_growtree_water[] = {
 A(WATERDRY1, NF),
 A(WATERDRY2, NF),
 E(WATERDRY3, NF, wood, ani_wood_start)
};

aspath ani_crack_ice[] = {
 A(ICEBREAK1, NF),
 A(ICEBREAK2, NF),
 E(ICEBREAK3, NF, none, ani_none_loop)
};

aspath ani_rust_metal[] = {
  A(METALRUST1, NF),
  A(METALRUST1, NF),
  E(METALRUST3, NF, none, ani_rusted_loop)
};

//=============== Temp Suff =====================


#define SHKT 800
aspath ani_elecrol[] = {
  E(ZAP, SHKT, water, ani_water_loop)
};

aspath ani_relecrol[] = {
  E(ZAP, SHKT, wind, ani_wind_loop)
};

aspath ani_shock_metal[] = {
  E(ZAP, SHKT, metal, ani_metal_loop)
};
#undef SHKT

#define ani_expl_tree ani_frost_tree


aspath ani_expl_water[] = { //temp
 A(WATERDRY1, NF),
 A(WATERDRY2, NF),
 E(WATERDRY3, NF, none, ani_none_loop)
};


#define ani_expl_rock ani_crack_rock
#define ani_expl_ice ani_crack_ice
#define ani_expl_metal ani_rust_metal
#define ani_magic_morph ani_morph_loop
#define ani_splash_water ani_expl_water
#define ani_blow_fire ani_drown_fire


#undef NF
#undef E
#undef A
#undef UNLOOPED



aspath *ani_matrix[morph + 1][metal + 1] = {
         /*(none, wind,          wood,          rock,           fire,      water,        ice,     metal)*/
/*none*/  { NULL, NULL,          NULL,          NULL,           NULL,      NULL,         NULL,    NULL},
/*wind*/  { NULL, NULL,          NULL,          NULL,  ani_blow_fire,   ani_freeze_water,NULL,    NULL},
/*wood*/  { NULL, ani_kill_wind, NULL,          NULL,           NULL, ani_growtree_water,NULL,    NULL},
/*rock*/  { NULL, NULL,          NULL,          NULL,           NULL, ani_splash_water,  NULL,    NULL},
/*fire*/  { NULL, NULL,          ani_burn_tree, NULL,           NULL,      NULL, ani_melt_ice,    NULL},
/*water*/ { NULL, NULL,          NULL,          NULL,      ani_drown_fire, NULL,         NULL,   ani_rust_metal},
/*ice*/   { NULL, NULL,          ani_frost_tree,ani_freeze_rock,NULL,      NULL,         NULL,    NULL},
/*metal*/ { NULL, NULL,          NULL,          ani_crack_rock, NULL,      NULL, ani_crack_ice,   NULL },
/*ltng*/  { NULL, ani_elecrol,   ani_burn_tree, ani_expl_rock,  NULL,   ani_relecrol, ani_melt_ice, ani_shock_metal},

/*anti*/  { NULL, ani_kill_wind, ani_expl_tree, ani_expl_rock,  ani_drown_fire,ani_expl_water, ani_expl_ice, ani_expl_metal},
/*morph*/ { NULL, ani_magic_morph,ani_magic_morph,ani_magic_morph,ani_magic_morph,ani_magic_morph,ani_magic_morph}
};


int put_sound_list[] = {
   -1, SND_PUT_WIND_WAV, SND_PUT_WOOD_WAV, SND_PUT_ROCK_WAV,  SND_PUT_FIRE_WAV,
   SND_PUT_WATER_WAV, SND_PUT_ICE_WAV, SND_PUT_METAL_WAV, SND_PUT_LIGHTNING_WAV,
   SND_PUT_ANTI_WAV, SND_PUT_MORPH_WAV, SND_PUT_XENON_WAV, -1/*wild*/,
   SND_PUT_CROSS_WAV, SND_PUT_SKIP_WAV, SND_PUT_REVERSE_WAV, SND_PUT_SCHANGE_WAV,
   SND_PUT_BONUS_WAV
};

#define NOS {-1, 0}
#define Q(s) {SND_ ## s ## _WAV, 300}
#define X(s,t) {SND_ ## s ## _WAV, t}

sound_matrix_t sound_matrix[ltning + 1][metal + 1] = {
        /*(none, wind,        wood,   rock,        fire, water,       ice,   metal)*/
/*none*/  { NOS, NOS,         NOS,     NOS,         NOS, NOS,             NOS,    NOS},
/*wind*/  { NOS, NOS,         NOS,     NOS, Q(PUT_FIRE), Q(PUT_ICE),      NOS,    NOS},
/*wood*/  { NOS, Q(WIND_DIE), NOS,     NOS,         NOS, X(PUT_WOOD,600),  NOS,    NOS},
/*rock*/  { NOS, NOS,         NOS,     NOS,         NOS, Q(PUT_WATER),    NOS,    NOS},
/*fire*/  { NOS, NOS, Q(PUT_FIRE),     NOS,         NOS, NOS,             NOS,    NOS},
/*water*/ { NOS, NOS,         NOS,     NOS, Q(FIRE_DIE), NOS,             NOS,    NOS},
/*ice*/   { NOS, NOS, Q(WOOD_DIE), Q(ROCK_CRACK),   NOS, NOS,             NOS,    NOS},
/*metal*/ { NOS, NOS,         NOS, Q(ROCK_CRACK),   NOS, NOS,  Q(ICE_SHATTER),    NOS},
/*ltng*/  { NOS, NOS, Q(PUT_FIRE), Q(ROCK_CRACK),   NOS, NOS,             NOS,    NOS}
};

#undef X
#undef Q
#undef NOS




