/*---------------------------------------------------------------------------/
/ Chryzodus - A chryzode explorer                                            /
/ http://chryzodus.sourceforge.net                                           /
/ Copyright (C) 2004 Florian LHERBETTE                                       /
/                                                                            /
/----------------------------------------------------------------------------/
/                                                                            /
/ This program is free software; you can redistribute it and/or              /
/ modify it under the terms of the GNU General Public License                /
/ as published by the Free Software Foundation; either version 2             /
/ of the License, or (at your option) any later version.                     /
/                                                                            /
/ This program is distributed in the hope that it will be useful,            /
/ but WITHOUT ANY WARRANTY; without even the implied warranty of             /
/ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              /
/ GNU General Public License for more details.                               /
/                                                                            /
/ You should have received a copy of the GNU General Public License          /
/ along with this program; if not, write to the Free Software                /
/ Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA./
/                                                                            /
/----------------------------------------------------------------------------/
/                                                                            /
/ Chryzodus version 0.32                                                     /
/ main.cpp : Main source file                                                /
/                                                                            /
/---------------------------------------------------------------------------*/

#include <allegro.h>
#include "gui.h"
#include "compute.h"

int close_button_clicked = 0;

void close_button_callback(void)
{
	close_button_clicked = 1;
}

int main(void)
{
	BITMAP *buffer;
	Cchryzode *chryzode;
	char status[128]; // hum on prevoit large... Au fait pourquoi le declarer ici ?
	DIALOG_PLAYER *player;
	int done = 0;

	allegro_init();
	install_keyboard();
	install_timer();
	install_mouse();

	// initialisation graphique... A REVOIR !
	set_color_depth(desktop_color_depth());
	if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0)) set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0);

	set_window_title("Chryzodus - a chryzode explorer");
	set_close_button_callback(close_button_callback);

	buffer = create_bitmap(SCREEN_W, SCREEN_H);
	clear(buffer);
	chryzode = new Cchryzode(buffer);
	main_dialog[MAIN_D_CHRYZODE].dp = buffer;
	main_dialog[MAIN_D_CHRYZODE].dp2 = chryzode;
	main_dialog[MAIN_D_CHRYZODE].w = buffer->w;
	main_dialog[MAIN_D_CHRYZODE].h = buffer->h;
	usprintf(status, "Chryzodus 0.31");
	main_dialog[MAIN_D_STATUS].dp = status;
	set_dialog_color(main_dialog, gui_fg_color, gui_bg_color);

	show_mouse(screen);

	player = init_dialog(main_dialog, -1);
	while (!done)
	{
		if (update_dialog(player)==0)
			if (player->obj!=-1) done = 1;
		if (close_button_clicked) done = 1;
	}
	shutdown_dialog(player);

	delete chryzode;
	return 0;
}
END_OF_MAIN();
