/*---------------------------------------------------------------------------/
/ Chryzodus - A chryzode explorer                                            /
/ http://chryzodus.sourceforge.net                                           /
/ Copyright (C) 2004 Florian LHERBETTE                                       /
/                                                                            /
/----------------------------------------------------------------------------/
/                                                                            /
/ This program is free software; you can redistribute it and/or              /
/ modify it under the terms of the GNU General Public License                /
/ as published by the Free Software Foundation; either version 2             /
/ of the License, or (at your option) any later version.                     /
/                                                                            /
/ This program is distributed in the hope that it will be useful,            /
/ but WITHOUT ANY WARRANTY; without even the implied warranty of             /
/ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              /
/ GNU General Public License for more details.                               /
/                                                                            /
/ You should have received a copy of the GNU General Public License          /
/ along with this program; if not, write to the Free Software                /
/ Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA./
/                                                                            /
/----------------------------------------------------------------------------/
/                                                                            /
/ Chryzodus version 0.32                                                     /
/ gui.cpp : Graphical User Interface source file                             /
/                                                                            /
/---------------------------------------------------------------------------*/

#include <string.h>
#include "gui.h"
#include "compute.h"

DIALOG save_chryzode_dialog[] =
{
	{ d_box_proc, 0, 0, 300, 150, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL },
	{ d_textbox_proc, 0, 0, 300, 16, 0, 0, 0, 0, 0, 0, (void *)"Save as", NULL, NULL },
	{ d_button_proc, 30, 100, 100, 20, 0, 0, 13, D_CLOSE, 0, 0, (void *)"OK", NULL, NULL },
	{ d_button_proc, 170, 100, 100, 20, 0, 0, 0, D_CLOSE, 0, 0, (void *)"Cancel", NULL, NULL },
	{ d_text_proc, 30, 50, 120, 16, 0, 0, 0, 0, 0, 0, (void *)"name (.bmp) :", NULL, NULL },
	{ d_edit_proc, 150, 50, 120, 16, 0, 0, 0, 0, 63, 0, NULL, NULL, NULL },
	{ d_yield_proc, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL },
	{ NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL }
};

int save_chryzode(void)
{
	int ret;
	static char directory[192]="", filename[64]=".bmp";
	char path[256];

	file_select_ex("Choose saving directory", directory, "/+d", 192, 400, 300);

	save_chryzode_dialog[SAVE_D_EDIT].dp = (void *)filename;
	set_dialog_color(save_chryzode_dialog, gui_fg_color, gui_bg_color);
	centre_dialog(save_chryzode_dialog);
	ret = do_dialog(save_chryzode_dialog, -1);
	if (ret == COMMON_D_OK && (BITMAP *)main_dialog[MAIN_D_CHRYZODE].dp)
	{
		strcpy(path, directory);
		strcat(path, filename);
		save_bmp(path, (BITMAP *)active_dialog[MAIN_D_CHRYZODE].dp, NULL);
	}
	broadcast_dialog_message(MSG_DRAW, 0);
	return D_O_K;
}

char *gfx_list(int index, int *list_size)
{
	static char *modes[] =
	{
		"640x480 Windowed",
		"640x480 Fullscreen",
		"800x600 Windowed",
		"800x600 Fullscreen",
		"1024x768 Windowed",
		"1024x768 Fullscreen"
	};
	if (index < 0)
	{
		*list_size = 6;
		return NULL;
	}
	return modes[index];
}

DIALOG gfx_dialog[] =
{
	{ d_box_proc, 0, 0, 400, 300, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL },
	{ d_textbox_proc, 0, 0, 400, 16, 0, 0, 0, 0, 0, 0, (void *)"Changing graphics mode", NULL, NULL },
	{ d_button_proc, 50, 260, 100, 20, 0, 0, 13, D_CLOSE, 0, 0, (void *)"OK", NULL, NULL },
	{ d_button_proc, 250, 260, 100, 20, 0, 0, 0, D_CLOSE, 0, 0, (void *)"Cancel", NULL, NULL },
	{ d_list_proc, 50, 50, 300, 100, 0, 0, 0, D_CLOSE, 0, 0, (void *)gfx_list, NULL, NULL },
	{ d_yield_proc, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL },
	{ NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL }
};

int change_gfx_mode(void)
{
	int res, old_w=SCREEN_W, old_h=SCREEN_H;
	set_dialog_color(gfx_dialog, gui_fg_color, gui_bg_color);
	centre_dialog(gfx_dialog);
	res = do_dialog(gfx_dialog, -1);
	if (res == COMMON_D_OK || res == GFX_D_LIST)
	{
		switch (gfx_dialog[GFX_D_LIST].d1)
		{
			case 0: res = set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0);
				break;
			case 1: res = set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0);
				break;
			case 2: res = set_gfx_mode(GFX_AUTODETECT_WINDOWED, 800, 600, 0, 0);
				break;
			case 3: res = set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 800, 600, 0, 0);
				break;
			case 4: res = set_gfx_mode(GFX_AUTODETECT_WINDOWED, 1024, 768, 0, 0);
				break;
			case 5: res = set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 1024, 768, 0, 0);
				break;
		}
		if (res == 0)
		{
			// utiliser d_chryzode_proc pour tenir  jour la bitmap ??????
			destroy_bitmap((BITMAP *)main_dialog[MAIN_D_CHRYZODE].dp);
			(BITMAP *)main_dialog[MAIN_D_CHRYZODE].dp = create_bitmap(SCREEN_W, SCREEN_H);
			((Cchryzode *)main_dialog[MAIN_D_CHRYZODE].dp2)->set_bmp((BITMAP *)main_dialog[MAIN_D_CHRYZODE].dp);
			main_dialog[MAIN_D_CHRYZODE].w = SCREEN_W;
			main_dialog[MAIN_D_CHRYZODE].h = SCREEN_H;
			main_dialog[MAIN_D_STATUS].y = SCREEN_H - 20;
			main_dialog[MAIN_D_STATUS].w = SCREEN_W;
		}
		else
		{
			set_gfx_mode(GFX_AUTODETECT, old_w, old_h, 0, 0);
			alert("Error !", "Unable to change", "Graphics mode", "OK", NULL, 0, 0);
		}
		show_mouse(screen);
	}
	broadcast_dialog_message(MSG_DRAW, 0);
	return D_O_K;
}

int quit(void)
{
	return D_CLOSE;
}

MENU file_menu[] =
{
	{ "&Save image as", save_chryzode, NULL, D_DISABLED, NULL },
	{ "&Graphics Mode", change_gfx_mode, NULL, 0, NULL },
	{ "&Quit", quit, NULL, 0, NULL },
	{ NULL, NULL, NULL, 0, NULL }
};

int zoom_ratio = 2;
int zoom_value = 1;

int zoom_normal(void)
{
	zoom_value = 1;
	((Cchryzode *)main_dialog[MAIN_D_CHRYZODE].dp2)->set_zoom(zoom_value);
	((Cchryzode *)main_dialog[MAIN_D_CHRYZODE].dp2)->rerender();
	((Cchryzode *)main_dialog[MAIN_D_CHRYZODE].dp2)->status((char *)active_dialog[MAIN_D_STATUS].dp);
	broadcast_dialog_message(MSG_DRAW, 0);
	return D_O_K;
}

DIALOG zoom_value_dialog[] =
{
	{ d_box_proc, 0, 0, 300, 150, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL },
	{ d_textbox_proc, 0, 0, 300, 16, 0, 0, 0, 0, 0, 0, (void *)"Zoom value", NULL, NULL },
	{ d_button_proc, 30, 100, 100, 20, 0, 0, 13, D_CLOSE, 0, 0, (void *)"OK", NULL, NULL },
	{ d_button_proc, 170, 100, 100, 20, 0, 0, 0, D_CLOSE, 0, 0, (void *)"Cancel", NULL, NULL },
	{ d_text_proc, 50, 50, 50, 16, 0, 0, 0, 0, 0, 0, (void *)"zoom =", NULL, NULL },
	{ d_edit_proc, 110, 50, 70, 16, 0, 0, 0, 0, 7, 0, NULL, NULL, NULL },
	{ d_yield_proc, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL },
	{ NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL }
};

int zoom_change_value(void)
{
	int ret;
	char zoom_string[8];
	uszprintf(zoom_string, sizeof(zoom_string), "%d", zoom_value);
	zoom_value_dialog[ZOOM_V_D_EDIT].dp = (void *)zoom_string;
	set_dialog_color(zoom_value_dialog, gui_fg_color, gui_bg_color);
	centre_dialog(zoom_value_dialog);
	ret = do_dialog(zoom_value_dialog, -1);
	broadcast_dialog_message(MSG_DRAW, 0);
	if (ret == COMMON_D_OK)
	{
		zoom_value = ustrtol(zoom_string, NULL, 10);
		((Cchryzode *)main_dialog[MAIN_D_CHRYZODE].dp2)->set_zoom(zoom_value);
		((Cchryzode *)main_dialog[MAIN_D_CHRYZODE].dp2)->rerender();
		((Cchryzode *)main_dialog[MAIN_D_CHRYZODE].dp2)->status((char *)main_dialog[MAIN_D_STATUS].dp);
	}
	broadcast_dialog_message(MSG_DRAW, 0);
	return D_O_K;
}

DIALOG zoom_ratio_dialog[] =
{
	{ d_box_proc, 0, 0, 300, 150, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL },
	{ d_textbox_proc, 0, 0, 300, 16, 0, 0, 0, 0, 0, 0, (void *)"Zoom in/zoom out ratio", NULL, NULL },
	{ d_button_proc, 30, 100, 100, 20, 0, 0, 13, D_CLOSE, 0, 0, (void *)"OK", NULL, NULL },
	{ d_button_proc, 170, 100, 100, 20, 0, 0, 0, D_CLOSE, 0, 0, (void *)"Cancel", NULL, NULL },
	{ d_text_proc, 50, 50, 50, 16, 0, 0, 0, 0, 0, 0, (void *)"ratio =", NULL, NULL },
	{ d_edit_proc, 110, 50, 70, 16, 0, 0, 0, 0, 3, 0, NULL, NULL, NULL },
	{ d_yield_proc, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL },
	{ NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL }
};

int zoom_change_ratio(void)
{
	int ret;
	char zoom_ratio_string[4];
	uszprintf(zoom_ratio_string, sizeof(zoom_ratio_string), "%d", zoom_ratio);
	zoom_ratio_dialog[ZOOM_R_D_EDIT].dp = (void *)zoom_ratio_string;
	set_dialog_color(zoom_ratio_dialog, gui_fg_color, gui_bg_color);
	centre_dialog(zoom_ratio_dialog);
	ret = do_dialog(zoom_ratio_dialog, -1);
	if (ret == COMMON_D_OK)
	{
		zoom_ratio = ustrtol(zoom_ratio_string, NULL, 10);
		if (zoom_value < zoom_ratio) zoom_menu[ZOOM_M_IN].flags = D_DISABLED;
	}
	broadcast_dialog_message(MSG_DRAW, 0);
	return D_O_K;
}

int zoom_out(void)
{
	zoom_value *= zoom_ratio;
	((Cchryzode *)main_dialog[MAIN_D_CHRYZODE].dp2)->set_zoom(zoom_value);
	((Cchryzode *)main_dialog[MAIN_D_CHRYZODE].dp2)->rerender();
	((Cchryzode *)main_dialog[MAIN_D_CHRYZODE].dp2)->status((char *)main_dialog[MAIN_D_STATUS].dp);
	broadcast_dialog_message(MSG_DRAW, 0);
	if (zoom_value >= zoom_ratio) zoom_menu[ZOOM_M_IN].flags = 0;
	return D_O_K;
}

int zoom_in(void)
{
	zoom_value /= zoom_ratio;
	((Cchryzode *)main_dialog[MAIN_D_CHRYZODE].dp2)->set_zoom(zoom_value);
	((Cchryzode *)main_dialog[MAIN_D_CHRYZODE].dp2)->rerender();
	((Cchryzode *)main_dialog[MAIN_D_CHRYZODE].dp2)->status((char *)main_dialog[MAIN_D_STATUS].dp);
	broadcast_dialog_message(MSG_DRAW, 0);
	if (zoom_value < zoom_ratio) zoom_menu[ZOOM_M_IN].flags = D_DISABLED;
	return D_O_K;
}

MENU zoom_menu[] =
{
	{ "&Normal size", zoom_normal, NULL, D_DISABLED, NULL },
	{ "Zoom &Value", zoom_change_value, NULL, D_DISABLED, NULL },
	{ "Zoom &Ratio", zoom_change_ratio, NULL, D_DISABLED, NULL },
	{ "Zoom &Out", zoom_out, NULL, D_DISABLED, NULL },
	{ "Zoom &In", zoom_in, NULL, D_DISABLED, NULL },
	{ NULL, NULL, NULL, 0, NULL }
};

char new_string[4][6];

DIALOG new_dialog[] =
{
	{ d_box_proc, 0, 0, 400, 300, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL },
	{ d_textbox_proc, 0, 0, 400, 16, 0, 0, 0, 0, 0, 0, (void *)"New chryzode", NULL, NULL },
	{ d_button_proc, 70, 260, 100, 20, 0, 0, 13, D_CLOSE, 0, 0, (void *)"OK", NULL, NULL },
	{ d_button_proc, 230, 260, 100, 20, 0, 0, 0, D_CLOSE, 0, 0, (void *)"Cancel", NULL, NULL },
	{ d_text_proc, 30, 50, 30, 16, 0, 0, 0, 0, 0, 0, (void *)"n =", NULL, NULL },
	{ d_edit_proc, 90, 50, 50, 16, 0, 0, 0, 0, 5, 0, (void *)new_string[0], NULL, NULL },
	{ d_text_proc, 30, 100, 30, 16, 0, 0, 0, 0, 0, 0, (void *)"m =", NULL, NULL },
	{ d_edit_proc, 90, 100, 50, 16, 0, 0, 0, 0, 5, 0, (void *)new_string[1], NULL, NULL },
	{ d_text_proc, 30, 150, 30, 16, 0, 0, 0, 0, 0, 0, (void *)"r =", NULL, NULL },
	{ d_edit_proc, 90, 150, 50, 16, 0, 0, 0, 0, 5, 0, (void *)new_string[2], NULL, NULL },
	{ d_text_proc, 30, 200, 30, 16, 0, 0, 0, 0, 0, 0, (void *)"zoom =", NULL, NULL },
	{ d_edit_proc, 90, 200, 50, 16, 0, 0, 0, 0, 5, 0, (void *)new_string[3], NULL, NULL },
	{ d_box_proc, 190, 40, 180, 90, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL },
	{ d_text_proc, 200, 50, 140, 16, 0, 0, 0, 0, 0, 0, (void *)"Computation mode :", NULL, NULL },
	{ d_radio_proc, 210, 70, 100, 16, 0, 0, 0, D_SELECTED, 1, 0, (void *)"From root", NULL, NULL },
	{ d_radio_proc, 210, 100, 100, 16, 0, 0, 0, 0, 1, 0, (void *)"Complete", NULL, NULL },
	{ d_box_proc, 190, 140, 180, 90, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL },
	{ d_text_proc, 200, 150, 140, 16, 0, 0, 0, 0, 0, 0, (void *)"Pts of intersection :", NULL, NULL },
	{ d_radio_proc, 210, 170, 100, 16, 0, 0, 0, D_SELECTED, 2, 0, (void *)"On the fly", NULL, NULL },
	{ d_radio_proc, 210, 200, 100, 16, 0, 0, 0, 0, 2, 0, (void *)"Stored", NULL, NULL },
	{ d_yield_proc, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL },
	{ NULL, 0, 0, 0,0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL }
};

int new_chryzode(void)
{
	static int n=2, m=1499, r=1, zoom_temp=1, type_temp=Cchryzode::racine | Cchryzode::on_the_fly;
	int type, res;
	DIALOG_PLAYER *player;

	uszprintf(new_string[0], sizeof(new_string[0]), "%d", n);
	uszprintf(new_string[1], sizeof(new_string[1]), "%d", m);
	uszprintf(new_string[2], sizeof(new_string[2]), "%d", r);
	uszprintf(new_string[3], sizeof(new_string[3]), "%d", zoom_temp);

    // Peut etre un peu lourd mais a marche :)
	new_dialog[NEW_D_CTYPE_RADIO1].flags &= ~D_SELECTED;
	new_dialog[NEW_D_CTYPE_RADIO2].flags &= ~D_SELECTED;
	new_dialog[NEW_D_PTYPE_RADIO1].flags &= ~D_SELECTED;
	new_dialog[NEW_D_PTYPE_RADIO2].flags &= ~D_SELECTED;
	if (type_temp & Cchryzode::racine) new_dialog[NEW_D_CTYPE_RADIO1].flags |= D_SELECTED;
	if (!(type_temp & Cchryzode::racine)) new_dialog[NEW_D_CTYPE_RADIO2].flags |= D_SELECTED;
	if (type_temp & Cchryzode::on_the_fly) new_dialog[NEW_D_PTYPE_RADIO1].flags |= D_SELECTED;
	if (!(type_temp & Cchryzode::on_the_fly)) new_dialog[NEW_D_PTYPE_RADIO2].flags |= D_SELECTED;

	set_dialog_color(new_dialog, gui_fg_color, gui_bg_color);
	centre_dialog(new_dialog);
	player = init_dialog(new_dialog, -1);
	type = 0;
	if (player->dialog[NEW_D_CTYPE_RADIO1].flags & D_SELECTED) type |= Cchryzode::racine;
	if (player->dialog[NEW_D_PTYPE_RADIO1].flags & D_SELECTED) type |= Cchryzode::on_the_fly;
	while (update_dialog(player))
	{
		if (player->dialog[NEW_D_CTYPE_RADIO1].flags & D_SELECTED && !(type & Cchryzode::racine))
		{
			type ^= Cchryzode::racine;
			player->dialog[NEW_D_ROOT_LABEL].flags &= ~D_HIDDEN;
			player->dialog[NEW_D_ROOT_EDIT].flags &= ~D_HIDDEN;
			dialog_message(player->dialog, MSG_DRAW, 0, NULL);
		}
		if (player->dialog[NEW_D_CTYPE_RADIO2].flags & D_SELECTED && type & Cchryzode::racine)
		{
			type ^= Cchryzode::racine;
			player->dialog[NEW_D_ROOT_LABEL].flags |= D_HIDDEN;
			player->dialog[NEW_D_ROOT_EDIT].flags |= D_HIDDEN;
			dialog_message(player->dialog, MSG_DRAW, 0, NULL);
		}
		if (player->dialog[NEW_D_PTYPE_RADIO1].flags & D_SELECTED && !(type & Cchryzode::on_the_fly))
			type ^= Cchryzode::on_the_fly;
		if(player->dialog[NEW_D_PTYPE_RADIO2].flags & D_SELECTED && type & Cchryzode::on_the_fly)
			type ^= Cchryzode::on_the_fly;
	}
	res = shutdown_dialog(player);
	broadcast_dialog_message(MSG_DRAW, 0);

	if ( res == COMMON_D_OK )
	{
		// Mise a jour de l'objet Cchryzode
		n = ustrtol(new_string[0], NULL, 10);
		m = ustrtol(new_string[1], NULL, 10);
		r = ustrtol(new_string[2], NULL, 10);
		type_temp = type;
		zoom_temp = zoom_value = ustrtol(new_string[3], NULL, 10);
		((Cchryzode *)main_dialog[MAIN_D_CHRYZODE].dp2)->set(n, m, r, type);
		((Cchryzode *)main_dialog[MAIN_D_CHRYZODE].dp2)->set_zoom(zoom_value);
		((Cchryzode *)main_dialog[MAIN_D_CHRYZODE].dp2)->calcul();

		// Mise a jour des options de menu disponibles
		// utiliser = 0 ou &= ~D_DISABLED ???
		zoom_menu[ZOOM_M_NORMAL].flags = 0;
		zoom_menu[ZOOM_M_VALUE].flags = 0;
		if (type & Cchryzode::on_the_fly)
		{
			zoom_menu[ZOOM_M_RATIO].flags = D_DISABLED;
			zoom_menu[ZOOM_M_OUT].flags = D_DISABLED;
			zoom_menu[ZOOM_M_IN].flags = D_DISABLED;
		}
		else
		{
			zoom_menu[ZOOM_M_RATIO].flags = 0;
			zoom_menu[ZOOM_M_OUT].flags = 0;
			if (zoom_value < zoom_ratio) zoom_menu[ZOOM_M_IN].flags = D_DISABLED;
			else zoom_menu[ZOOM_M_IN].flags = 0;
		}
		chryzode_menu[CHRYZODE_M_RERENDER].flags = 0;
		file_menu[FILE_M_SAVE].flags = 0;

		// Calcul du nouveau chryzode
		((Cchryzode *)main_dialog[MAIN_D_CHRYZODE].dp2)->render();
		((Cchryzode *)main_dialog[MAIN_D_CHRYZODE].dp2)->status((char *)main_dialog[MAIN_D_STATUS].dp);
		broadcast_dialog_message(MSG_DRAW, 0);
	}

	return D_O_K;
}

int render_chryzode(void)
{
	((Cchryzode *)main_dialog[MAIN_D_CHRYZODE].dp2)->rerender();
	broadcast_dialog_message(MSG_DRAW, 0);
	return D_O_K;
}

char color_string[3][3][4];

int d_rgbbox_proc(int msg, DIALOG *d, int c)
{
	int rgb[3];
	if (msg == MSG_DRAW)
	{
		for (int i=0; i<3; ++i) rgb[i] = ustrtol(color_string[d->d1][i], NULL, 10);
		d->bg = makecol(rgb[0], rgb[1], rgb[2]);
		rectfill(screen, d->x+1, d->y+1, d->x+d->w-2, d->y+d->h-2, d->bg);
		rect(screen, d->x, d->y, d->x+d->w-1, d->y+d->h-1, d->fg);
	}
	return D_O_K;
}

int d_rgbedit_proc(int msg, DIALOG *d, int c)
{
	int ret, i;
	ret = d_edit_proc(msg, d, c);

	// un peu lourd mais necessaire pour garder une logique dans l'organisation du code du GUI
	switch (*(int *)d->dp2)
	{
		case 1 :
			i = COLOR_D_RGB1;
			break;
		case 2 :
			i = COLOR_D_RGB2;
			break;
		case 3 :
			i = COLOR_D_RGB3;
			break;
	}
	if (ret == D_USED_CHAR) object_message(&color_dialog[i], MSG_DRAW, 0);
	return ret;
}

int group[3] = { 1, 2, 3 };

DIALOG color_dialog[] =
{
	{ d_box_proc, 0, 0, 400, 300, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL },
	{ d_textbox_proc, 0, 0, 400, 16, 0, 0, 0, 0, 0, 0, (void *)"Chryzode colors", NULL, NULL },
	{ d_button_proc, 70, 260, 100, 20, 0, 0, 13, D_CLOSE, 0, 0, (void *)"OK", NULL, NULL },
	{ d_button_proc, 230, 260, 100, 20, 0, 0, 0, D_CLOSE, 0, 0, (void *)"Cancel", NULL, NULL },
	{ d_rgbbox_proc, 320, 60, 40, 30, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL },
	{ d_rgbbox_proc, 320, 130, 40, 30, 0, 0, 0, 0, 1, 0, NULL, NULL, NULL },
	{ d_rgbbox_proc, 320, 200, 40, 30, 0, 0, 0, 0, 2, 0, NULL, NULL, NULL },

	{ d_textbox_proc, 30, 30, 150, 16, 0, 0, 0, 0, 0, 0, (void *)"Color 1", NULL, NULL},
	{ d_text_proc, 40, 70, 30, 16, 0, 0, 0, 0, 0, 0, (void *)"R =", NULL, NULL},
	{ d_rgbedit_proc, 80, 70, 40, 16, 0, 0, 0, 0, 3, 0, (void *)color_string[0][0], &group[0], NULL},
	{ d_text_proc, 130, 70, 30, 16, 0, 0, 0, 0, 0, 0, (void *)"V =", NULL, NULL},
	{ d_rgbedit_proc, 170, 70, 40, 16, 0, 0, 0, 0, 3, 0, (void *)color_string[0][1], &group[0], NULL},
	{ d_text_proc, 220, 70, 30, 16, 0, 0, 0, 0, 0, 0, (void *)"B =", NULL, NULL},
	{ d_rgbedit_proc, 260, 70, 40, 16, 0, 0, 0, 0, 3, 0, (void *)color_string[0][2], &group[0], NULL},
	{ d_textbox_proc, 30, 100, 150, 16, 0, 0, 0, 0, 0, 0, (void *)"Color 2", NULL, NULL},
	{ d_text_proc, 40, 140, 30, 16, 0, 0, 0, 0, 0, 0, (void *)"R =", NULL, NULL},
	{ d_rgbedit_proc, 80, 140, 40, 16, 0, 0, 0, 0, 3, 0, (void *)color_string[1][0], &group[1], NULL},
	{ d_text_proc, 130, 140, 30, 16, 0, 0, 0, 0, 0, 0, (void *)"V =", NULL, NULL},
	{ d_rgbedit_proc, 170, 140, 40, 16, 0, 0, 0, 0, 3, 0, (void *)color_string[1][1], &group[1], NULL},
	{ d_text_proc, 220, 140, 30, 16, 0, 0, 0, 0, 0, 0, (void *)"B =", NULL, NULL},
	{ d_rgbedit_proc, 260, 140, 40, 16, 0, 0, 0, 0, 3, 0, (void *)color_string[1][2], &group[1], NULL},
	{ d_textbox_proc, 30, 170, 150, 16, 0, 0, 0, 0, 0, 0, (void *)"Background", NULL, NULL},
	{ d_text_proc, 40, 210, 30, 16, 0, 0, 0, 0, 0, 0, (void *)"R =", NULL, NULL},
	{ d_rgbedit_proc, 80, 210, 40, 16, 0, 0, 0, 0, 3, 0, (void *)color_string[2][0], &group[2], NULL},
	{ d_text_proc, 130, 210, 30, 16, 0, 0, 0, 0, 0, 0, (void *)"V =", NULL, NULL},
	{ d_rgbedit_proc, 170, 210, 40, 16, 0, 0, 0, 0, 3, 0, (void *)color_string[2][1], &group[2], NULL},
	{ d_text_proc, 220, 210, 30, 16, 0, 0, 0, 0, 0, 0, (void *)"B =", NULL, NULL},
	{ d_rgbedit_proc, 260, 210, 40, 16, 0, 0, 0, 0, 3, 0, (void *)color_string[2][2], &group[2], NULL},
	{ d_yield_proc, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL },
	{ NULL, 0, 0, 0,0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL }
};


int change_color(void)
{
	static int fg1=makecol(255,0,0), fg2=makecol(255,255,0), bg=makecol(0,0,0);
	int ret;

	uszprintf(color_string[0][0], sizeof(color_string[0][0]), "%d", getr(fg1));
	uszprintf(color_string[0][1], sizeof(color_string[0][1]), "%d", getg(fg1));
	uszprintf(color_string[0][2], sizeof(color_string[0][2]), "%d", getb(fg1));
	uszprintf(color_string[1][0], sizeof(color_string[1][0]), "%d", getr(fg2));
	uszprintf(color_string[1][1], sizeof(color_string[1][1]), "%d", getg(fg2));
	uszprintf(color_string[1][2], sizeof(color_string[1][2]), "%d", getb(fg2));
	uszprintf(color_string[2][0], sizeof(color_string[2][0]), "%d", getr(bg));
	uszprintf(color_string[2][1], sizeof(color_string[2][1]), "%d", getg(bg));
	uszprintf(color_string[2][2], sizeof(color_string[2][2]), "%d", getb(bg));

	set_dialog_color(color_dialog, gui_fg_color, gui_bg_color);
	centre_dialog(color_dialog);
	ret = do_dialog(color_dialog, -1);
	if (ret == COMMON_D_OK)
	{
		fg1 = color_dialog[COLOR_D_RGB1].bg;
		fg2 = color_dialog[COLOR_D_RGB2].bg;
		bg = color_dialog[COLOR_D_RGB3].bg;
		((Cchryzode *)main_dialog[MAIN_D_CHRYZODE].dp2)->set_colors(fg1, fg2, bg);
	}
	broadcast_dialog_message(MSG_DRAW, 0);
	return D_O_K;
}

MENU chryzode_menu[] =
{
	{ "&New", new_chryzode, NULL, 0, NULL },
	{ "&Rerender", render_chryzode, NULL, D_DISABLED, NULL },
	{ "&Colors", change_color, NULL, 0, NULL },
	{ NULL, NULL, NULL, 0, NULL }
};

int about(void)
{
	alert("Chryzodus - A chryzode explorer", "version 0.32", "Copyright (C) 2004 Florian LHERBETTE", "OK", NULL, 0, 0);
	return D_O_K;
}

MENU help_menu[] =
{
	{ "&About...", about, NULL, 0, NULL },
	{ NULL, NULL, NULL, 0, NULL }
};

MENU main_menu[] =
{
	{ "&File", NULL, file_menu, 0, NULL },
	{ "&Chryzode", NULL, chryzode_menu, 0, NULL },
	{ "&Zoom", NULL, zoom_menu, 0, NULL },
	{ "&Help", NULL, help_menu, 0, NULL },
	{ NULL, NULL, NULL, 0, NULL }
};

int hide(void)
{
	int i;
	// not very good... Should be done another way
	for (i=2; main_dialog[i].proc != NULL; ++i) main_dialog[i].flags ^= D_HIDDEN;
	broadcast_dialog_message(MSG_DRAW, 0);
	return D_O_K;
}

int d_chryzode_proc(int msg, DIALOG *d, int c)
{
	return d_bitmap_proc(msg, d, c);
}

DIALOG main_dialog[] =
{
	{ d_chryzode_proc, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL },
	{ d_keyboard_proc, 0, 0, 0, 0, 0, 0, 'h', 0, 0, 0, (void *)hide, NULL, NULL },
	{ d_menu_proc, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, main_menu, NULL, NULL },
	{ d_textbox_proc, 0, 460, 640, 20, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL},
	{ d_yield_proc, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL },
	{ NULL, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, NULL, NULL }
};
