/*---------------------------------------------------------------------------/
/ Chryzodus - A chryzode explorer                                            /
/ http://chryzodus.sourceforge.net                                           /
/ Copyright (C) 2004 Florian LHERBETTE                                       /
/                                                                            /
/----------------------------------------------------------------------------/
/                                                                            /
/ This program is free software; you can redistribute it and/or              /
/ modify it under the terms of the GNU General Public License                /
/ as published by the Free Software Foundation; either version 2             /
/ of the License, or (at your option) any later version.                     /
/                                                                            /
/ This program is distributed in the hope that it will be useful,            /
/ but WITHOUT ANY WARRANTY; without even the implied warranty of             /
/ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              /
/ GNU General Public License for more details.                               /
/                                                                            /
/ You should have received a copy of the GNU General Public License          /
/ along with this program; if not, write to the Free Software                /
/ Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA./
/                                                                            /
/----------------------------------------------------------------------------/
/                                                                            /
/ Chryzodus version 0.32                                                     /
/ compute.h : Chryzode computation header file                               /
/                                                                            /
/---------------------------------------------------------------------------*/

#include <allegro.h>

class Cpoint
{
public:
	float x, y;
	Cpoint(float x0=0, float y0=0) : x(x0), y(y0) {};
};

class Cchryzode
{
	BITMAP *bmp;
	int n, m, r;
	int type; // flags racine, on_the_fly
	int zoom;
	int fg1, fg2, bg;
	int npts; // necessaire mais a revoir
	Cpoint *cercle;
	int *iter;
	Cpoint *map;
	int **colormap;
public:
	Cchryzode(BITMAP *_bmp); // ne pas oublier de mettre les ptr a NULL
	~Cchryzode();
	static const int racine = 1; // contraire : complet
	static const int on_the_fly = 2; // contraire : stockage des pts
	void set(int _n, int _m, int _r, int _type);
	void set_bmp(BITMAP *_bmp);
	void set_colors(int _fg1, int _fg2, int _bg);
	void set_zoom(int _zoom);
	void status(char *status);
	void calcul(void); // calcul iter + colormap OU iter + map
	void render(void); // dessin bmp OU colormap + bmp
	void rerender(void);
};
