/*---------------------------------------------------------------------------/
/ Chryzodus - A chryzode explorer                                            /
/ http://chryzodus.sourceforge.net                                           /
/ Copyright (C) 2004 Florian LHERBETTE                                       /
/                                                                            /
/----------------------------------------------------------------------------/
/                                                                            /
/ This program is free software; you can redistribute it and/or              /
/ modify it under the terms of the GNU General Public License                /
/ as published by the Free Software Foundation; either version 2             /
/ of the License, or (at your option) any later version.                     /
/                                                                            /
/ This program is distributed in the hope that it will be useful,            /
/ but WITHOUT ANY WARRANTY; without even the implied warranty of             /
/ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              /
/ GNU General Public License for more details.                               /
/                                                                            /
/ You should have received a copy of the GNU General Public License          /
/ along with this program; if not, write to the Free Software                /
/ Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA./
/                                                                            /
/----------------------------------------------------------------------------/
/                                                                            /
/ Chryzodus version 0.32                                                     /
/ compute.cpp : Chryzode computation source file                             /
/                                                                            /
/---------------------------------------------------------------------------*/

#include <math.h>
#include "compute.h"

#define PI 3.141592f

Cpoint inter(Cpoint &A, Cpoint &B, Cpoint &C, Cpoint &D)
{
	float a1, b1, c1, a2, b2, c2, d;
	a1 = A.y - B.y;
	b1 = B.x - A.x;
	c1 = a1*A.x + b1*A.y;
	a2 = C.y - D.y;
	b2 = D.x - C.x;
	c2 = a2*C.x + b2*C.y;

	d = a1*b2 - a2*b1;
	if (d) return Cpoint( (c1*b2 - c2*b1)/d, (a1*c2 - a2*c1)/d );
	else return Cpoint(); // A REVOIR...
}

Cchryzode::Cchryzode(BITMAP *_bmp)
{
	bmp = _bmp;
	cercle = NULL;
	iter = NULL;
	map = NULL;
	colormap = NULL;
	fg1 = makecol(255, 0, 0);
	fg2 = makecol(255, 255, 0);
	bg = makecol(0, 0, 0);
}

Cchryzode::~Cchryzode()
{
	if (cercle) delete [] cercle;
	if (iter) delete [] iter;
	if (map) delete [] map;
	if (colormap)
	{
		for (int i=0; i<bmp->w; ++i) delete [] colormap[i];
		delete [] colormap;
	}
	if (bmp) destroy_bitmap(bmp);
}

void Cchryzode::set(int _n, int _m, int _r, int _type)
{
	n = _n;
	m = _m;
	r = _r;
	type = _type;
}

void Cchryzode::set_bmp(BITMAP *_bmp)
{
	bmp = _bmp;
}

void Cchryzode::set_colors(int _fg1, int _fg2, int _bg)
{
	fg1 = _fg1;
	fg2 = _fg2;
	bg = _bg;
}

void Cchryzode::set_zoom(int _zoom)
{
	zoom = _zoom;
}

void Cchryzode::calcul(void)
{
	if (iter)
	{
		delete [] iter;
		iter = NULL;
	}
	if (cercle)
	{
		delete [] cercle;
		cercle = NULL;
	}

	cercle = new Cpoint[m];
	for (int j=0; j<m; ++j)
	{
		cercle[j].x = cos(2*j*PI/m);
		cercle[j].y = -sin(2*j*PI/m);
	}

	if (type & racine)
	{
		iter = new int[m+1];
		for (int j=0; j<m+1; ++j) iter[j]=0;
		iter[0]=r;
		for (int j=0; j<m; ++j)
		{
			iter[j+1] = (iter[j]*n) % m;
			if (iter[j+1] == r)
			{
				npts = j+2; // hum tout ceci devient tres bordelique
				break;
			}
		}
	}
	else
	{
		iter = new int[m];
		for (int j=1; j<m; ++j) iter[j] = (j*n) % m;
		npts = m;
	}

	if (type & on_the_fly)
	{
		int x, y;
		Cpoint P;

		colormap = new int *[bmp->w];
		for (int i=0; i<bmp->w; ++i)
		{
			colormap[i] = new int[bmp->h];
			for (int j=0; j<bmp->h; ++j) colormap[i][j] = 0;
		}
		for (int i=1; i<npts; ++i)
			for (int j=1; j<i; ++j)
			{
				if (type & racine) P = inter(cercle[iter[i-1]], cercle[iter[i]], cercle[iter[j-1]], cercle[iter[j]]);
				else P = inter(cercle[i], cercle[iter[i]], cercle[j], cercle[iter[j]]);
				x = (int)(bmp->w/2 + (P.x*bmp->h)/(2*zoom));
				y = (int)(bmp->h/2 + (P.y*bmp->h)/(2*zoom));
				if (x>=0 && x<bmp->w && y>=0 && y<bmp->h) ++(colormap[x][y] );
			}
	}
	else
	{
		int i=0;
		if (map)
		{
			delete [] map;
			map = NULL;
		}
		map = new Cpoint[((npts-2)*(npts-1))/2];
		for (int k=1; k<npts; ++k)
			for (int l=1; l<k; ++l)
			{
				if (type & racine) map[i] = inter(cercle[iter[k-1]], cercle[iter[k]], cercle[iter[l-1]], cercle[iter[l]]);
				else map[i] = inter(cercle[k], cercle[iter[k]], cercle[l], cercle[iter[l]]);
				++i;
			}
	}
}

void Cchryzode::status(char *status)
{
	if (type & Cchryzode::racine)
	usprintf(status, "Multiplication chryzode of n=%d in m=%d, from root r=%d ; zoom 1:%d", n, m, r, zoom);
	else usprintf(status, "Complete multiplication chryzode of n=%d in m=%d ; zoom 1:%d", n, m, zoom);
}

void Cchryzode::render(void)
{
	float col;

	if (!(type & on_the_fly))
	{
		int x, y;

		colormap = new int *[bmp->w];
		for (int i=0; i<bmp->w; ++i)
		{
			colormap[i] = new int[bmp->h];
			for (int j=0; j<bmp->h; ++j) colormap[i][j] = 0;
		}

		for (int k=0; k<((npts-2)*(npts-1))/2; ++k)
		{
			x = (int)(bmp->w/2 + (map[k].x*bmp->h)/(2*zoom));
			y = (int)(bmp->h/2 + (map[k].y*bmp->h)/(2*zoom));
			if (x>=0 && x<bmp->w && y>=0 && y<bmp->h) ++(colormap[x][y] );
		}
	}

	clear_to_color(bmp, bg);
	for (int i=0; i<bmp->w; ++i) for (int j=0; j<bmp->h; ++j)
	{
		col = sqrt(colormap[i][j]);
		if (col != 0) putpixel(bmp, i, j, makecol(getr(fg2) - (int)((getr(fg2)-getr(fg1))/(col)), getg(fg2) - (int)((getg(fg2)-getg(fg1))/(col)), getb(fg2) - (int)((getb(fg2)-getb(fg1))/(col))));
	}

	// desallocation de la colormap qui ne va plus servir -> eviter les bugs au changement de mode gfx
	for (int i=0; i<bmp->w; ++i) delete [] colormap[i];
	delete [] colormap;
	colormap = NULL;
}

void Cchryzode::rerender(void)
{
	if (type & on_the_fly)
	{
		calcul();
		render();
	}
	else render();
}
