#ifndef _TIEMPO_H_
#define _TIEMPO_H_

#include<allegro.h>

#define CUADRO_LOGICO 1
#define CUADRO_DIBUJO 2
#define ESPERAR       3
#define TERMINAR      4

int contador_logico;
int cuadro_actual;


void update();

class tiempo
{         
     private:
          long ultimo_beat;         
          bool cuadro_dibujado;
          
      public:  
          void empezar(int fps);
          void parar();
          
          int que_hacer();
          bool cambio_de_beat();
};


void tiempo::empezar(int fps)
{
    contador_logico=0;
    cuadro_actual=0;
    
    LOCK_VARIABLE(contador_logico);
    LOCK_VARIABLE(cuadro_actual);
	LOCK_FUNCTION(update);
	install_int_ex(update, BPS_TO_TIMER(fps));
	
}

       
void update()
{
    if(midi_pos>0)
    {
    	contador_logico++;
    	cuadro_actual++;
     }
}
END_OF_FUNCTION(update);


void tiempo::parar()
{
     remove_int(update);
}


bool tiempo::cambio_de_beat()
{
     if(ultimo_beat==midi_pos)
         return false;
     else
     {
         ultimo_beat=midi_pos;
         return true;
     }
}


int tiempo::que_hacer()
{
    if(contador_logico>0)
    {
        cuadro_dibujado=false;
        contador_logico--;
        return CUADRO_LOGICO;
    }
    else if(!cuadro_dibujado)
    {
         cuadro_dibujado=true;
         return CUADRO_DIBUJO;
    }
    else if(midi_pos<0)
    {
        parar();
        return TERMINAR;
    }
    else
    {
        return ESPERAR;    
    }
}
         
    
#endif    
    

