#ifndef _MENU_H_
#define _MENU_H_

#define   PRINCIPAL    0
#define   OPCIONES     1
#define   ELEGIR_TEMA  2

#define CANT_TEMAS 3

#include "gfx/datafile_menu.h"
#include "howto.h"


void play_song(int);

bool salir=false;
int volumen=128;

DATAFILE *dmenu;
extern BITMAP *buffer;

PACKFILE *salvado;
bool primeravez=false;

MIDI *prueba_volumen;

char nombres[CANT_TEMAS][50] = {
     { "Do you want to know a secret?" },
     { "With a little help from my friends" },
     { "And your bird can sing" }
};

bool habilitado[CANT_TEMAS] = 
{ true,true,true };


void menu()
{
    int x_cursor;
    int y_cursor;
    
    int estado_menu=0;
    int opcion_actual=0;
    
    if(exists("save.dat"))
    {
        salvado=pack_fopen("save.dat","r");
        volumen = pack_igetw(salvado);
        pack_fclose(salvado);
        set_volume(volumen,volumen);
    }
    else
    {
        salvado=pack_fopen("save.dat","w");
        pack_iputw(volumen,salvado);
        pack_fclose(salvado);
        primeravez=true;
    }
    
    if(primeravez)
        how_to();
    
    prueba_volumen=(MIDI*)dmenu[PRUEBA].dat;
    
    while(!salir)
    {
        if(estado_menu==PRINCIPAL)
        {
            x_cursor=200;
            y_cursor=175+(opcion_actual*37);
                        
            draw_sprite(buffer,(BITMAP *)dmenu[MENU].dat,0,0);
            draw_sprite(buffer,(BITMAP *)dmenu[CURSOR].dat,x_cursor,y_cursor);
            draw_sprite(screen,buffer,0,0);
            if(key[KEY_UP] && opcion_actual>0) { opcion_actual--; while(key[KEY_UP]) {} }
            if(key[KEY_DOWN] && opcion_actual<3) { opcion_actual++; while(key[KEY_DOWN]) {} }
            
            if(key[KEY_ESC]) salir=true;
            
            if(key[KEY_ENTER])
            {
                if(opcion_actual==0)
                {
                    estado_menu=ELEGIR_TEMA;
                    opcion_actual=0;
                    stop_midi();
                }
                if(opcion_actual==1)
                {
                    estado_menu=OPCIONES;
                    opcion_actual=0;
                    play_midi(prueba_volumen,1);
                }
                if(opcion_actual==2)
                {
                    while(key[KEY_ENTER]) {}
                    play_midi((MIDI*)dmenu[LETITBE].dat,1);
                    clear_to_color(screen,makecol(255,255,255));
                    textprintf_centre_ex(screen, font, 320, 120, makecol(0,0,0), -1, "Letting it be");
                    while(!key[KEY_ESC]) {}
                    while(key[KEY_ESC]) {}                
                    stop_midi();    
                }
                
                if(opcion_actual==3)
                {
                    salir=true;
                }
                while(key[KEY_ENTER]) {}
            }
            
        }
        else if(estado_menu==OPCIONES)
        {
            x_cursor=10;
            y_cursor=110+(opcion_actual*47);
                        
            draw_sprite(buffer,(BITMAP *)dmenu[MENU2].dat,0,0);
            draw_sprite(buffer,(BITMAP *)dmenu[CURSOR].dat,x_cursor,y_cursor);
            draw_sprite(buffer,(BITMAP *)dmenu[VOLUMEN].dat,400,122);
            for(int i=0;i<=(volumen/8);i++)
                draw_sprite(buffer,(BITMAP *)dmenu[VOLUMEN2].dat,401+(i*3),123);
            
            draw_sprite(screen,buffer,0,0);
            if(key[KEY_UP] && opcion_actual>0) { opcion_actual--; while(key[KEY_UP]) {} }
            if(key[KEY_DOWN] && opcion_actual<3) { opcion_actual++; while(key[KEY_DOWN]) {} }
            
            if(key[KEY_ESC]) { estado_menu=PRINCIPAL; opcion_actual=0; stop_midi(); while(key[KEY_ESC]) {} }
            
            if(opcion_actual==0)
            {
                if(key[KEY_LEFT])
                {
                    volumen--;
                    if(volumen<0) volumen=0;
                    set_volume(volumen,volumen);
                    
                    salvado=pack_fopen("save.dat","w");
                    pack_iputw(volumen,salvado);
                    pack_fclose(salvado);
                }
                if(key[KEY_RIGHT])
                {
                    volumen++;
                    if(volumen>255) volumen=255;
                    set_volume(volumen,volumen);
                    salvado=pack_fopen("save.dat","w");
                    pack_iputw(volumen,salvado);
                    pack_fclose(salvado);
                }
            }

            
            if(key[KEY_ENTER])
            {
                if(opcion_actual==1)
                {
                    how_to();           
                }
                if(opcion_actual==2)
                {
                    while(key[KEY_ENTER]) {}
                    clear_to_color(screen,makecol(0,0,0));
                    draw_sprite(screen,(BITMAP*)dmenu[CREDITOS].dat,70,51);
                    while(!key[KEY_ESC]) {}
                    while(key[KEY_ESC]) {}                
                }
                if(opcion_actual==3)
                {
                     estado_menu=PRINCIPAL; 
                     opcion_actual=0; 
                     stop_midi(); 
                     while(key[KEY_ENTER]) {} 
                }

            }
        }
        
        else if(estado_menu==ELEGIR_TEMA)
        {
            x_cursor=20;
            y_cursor=95+(opcion_actual*25);
            
            clear(buffer);
                        
//            draw_sprite(buffer,(BITMAP *)dmenu[MENU2].dat,0,0);
            draw_sprite(buffer,(BITMAP *)dmenu[CURSOR2].dat,x_cursor,y_cursor);
            int color;
            for(int i=0;i!=CANT_TEMAS;i++)
            {
                if(habilitado[i])
                    color=255;
                else
                    color=96;
                    
                textprintf_ex(buffer, font, 45, 105+(i*25), makecol(color,color,color), -1, "%s",nombres[i]);
            }
                
            
            draw_sprite(screen,buffer,0,0);
            if(key[KEY_UP] && opcion_actual>0) { opcion_actual--; while(key[KEY_UP]) {} }
            if(key[KEY_DOWN] && opcion_actual<4) { opcion_actual++; while(key[KEY_DOWN]) {} }
            
            if(key[KEY_ESC]) { estado_menu=PRINCIPAL; opcion_actual=0; stop_midi(); while(key[KEY_ESC]) {} }
            
            if(opcion_actual==0)
            {
                if(key[KEY_LEFT])
                {
                    volumen--;
                    if(volumen<0) volumen=0;
                    set_volume(volumen,volumen);
                }
                if(key[KEY_RIGHT])
                {
                    volumen++;
                    if(volumen>255) volumen=255;
                    set_volume(volumen,volumen);
                }
            }

            
            if(key[KEY_ENTER])
            {
                if(habilitado[opcion_actual])
                {
                    play_song(opcion_actual);
                     estado_menu=PRINCIPAL; 
                     opcion_actual=0; 
                     while(key[KEY_ESC]) {}
                     while(key[KEY_ENTER]) {}                    
                }
                if(opcion_actual==3)
                {
                     estado_menu=PRINCIPAL; 
                     opcion_actual=0; 
                     stop_midi(); 
                     while(key[KEY_ESC]) {} 
                }
            }
        }
            
            
            
    }
}



#endif

