#ifndef _BARRA_H_
#define _BARRA_H_

#define MAX_PERFORMANCE 160

extern BITMAP *buffer;

bool gameover=false;

class barra
{
      private:
          int x;
          int y;
          
          int cools;
          int goods;
          int misses;
          
          int total;
          int performance;
          
          DATAFILE *data;
                 
      public:
          barra();
          ~barra();
          
          void dibujar();
          
          void cool()  { cools++; if(performance < MAX_PERFORMANCE) { performance++; } }
          void good()  { goods++; }
          void miss()  { misses++; performance-=16; if(performance<0) { performance=0; } }
          void wrong() { performance-=4; }
          
          int get_ranking();
          void show_ranking();
          void game_over();
};
          
          
barra::barra()
{
    x=5;
    y=30;
    
    cools=0;
    goods=0;
    misses=0;
    
    total=0;
    performance=120;
    
    data = load_datafile("gfx/barra.dat");
}

barra::~barra()
{
    unload_datafile(data);
}

void barra::dibujar()
{
     textprintf_ex(buffer, font, x+17, y-20, makecol(255,255,255), -1, "Performance");
     draw_sprite(buffer,(BITMAP*)data[0].dat,x,y);
     for(int i=0;i!=(performance/4);i++)
         draw_sprite(buffer,(BITMAP*)data[1].dat,(x+1)+(i*3),y+1);
     if(performance<=0)
         gameover=true;
}


void barra::show_ranking()
{
     while(!key[KEY_ESC] && !key[KEY_ENTER]){
         clear(buffer);
         draw_sprite(buffer,(BITMAP*)data[2].dat,132,0);
         textprintf_centre_ex(buffer, font, 320, 100, makecol(0,0,0), -1, "Cools : %d", cools);
         textprintf_centre_ex(buffer, font, 320, 130, makecol(0,0,0), -1, "Goods : %d", goods);
         textprintf_centre_ex(buffer, font, 320, 160, makecol(0,0,0), -1, "Misses: %d", misses);
         draw_sprite(screen,buffer,0,0);
     }
     while(key[KEY_ENTER] || key[KEY_ESC]) {}
     
}

void barra::game_over()
{
    while(key[KEY_ENTER]) {}
    stop_midi();
    clear(buffer);
    draw_sprite(buffer,(BITMAP*)data[3].dat,120,100);
    draw_sprite(screen,buffer,0,0);
    gameover=false;
    while(!key[KEY_ENTER]) {}
          
    while(key[KEY_ENTER]) {}
}
     

#endif


