#include <allegro.h>

#include "tiempo.h"
#include "tablero.h"
#include "grat.h"
#include "video.h"
#include "menu.h"

void init();
void deinit();


BITMAP *buffer;


int main() 
{
	init();
	
	menu();
	
    
	
//	play_song(1);
           

	deinit();
	return 0;
}
END_OF_MAIN()

void init() 
{
	int depth, res;
	allegro_init();
	depth = desktop_color_depth();
	if (depth == 0) depth = 32;
	set_color_depth(depth);
	res = set_gfx_mode(GFX_AUTODETECT/*_WINDOWED*/, 640, 480, 0, 0);
	if (res != 0) {
		allegro_message(allegro_error);
		exit(-1);
	}
	
	buffer = create_bitmap(640,480);

	install_timer();
	install_keyboard();
	install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);
	
	set_trans_blender(255, 255, 255, 128);
	
	dmenu = load_datafile("gfx/menu.dat");
	
	set_volume(volumen, volumen);

}

void deinit() {
	clear_keybuf();
}


void play_song(int cual)
{
    tiempo a;
    a.empezar(40);
    tablero b;

    cancion_actual=cual;
    
    b.cargar(cancion_actual);
    
    int var,var2,var3=1,var4=0;
    
    barra Barra;
    
    b.empezar();
    

    while (!key[KEY_ESC]) 
    {
         
         if(gameover)
         { 
             Barra.game_over();
             return;
         }
         
         var=a.que_hacer();
         
         if(var==CUADRO_LOGICO)
         {

             var2=0;
             if(key[KEY_Q]) var2+=IZQUIERDA;
             if(key[KEY_W]) var2+=MEDIO;
             if(key[KEY_E]) var2+=DERECHA;
             if(!key[KEY_BACKSPACE]) { var3=1; }
                          
             b.set_estado(var2);
             b.procesar();
             
             
             if((key[KEY_BACKSPACE]) && var3)
             {
                 var4=b.golpeo();
                 var3=0;
             }
             else
                 var4=0;

             if(var4)
             {
                 if(var4==ERRADO)
                     Barra.wrong();
                 else if(var4==PERFECTO)
                     Barra.cool();
                 else if(var4==EXCELENTE)
                     Barra.good();
             }
             
             if(escapo)
             {
                 Barra.miss();
                 escapo=false;
                 grat(ERRADO);
             }
             video_manager();
             
             if(a.cambio_de_beat())
                 set_leds(KB_NUMLOCK_FLAG);
             else
                   set_leds(-1);
             
         }
         else if(var==CUADRO_DIBUJO)
         {
             clear(buffer);
             b.dibujar();
             
             next_fli_frame(loop);             
             
             draw_sprite(buffer,fli_bitmap,100,150);

             grat(var4);
             Barra.dibujar();
                        
             textprintf_ex(buffer, font, 200, 10, makecol(255,255,255), -1, "%d",cuadro_actual);

             draw_sprite(screen,buffer,0,0);
         }
         else if(var==TERMINAR) 
         {
              Barra.show_ranking();
              return;
         }
    }
		
	stop_midi();
	close_fli();
}

