#ifndef		__PLUGIN_H__
#define		__PLUGIN_H__

#include "debug.h"

#ifdef ALLEGRO_WINDOWS
#include <winalleg.h>
#else
#include <dlfcn.h>
#endif	//ALLEGRO_WINDOWS

#include <stdio.h>

template <typename T>
class Plugin {
	private:
		T* plugin;

		typedef T* (*LOADER)();

		// platform specific
#ifdef ALLEGRO_WINDOWS
		HINSTANCE library;
#else
		void *library;
#endif	//ALLEGRO_WINDOWS

	public:
		Plugin(const char *dllName) : plugin(0), library(0) {
DEBUG("main.log")
			Load(dllName, "GetPlugin");
DEBUG("main.log")
		}

		~Plugin() {
			Release();
		}

		operator T* () {
			return plugin;
		}

		/**
			@param dllName		- the name of the dll to load
			@return T*			- the plugin
		**/
		T* Load(const char* dllName, const char* functionName) {
DEBUG("main.log")
			// just in case
			Release();
DEBUG("main.log")

			// load our rendering plugin
#ifdef ALLEGRO_WINDOWS
			library = (HINSTANCE)::LoadLibrary(dllName);
#else
			library = dlopen(dllName, RTLD_LAZY);
DEBUG("main.log")
			// handle errors
			if (library == NULL) {
				const char *err = dlerror();
				if (err != NULL) {
					printf("ERROR: can't load library! dlerror(): %s\n", err);
				}
				return 0;
			}
#endif	//ALLEGRO_WINDOWS


DEBUG("main.log")
			// get the address of our renderer accessing function
			LOADER loader = 0;
#ifdef ALLEGRO_WINDOWS
			loader = (LOADER)::GetProcAddress(library, functionName);
#else
			loader = (LOADER)dlsym(library, functionName);
#endif	//ALLEGRO_WINDOWS

DEBUG("main.log")
			// get our graphics device
			if (loader) {
				plugin = loader();
			}
			else {
#ifdef ALLEGRO_WINDOWS
#else
				const char *err = dlerror();
				if (err != NULL) {
					printf("ERROR: can't find loader proc! dlerror(): %s\n", err);
				}
#endif	//ALLEGRO_WINDOWS
			}
DEBUG("main.log")

			return plugin;
		}

		/**
			@brief Releases the library from memory
		**/
		void Release() {
			if (plugin == 0) {
				return;
			}

			delete plugin;
#ifdef ALLEGRO_WINDOWS
			::FreeLibrary(library);
#else
			dlclose(library);
#endif	//ALLEGRO_WINDOWS
			plugin = 0;
		}
};



#endif		//__PLUGIN_H__
