#include "debug.h"
#include "global.h"
#include "GameDriver.h"
#include "MainMenu.h"
#include <aldumb.h>

int plugin_getter(const char *filename, int attrib, void *param) {
	attrib = 0;
	clear_to_color(screen, 0);
	textprintf_ex(screen, font, 0, 0, makecol(255,255,255), 0, "%s", filename);
	PluginManager *pm = (PluginManager *)param;
	pm->RegisterPlugin(std::string(filename));
	return 0;
}


int plugin_getter_dir(const char *filename, int attrib, void *param) {
	char *file = get_filename(filename);
	if (ustrlen(file) > 0 && file[0] == '.') {
		return 0;
	}

	attrib = 0;
	char mask[512];
	usprintf(mask, filename);
	put_backslash(mask);
#ifdef ALLEGRO_WINDOWS
	ustrcat(mask, "*.dll");
#else
	ustrcat(mask, "*.so");
#endif //ALLEGRO_WINDOWS
	for_each_file_ex(mask, 0, 0, plugin_getter, param);
	return 0;
}


class Game {
	private:
		MainMenu *mainMenu;
		GameDriver *gameScreen;

		PluginManager *pluginManager;

		void InitPluginManager() {
			char mask[512];
#ifdef ALLEGRO_WINDOWS
			MakeFullPath(mask, "games/*.dll");
#else
			MakeFullPath(mask, "games/*.so");
#endif //ALLEGRO_WINDOWS
			for_each_file_ex(mask, 0, 0, plugin_getter, pluginManager);

			// do subdirectories
			MakeFullPath(mask, "games/*.*");
			for_each_file_ex(mask, FA_DIREC, 0, plugin_getter_dir, pluginManager);
		}

	public:
		Game() {
			mainMenu = new MainMenu;
			gameScreen = new GameDriver;

			// Put some more initialization stuff here. Things you only want
			// to do once, like for example loading some global datafiles,
			// bitmaps, sounds, etc.
			// ...

			pluginManager = new PluginManager;
			InitPluginManager();

			mainMenu->SetPluginManager(pluginManager);
			gameScreen->SetPluginManager(pluginManager);
		}

		~Game() {
			delete mainMenu;
			delete gameScreen;

			// Unload global datafiles, bitmaps, sounds, etc.
			// ...

			delete pluginManager;
		}

		void Run() {
			while (true) {
				int next = mainMenu->Run();

				if (next == EXIT_GAME) {
					break;
				}
				else {
					gameScreen->SelectGame(mainMenu->GetSelectedGame());
					gameScreen->Run();
				}
			}
		}
};



int main() {
DEBUG_INIT("main.log")
	Error err = InstallMASkinG(AGC2_CONFIG_FILE);
	if (err) {
		err.Report();
	}
DEBUG("main.log")
	set_window_title("Allegro Mini Game Collection");
#ifdef	USE_ALNET
	alnet_init();
#endif
	atexit(&dumb_exit);
	dumb_register_stdfiles();

DEBUG("main.log")
	Game *game = new Game;
DEBUG("main.log")
	game->Run();
DEBUG("main.log")
	delete game;
DEBUG("main.log")
	ExitMASkinG();
DEBUG("main.log")
#ifdef	USE_ALNET
	alnet_disconnect();
	alnet_shutdown();
#endif
	return 0;
}
END_OF_MAIN()
