#include "debug.h"

#include "hsc.h"
using namespace std;

#include <time.h>
#include <allegro.h>


HSC::Entry::Entry() {
	name = string("---");
	date = string("yyyy/mm/dd hh:mm");
	score = 0;
}


HSC::HSC() {
}


HSC::~HSC() {
DEBUG("main.log")
}


void HSC::Load(std::string filename) {
DEBUG("main.log")
	PACKFILE *f = pack_fopen(filename.c_str(), "r");

	if (f) {
		// HSCR
		char buf[256];
		pack_fread(buf, 4, f);

		if (ustrncmp("HSCR", buf, 4) == 0) {
			scores.clear();

			int count = 0;
			pack_fread(&count, sizeof(int), f);

			for (int i=0; i<count; i++) {
				Entry e;
				int size = 0;

				pack_fread(&size, sizeof(int), f);
				pack_fread(&buf, sizeof(char)*size, f);
				buf[size] = 0;
				e.name = string(buf);

				pack_fread(&size, sizeof(int), f);
				pack_fread(&buf, sizeof(char)*size, f);
				buf[size] = 0;
				e.date = string(buf);

				pack_fread(&e.score, sizeof(int), f);

				scores.push_back(e);
			}
		}

		pack_fclose(f);
	}
DEBUG("main.log")
}


void HSC::Save(std::string filename) {
DEBUG("main.log")
	PACKFILE *f = pack_fopen(filename.c_str(), "w");

	if (f) {
		int tmp = 0;
		pack_fwrite("HSCR", 4, f);
		tmp = Count();
		pack_fwrite(&tmp, sizeof(int), f);

		for (int i=0; i<Count(); i++) {
			Entry e = scores[i];

			tmp = e.name.size();
			pack_fwrite(&tmp, sizeof(int), f);
			pack_fwrite(e.name.c_str(), sizeof(char)*tmp, f);

			tmp = e.date.size();
			pack_fwrite(&tmp, sizeof(int), f);
			pack_fwrite(e.date.c_str(), sizeof(char)*tmp, f);

			tmp = e.score;
			pack_fwrite(&tmp, sizeof(int), f);
		}

		pack_fclose(f);
	}
DEBUG("main.log")
}


int HSC::Count() {
	return scores.size();
}


HSC::Entry &HSC::GetEntry(int i) {
	return scores[i];
}


void HSC::AddEntry(HSC::Entry e) {
DEBUG("main.log")
	if (Count() == entryLimit) {
		if (scores[entryLimit-1].score >= e.score) {
			return;
		}
	}
DEBUG("main.log")

	time_t t;
	struct tm *ct;
	time(&t);
	ct = localtime(&t);
	char buf[256];
	usprintf(buf, "%04d/%02d/%02d %02d:%02d", ct->tm_year+1900, ct->tm_mon+1, ct->tm_mday, ct->tm_hour, ct->tm_min);
	e.date = string(buf);

	if (scores.empty()) {
		scores.push_back(e);
	}
	else if (scores[0].score < e.score) {
		scores.insert(scores.begin(), e);
	}
	else {
		vector<Entry>::iterator i = scores.begin();
		for (; i != scores.end() && i->score >= e.score; ++i);
		scores.insert(i, e);
	}

	if (Count() > entryLimit) {
		scores.pop_back();
	}
DEBUG("main.log")
}


bool HSC::CanAdd(int score) {
DEBUG("main.log")
	if (score <= 0) {
DEBUG("main.log")
		return false;
	}

	if (Count() < entryLimit) {
DEBUG("main.log")
		return true;
	}

	if (score > scores.back().score) {
DEBUG("main.log")
		return true;
	}

DEBUG("main.log")
	return false;
}


void HSC::Reset() {
DEBUG("main.log")
	scores.clear();
}
