#include "global.h"
#include "defines.h"
#include <MASkinG.h>

void load_settings(GameSettings *settings, const char *file) {
	push_config_state();

	set_config_file(file);

	int i=0;
	while (settings[i].name) {
		settings[i].value = get_config_int("settings", settings[i].name, settings[i].value);
		++i;
	}

	pop_config_state();
}


void save_settings(GameSettings *settings, const char *file) {
	push_config_state();

	set_config_file(file);

	int i=0;
	while (settings[i].name) {
		set_config_int("settings", settings[i].name, settings[i].value);
		++i;
	}

	pop_config_state();
}


char *encode_game_name(const char *name) {
	static char buf[256];
	usprintf(buf, name);
	int l = ustrlen(buf);
	for (int i=0; i<l; i++) {
		if (isspace(buf[i])) {
			buf[i] = '_';
		}
	}
	return buf;
}
