#ifndef		__DEBUG_H__
#define		__DEBUG_H__

#include <stdio.h>

#ifdef DEBUGMODE
#define DEBUG_INIT(x) { \
	FILE *f = fopen(x, "wt"); \
	fprintf(f,"%s, %s (%d)\n",__FILE__,__FUNCTION__,__LINE__); \
	fclose(f); }
#else
#define DEBUG_INIT(x)
#endif


#ifdef DEBUGMODE
#define DEBUG(x) { \
	FILE *f = fopen(x, "at"); \
	fprintf(f,"%s, %s (%d)\n",__FILE__,__FUNCTION__,__LINE__); \
	fclose(f); }
#else
#define DEBUG(x)
#endif


#ifdef DEBUGMODE
#define DEBUG_STR(x,y) { \
	FILE *f = fopen(x, "wt"); \
	fprintf(f,"%s, %s (%d): %s\n",__FILE__,__FUNCTION__,__LINE__,y); \
	fclose(f); }
#else
#define DEBUG_STR(x,y)
#endif


#endif		//__DEBUG_H__
