#include "SettingsDialog.h"
#include "KeyDialog.h"
#include "global.h"


int count_tokens(const char *str) {
	static char buf[256];
	usprintf(buf, str);
	char *tok = ustrtok(buf, "|");
	int i = 0;
	while (tok) {
		++i;
		tok = ustrtok(0, "|");
	}
	return i;
}


const char *get_token(const char *str, int i) {
	static char buf[256];
	usprintf(buf, str);
	char *tok = ustrtok(buf, "|");
	int count = 0;
	while (tok && count < i) {
		++count;
		tok = ustrtok(0, "|");
	}
	return tok;
}


SettingsDlg::SettingsDlg() : Window() {
}


SettingsDlg::~SettingsDlg() {
	while (!lblOptionName.empty()) {
		delete lblOptionName.back();
		lblOptionName.pop_back();
		delete wdgOptionValue.back();
		wdgOptionValue.pop_back();
		delete lblOptionValue.back();
		lblOptionValue.pop_back();
	}
}


void SettingsDlg::MsgInitSkin() {
	Window::MsgInitSkin();

}


void SettingsDlg::HandleEvent(Widget &obj, int msg, int arg1, int arg2) {
	Window::HandleEvent(obj, msg, arg1, arg2);

	switch (msg) {
		case MSG_ACTIVATE:
			for (unsigned int i=0; i<wdgOptionValue.size(); i++) {
				if (obj == *wdgOptionValue[i]) {
					OnClick(i);
					break;
				}
			}

			if (obj == btnKeys) {
				OnKeys();
			}
		break;

		case MSG_SCROLL:
			for (unsigned int i=0; i<wdgOptionValue.size(); i++) {
				if (obj == *wdgOptionValue[i]) {
					OnScroll(i);
					break;
				}
			}
		break;
	};
}


void SettingsDlg::Popup(Dialog *parent, IGame *game, std::string path_to_dll) {
	this->game = game;
	this->path_to_dll = path_to_dll;

	if (!game) {
		return;
	}

	int settingsCount = 0;
	GameSettings *settings = game->GetSettings();

	if (settings) {
		while (settings[settingsCount].name) {
			++settingsCount;
		}

		char buf[256];
		char path[256];
		replace_filename(buf, path_to_dll.c_str(), game->GetName(), 256);
		ustrcat(buf, ".cfg");
		MakeFullPath(path, buf);
		load_settings(settings, path);
	}

	int y = 8;
	int dy = 24;
	int x = 8;
	int dx = 96;

	clientArea->Resize(2*x + 3*dx, settingsCount*dy + 2*32 + 8 + (settingsCount>0?1:0)*8);
	Resize(clientArea->size());
	ClearFlag(D_RESIZABLE);
	title.SetText(game->GetName());

	for (int i=0; i<settingsCount; i++) {
DEBUG("main.log")
		Label *lbl = new Label;
		lbl->ClearFlag(D_AUTOSIZE);
		lbl->AlignCentre();
		lbl->Shape(x, y, dx, dy);
		lbl->SetText(settings[i].label);
		lblOptionName.push_back(lbl);
		Add(*lblOptionName[lblOptionName.size()-1]);

		Widget *wdg = 0;
		int type = 0;
		int token_count = 0;

		if (!settings[i].options) {
			// checkbox
			type = 0;
DEBUG("main.log")
			wdg = new CheckBox;
			wdg->Shape(x + dx, y+4, dx, dy);
			((CheckBox *)wdg)->SetText(settings[i].value ? "on" : "off");
			if (settings[i].value) {
				wdg->Select();
			}
			else {
				wdg->Deselect();
			}
		}
		else {
			token_count = count_tokens(settings[i].options);

			// slider?
			type = 1;

			for (int j=0; j<token_count; j++) {
				const char *tok = get_token(settings[i].options, j);

				if (uatof(tok) != 0 || (tok && tok[i] == '0')) {
					continue;
				}
				else {
					// dropdown listbox
					type = 2;
					break;
				}
			}
		}

		if (type == 2) {
DEBUG("main.log")
			wdg = new ComboBox;
			wdg->Shape(x + dx, y, dx, dy);

			for (int j=0; j<token_count; j++) {
				((ComboBox *)wdg)->list.InsertItem(new ListItemString(get_token(settings[i].options, j)), j);
			}
			((ComboBox *)wdg)->list.Select(settings[i].value);
			((ComboBox *)wdg)->list.h(MIN(token_count*24, 384));
		}
		else if (type == 1) {
DEBUG("main.log")
			wdg = new Slider;
			wdg->Shape(x + dx, y+4, dx, dy);

			Slider *sld = (Slider *)wdg;
			sld->SetOrientation(1);
			sld->SetMax(token_count-1);
			sld->SetPosition(settings[i].value);
		}

		wdgType.push_back(type);

DEBUG("main.log")
		wdgOptionValue.push_back(wdg);
		Add(*wdgOptionValue[wdgOptionValue.size()-1]);

		lbl = new Label;
		lbl->ClearFlag(D_AUTOSIZE);
		lbl->AlignCentre();
		lbl->Shape(x + 2*dx, y, dx, dy);
		if (type == 1) {
			lbl->SetText(get_token(settings[i].options, settings[i].value));
		}
		else {
			lbl->SetText(" ");
		}
		lblOptionValue.push_back(lbl);
		Add(*lblOptionValue[lblOptionValue.size()-1]);

		y += dy;
DEBUG("main.log")
	}

	if (settingsCount > 0) {
		y += 8;
	}

	if (game->RedefinesKeys()) {
		btnKeys.Enable();
	}
	else {
		btnKeys.Disable();
	}
	btnKeys.Shape(x+dx-32, y, dx+64, 24);
	btnKeys.SetText("Redefine keys");
	Add(btnKeys);
	y += 32;

	btnOK.Shape(x+dx-32, y, dx+64, 24);
	btnOK.MakeExit();
	btnOK.SetText("OK");
	Add(btnOK);

	Centre();
	Window::Popup(parent);

	if (settings) {
		char buf[256];
		char path[256];
		replace_filename(buf, path_to_dll.c_str(), game->GetName(), 256);
		ustrcat(buf, ".cfg");
		MakeFullPath(path, buf);
		save_settings(settings, path);
	}

	for (int i=0; i<settingsCount; i++) {
		Remove(*lblOptionName[i]);
		Remove(*wdgOptionValue[i]);
		Remove(*lblOptionValue[i]);
	}
}


void SettingsDlg::OnKeys() {
	char buf[256];
	char path[256];
	replace_filename(buf, path_to_dll.c_str(), game->GetName(), 256);
	ustrcat(buf, ".cfg");
	MakeFullPath(path, buf);
	char *section = "keys";

	KeySettings keys;
	keys.Read(path, section);

	for (int i=0; i<8; i++) {
		if (game->KeyName(i)) {
			keys.GetKey(i).name = game->KeyName(i);
		}
		else {
			keys.GetKey(i).name = "";
		}
	}

	KeysDlg dlg;
	dlg.Centre();
	dlg.Popup(Root(), &keys);

	keys.Write(path, section);
}


void SettingsDlg::OnScroll(int i) {
	switch (wdgType[i]) {
		// checkbox -> can't happen
		case 0:
		break;

		// slider
		case 1: {
			GameSettings *settings = game->GetSettings();
			settings[i].value = (int)((Slider *)(wdgOptionValue[i]))->GetPosition();
			lblOptionValue[i]->SetText(get_token(settings[i].options, settings[i].value));
		}
		break;

		// combo box
		case 2:
		break;
	};
}


void SettingsDlg::OnClick(int i) {
	switch (wdgType[i]) {
		// checkbox
		case 0: {
			GameSettings *settings = game->GetSettings();
			settings[i].value = ((CheckBox *)(wdgOptionValue[i]))->Selected() ? 1 : 0;
			((CheckBox *)wdgOptionValue[i])->SetText(settings[i].value ? "on" : "off");
		}
		break;

		// slider
		case 1:
		break;

		// combo box
		case 2: {
			GameSettings *settings = game->GetSettings();
			settings[i].value = ((ComboBox *)(wdgOptionValue[i]))->list.Selection();
		}
		break;
	};
}
