#ifndef		__PLUGIN_MANAGER_H__
#define		__PLUGIN_MANAGER_H__

#include "IGame.h"
#include "plugin.h"
#include <string>
#include <vector>

class PluginManager {
	public:
		PluginManager();
		~PluginManager();

		void RegisterPlugin(std::string path);

		IGame *GetPlugin(int index);
		int GetPluginCount();
		std::string GetPluginName(int index);
		std::string GetPluginIcon(int index);
		std::string GetPluginPath(int index);
		int GetPluginIndex(const std::string &name);

	private:
		std::vector<std::string> names;
		std::vector<std::string> paths;
		std::vector<std::string> icons;
};

#endif		//__PLUGIN_MANAGER_H__
