#include "debug.h"
#include "PluginManager.h"

PluginManager::PluginManager() {
}


PluginManager::~PluginManager() {
}


void PluginManager::RegisterPlugin(std::string path) {
DEBUG_STR("main.log", path.c_str())
	IGame *game = *(new Plugin<IGame>(path.c_str()));
DEBUG("main.log")

	if (game) {
		game->SetGamePath(path.c_str());
		names.push_back(std::string(game->GetName()));
		icons.push_back(std::string(game->GetIconPath()));
		paths.push_back(path);
		delete game;
	}
	else {
		//error
	}
DEBUG("main.log")
}


IGame *PluginManager::GetPlugin(int index) {
DEBUG("main.log")
	if (index >= 0 && index < (int)paths.size()) {
DEBUG("main.log")
		IGame *game = *(new Plugin<IGame>(paths[index].c_str()));
		if (game) {
			game->SetGamePath(paths[index].c_str());
		}
		return game;
		//return *(new Plugin<IGame>(paths[index].c_str()));
	}
	else {
DEBUG("main.log")
		return 0;
	}
}


int PluginManager::GetPluginCount() {
	return paths.size();
}


std::string PluginManager::GetPluginName(int index) {
	return names[index];
}


std::string PluginManager::GetPluginIcon(int index) {
	return icons[index];
}


std::string PluginManager::GetPluginPath(int index) {
	return paths[index];
}


int PluginManager::GetPluginIndex(const std::string &name) {
	for (int i=0; i<(int)names.size(); i++) {
		if (names[i] == name) {
			return i;
		}
	}

	return -1;
}
