#include "OptionsDlg.h"
#include "KeyDialog.h"
#include "defines.h"


int skin_getter(const char *filename, int attrib, void *param) {
	attrib = 0;
	ListBoxEx *lst = (ListBoxEx *)param;
	lst->InsertItem(get_filename(filename));
	return 0;
}


OptionsDlg::OptionsDlg() : Dialog() {
	grpGfx.SetTitle("Graphics");
	Add(grpGfx);

	grpKeys.SetTitle("Keys");
	Add(grpKeys);

	chkFullscreen.SetCallbackID(IDM_FULLSCREEN);
	chkFullscreen.SetText("Fullscreen");
	if (Settings::fullscreen) {
		chkFullscreen.Select();
	}
	//chkFullscreen.Disable();
	Add(chkFullscreen);

	chkFps.SetCallbackID(IDM_FPS);
	chkFps.SetText("Show framerate");
	if (Settings::showFrameRate) {
		chkFps.Select();
	}
	Add(chkFps);

	chkLimitFramerate.SetCallbackID(IDM_LIMITFPS);
	chkLimitFramerate.SetText("Limit framerate");
	if (!Settings::unlimitedFrameRate) {
		chkLimitFramerate.Select();
	}
	Add(chkLimitFramerate);

	lblFramerate.SetText("Target framerate:");
	Add(lblFramerate);

	sldFramerate.SetMin(0);
	sldFramerate.SetMax(15);
	sldFramerate.SetPosition((Settings::gfxFrameRate - 25)/5);
	sldFramerate.SetCallbackID(IDM_FRAMERATE);
	sldFramerate.SetOrientation(1);
	Add(sldFramerate);

	lblSelectedFramerate.ClearFlag(D_AUTOSIZE);
	lblSelectedFramerate.AlignCentre();
	lblSelectedFramerate.SetNumber(Settings::gfxFrameRate);
	Add(lblSelectedFramerate);

	OnLimitFramerate();

	lblSkins.SetText("Select skin");
	Add(lblSkins);

	char mask[512];
	MakeFullPath(mask, "skins/*.ini");
	for_each_file_ex(mask, 0, 0, skin_getter, &lstSkins);
	usprintf(mask, Settings::skinPath);
	char *selSkin = get_filename(mask);
	for (int i=0; i<lstSkins.GetItemCount(); i++) {
		if (ustrcmp(selSkin, lstSkins.GetItem(i)->GetText()) == 0) {
			lstSkins.Select(i);
			break;
		}
	}
	Add(lstSkins);

	Add(dlgKeys);
}


OptionsDlg::~OptionsDlg() {
}


void OptionsDlg::UpdateSize() {
	Dialog::UpdateSize();

	grpGfx.Shape(8, 8, 176, h()-16);
	chkFullscreen.Shape(16, 32, 160, 16);
	chkFps.Shape(16, 56, 160, 16);

	chkLimitFramerate.Shape(16, 80, 160, 16);
	lblFramerate.Shape(16, 104, 160, 16);
	sldFramerate.Shape(16, 120, 120, 16);
	lblSelectedFramerate.Shape(140, 120, 36, 16);

	lblSkins.Shape(16, 144, 160, 16);
	lstSkins.Shape(16, 160, 160, h()-160-16);

	grpKeys.Shape(192, 8, 236, h()-16);
	dlgKeys.Shape(200, 32, 220, 240);
}

void OptionsDlg::MsgInitSkin() {
	Dialog::MsgInitSkin();

}


void OptionsDlg::HandleEvent(Widget &obj, int msg, int arg1, int arg2) {
	Dialog::HandleEvent(obj, msg, arg1, arg2);

	switch (msg) {
		case IDM_FULLSCREEN:	OnFullscreen();		break;
		case IDM_FPS:			OnFps();			break;
		case IDM_LIMITFPS:		OnLimitFramerate();	break;
		//case IDM_FRAMERATE:		OnFramerate();		break;
		case IDM_SKIN:			OnSkin();			break;

		case MSG_SCROLL: {
			if (obj == lstSkins) {
				OnSkin();
			}
			else if (obj == sldFramerate) {
				OnFramerate();
			}
		}
		break;
	};
}


void OptionsDlg::OnFullscreen() {
	Settings::fullscreen = chkFullscreen.Selected();
	ChangeResolution(Settings::gfxMode, Settings::fullscreen, Settings::screenWidth, Settings::screenHeight, Settings::colorDepth, Root());
}


void OptionsDlg::OnFps() {
	Settings::showFrameRate = chkFps.Selected();
}


void OptionsDlg::OnLimitFramerate() {
	Settings::unlimitedFrameRate = !chkLimitFramerate.Selected();

	if (Settings::unlimitedFrameRate) {
		lblFramerate.Disable();
		lblSelectedFramerate.Disable();
		sldFramerate.Disable();

		Settings::yield = 0;
		Settings::vsync = 0;
	}
	else {
		lblFramerate.Enable();
		lblSelectedFramerate.Enable();
		sldFramerate.Enable();

		Settings::yield = 1;
	}
}


void OptionsDlg::OnFramerate() {
	Settings::gfxFrameRate = (int)(sldFramerate.GetPosition())*5 + 25;
	lblSelectedFramerate.SetNumber(Settings::gfxFrameRate);
}


void OptionsDlg::OnSkin() {
	char path[512];
	char tmp[256];
	usprintf(tmp, "skins/%s", lstSkins.GetSelectedItem()->GetText());
	MakeFullPath(path, tmp);
	theSkin->Load(path);
	//Root()->DialogMessage(MSG_INITSKIN);
	Root()->SetSkin(theSkin);
	//Root()->Redraw();
	//ChangeResolution(Settings::gfxMode, Settings::fullscreen, Settings::screenWidth, Settings::screenHeight, Settings::colorDepth, Root());
	ustrcpy(Settings::skinPath, tmp);
}
