#include "OnlineDlg.h"
#include "defines.h"


OnlineDlg::OnlineDlg() : Window(), retVal(0) {
	clientArea->Resize(400, 180);
	Resize(clientArea->size());
	ClearFlag(D_RESIZABLE);
	title.SetText("Online Play");

	lblSelectServer.Setup(8, 16, 120, 32, 0, 0, "Select server", 0);
	Add(lblSelectServer);

	lstServer.Shape(128, 8, 264, 68);
	lstServer.SetCallbackID(IDM_OK);
	Add(lstServer);

	lblAddServer.Setup(8, 84, 120, 32, 0, 0, "Add new server", 0);
	Add(lblAddServer);

	txtServer.Setup(128, 84, 184, 24, 0, 0, "", 64);
	txtServer.SetCallbackID(IDM_ADDSERVER);
	Add(txtServer);

	btnAddServer.Setup(320, 84, 72, 24, 0, 0, "Add");
	btnAddServer.SetCallbackID(IDM_ADDSERVER);
	Add(btnAddServer);

	lblName.Setup(8, 116, 120, 32, 0, 0, "Enter your name", 0);
	Add(lblName);

	txtName.Setup(128, 116, 160, 24, 0, 0, "", 64);
	txtName.SetCallbackID(IDM_OK);
	Add(txtName);

	col = Color::lightgray;
	btnColor.Setup(296, 116, 96, 24, 0, 0, "Color");
	btnColor.SetCallbackID(IDM_COLOR2);
	Add(btnColor);

	btnOK.Setup(100, 148, 96, 24, 0, 0, "OK");
	btnOK.SetCallbackID(IDM_OK);
	Add(btnOK);

	btnCancel.Setup(204, 148, 96, 24, 0, 0, "Cancel");
	btnCancel.MakeExit();
	Add(btnCancel);

	ReadServerList();
}


OnlineDlg::~OnlineDlg() {
}


void OnlineDlg::MsgInitSkin() {
	Window::MsgInitSkin();

}


void OnlineDlg::HandleEvent(Widget &obj, int msg, int arg1, int arg2) {
	Window::HandleEvent(obj, msg, arg1, arg2);

	switch (msg) {
		case MSG_ACTIVATE:
		break;

		case IDM_ADDSERVER:		OnAddServer();		break;
		case IDM_OK:			OnOK();				break;
		case IDM_COLOR2:		OnColor();			break;
	};
}


void OnlineDlg::OnAddServer() {
	const char *server = txtServer.GetText();

	if (server && ustrlen(server) > 0) {
		lstServer.InsertItem(server);
		lstServer.Select(lstServer.GetItemCount()-1);
	}
}


void OnlineDlg::OnOK() {
	const char *server = GetServer();
	const char *name = GetName();

	if (!server || !name) {
		MessageBox msg("Error", "Select a server and enter your name!", 0, 0, "OK");
		msg.Popup(Root());
	}
	else {
		retVal = 1;
		Close();
	}
}


void OnlineDlg::OnColor() {
	ColorSelect dlg("Chatbox backgorund color", col);
	Color newCol = dlg.Popup(Root());

	if (newCol) {
		col = newCol;
	}
}


int OnlineDlg::Popup(Dialog *parent) {
	Centre();
	Window::Popup(parent, x(), y(), &txtName);
	WriteServerList();
	return retVal;
}


void OnlineDlg::ReadServerList() {
	push_config_state();

	char path[256];
	MakeFullPath(path, AGC2_CONFIG_FILE);
	char *section = "servers";

	set_config_file(path);

	char buf[32];
	int i=0;

	while (true) {
		usprintf(buf, "server%d", i+1);
		const char *serverName = get_config_string(section, buf, 0);

		if (!serverName) {
			break;
		}
		else {
			lstServer.InsertItem(serverName);
		}

		++i;
	}

	pop_config_state();
}


void OnlineDlg::WriteServerList() {
	push_config_state();

	char path[256];
	MakeFullPath(path, AGC2_CONFIG_FILE);
	char *section = "servers";

	set_config_file(path);

	char buf[32];

	for (int i=0; i<lstServer.GetItemCount(); i++) {
		usprintf(buf, "server%d", i+1);
		set_config_string(section, buf, lstServer.GetItem(i)->GetText());
	}

	pop_config_state();
}


const char *OnlineDlg::GetServer() {
	ListBoxEx::Item *item = lstServer.GetSelectedItem();
	if (item) {
		return item->GetText();
	}
	else {
		return 0;
	}
}


const char *OnlineDlg::GetName() {
	const char *ret = txtName.GetText();

	if (ret && ustrlen(ret) > 0) {
		return ret;
	}

	return 0;
}


Color OnlineDlg::GetColor() {
	return col;
}


void OnlineDlg::SetName(const char *str) {
	txtName.SetText(str);
}


void OnlineDlg::SetColor(Color col) {
	this->col = col;
}
