#ifndef		DLG_MAINMENU_H
#define		DLG_MAINMENU_H

#include "GameScreen.h"
#include "OptionsDlg.h"
#include "defines.h"
using namespace MAS;

#ifdef	USE_ALNET
#include <alnet.h>
#endif


class MainMenu : public GameScreen {
	private:
		class GameMenu : public Dialog {
			public:
				GroupBox grpGames;
				ListBoxEx lstGames;
				GroupBox grpDesc;
				Label lblAuthor;
				Label lblDesc;
				GroupBox grpHsc;
				ListBoxEx lstHsc;
				Button btnPlay;
				Button btnSettings;
				HyperText btnReadme;

				GameMenu();
		};

		class ChatBox : public Dialog {
			public:
				Button btnOnline;
				ListBoxEx lstMsg;
				ListBoxEx lstChn;
				ListBoxEx lstPeer;
				EditBox txtMsg;
				Button btnColor;
				Button btnStart;
				Button btnJoin;

				ChatBox();
		};

		class AboutBox : public Dialog {
			public:
				Label lbl[3];

				AboutBox() : Dialog() {
					char line1[128];
					char line2[128];
					char line3[128];
					usprintf(line1, "Allegro Mini Game Collection v%d.%02d", AGC2_VERSION_MAJOR, AGC2_VERSION_MINOR);
					usprintf(line2, "Created by %s on %s", AGC2_AUTHOR_STRING, AGC2_DATE_STRING);
					usprintf(line3, "%s", allegro_id);

					lbl[0].SetText(line1);
					lbl[1].SetText(line2);
					lbl[2].SetText(line3);

					for (int i=0; i<3; i++) {
						lbl[i].ClearFlag(D_AUTOSIZE);
						lbl[i].AlignCentre();
						Add(lbl[i]);
					}
				}

				void UpdateSize() {
					Dialog::UpdateSize();

					int dy = 24;
					lbl[0].Shape(0, h()/2 - dy/2 - dy, w(), dy);
					lbl[1].Shape(0, h()/2 - dy/2     , w(), dy);
					lbl[2].Shape(0, h()/2 - dy/2 + dy, w(), dy);
				}
		};

		Panel desktop;
		Label lblTitle;
		Accelerator acc;
		Button btnExit;

		TabPanel tabs;
		GameMenu dlg1;
		ChatBox dlg2;
		OptionsDlg dlg3;
		AboutBox dlg4;
		TextArea dlg5;

		Widget *lastButton;
		int retValue;

		std::string playerName;
		std::string serverName;
		Color playerColor;

#ifdef	USE_ALNET
		ALNET_CHANNEL *channel;
		ALNET_PEER *FindPeer(int id);
#endif

	protected:
		void MsgInitSkin();
		bool MsgClose();
		void MsgTick();
		void OnSettings();
		void OnPlay();
		void OnExit();
		void OnSelectGame();
		void OnOnline();
		void OnStartNetGame();
		void OnJoinNetGame();
		void OnSendMsg();
		void OnColor();
		void RebuildGUI();
		void OnReadme();

		void SystemNetMessage(const char *str, int col=-1);
		void NYI();

		void ReadSettings();
		void WriteSettings();

	public:
		MainMenu();
		~MainMenu();

		void HandleEvent(Widget &obj, int msg, int arg1=0, int arg2=0);
		int Run();
		int GetSelectedGame();
		void SetPluginManager(PluginManager *pm);
};

#endif		//DLG_MAINMENU_H
