#include "debug.h"
#include "MainMenu.h"
#include "hsc.h"
#include "OptionsDlg.h"
#include "SettingsDialog.h"
#include "OnlineDlg.h"


class IconItem : public MAS::ListBoxEx::Item {
	protected:
		BITMAP *icon;

		void DrawItem(Bitmap &canvas, int i, int state, const Rect &dstRect) {
			if (parent->AreGridLinesEnabled()) {
				DrawGrid(canvas, i, state, dstRect);
			}

			int s = 0;
			switch (state) {
				case 0:
				case 1:
					s = 0;	break;
				case 2:
				case 3:
					s = 3;	break;
				case 4:
				case 5:
					s = 1;	break;
				case 6:
				case 7:
					s = 2;	break;
			};

			Color fg = parent->GetFontColor(s);
			Color bg = parent->GetShadowColor(s);
			Font fnt = parent->GetFont(s);
			Color tm = parent->GetTextMode();

			int xx = dstRect.x() + 32;
			int yy = dstRect.y() + (dstRect.h() - fnt.TextHeight())/2;

			// adjust x offset according to alignment
			xx += 4;
			/*
			switch (parent->columns[i].alignment) {
				case 0:		xx += 4;				break;
				case 1:		xx += dstRect.w()-4;	break;
				case 2:		xx += dstRect.w()/2;	break;
			};
			*/

			fnt.GUITextout(canvas, GetText(i), Point(xx, yy), fg, bg, tm, 0 /*parent->columns[i].alignment*/);

			if (icon) {
				draw_sprite(canvas, icon, dstRect.x() + (32 - icon->w)/2, dstRect.y() + (32 - icon->h)/2);
			}
			else {
				/*
				rectfill(canvas, 8, 8, 24, 24, makecol(255,255,255));
				rect(canvas, 8, 8, 24, 24, makecol(0,0,0));
				*/
			}
		}

	public:
		IconItem(const char *path) : ListBoxEx::Item(), icon(0) {
			icon = load_bitmap(path, 0);
		}

		~IconItem() {
			if (icon) {
				destroy_bitmap(icon);
			}
		}

		int h() {
			return 32;
		}
};


class ChatboxItem : public MAS::ListBoxEx::Item {
	protected:
		Color col;

		void DrawBackground(Bitmap &canvas, int state, const Rect &dstRect) {
			state = 0;
			canvas.Rectfill(dstRect, col);
		}

	public:
		ChatboxItem(const char *text, int col) : ListBoxEx::Item() {
			this->col = col;
			InsertColumn();
			SetText(text);
		}
};


MainMenu::ChatBox::ChatBox() : Dialog() {
	// y +32
	// x +4

	lstMsg.Shape(4, 32, 530, 324);
	Add(lstMsg);

	lstChn.Shape(538, 32, 86, 92);
	Add(lstChn);

	lstPeer.Shape(538, 128, 86, 228);
	Add(lstPeer);

	txtMsg.Shape(4, 360, 516, 24);
	txtMsg.SetText("", 256);
	txtMsg.SetCallbackID(IDM_SENDMSG);
	Add(txtMsg);

	btnColor.Shape(528, 360, 96, 24);
	btnColor.SetCallbackID(IDM_COLOR);
	btnColor.SetText("Set Color");
	Add(btnColor);

	btnOnline.Shape(4, 4, 120, 24);
	btnOnline.Key(KEY_N);
	btnOnline.SetCallbackID(IDM_ONLINE);
	btnOnline.SetText("Go O&nline");
	Add(btnOnline);

	btnStart.Shape(132, 4, 120, 24);
	btnStart.Key(KEY_T);
	btnStart.SetCallbackID(IDM_START);
	btnStart.SetText("S&tart Game");
	Add(btnStart);

	btnJoin.Shape(260, 4, 120, 24);
	btnJoin.Key(KEY_J);
	btnJoin.SetCallbackID(IDM_JOIN);
	btnJoin.SetText("&Join Game");
	Add(btnJoin);
}


MainMenu::GameMenu::GameMenu() : Dialog() {
	Resize(640, 480);

	grpGames.Shape(4, 0, 620, 384);
	grpGames.SetTitle("Available Games");
	Add(grpGames);

	lstGames.Shape(12, 24, 256, 352);
	lstGames.SetCallbackID(IDM_PLAY);
	Add(lstGames);

	grpDesc.Shape(276, 24, 344, 144);
	grpDesc.SetTitle("Game Description and Instructions");
	Add(grpDesc);

	lblAuthor.SetText("label");
	lblAuthor.Shape(284, 48, 328, 16);
	Add(lblAuthor);

	lblDesc.SetText("label");
	lblDesc.ClearFlag(D_AUTOSIZE);
	lblDesc.SetVAlignment(2);
	lblDesc.SetWordWrap(true);
	lblDesc.Shape(284, 64, 328, 96);
	Add(lblDesc);

	grpHsc.Shape(276, 176, 344, 168);
	grpHsc.SetTitle("High Scores");
	Add(grpHsc);

	lstHsc.Shape(284, 200, 328, 136);
	lstHsc.InsertColumn("#");
	lstHsc.InsertColumn("Name");
	lstHsc.InsertColumn("Date");
	lstHsc.InsertColumn("Score");
	lstHsc.SetColumnWidth(0, 24);
	lstHsc.SetColumnWidth(1, 13*8);
	lstHsc.SetColumnWidth(2, 16*8);
	lstHsc.SetColumnWidth(3, 6*8);
	Add(lstHsc);

	btnPlay.Shape(276, 352, 120, 24);
	btnPlay.Key(KEY_P);
	btnPlay.SetCallbackID(IDM_PLAY);
	btnPlay.SetText("&Play Game");
	Add(btnPlay);

	btnSettings.Shape(404, 352, 120, 24);
	btnSettings.Key(KEY_S);
	btnSettings.SetCallbackID(IDM_SETTINGS);
	btnSettings.SetText("Game &Settings");
	Add(btnSettings);

	btnReadme.Shape(600, 144, 28, 12);
	btnReadme.SetText("...");
	btnReadme.SetCallbackID(IDM_README);
	btnReadme.SetTextMode(-1);
	Add(btnReadme);
}


MainMenu::MainMenu() : GameScreen() {
DEBUG("main.log")
	Resize(640, 480);

	desktop.Shape(0, 0, 640, 480);
	Add(desktop);

	lblTitle.SetText("Allegro Game Collection");
	lblTitle.ClearFlag(D_AUTOSIZE);
	lblTitle.SetAlignment(2);
	lblTitle.SetVAlignment(2);
	lblTitle.Shape(8, 4, 624, 48);
	Add(lblTitle);

	btnExit.Shape(620, 4, 16, 16);
	btnExit.Key(KEY_X);
	btnExit.SetCallbackID(IDM_EXIT);
	btnExit.SetText("");
	//Add(btnExit);

	dlg1.Shape(0, 0, 640, 392);
	dlg2.Shape(0, 0, 640, 392);
	dlg3.Shape(0, 0, 640, 392);
	dlg4.Shape(0, 0, 640, 392);
	dlg5.Shape(0, 0, 640, 392);
	tabs.Shape(4, 60, 632, 416);
	tabs.Attach(&dlg1, "Games");
	tabs.Attach(&dlg2, "Chatroom");
	tabs.Attach(&dlg3, "Options");
	tabs.Attach(&dlg4, "About");
	tabs.Attach(&dlg5, "readme.txt");
	Add(tabs);

	//acc.Add(KEY_F1, 0, 2000);
	acc.Add(KEY_ESC, 0, 3000);
	Add(acc);

	lastButton = &dlg1.lstGames;
	escapeExits = false;

	ReadSettings();

#ifdef	USE_ALNET
	channel = 0;
#endif
DEBUG("main.log")
}


MainMenu::~MainMenu() {
	WriteSettings();
}


void MainMenu::MsgInitSkin() {
DEBUG("main.log")
	Dialog::MsgInitSkin();

	char path[512];
	MakeFullPath(path, "bassoonb.ttf");
	skin->LoadFont(path, Skin::nFonts, 48);
	lblTitle.SetFont(Skin::nFonts, Skin::NORMAL);
	lblTitle.SetFontColor(Color(0, 128, 255), Color(0, 0, 64), Skin::NORMAL);
	lblTitle.SetText("Allegro Mini Game Collection");

	btnExit.SetBitmap(Skin::ICONEXIT);
	Bitmap bmp = skin->GetBitmap(Skin::ICONEXIT);
	btnExit.Resize(bmp.w(), bmp.h()/4);
	btnExit.Place(w() - bmp.w() - 4, 4);

	MakeFullPath(path, "readme.txt");
	dlg5.LoadLinesFromFile(path);
	DEBUG("main.log")
}


bool MainMenu::MsgClose() {
	/*
	MessageBox msg("Alert", "Really exit?", 0, 0, "Yes", "No");
	return msg.Popup(this) == 1;
	*/
	return true;
}


void MainMenu::HandleEvent(Widget &obj, int msg, int arg1, int arg2) {
	Dialog::HandleEvent(obj, msg, arg1, arg2);

	switch (msg) {
		case IDM_SETTINGS:		OnSettings();		break;
		case IDM_PLAY:			OnPlay();			break;
		case IDM_EXIT:			OnExit();			break;
		case IDM_ONLINE:		OnOnline();			break;
		case IDM_START:			OnStartNetGame();	break;
		case IDM_JOIN:			OnJoinNetGame();	break;
		case IDM_SENDMSG:		OnSendMsg();		break;
		case IDM_COLOR:			OnColor();			break;
		case IDM_README:		OnReadme();			break;

		case 3000: {
			MessageBox msg("Alert", "Really exit?", 0, 0, "Yes", "No");
			if (msg.Popup(this) == 1) {
				Close();
			}
		}
		break;

		case MSG_SCROLL: {
			if (obj == dlg1.lstGames) {
				OnSelectGame();
			}
		}
		break;
	};
}


void MainMenu::OnSettings() {
	int game_index = GetSelectedGame();
	if (game_index >= 0) {
		IGame *game = pm->GetPlugin(game_index);
		if (!game) {
			return;
		}

		SettingsDlg dlg;
		dlg.Popup(Root(), game, pm->GetPluginPath(game_index));
		delete game;
	}
}


void MainMenu::OnPlay() {
	retValue = PLAY_GAME;
	Close();
}


void MainMenu::OnExit() {
	retValue = EXIT_GAME;
	Close();
}


#ifdef	USE_ALNET
static bool toggle = false;
#endif

void MainMenu::OnOnline() {
#ifdef	USE_ALNET
	if (toggle) {
		// back to normal play
		alnet_leave_channel(channel);
		RebuildGUI();
	}
	else {
		// go online
		OnlineDlg dlg;
		dlg.SetName(playerName.c_str());
		dlg.SetColor(playerColor);

		if (dlg.Popup(Root()) == 1) {
			playerName = std::string(dlg.GetName());
			serverName = std::string(dlg.GetServer());
			playerColor = dlg.GetColor();
			dlg2.lstMsg.DeleteAllItems();
			SystemNetMessage("Connecting...");
			dlg2.btnOnline.SetText("Disco&nnect");
			alnet_connect(serverName.c_str(), 33000);
			toggle = !toggle;
		}
	}

	Redraw();
#endif
}


void MainMenu::SystemNetMessage(const char *str, int col) {
	dlg2.lstMsg.InsertItem(new ChatboxItem(str, col == -1 ? makecol(212,240,220) : col));
	dlg2.lstMsg.ScrollToItem(dlg2.lstMsg.GetItemCount()-1);
}


void MainMenu::NYI() {
	MessageBox msg("Alert", "Not Yet Implemented", 0, 0, "Whatever...");
	msg.Popup(Root());
}


void MainMenu::OnSelectGame() {
DEBUG("main.log")
	IGame *game = pm->GetPlugin(GetSelectedGame());

DEBUG("main.log")
	if (game) {
		// author label
		std::string s = "";
		s += std::string(game->GetName());
		s += std::string(" v");
		s += std::string(game->GetVersion());
		s += std::string(" by ");
		s += std::string(game->GetAuthor());
		dlg1.lblAuthor.SetText(s.c_str());
DEBUG("main.log")

		// description label
		dlg1.lblDesc.SetText(game->GetDescription());

		// high scores
		dlg1.lstHsc.DeleteAllItems();

DEBUG("main.log")
		HSC *hsc = new HSC;
		char path[256];
		char filename[256];
		replace_filename(filename, pm->GetPluginPath(GetSelectedGame()).c_str(), game->GetName(), 256);
		ustrcat(filename, ".hsc");
		MakeFullPath(path, filename);
		hsc->Load(path);
DEBUG("main.log")

		for (int i=0; i<hsc->Count(); i++) {
			dlg1.lstHsc.InsertItem(new ListBoxEx::Item());

			HSC::Entry e = hsc->GetEntry(i);
			static char buf[16];

			usprintf(buf, "%d", i+1);
			dlg1.lstHsc.SetItem(i, 0, buf);
			dlg1.lstHsc.SetItem(i, 1, e.name.c_str());
			dlg1.lstHsc.SetItem(i, 2, e.date.c_str());
			usprintf(buf, "%d", e.score);
			dlg1.lstHsc.SetItem(i, 3, buf);
		}
DEBUG("main.log")

		if (game->RedefinesKeys() || game->GetSettings()) {
			dlg1.btnSettings.Unhide();
		}
		else {
			dlg1.btnSettings.Hide();
		}

		delete hsc;
		delete game;

DEBUG("main.log")
		Redraw();
	}
DEBUG("main.log")

	if (GetSelectedGame() >= 0) {
		char buf[256];
		replace_filename(buf, pm->GetPluginPath(GetSelectedGame()).c_str(), "readme.txt", 256);
		if (exists(buf)) {
			dlg1.btnReadme.Unhide();
		}
		else {
			dlg1.btnReadme.Hide();
		}
	}
	else {
		dlg1.btnReadme.Hide();
	}
}


int MainMenu::Run() {
DEBUG("main.log")
	retValue = EXIT_GAME;
	OnSelectGame();
	lastButton = Execute(lastButton);
DEBUG("main.log")
	return retValue;
}


int MainMenu::GetSelectedGame() {
DEBUG("main.log")
	ListBoxEx::Item *item = dlg1.lstGames.GetSelectedItem();
	int ret = -1;
	if (item) {
		ret = pm->GetPluginIndex(std::string(item->GetText()));
	}
DEBUG("main.log")
	return ret;
	//return lstGames.GetSelectedIndex();
}


void MainMenu::SetPluginManager(PluginManager *pm) {
DEBUG("main.log")
	GameScreen::SetPluginManager(pm);

	char buf[256];
	char path[256];
	MakeFullPath(buf, "games/icon.bmp");
	dlg1.lstHsc.DeleteAllItems();
	dlg1.lstGames.DeleteAllItems();
	for (int i=0; i<pm->GetPluginCount(); i++) {
		replace_filename(buf, pm->GetPluginPath(i).c_str(), pm->GetPluginIcon(i).c_str(), 256);
		MakeFullPath(path, buf);
		dlg1.lstGames.InsertItem(new IconItem(path));
		dlg1.lstGames.SetItem(i, 0, pm->GetPluginName(i).c_str());
	}

	dlg1.lstGames.Sort();

	if (dlg1.lstGames.GetItemCount() > 0) {
		dlg1.lstGames.Select(0);
		OnSelectGame();
	}
DEBUG("main.log")
}


void MainMenu::OnStartNetGame() {
	NYI();
}


void MainMenu::OnJoinNetGame() {
	NYI();
}


void MainMenu::OnSendMsg() {
#ifdef	USE_ALNET
	const char *msg = dlg2.txtMsg.GetText();

	if (msg && ustrlen(msg) > 0) {
		if (channel) {
			// broadcast the message
			alnet_broadcast_data(channel, (void*)msg, ustrlen(msg));

			// do the same manually with send_data
			/*
			ALNET_PEER_LIST *list = channel->peers;
			while (list) {
				alnet_send_data(channel, list->peer->id, (void*)msg, ustrlen(msg));
				list = list->next;
			}
			*/
		}
		else {
			SystemNetMessage("Error: no channel!");
		}

		std::string item = playerName + ": " + msg;
		dlg2.lstMsg.InsertItem(new ChatboxItem(item.c_str(), playerColor));
		dlg2.lstMsg.ScrollToItem(dlg2.lstMsg.GetItemCount()-1);
		dlg2.txtMsg.SetText("");
	}
#endif
}


void MainMenu::ReadSettings() {
	push_config_state();

	char path[256];
	MakeFullPath(path, AGC2_CONFIG_FILE);

	set_config_file(path);

	playerName = get_config_string("player", "name", "");
	playerColor = Color(get_config_int("player", "r", 220), get_config_int("player", "g", 220), get_config_int("player", "b", 220));

	pop_config_state();
}


void MainMenu::WriteSettings() {
	push_config_state();

	char path[256];
	MakeFullPath(path, AGC2_CONFIG_FILE);

	set_config_file(path);

	set_config_string("player", "name", playerName.c_str());
	set_config_int("player", "r", playerColor.r());
	set_config_int("player", "g", playerColor.g());
	set_config_int("player", "b", playerColor.b());

	pop_config_state();
}


void MainMenu::OnColor() {
	ColorSelect dlg("Chatbox backgorund color", playerColor);
	Color newCol = dlg.Popup(Root());

	if (newCol) {
		playerColor = newCol;
	}
}


void MainMenu::MsgTick() {
	Dialog::MsgTick();

#ifdef	USE_ALNET
	ALNET_EVENT event;
	static char buf[256];

	if (alnet_status != ALNET_STATUS_OFFLINE)
	{
		if (alnet_poll(&event))
		{
			switch (event.type)
			{
				case ALNET_EVENT_CONNECT_FAIL:
					SystemNetMessage("Unable to connect to server.");
				break;

				case ALNET_EVENT_CONNECT:
					SystemNetMessage("Connected to server.");
					SystemNetMessage("Authenticating...");
					alnet_authenticate(playerName.c_str(), NULL);
				break;

				case ALNET_EVENT_DISCONNECT:
					SystemNetMessage("Disconnected from server.");
					dlg2.btnOnline.SetText("Go O&nline");
					toggle = !toggle;
					channel = 0;
					RebuildGUI();
				break;

				case ALNET_EVENT_AUTH_OK:
					SystemNetMessage("Authentication successful.");

					/* Join a public communication channel.
					   Public channels have IDs that should be "registered" so that people don't
					   choose the same ones. Any one can join a public channel, so it's best
					   (if not only) use is for free entry chat rooms.
					*/
					alnet_join_channel(100);
				break;

				case ALNET_EVENT_AUTH_FAIL:
					SystemNetMessage("Unable to authenticate.");
					alnet_disconnect();
				break;

				case ALNET_EVENT_JOIN_CHANNEL_OK:
					usprintf(buf, "Joined channel #%u.", event.id);
					SystemNetMessage(buf);
					channel = event.channel;
				break;

				case ALNET_EVENT_JOIN_CHANNEL_FAIL:
					usprintf(buf, "Unable to join channel #%d.", event.id);
					SystemNetMessage(buf);
				break;

				case ALNET_EVENT_LIST_CHANNEL:
				{
					if (channel)
					{
						/*
						ALNET_PEER_LIST *list = channel->peers;
						usprintf(buf, "Received Peer List for channel #%d:", channel->id);
						SystemNetMessage(buf);

						while (list)
						{
							usprintf(buf, "%d: %s", list->peer->id, list->peer->name);
							SystemNetMessage(buf);
							list = list->next;
						}
						*/

						RebuildGUI();
					}
				}
				break;

				case ALNET_EVENT_PEER_JOIN_CHANNEL:
				{
					ALNET_PEER *peer = event.peer;

					//usprintf(buf, "Peer #%d (%s) has joined channel #%d.", peer->id, peer->name, channel->id);
					usprintf(buf, "%s has entered the chatroom.", peer->name);
					SystemNetMessage(buf);

					RebuildGUI();
				}
				break;

				case ALNET_EVENT_PEER_LEAVE_CHANNEL:
				{
					ALNET_PEER *peer = event.peer;
					channel = event.channel;
					usprintf(buf, "%s has left channel #%d.", peer->name, channel->id);
					SystemNetMessage(buf);
					RebuildGUI();
				}
				break;

				case ALNET_EVENT_LEAVE_CHANNEL_OK:
				{
					channel = event.channel;
					usprintf(buf, "You have left channel #%d.", channel->id);
					SystemNetMessage(buf);
					alnet_disconnect();
					RebuildGUI();
				}
				break;

				case ALNET_EVENT_PEER_QUIT:
				{
					ALNET_PEER *peer = event.peer;
					ALNET_CHANNEL_LIST *clist = peer->channels;
					//usprintf(buf, "Peer #%d has quit.", peer->id);
					usprintf(buf, "%s has quit.", peer->name);
					SystemNetMessage(buf);
					while (clist)
					{
						if (clist->channel->id == channel->id) {
							channel = clist->channel;
							RebuildGUI();
						}
						usprintf(buf, "#%d", clist->channel->id);
						//SystemNetMessage(buf);
						clist = clist->next;
					}
					//RebuildGUI();
				}
				break;

				case ALNET_EVENT_DATA:
				{
					// TODO:
					//  - find channel
					//  - decode type of message
					//  - forward message to receiver (e.g. message list, game, etc.)

					char *msg = (char *)event.ptr;
					msg[event.len] = 0;

					ALNET_PEER *peer = FindPeer(event.id);
					if (peer) {
						if (std::string(peer->name) != playerName) {
							std::string txt = std::string(peer->name) + ": " + msg;
							SystemNetMessage(txt.c_str(), makecol(232,212,212));
						}
					}
					else {
						usprintf(buf, "-> Received %x bytes From Client %d", event.len, event.id);
						SystemNetMessage(buf);
						SystemNetMessage(msg);
					}
				}
				break;

				default:
					usprintf(buf, "Unknown event: %d", event.type);
					SystemNetMessage(buf);
				break;

			}
			alnet_cleanup_event(&event);
		}
	}
#endif
}


void MainMenu::RebuildGUI() {
#ifdef	USE_ALNET
	dlg2.lstChn.DeleteAllItems();
	//for (std::vector<Channel>::iterator i = channels.begin(); i != channels.end(); ++i) {
	if (channel) {
		char buf[32];
		usprintf(buf, "%d", channel->id);
		dlg2.lstChn.InsertItem(buf);
	}

	dlg2.lstPeer.DeleteAllItems();

	if (channel) {
		ALNET_PEER_LIST *list = channel->peers;
		while (list) {
			dlg2.lstPeer.InsertItem(list->peer->name);
			list = list->next;
		}
	}
#endif
}

#ifdef	USE_ALNET
ALNET_PEER *MainMenu::FindPeer(int id) {
	if (!channel) {
		return 0;
	}

	ALNET_PEER_LIST *list = channel->peers;

	while (list) {
		if (list->peer->id == (unsigned)id) {
			return list->peer;
		}

		list = list->next;
	}

	return 0;
}
#endif


void MainMenu::OnReadme() {
	int game_index = GetSelectedGame();
	if (game_index >= 0) {
		char buf[256];
		replace_filename(buf, pm->GetPluginPath(game_index).c_str(), "readme.txt", 256);

		class ReadmeWindow : public Window {
			public:
				TextArea txtReadme;

				ReadmeWindow() : Window() {
					clientArea->Resize(3*SCREEN_W/4, 3*SCREEN_H/4);
					Resize(clientArea->size());

					minSize = Size(SCREEN_W/2, SCREEN_H/2);

					txtReadme.Shape(0,0,clientArea->w(),clientArea->h());
					Add(txtReadme);
				}

				void Popup(Dialog *parent, char *readme) {
					txtReadme.SetText("");
					txtReadme.LoadLinesFromFile(readme);

					title.SetText(readme);
					Centre();
					Window::Popup(parent);
				}

				void UpdateSize() {
					Window::UpdateSize();
					txtReadme.Shape(0,0,MAX(clientArea->w(),8),MAX(clientArea->h(),8));
				}
		};

		static ReadmeWindow wndReadme;
		if (exists(buf)) {
			wndReadme.Popup(Root(), buf);
		}
	}
}
