#include "defines.h"
#include "KeySettings.h"
#include <MASkinG.h>


KeySettings::KeySettings() {
	keys[0].code = KEY_LEFT;
	keys[1].code = KEY_RIGHT;
	keys[2].code = KEY_UP;
	keys[3].code = KEY_DOWN;
	keys[4].code = KEY_RCONTROL;
	keys[5].code = KEY_SPACE;
	keys[6].code = KEY_ALTGR;
	keys[7].code = KEY_RSHIFT;

	keys[0].name = "Left";
	keys[1].name = "Right";
	keys[2].name = "Up";
	keys[3].name = "Down";
	keys[4].name = "Action A";
	keys[5].name = "Action B";
	keys[6].name = "Action C";
	keys[7].name = "Action D";
}


KeySettings::~KeySettings() {
}


KeySettings::Key& KeySettings::GetKey(int i) {
	return keys[i];
}


void KeySettings::Read(const char *file, const char *section) {
	push_config_state();

	set_config_file(file);

	char key_name[32];
	for (int i=0; i<key_count; i++) {
		usprintf(key_name, "key%d", i+1);
		keys[i].code = get_config_int(section, key_name, keys[i].code);
	}

	pop_config_state();
}


void KeySettings::Write(const char *file, const char *section) {
	push_config_state();

	set_config_file(file);

	char key_name[32];
	for (int i=0; i<key_count; i++) {
		usprintf(key_name, "key%d", i+1);
		set_config_int(section, key_name, keys[i].code);
	}

	pop_config_state();
}
