#include "KeyDialog.h"
#include "defines.h"

class GetKeyDlg : public MessageBox {
	protected:
		int ret_value;

		void MsgTick() {
			MessageBox::MsgTick();

			for (int i=0; i<KEY_MAX; i++) {
				if (::key[i]) {
					ret_value = i;
					Close();
					break;
				}
			}
		}

	public:
		GetKeyDlg() : MessageBox("Define key", "Select new key or press ESC to cancel", 0, 0, "OK") {
		}

		int GetKey(Dialog *parent) {
			ret_value = -1;

			if (Popup(parent) == 1) {
				return ret_value;
			}
			else {
				return -1;
			}
		}
};


//------------------------

KeysDlg::KeysDlg() : Window() {
	clientArea->Resize(220, 240);
	Resize(clientArea->size());
	ClearFlag(D_RESIZABLE);
	title.SetText("Redefine Keys");

	for (int i=0; i<8; i++) {
		lblKeys[i].ClearFlag(D_AUTOSIZE);
		lblKeys[i].SetAlignment(2);
		lblKeys[i].Shape(8, 8+i*24+2, 80, 16);
		btnKeys[i].Shape(92, 8+i*24, 124, 22);
		Add(lblKeys[i]);
		Add(btnKeys[i]);
	}

	btnOK.Shape(50, 208, 120, 24);
	btnOK.MakeExit();
	btnOK.SetText("OK");
	Add(btnOK);
}


KeysDlg::~KeysDlg() {
}


void KeysDlg::MsgInitSkin() {
	Window::MsgInitSkin();

}


void KeysDlg::HandleEvent(Widget &obj, int msg, int arg1, int arg2) {
	Window::HandleEvent(obj, msg, arg1, arg2);

	switch (msg) {
		case MSG_ACTIVATE:
			for (int i=0; i<8; i++) {
				if (obj == btnKeys[i]) {
					OnGetKey(i);
				}
			}
		break;
	};
}


void KeysDlg::Popup(Dialog *parent, KeySettings *keys) {
	this->keys = keys;

	PopulateGUI();
	Window::Popup(parent);
}


void KeysDlg::OnGetKey(int i) {
	GetKeyDlg dlg;
	int new_key = dlg.GetKey(Root());
	if (new_key != -1) {
		keys->GetKey(i).code = new_key;
		PopulateGUI();
	}
}


void KeysDlg::PopulateGUI() {
	for (int i=0; i<8; i++) {
		lblKeys[i].SetText(keys->GetKey(i).name.c_str());

		if (!keys->GetKey(i).name.empty()) {
			btnKeys[i].Enable();
			btnKeys[i].SetText(scancode_to_name(keys->GetKey(i).code));
		}
		else {
			btnKeys[i].Disable();
			btnKeys[i].SetText("");
		}
	}
}


//------------------------


KeysDlg2::KeysDlg2() : Dialog() {
	for (int i=0; i<8; i++) {
		lblKeys[i].ClearFlag(D_AUTOSIZE);
		lblKeys[i].SetAlignment(2);
		lblKeys[i].Shape(8, 8+i*24+2, 80, 16);
		btnKeys[i].Shape(92, 8+i*24, 124, 22);
		Add(lblKeys[i]);
		Add(btnKeys[i]);
	}
}


KeysDlg2::~KeysDlg2() {
}


void KeysDlg2::MsgInitSkin() {
	Dialog::MsgInitSkin();

}


void KeysDlg2::HandleEvent(Widget &obj, int msg, int arg1, int arg2) {
	Dialog::HandleEvent(obj, msg, arg1, arg2);

	switch (msg) {
		case MSG_ACTIVATE:
			for (int i=0; i<8; i++) {
				if (obj == btnKeys[i]) {
					OnGetKey(i);
				}
			}
		break;
	};
}


void KeysDlg2::MsgStart() {
	Dialog::MsgStart();
	keys.Read(AGC2_CONFIG_FILE, "GLOBAL_KEYS");
	PopulateGUI();
}


void KeysDlg2::OnGetKey(int i) {
	GetKeyDlg dlg;
	int new_key = dlg.GetKey(Root());
	if (new_key != -1) {
		keys.GetKey(i).code = new_key;
		PopulateGUI();
		keys.Write(AGC2_CONFIG_FILE, "GLOBAL_KEYS");
	}
}


void KeysDlg2::PopulateGUI() {
	for (int i=0; i<8; i++) {
		lblKeys[i].SetText(keys.GetKey(i).name.c_str());

		if (!keys.GetKey(i).name.empty()) {
			btnKeys[i].Enable();
			btnKeys[i].SetText(scancode_to_name(keys.GetKey(i).code));
		}
		else {
			btnKeys[i].Disable();
			btnKeys[i].SetText("");
		}
	}
}
