#include "HscDialog.h"

static std::string lastName = "";

HscDialog::HscDialog() : Window() {
	clientArea->Resize(256, 96);
	Resize(clientArea->size());
	ClearFlag(D_RESIZABLE);
	title.SetText("High score!");

	widget1.SetText("Congratulations! You have a high score!");
	widget1.Shape(12, 8, 192, 16);
	Add(widget1);

	widget2.SetText("Enter your name");
	widget2.Shape(8, 36, 80, 16);
	Add(widget2);

	widget3.Shape(112, 32, 132, 24);
	widget3.MakeExit();
	widget3.SetText("", 64);
	Add(widget3);

	widget4.Shape(80, 64, 120, 24);
	widget4.MakeExit();
	widget4.SetText("OK");
	Add(widget4);

	escapeExits = false;
}


std::string HscDialog::Popup(Dialog *parent) {
	widget3.SetText(lastName.c_str());
	Window::Popup(parent, (SCREEN_W - w())/2, (SCREEN_H - h())/2, &widget3);
	lastName = widget3.GetText();
	return lastName;
}


void HscDialog::SetScore(int score) {
	char buf[64];
	usprintf(buf, "High score: %d!", score);
	title.SetText(buf);
}
