#ifndef		GAME_DRIVER_H
#define 	GAME_DRIVER_H

#include "GameScreen.h"
#include "defines.h"
#include "PluginManager.h"
#include "hsc.h"
#include "HscDialog.h"
#include "fps.h"
#include "screenshot.h"
#include "KeySettings.h"
#include "global.h"
using namespace MAS;


class GameDriver : public GameScreen {
	protected:
		int selectedGame;
		IGame *theGame;
		HSC hsc;
		bool doing_game_over_messages;
		CFPS fps;
		SCREENSHOT *ss;
		KeySettings keys;

		#define MSG_SCREENSHOT 1000
		Accelerator acc;

		void MsgStart();
		void MsgEnd();
		void Draw(Bitmap &canvas);
		void MsgTick();
		void MsgIdle();
		bool MsgClose();
		void LoadHighscores();
		void SaveHighscores();
		void OnHiscore();

		void StartGame();
		void EndGame();

	public:
		GameDriver();
		~GameDriver();

		int Run();
		void SelectGame(int game);
		void HandleEvent(Widget &obj, int msg, int arg1=0, int arg2=0);
};


#endif		//GAME_DRIVER_H
