#include "debug.h"
#include "GameDriver.h"
#include "global.h"


void GameDriver::StartGame() {
	srand(time(0));

	doing_game_over_messages = false;

	if (!theGame) return;

	if (!theGame->Init()) {
		/*
		MessageBox msg("Error", "Can't load game!", 0, 0, "Too bad");
		msg.Popup(Root());
		*/
		theGame = 0;
		Close();
		return;
	}

	if (theGame->UseSystemMouse() == false) {
		Settings::showMouse = false;
	}

	fps.Init(Settings::logicFrameRate);
	ss = create_screenshot("SHOT", "TGA");
}


void GameDriver::EndGame() {
	if (!theGame) return;
	theGame->Deinit();
	Settings::showMouse = true;
	//doing_game_over_messages = false;
	destroy_screenshot(ss);
}


void GameDriver::MsgStart() {
	GameScreen::MsgStart();
	StartGame();
}


void GameDriver::MsgEnd() {
	GameScreen::MsgEnd();
	EndGame();
}


void GameDriver::Draw(Bitmap &canvas) {
	if (!theGame) return;
	theGame->Draw(canvas);
	fps.Frame();
	if (Settings::showFrameRate) {
		textprintf_right_ex(canvas, font, SCREEN_W, 0, -1, 0, "%d", fps.Get());
	}
}


void GameDriver::MsgTick() {
	GameScreen::MsgTick();
	if (!theGame) return;

	int keys[8];
	int mouse[4];

	if (doing_game_over_messages == false) {
		for (int i=0; i<8; i++) {
			keys[i] = ::key[this->keys.GetKey(i).code];
		}

		if (theGame->UseSystemMouse() == false) {
			poll_mouse();
		}

		mouse[0] = ::mouse_x;
		mouse[1] = ::mouse_y;
		mouse[2] = ::mouse_b;
		mouse[3] = ::mouse_z;
	}

	float dT = 1000.0f / (float)Settings::logicFrameRate;

	if (theGame->Logic(keys, mouse, dT) != 0 && doing_game_over_messages == false) {
		doing_game_over_messages = true;
		Settings::showMouse = true;
		OnHiscore();
		MessageBox msg("Alert", "Game Over!", 0, 0, "Play Again", "Main Menu");

		if (msg.Popup(Root()) == 2) {
			Close();
		}
		else {
			EndGame();
			StartGame();
		}

		//doing_game_over_messages = false;
	}

	fps.Tick();
}


void GameDriver::MsgIdle() {
	GameScreen::MsgIdle();
	Redraw();
}

bool GameDriver::MsgClose() {
DEBUG("main.log")
	if (::key[KEY_ESC] && !doing_game_over_messages) {
		doing_game_over_messages = true;
		Settings::showMouse = true;
		MessageBox msg("Game paused", "Press ESC to continue or ENTER to exit the game", 0, 0, "Exit", "Continue");
		theGame->Pause();
		if (msg.Popup(Root()) == 1) {
			OnHiscore();
DEBUG("main.log")
			return true;
		}
		else {
			if (theGame->UseSystemMouse() == false) {
				Settings::showMouse = false;
			}
			theGame->Resume();
			doing_game_over_messages = false;
DEBUG("main.log")
			return false;
		}
	}
	else {
DEBUG("main.log")
		return true;
	}
}


void GameDriver::LoadHighscores() {
	if (!theGame) return;
DEBUG("main.log")
	char path[512];
	char filename[256];
	replace_filename(filename, pm->GetPluginPath(pm->GetPluginIndex(theGame->GetName())).c_str(), theGame->GetName(), 256);
	ustrcat(filename, ".hsc");
	MakeFullPath(path, filename);
	hsc.Load(path);
DEBUG("main.log")
}


void GameDriver::SaveHighscores() {
	if (!theGame) return;
DEBUG("main.log")
	char path[512];
	char filename[256];
	replace_filename(filename, pm->GetPluginPath(pm->GetPluginIndex(theGame->GetName())).c_str(), theGame->GetName(), 256);
	ustrcat(filename, ".hsc");
	MakeFullPath(path, filename);
	hsc.Save(path);
DEBUG("main.log")
}


void GameDriver::OnHiscore() {
	if (!theGame) return;
DEBUG("main.log")
	HSC::Entry e;
	e.score = theGame->Score();
	if (hsc.CanAdd(e.score)) {
		HscDialog dlg;
		dlg.SetScore(e.score);
		e.name = dlg.Popup(Root());
		hsc.AddEntry(e);
	}
DEBUG("main.log")
}


GameDriver::GameDriver() : GameScreen() {
	acc.Add(KEY_F12, 0, MSG_SCREENSHOT);
	acc.Add(KEY_PRTSCR, 0, MSG_SCREENSHOT);
	Add(acc);
}


GameDriver::~GameDriver() {
}


int GameDriver::Run() {
DEBUG("main.log")
	theGame = pm->GetPlugin(selectedGame);
	if (theGame) {
		hsc.Reset();
		LoadHighscores();
		GameSettings *settings = theGame->GetSettings();
		char buf[256];
		char path[256];
		replace_filename(buf, pm->GetPluginPath(pm->GetPluginIndex(theGame->GetName())).c_str(), theGame->GetName(), 256);
		ustrcat(buf, ".cfg");
		MakeFullPath(path, buf);
		if (settings) {
			load_settings(settings, path);
		}
		if (theGame->RedefinesKeys()) {
			keys.Read(path, "keys");
		}
		else {
			keys.Read(AGC2_CONFIG_FILE, "GLOBAL_KEYS");
		}
		Execute();
		doing_game_over_messages = false;
		SaveHighscores();
		delete theGame;
		theGame = 0;
	}
DEBUG("main.log")
	return MAIN_MENU;
}


void GameDriver::SelectGame(int game) {
	selectedGame = game;
}


void GameDriver::HandleEvent(Widget &obj, int msg, int arg1, int arg2) {
	GameScreen::HandleEvent(obj, msg, arg1, arg2);

	if (msg == MSG_SCREENSHOT) {
		BITMAP *canvas = GetDriver()->GetCanvas();
		take_screenshot(ss, canvas);
	}
}
