// Compile in MinGW with the following command:
// g++ -o template.dll template.cpp -W -Wall -shared -Wl,--enable-auto-import -Wl,--enable-runtime-pseudo-reloc -s -lalleg
// and in Linux with
// g++ -o template.dll template.cpp -W -Wall -shared -s -fPIC `allegro-config --libs`
// ...or something like that...

#include "IGame.h"


class MyGame : public IGame {
	public:
		MyGame() : IGame() {
		}

		~MyGame() {
		}

		void SetGamePath(const char *path) {
			IGame::SetGamePath(path);

			// Put your code that depends on the game path here
			// if it needs to be called when the game object is
			// created (although ideally it should go in the
			// Init() method. The member 'game_path' will hold the
			// full path to the directory where the game is located
			// including a trailing backslash.
			// E.g: 'this->game_path == "c:/amgc/games/template/'
		}

		char *GetName() {
			return "My game";
		}

		char *GetAuthor() {
			return "John Doe";
		}

		char *GetDescription() {
			return "This is my game.";
		}

		char *GetVersion() {
			return "1.0";
		}

		char *GetIconPath() {
			return "icon.bmp";
		}

		bool Init() {
			if (!IGame::Init()) {
				return false;
			}

			// custom initialization goes here
			// ...

			return true;
		}

		void Deinit() {
			// custom deinitialization goes here
			// ...

			// no more Allegro calls after this line!
			IGame::Deinit();
		}

		void Draw(BITMAP *canvas) {
			// Do all the drawing here. Draw only to the canvas bitmap.
			// ...
			clear(canvas);
			textprintf_centre_ex(canvas, font, canvas->w/2, canvas->h/2, makecol(255,255,255), -1, "Hello, world!");
		}

		int Logic(int[8], int[4], float) {
			// Do all input processing and game logic here. Refer to the
			// comments in IGame.h for details on the format of the input
			// parameters and the requirements for the output.
			// The first parameter holds the status of 8 keys, the second
			// the status of the mouse (x, y, wheel, buttons) and the third
			// the time difference in milliseconds since the last Logic
			// update (note: In this example the parameters are unnamed
			// only to avoid compile warnings. In your implementation
			// you should give them proper names.)
			// ...
			return 0;
		}

		int Score() {
			// Return -1 if this game doesn't have points, otherwise the last
			// valid score where more points is better.
			return -1;
		}

		bool UseSystemMouse() {
			// Return false if the game draws its own cursor or doesn't use
			// the mouse at all.
			return true;
		}

		void Pause() {
		}

		void Resume() {
		}

		// Should return true if keys can be redefined (otherwise
		// global keys are used)
		bool RedefinesKeys() {
			return false;
		}

		// Should return names of redefinable keys or NULL if
		// key can't be redefined. i = [0,7]
		const char *KeyName(int i) {
			switch (i) {
				default: return 0;
			};
		}

		// Should return to a NULL terminated array of GameSettings structures.
		// For example you could define the array like this:
		//
		//	GameSettings my_settings[] = {
		//		{ "name1", "option 1", "first|second|third", 1 },
		//		{ "name2", "option 2", "first|second|third", 0 },
		//		{ "name3", "option 3", "first|second|third", 2 },
		//		{ 0, 0, 0, 0 }
		//	};
		//
		// and then return my_settings in this function.
		GameSettings* GetSettings() {
			return 0;
		}
};



extern "C" DLLEXPORT IGame* GetPlugin() {
	return new MyGame;
}
