// Compile in MinGW with the following command:
// g++ -o quad.dll quad.cpp -shared -Wl,--enable-auto-import -Wl,--enable-runtime-pseudo-reloc -s -lalleg
// ...or something like that...

#include "IGame.h"


class Quad : public IGame {
	protected:
		int score;
		int highscore;
		bool mouseDown;
		FONT *qfont;

		int tileSize;
		int nTiles_x, nTiles_y;
		int active[32][32];
		int number[32][32];
		int cx, cy;
		bool finnished;
		int text, cf, cb, c1, c2, cs, cs1, cs2;

		int s_w, s_h;

		void draw_3d_frame(BITMAP *bmp, int x1, int y1, int x2, int y2, int c1, int c2, int c3) {
			if (c1 >= 0) rectfill(bmp, x1, y1, x2, y2, c1);

			int c4 = makecol(getr(c2) + (getr(c3) - getr(c2))/3, getg(c2) + (getg(c3) - getg(c2))/3, getb(c2) + (getb(c3) - getb(c2))/3);
			int c5 = makecol(getr(c3) - (getr(c3) - getr(c2))/3, getg(c3) - (getg(c3) - getg(c2))/3, getb(c3) - (getb(c3) - getb(c2))/3);

			vline(bmp, x1, y1, y2, c4);
			hline(bmp, x1, y1, x2, c4);
			vline(bmp, x1+1, y1+1, y2-1, c2);
			hline(bmp, x1+1, y1+1, x2-1, c2);
			vline(bmp, x2-1, y1+1, y2, c5);
			hline(bmp, x1+1, y2-1, x2, c5);
			hline(bmp, x1, y2, x2, c3);
			vline(bmp, x2, y1, y2, c3);
		}

		bool CanDo(int mx, int my, bool left, bool right, bool up, bool down) {
			int moves = 0;
			bool ret = true;

			if (mx>=0 && mx<nTiles_x && my>=0 && my<nTiles_y)
				moves = number[mx][my];
			else
				return false;

			if (left || right || up || down) {
				for (int x=0; x<moves; x++) {
					if (active[mx][my] && mx>=0 && mx<nTiles_x && my>=0 && my<nTiles_y) {
						if (left)	mx--;
						else if (right)	mx++;
						if (up)		my--;
						else if (down)	my++;
					}
					else {
						ret = false;
						break;
					}
				}
			}
			else
				ret = false;

			return ret;
		}

		void Move(int mx, int my, bool left, bool right, bool up, bool down) {
			if (CanDo(mx, my, left, right, up, down)) {
				int moves = number[mx][my];
				score += moves*moves;
				if (score > highscore) {
					highscore = score;
				}
				for (int i=0; i<moves; i++) {
					if (left)		cx--;
					else if (right)	cx++;
					if (up)		cy--;
					else if (down)	cy++;
					active[cx][cy] = false;
				}
				CheckForEndGame();
			}
		}

		int MovesLeft(int mx, int my) {
			int ret = 0;
			if (CanDo(mx-1, my-1, 1, 0, 1, 0))		ret++;
			if (CanDo(mx-1, my,   1, 0, 0, 0))		ret++;
			if (CanDo(mx-1, my+1, 1, 0, 0, 1))		ret++;
			if (CanDo(mx,   my-1, 0, 0, 1, 0))		ret++;
			if (CanDo(mx,   my+1, 0, 0, 0, 1))		ret++;
			if (CanDo(mx+1, my-1, 0, 1, 1, 0))		ret++;
			if (CanDo(mx+1, my,   0, 1, 0, 0))		ret++;
			if (CanDo(mx+1, my+1, 0, 1, 0, 1))		ret++;
			return ret;
		}

		void CheckForEndGame() {
			if (MovesLeft(cx, cy) == 0) {
				finnished = true;
			}
		}

		void Reset() {
			double rnd = 1.035742;
			int cursor;
			for (int y=0; y<nTiles_y; y++) {
				for (int x=0; x<nTiles_x; x++) {
					rnd *= 1.00056462;
					srand((int)(time(0)*rnd));
					number[x][y] = (rand()%9)+1;
					active[x][y] = true;
				}
			}
			cursor = rand() % (nTiles_x*nTiles_y);
			cx = ldiv(cursor, nTiles_x).quot;
			cy = ldiv(cursor, nTiles_y).rem;
			active[cx][cy] = false;
			score = 0;
			finnished = false;
		}

		void Click(int mouse_x, int mouse_y) {
			int mx, my;
			bool left = false;
			bool right = false;
			bool up = false;
			bool down = false;

			int w = tileSize*nTiles_x + 4;
			//int h = tileSize*nTiles_y + 4;
			int offX = (s_w - w)/2 + 2;
			int offY = offX;
			mx = (mouse_x - offX)/tileSize;
			my = (mouse_y - offY)/tileSize;

			if		(mx-cx == 1  && my-cy > -2 && my-cy < 2)	right = true;
			else if (mx-cx == -1 && my-cy > -2 && my-cy < 2)	left  = true;
			if 		(my-cy == 1  && mx-cx > -2 && mx-cx < 2)	down  = true;
			else if (my-cy == -1 && mx-cx > -2 && mx-cx < 2)	up    = true;

			Move(mx,my,left,right,up,down);
		}

		void NewGame() {
			tileSize = 20;
			nTiles_x = (s_w-8)/tileSize;
			if (nTiles_x > 32) {
				nTiles_x = 32;
				tileSize = (s_w-8)/nTiles_x;
			}
			nTiles_y = (s_h-24)/tileSize;
			if (nTiles_y > 32) {
				nTiles_y = 32;
				tileSize = (s_h-24)/nTiles_y;
				nTiles_x = (s_w-8)/tileSize;
			}
			Reset();
		}

	public:
		Quad() : IGame() {
		}

		~Quad() {
		}

		char *GetName() {
			return "Quad";
		}

		char *GetAuthor() {
			return "Miran Amon";
		}

		char *GetDescription() {
			return "Use the mouse to select where you want to move. Click the tile next to the highlighted square to move in its direction by as many tiles as the number on it. Collect as many points as you can before running out of places to move.";
		}

		char *GetVersion() {
			return "1.32";
		}

		char *GetIconPath() {
			return "quad.bmp";
		}

		bool Init() {
			if (!IGame::Init()) {
				return false;
			}

			// custom initialization goes here
			this->s_w = SCREEN_W;
			this->s_h = SCREEN_H;

			score = 0;
			highscore = 0;
			mouseDown = false;

			RGB rtext = { 16, 16, 16, 0 };
			RGB rface = { 53, 53, 53, 0 };
			RGB rback = { 48, 48, 48, 0 };
			RGB rsh1 = { 59, 59, 59, 0 };
			RGB rsh2 = { 32, 32, 32, 0 };
			RGB rcur = { 58, 56, 24, 0 };
			RGB rcs1 = { 63, 60, 32, 0 };
			RGB rcs2 = { 48, 46, 16, 0 };

			set_color(16, &rtext);
			set_color(17, &rface);
			set_color(18, &rback);
			set_color(19, &rsh1);
			set_color(20, &rsh2);
			set_color(21, &rcur);
			set_color(22, &rcs1);
			set_color(23, &rcs2);

			text = makecol(64, 64, 64);
			cf = makecol(212, 212, 212);
			cb = makecol(192, 192, 192);
			c1 = makecol(236, 236, 236);
			c2 = makecol(128, 128, 128);
			cs = makecol(232, 224, 96);
			cs1 = makecol(255, 240, 128);
			cs2 = makecol(192, 184, 64);

			NewGame();

			//qfont = (FONT *)shared[FONT01].dat;
			//qfont = font;
			qfont = load_font("games/8x8.pcx", 0, 0);
			if (!qfont) {
				qfont = font;
			}

			return true;
		}

		void Deinit() {
			// custom deinitialization goes here
			// ...
			if (qfont != font) {
				destroy_font(qfont);
				qfont = font;
			}

			// no more Allegro calls after this line!
			IGame::Deinit();
		}

		void Draw(BITMAP *canvas) {
			// Do all the drawing here. Draw only to the canvas bitmap.
			char num[2];
			int ax, ay, offX, offY, x, y;

			int w = tileSize*nTiles_x + 4;
			int h = tileSize*nTiles_y + 4;
			offX = (s_w - w)/2;
			offY = offX;

			clear_to_color(canvas, cf);
			rectfill(canvas, offX, offY, offX+w-1, offY+h-1, cb);
			rect(canvas, offX, offY, offX+w-1, offY+h-1, text);
			for (ay=0, y=offY+2; ay<nTiles_y; ay++, y+=tileSize) {
				x=offX+2;
				for (ax=0; ax<nTiles_x; ax++, x+=tileSize) {
					if (active[ax][ay]) {
						draw_3d_frame(canvas, x, y, x+tileSize-1, y+tileSize-1, cf, c1, c2);
						usprintf(num, "%d", number[ax][ay]);
						textout_ex(canvas, qfont, num, x+(tileSize/2)-3, (y)+((tileSize-8)/2)+1, c1, -1);
						textout_ex(canvas, qfont, num, x+(tileSize/2)-4, (y)+((tileSize-8)/2), text, -1);
					}
					else {
						rectfill(canvas, x, y, x+tileSize-1, y+tileSize-1, cb);
					}
				}
			}


			x = offX + 2 + cx*tileSize;
			y = offY + 2 + cy*tileSize;

			draw_3d_frame(canvas, x,   y,   x+tileSize-1, y+tileSize-1, cs, cs1, cs2);
			draw_3d_frame(canvas, x+3, y+3, x+tileSize-4, y+tileSize-4, cs, cs2, cs1);
			if (tileSize >= 18) draw_3d_frame(canvas, x+6, y+6, x+tileSize-7, y+tileSize-7, cs, cs1, cs2);
			if (tileSize >= 24) draw_3d_frame(canvas, x+9, y+9, x+tileSize-10, y+tileSize-10, cs, c2, cs1);

			x = 60;
			y = s_h - 20;
			int dy = 16;
			rectfill(canvas, x, y, x+80, y+dy, cb);
			rect(canvas, x, y, x+80, y+dy, text);
			textout_right_ex(canvas, qfont, "score", x-8, y+4, text, -1);
			textprintf_centre_ex(canvas, qfont, x+40, y+4, text, -1, "%d", score);

			x += 200;
			rectfill(canvas, x, y, x+80, y+dy, cb);
			rect(canvas, x, y, x+80, y+dy, text);
			textout_right_ex(canvas, qfont, "moves left", x-8, y+4, text, -1);
			textprintf_centre_ex(canvas, qfont, x+40, y+4, text, -1, "%d", MovesLeft(cx, cy));

		}

		int Logic(int[8], int mouse[4], float) {
			// Do all input processing and game logic here. Refer to the
			// comments in IGame.h for details on the format of the input
			// parameters and the requirements for the output.
			if (finnished && !mouse[2]) {
				//do_game_over();
				return 1;
				NewGame();
			}
			else {
				bool click = false;
				if (mouse[2]) {
					if (!mouseDown) {
						click = true;
						mouseDown = true;
					}
				}
				else {
					mouseDown = false;
				}

				if (click) {
					Click(mouse[0], mouse[1]);
				}
			}

			return 0;
		}

		int Score() {
			// Return -1 if this game doesn't have points, otherwise the last
			// valid score where more points is better.
			return highscore;
		}

		bool UseSystemMouse() {
			// Return false if the game draws its own cursor or doesn't use
			// the mouse at all.
			return true;
		}

		void Pause() {
		}

		void Resume() {
		}
};


extern "C" DLLEXPORT IGame* GetPlugin() {
	return new Quad;
}
