// Compile in MinGW with the following command:
// g++ -o kickups.dll kickups.cpp -shared -Wl,--enable-auto-import -Wl,--enable-runtime-pseudo-reloc -s -lalleg


#include "debug.h"
#include "IGame.h"


class Kickups : public IGame {
	private:
		int score;
		int highscore;
		float r;
		float x;
		float y;
		float vx;
		float vy;
		bool mouseDown;
		DATAFILE *data;
		int *grass[2];
		int angle;
		int s_w;
		int s_h;

		BITMAP *buffer;
		int b_w;
		int b_h;

	public:
		Kickups() : IGame() {
DEBUG_INIT("kickups.log");
			grass[0] = 0;
			grass[1] = 0;
			data = 0;
			buffer = 0;
		}

		~Kickups() {
		}

		char *GetName() {
			return "Kickups";
		}

		char *GetAuthor() {
			return "Miran Amon";
		}

		char *GetDescription() {
			return "A simple football practice game to challenge your mouse skills. Click the ball to kick it and try to keep it in the air as long as possible. Game is over when the ball falls to the ground.";
		}

		char *GetVersion() {
			return "1.02";
		}

		char *GetIconPath() {
			return "ball.bmp";
		}

		// ignore the wnd, bpp, w and h parameters, they're of no good use to you!
		bool Init() {
DEBUG("kickups.log")
			if (!IGame::Init()) {
				return false;
			}

			score = 0;
			highscore = 0;

DEBUG("kickups.log")
			// custom initialization goes here
			b_w = 320;
			b_h = 240;
			buffer = create_bitmap(b_w, b_h);
DEBUG("kickups.log")

			r = 15.0f;
			x = (float)b_w/2;
			y = (float)(5*b_h/6);
			vx = 0.0f;
			vy = 0.0f;
			mouseDown = false;
			this->s_w = SCREEN_W;
			this->s_h = SCREEN_H;

DEBUG("kickups.log")
			char buf[1024];
			get_executable_name(buf, 1024);
			replace_filename(buf, buf, "games/kickups/kickups.dat", 1024);
			data = load_datafile(buf);
			if (!data) {
DEBUG("kickups.log")
				return false;
			}

DEBUG("kickups.log")
			int w  = b_w;
			grass[0] = new int[w];
			grass[1] = new int[w];
			for (int i=0; i<w; i++) {
				grass[0][i] = 0;
				grass[1][i] = 0;
			}
			for (int i=0; i<w; i++) {
				if (rand()%100<40) {
					grass[1][i] = 1;
					int d = rand()%4;
					if (d<3) {
						int j = i+d-1;
						if (j >= w) {
							j -= w;
						}
						else if (j < 0) {
							j += w;
						}
						grass[0][j] = 1;
					}
				}
			}

DEBUG("kickups.log")
			angle = 0;
			return true;
		}

		void Deinit() {
			// custom deinitialization goes here
DEBUG("kickups.log")
			if (data) {
				unload_datafile(data);
				data = 0;
			}
DEBUG("kickups.log")
			if (grass[0]) {
				delete [] grass[0];
				grass[0] = 0;
			}
DEBUG("kickups.log")
			if (grass[1]) {
				delete [] grass[1];
				grass[1] = 0;
			}
DEBUG("kickups.log")
			if (buffer) {
				destroy_bitmap(buffer);
				buffer = 0;
			}
DEBUG("kickups.log")

			// no more Allegro calls after this line!
			IGame::Deinit();
DEBUG("kickups.log")
		}

		void Draw(BITMAP *canvas) {
			// Do all the drawing here. Draw only to the canvas bitmap.
			float r1, r2, g1, g2, b1, b2;
			float dr, dg, db;
			int h, i, x2;

			// draw sky
			h = 5*buffer->h/6 + (int)r;
			x2 = buffer->w-1;
			r1 = 100.0f;
			r2 = 196.0f;
			g1 = 160.0f;
			g2 = 240.0f;
			b1 = 255.0f;
			b2 = 240.0f;
			dr = (r2 - r1)/(float)h;
			dg = (g2 - g1)/(float)h;
			db = (b2 - b1)/(float)h;
			for (i=0; i<h; i++) {
				hline(buffer, 0, i, x2, makecol((int)(r1+=dr), (int)(g1+=dg), (int)(b1+=db)));
			}

			// draw ball
			draw_sprite(buffer, (BITMAP *)data[0].dat, (int)(x-r), (int)(y-r));
			//rotate_sprite(buffer, (BITMAP *)data[0].dat, (int)(x-r), (int)(y-r), itofix(angle));

			// draw grass
			int j;
			int y = i - 2;
			int green = makecol(0,128,0);
			for (j=0; j<x2; j++) {
				if (grass[0][j] == 1) putpixel(buffer, j, y, green);
				if (grass[1][j] == 1) putpixel(buffer, j, y+1, green);
			}
			h = buffer->h - h;
			g1 = 128.0f;
			g2 = 192.0f;
			dg = (g2 - g1)/(float)h;
			h = buffer->h;
			for (; i<h; i++) {
				hline(buffer, 0, i, x2, makecol(0, (int)(g1+=dg), 0));
			}

			FONT *font = (FONT *)data[1].dat;
			int tcol = makecol(255,240,96);
			textprintf_ex(buffer, font, 0, 1, tcol, -1, "score: %d", (int)highscore);

			stretch_blit(buffer, canvas, 0, 0, b_w, b_h, 0, 0, s_w, s_h);
		}

		int Logic(int[8], int mouse[4], float) {
			int ret = 0;

			mouse[0] *= b_w;
			mouse[0] /= s_w;
			mouse[1] *= b_w;
			mouse[1] /= s_w;

			bool click = false;
			if (mouse[2]) {
				if (!mouseDown) {
					click = true;
					mouseDown = true;
				}
			}
			else {
				mouseDown = false;
			}

			if (click) {
				float dx = x - mouse[0];
				float dy = y - mouse[1];

				if (dx*dx + dy*dy <= r*r) {
					vy = 8.0f;
					vx = dx/3.0f;
					++score;
					if (score > highscore) {
						highscore = score;
					}
				}
			}

			vx *= 0.985f;
			x += vx;
			vx = (x < r || x > b_w-r) ? (-vx) : (vx);
			x = MID(r, x, b_w-r);

			angle += (int)(3.0*vx);
			if (angle >= 256) {
				angle -= 256;
			}
			else if (angle < 0) {
				angle += 256;
			}

			if (vy >= 0.3f) {
				vy *= 0.92;
			}
			else if (vy <= -0.3f) {
				vy /= 0.96f;
			}
			else if (vy > 0.0f) {
				vy = -1.0f;
			}
			else if (vy < 0.0f) {
				vy = 1.0f;
			}
			else {
				vy = 0.0f;
			}
			y -= vy;
			float fl = (float)(5*b_h/6);
			if (y > fl) {
				y = fl;
				vx *= 0.92f;
				if (vy >= -1.2f) {
					vy = 0.0f;
				}
				else {
					vy *= -0.55f;
					if (score > highscore) {
						highscore = score;
					}
					ret = 1;
					score = 0;
				}
			}

			return ret;
		}

		int Score() {
			// Return -1 if this game doesn't have points, otherwise the last
			// valid score where more points is better.
			return highscore;
		}

		bool UseSystemMouse() {
			// Return false if the game draws its own cursor or doesn't use
			// the mouse at all.
			return true;
		}

		void Pause() {
		}

		void Resume() {
		}
};



extern "C" DLLEXPORT IGame* GetPlugin() {
	return new Kickups;
}
