/*

Copyright (c) 2004      Arthur Huillet


Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#include "all_inc.h"

static char must_handle_zignals=0;





/********************* raise a signal to an object*/


int raise_zignal(zignals_t *target, short int zignal_to_raise, int zparm, int zbmask)
{

/*log_msg(3,  "raise_zignal %x %i i %i", target, zignal_to_raise, zparm, zbmask);*/

/*zignal_to_raise est sous forme d'une num DONC il faut faire le dcalage*/
if(zignal_to_raise > 15)
        return -1;

short int zignal_to_raise_bmask = 1 << zignal_to_raise;

/*log_msg(3,  "Signal mask : %i", zignal_to_raise_bmask);*/
target->mask |= zignal_to_raise_bmask;

target->parm[zignal_to_raise][0] = zparm;
target->parm[zignal_to_raise][1] = zbmask;

if(must_handle_zignals)
        {
        must_handle_zignals=0;
        call_zignal_handlers();
        }
else must_handle_zignals=1;

return 0;
}
 
 
 /******************remove signal************************************/
 
int remove_zignal(zignals_t *target, short int zignal_to_rmv)
{
if(zignal_to_rmv > 15)
        return -1;
short int zignal_to_rmv_bmask = 1 << zignal_to_rmv;

target->mask &= ~zignal_to_rmv_bmask;
target->parm[zignal_to_rmv][0]=0;
target->parm[zignal_to_rmv][1]=0;
return 0;
}


/************call handlers*/
void call_zignal_handlers() 
{
int i;
for(i=0; i < obj_db.nombre_perso; i++)
        {
        liveplayer * target = &obj_db.perso[i];
        if(target->zignals.mask)
                handle_player_zignals(target);
        }
for(i=0; i < obj_db.nombre_enemies; i++)
        {
        liveplayer * target = &obj_db.enemies[i];
        if(target->zignals.mask)
                handle_player_zignals(target);
        }
for(i=0; i < obj_db.nombre_lwalls; i++)
        {
        if(obj_db.lwalls[i].zignals.mask)
                handle_lwall_zignals(i);
        }
}

/************************/

int handle_player_zignals(liveplayer * pltarget)
{
zignals_t *target = &(pltarget->zignals);

if(target->mask & (1 << ZIGNAL_COLLISION_N))
        {
        /*printf("Collision nord\n");*/
        }
if(target->mask & (1 << ZIGNAL_COLLISION_S))
        {
        /*unit_toggle_forbid(playernb, FORBID, NO_DOWN);
        obj_db.perso[playernb].ref_pform= (- (target->parm[ZIGNAL_COLLISION_S][0]) -1);*/
        }
if(target->mask & (1 << ZIGNAL_COLLISION_E))
        {
        /*rintf("Collision est\n");*/
        }
if(target->mask & (1 << ZIGNAL_COLLISION_W))
        {
        /*printf("Collision ouest\n");*/
        }
if(target->mask & (1 << ZIGNAL_PLAYER_INCOMING))
        {
        if(pltarget->effectors.armed & PLEFFECTOR_MOVE_ENNEMY)
                {
                pltarget->effectors.is_active |= PLEFFECTOR_MOVE_ENNEMY;
                pltarget->effectors.armed &= ~PLEFFECTOR_MOVE_ENNEMY;
                }
        switch(target->parm[ZIGNAL_PLAYER_INCOMING][1])
                {
                case 0 : /*this is a player*/
                        pltarget->target = TARGET_PLAYER(target->parm[ZIGNAL_PLAYER_INCOMING][0]); break;
                case 1 : /*this is an enemy*/
                        pltarget->target = TARGET_ENEMY(target->parm[ZIGNAL_PLAYER_INCOMING][0]); break;
                }
        log_msg(3, "Player targets %i", pltarget->target);
        }
        
if(target->mask & (1 << ZIGNAL_PLAYER_GETTINGAWAY))
        {
        if(pltarget->effectors.is_active & PLEFFECTOR_MOVE_ENNEMY)
                {
                pltarget->effectors.is_active &= ~PLEFFECTOR_MOVE_ENNEMY;
                pltarget->effectors.armed |= PLEFFECTOR_MOVE_ENNEMY;
                }
        switch(target->parm[ZIGNAL_PLAYER_GETTINGAWAY][1])
                {
                case 0 : /*this is a player*/
                        if(pltarget->target == TARGET_PLAYER(target->parm[ZIGNAL_PLAYER_INCOMING][0]))
                                pltarget->target = 0; break;
                case 1 : /*this is an enemy*/
                        if(pltarget->target == TARGET_ENEMY(target->parm[ZIGNAL_PLAYER_INCOMING][0]))
                                pltarget->target = 0; break;
                }
        log_msg(3, "Player targets %i", pltarget->target);
        }
        
if(target->mask & (1 << ZIGNAL_GOT_HURT))
        {
        if(!(pltarget->state & ZL_PLAYER_INVINCIBLE))
                {
                pltarget->state |= ZL_PLAYER_INVINCIBLE;
                pltarget->trigger_flagmask = -ZL_PLAYER_INVINCIBLE;
                log_msg(3,"player got hurt, setting alarm");
                add_scheduler_fnct(alarm_zignal, PLEFFECTOR_TRIGGER_FLAG, &pltarget->zignals, 150);
                }
        }
        
        
if(target->mask & (1 << ZIGNAL_ALARM))
        {
                if(target->parm[ZIGNAL_ALARM][0] == PLEFFECTOR_TRIGGER_FLAG)
                        {
                        log_msg(3, "Received alarm, triggering flags..");
                        if(pltarget->trigger_flagmask > 0)
                                pltarget->state |= pltarget->trigger_flagmask;
                        if(pltarget->trigger_flagmask < 0)
                                pltarget->state &= ~(-pltarget->trigger_flagmask);
                        pltarget->trigger_flagmask = 0;
                        }
        }
        
target->mask=0;
return 0;
}

/*************************/       

int handle_lwall_zignals(int lwlnb)
{
livewall *target = &obj_db.lwalls[lwlnb];
/*les signaux sont traits un par un, le concept auto rarm dans un tableau aurait fonctionn
pour les pointeurs de fonctions (donc peut tre pour les acteurs,  voir plus tard) 
mais pas ici
le rarmement doit tre dcid par le type d'objet (template) ou directement dans le code
hardcod dans un premier temps jusqu' l'implmentation des templates*/

if(target->zignals.mask & (1 << ZIGNAL_COLLISION_N))
        {
        /*printf("Collision nord\n");*/
        if(target->effectors.armed & LWLEFFECTOR_TRIGGER_FLAG)
                {
                if(target->trigger_flagmask > 0)
                        target->parms |= target->trigger_flagmask;
                else 
                        target->parms &= ~(-target->trigger_flagmask);
                /*une fois activ, s'auto-dsarme*/
                target->effectors.armed &= ~LWLEFFECTOR_TRIGGER_FLAG;
                }
        }
if(target->zignals.mask & (1 << ZIGNAL_COLLISION_S))
        {
        if(target->effectors.armed & LWLEFFECTOR_TRIGGER_FLAG)
                {
                if(target->trigger_flagmask > 0)
                        target->parms |= target->trigger_flagmask;
                else 
                        target->parms &= ~(-target->trigger_flagmask);
                /*une fois activ, s'auto-dsarme*/
                target->effectors.armed &= ~LWLEFFECTOR_TRIGGER_FLAG;
                }
        }
if(target->zignals.mask & (1 << ZIGNAL_COLLISION_E))
        {
        }
if(target->zignals.mask & (1 << ZIGNAL_COLLISION_W))
        {
        }
if(target->zignals.mask & (1 << ZIGNAL_LWLMOVE_BOUND))
        {
                if(target->template == ZL_TEMPLATE_ELEVATOR)
                        {
                        target->parms |= LWL_NOMOVE; /*on stoppe le mvt*/
                        target->trigger_flagmask = - LWL_NOMOVE;
                        add_scheduler_fnct(alarm_zignal, LWLEFFECTOR_TRIGGER_FLAG, &target->zignals, 200);
                        }
        }

if(target->zignals.mask & (1 << ZIGNAL_ALARM))
        {
                if(target->zignals.parm[ZIGNAL_ALARM][0] == LWLEFFECTOR_TRIGGER_FLAG)
                        {
                        if(target->trigger_flagmask > 0)
                                target->parms |= target->trigger_flagmask;
                        else 
                                target->parms &= ~(-target->trigger_flagmask);
                        }
                if(target->zignals.parm[ZIGNAL_ALARM][0] == LWLEFFECTOR_SZVAR_REAPPEAR)
                        {
                        target->state &= ~INHIBIT_COLLDET;
                        target->parms |=  LWL_SIZE_VAR;
                        }
                                        
        }
target->zignals.mask=0;
return 0;
}

/************************************/
/*int zalarm(zignals_t *, int, int, int) : 
raises an alarm

The alarm works as follows : 
time is the delay before ZIGALARM is raised (cool name heh !)
parm1 is the effector to be called 
parm2 is a parameter for the effector
*/
/**************************************/


void alarm_zignal(int time, int parm, void * target_b)
{
zignals_t * target = (zignals_t *)(target_b);

/*printf("Alarm_zignal timing ... %i\n", time);*/
if(time == 1)
        {
        raise_zignal(target, ZIGNAL_ALARM , parm, 0);
        }
}
        
        
