/*

Copyright (c) 2004      Arthur Huillet


Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    */

#include "all_inc.h"
    

int create_savefile(char * filename)
{
zl_savefile = fopen(filename, "w");
/*setvbuf(zl_savefile, NULL, _IONBF, 0);*/
if(zl_savefile)
        return 0;
else return -1;
}

int load_savefile(char *filename)
{ /*well, it would be a good thing to have no error right here, otherwise we will kill the whole game*/
if(open_lvl_file(filename))
        {
        log_msg(0, "Unable to open specified levelfile %s", filename);
        return -1;
        }
fin_instances(1);
if(register_level_objects())
        return -1;
close_lvl_file(filename);
log_msg(1,"First pass reading of savefile done");
zl_savefile = fopen(filename, "r");
if(! zl_savefile)
        return -1;
return 0;
}

int zl_load_link_binary_data()
{ /*now, find again the sprites*/
for(int i = 0; i < obj_db.nombre_perso; i++)
        {
        liveplayer * target = &obj_db.perso[i];
        if(! (target->spriteset = search_spritesetdb_entry(spriteset_db, target->sprset_key)))
                {
                spriteset_db = add_spritesetdb_entry(spriteset_db, target->sprset_key, PLAYER_SPRSET);
                target->spriteset = search_spritesetdb_entry(spriteset_db, target->sprset_key);
                }
        switch (target->direction)
                {
                case GAUCHE : target->current_sprite = target->spriteset[SPRSET_GOING_LEFT]; break;
                case DROITE : target->current_sprite = target->spriteset[SPRSET_GOING_RIGHT]; break;
                }
        target->spritecycling_parms = 0;
        }
for(int i = 0; i < obj_db.nombre_enemies; i++)
        {
        liveplayer * target = &obj_db.enemies[i];
        if(! (target->spriteset = search_spritesetdb_entry(spriteset_db, target->sprset_key)))
                {
                spriteset_db = add_spritesetdb_entry(spriteset_db, target->sprset_key, PLAYER_SPRSET);
                target->spriteset = search_spritesetdb_entry(spriteset_db, target->sprset_key);
                }
        switch (target->direction)
                {
                case GAUCHE : target->current_sprite = target->spriteset[SPRSET_GOING_LEFT]; break;
                case DROITE : target->current_sprite = target->spriteset[SPRSET_GOING_RIGHT]; break;
                }
        target->spritecycling_parms = 0;
        }
        
render_platforms();
return 0;
}

int close_savefile()
{
fclose(zl_savefile);
return 0;
}

int save_string(char *parameter, char* value)
{
fprintf(zl_savefile, "%s=\"", parameter);

unsigned int i = 0;
for(i = 0; i < strlen(value); i ++)
        if(value[i] == '"')
                fprintf(zl_savefile, "*");
        else fprintf(zl_savefile, "%c", value[i]);
        
fprintf(zl_savefile, "\"");
return 0;
}

int save_int(char *parm, int val)
{
fprintf(zl_savefile, "%s=\"%i\" ", parm, val);
return 0;
}

int save_float(char *parm, float val)
{
fprintf(zl_savefile, "%s=\"%f\" ", parm, val);
return 0;
}

int save_char(char *parm, char val)
{
fprintf(zl_savefile, "%s=\"%c\" ", parm, val);
return 0;
}

int save_point(char *parm, point pt)
{
fprintf(zl_savefile, "%s.x=\"%i\" %s.y=\"%i\" ", parm, pt.x, parm, pt.y);
return 0;
}

int save_speed(char *parm, speed spd)
{
fprintf(zl_savefile, "%s.x=\"%f\" %s.y=\"%f\" ", parm, spd.x, parm, spd.y);
return 0;
}

int save_zignals_t(char *parm, zignals_t zig)
{
int zigrot=0;
        /*short int mask;
        int parm[16][2];*/
fprintf(zl_savefile, "%s.mask=\"%i\" ", parm, zig.mask);
for(zigrot=0; zigrot < 16; zigrot++)
        fprintf(zl_savefile, "%s.parm%i_0=\"%i\" %s.parm%i_1=\"%i\" ", parm, zigrot, zig.parm[zigrot][0], parm, zigrot, zig.parm[zigrot][1]);
return 0;
}

int save_effectors_t(char *parm, effectors_t eft)
{
/*int is_active;
int armed;*/
fprintf(zl_savefile, "%s.is_active=\"%i\" %s.armed=\"%i\" ", parm, eft.is_active, parm, eft.armed);
return 0;
}

int read_string(char * buffer,char * parm, char* target)
{
/*if(buffer && parm)*/
        get_level_string(buffer, parm, "undefined", target);

unsigned int i = 0;
for(i = 0; i < strlen(target); i ++)
        if(target[i] == '*')
                target[i] = '"';

return 0;
}


int read_point(char *buffer,char *parm, point *target)
{
/*fprintf(zl_savefile, "%s.x=\"%i\" %s.y=\"%i\" ", parm, pt.x, parm, pt.y);*/
char temp[150];
char parm_name[150];
memset(temp, 0, 150);
memset(parm_name, 0, 150);
sprintf(parm_name, "%s.x", parm);
target->x = atoi(get_level_string(buffer, parm_name, "0", temp));
sprintf(parm_name, "%s.y", parm);
target->y = atoi(get_level_string(buffer, parm_name, "0", temp));
return 0;
}

int read_float(char *buffer, char *parm, float *target)
{
char temp[150];
*target = atof(get_level_string(buffer, parm, "0.0", temp));
return 0;
}

int read_speed(char *buffer,char *parm, speed *target)
{
char temp[150];
char parm_name[150];
memset(temp, 0, 150);
memset(parm_name, 0, 150);
sprintf(parm_name, "%s.x", parm);
target->x = atof(get_level_string(buffer, parm_name, "0", temp));
sprintf(parm_name, "%s.y", parm);
target->y = atof(get_level_string(buffer, parm_name, "0", temp));
return 0;
}

int read_zignals_t(char *buffer,char *parm, zignals_t *target)
{
char parm_name[150];
char temp[150];
int zigrot;
memset(parm_name, 0, 150);
sprintf(parm_name, "%s.mask", parm);
target->mask = atoi(get_level_string(buffer, parm_name, "0", temp));

for(zigrot=0; zigrot < 16; zigrot++)
        {
        sprintf(parm_name, "%s.parm%i_0", parm, zigrot);
        target->parm[zigrot][0] = atoi(get_level_string(buffer, parm_name, "0", temp));
        sprintf(parm_name, "%s.parm%i_1", parm, zigrot);
        target->parm[zigrot][1] = atoi(get_level_string(buffer, parm_name, "0", temp));
        }
/*
fprintf(zl_savefile, "%s.mask=\"%i\" ", parm, zig.mask);
for(zigrot=0; zigrot < 16; zigrot++)
        fprintf(zl_savefile, "%s.parm%i_0=\"%i\" %s.parm%i_1=\"%i\" ", parm, zigrot, zig.parm[zigrot][0], parm, zigrot, zig.parm[zigrot][1]);
        */


return 0;
}

int read_effectors_t(char *buffer,char *parm, effectors_t *target)
{
char parm_name[150];
char temp[150];
memset(parm_name, 0, 150);
sprintf(parm_name, "%s.is_active", parm);
target->is_active = atoi(get_level_string(buffer, parm_name, "0", temp));
sprintf(parm_name, "%s.armed", parm);
target->armed = atoi(get_level_string(buffer, parm_name, "0", temp));
return 0;
}
/*gnration automatique ?
int save_livewalls
int save_walls
int save_players
int save_klines 
etc.

avec structure similaire : 
une boucle et un pointeur target mis  jour rgulirement*/


#include "sav_autocode.zc"

