#!/bin/bash
##########################################################
#                   sav_autocode.sh                      #
#--------------------------------------------------------#
#      Automatically generates the game saving code      #
#              using the objects.h file.                 #
#--------------------------------------------------------#
#          Copyright (c) 2004 Arthur Huillet             #
#     This file, as a part of Zlog, is released under    #
#                 the MIT licence.                       #
##########################################################


#looking for objects defs
LIGNE_DEBUT_OBJETS=`grep -n '\/\*-=AUTOCODE OBJECT LIST BEGINS HERE=-\*\/' objects.h | sed 's/\:.*//'`
echo Object list begins line $LIGNE_DEBUT_OBJETS of objects.h
TEMP1=`mktemp`
TEMP2=`mktemp`
tail -n +`expr $LIGNE_DEBUT_OBJETS + 1` objects.h > $TEMP1
LIGNE_FIN_OBJETS=`grep -n '\/\*-=AUTOCODE OBJECT LIST ENDS HERE=-\*\/' $TEMP1 | sed 's/\:.*//'`
echo Object list ends line `expr $LIGNE_FIN_OBJETS + $LIGNE_DEBUT_OBJETS` of objects.h
cat $TEMP1 | sed `expr ${LIGNE_FIN_OBJETS} - 1`q > $TEMP2
rm $TEMP1
echo Object list stored at $TEMP2

#looking for object database
LIGNE_DEBUT_OBJDB=`grep -n '\/\*-=OBJ DATABASE BEGINS=-\*\/' $TEMP2 | sed 's/\:.*//'`
LIGNE_DEBUT_OBJDB=`expr $LIGNE_DEBUT_OBJDB + 1`
echo Object database begins line $LIGNE_DEBUT_OBJDB of $TEMP2
OBJ_DB=`mktemp`
tail -n +$LIGNE_DEBUT_OBJDB $TEMP2 > $OBJ_DB

#object database parsing
TEMP1=`mktemp`
cat $OBJ_DB | egrep -v '{|}|int |\[' | sed 's/\*/-/;' > $TEMP1
rm sav_autocode.zc
rm sav_autocode.zh
echo Now parsing 
#cat $TEMP1
#remove { and } for to keep only structure members, 
#remove int to keep only structure pointers 
#remove [ because we do not want weapons or bullets
#sed because the shell doesn't like stars much
i=2

AUTOREAD_TMP=`mktemp`

echo 'int zl_save_game()
{
int objrot=0;' >> sav_autocode.zc

echo 'int zl_load_game()
{
int objrot=0;
int entry_nb=1;' >> $AUTOREAD_TMP

while test "$i" -lt "`cat $TEMP1 | wc -l`"
	do
	LIGNE=`tail +$i $TEMP1 | sed q`
	TYPE=`echo $LIGNE | sed 's/ -.*//'`
	AZE=$TYPE
	if [ $TYPE = "liveplayer" ]; then
	AZE="perso"
	fi
	if [ $TYPE = "wall" ]; then 
	AZE="walls";
	fi
	if [ $TYPE = "livewall" ]; then 
	AZE="lwalls"
	fi
	if [ $TYPE = 'killing_line' ]; then 
	AZE="klines"
	fi
	if [ $TYPE = "portal" ]; then 
	AZE="portals"
	fi
        if [ $TYPE = "enemy" ]; then
        AZE="enemies"
        fi
	echo Writing code for $TYPE
	#code du .h
	echo 'int save_'$TYPE'('$TYPE' *);' >> sav_autocode.zh
	echo 'int read_'$TYPE'('$TYPE' *, int);' >> sav_autocode.zh
	#code du .c
	echo 'for(objrot = 0; objrot < obj_db.nombre_'$AZE'; objrot++)' >> sav_autocode.zc
	echo '        {' >> sav_autocode.zc
	echo '        '$TYPE '* target = &obj_db.'$AZE'[objrot];' >> sav_autocode.zc
	echo '        save_'$TYPE'(target);
	}
	' >> sav_autocode.zc
	echo 'for(objrot = 0; objrot < obj_db.nombre_'$AZE'; objrot++)' >> $AUTOREAD_TMP
	echo '        {' >> $AUTOREAD_TMP
	echo '        '$TYPE'* target = &obj_db.'$AZE'[objrot];' >> $AUTOREAD_TMP
	echo '        read_'$TYPE'(target, entry_nb);
	entry_nb++;
	}
	' >> $AUTOREAD_TMP


	i=`expr $i + 1`
	done

echo 'close_savefile();
log_msg(1, "Game saved successfully");
return 0;
}' >> sav_autocode.zc
echo 'close_savefile();
log_msg(1, "Game loaded successfully");
return 0;
}' >> $AUTOREAD_TMP

# ce point on a tous les for, il faut maintenant lire chaque structure et 
#crer save_xx()
#c'est pas du gteau mais je vais russir.
#plus besoin de obj_db ni de temp1, on relit carrment depuis le dbut
rm $OBJ_DB
rm $TEMP1
TEMP1=`mktemp`
cat $TEMP2 | egrep -v '{|}' > $TEMP1
rm $TEMP2

#cat $TEMP1
#premire boucle qui va faire crer les <liveplayer
i=1
while test "$i" -lt "`cat $TEMP1 | wc -l`"
	do
	LIGNE=`tail +$i $TEMP1 | sed q`
	if [ "$LIGNE" = '/*-=OBJ DATABASE BEGINS=-*/' ]; then
		i=50000
	fi
	#si la ligne dcrit un nouvel objet (/*-=_liveplayer_=-*/)
	SI_OBJET=`echo $LIGNE | egrep '\-\=_.*_\=\-'`
	if [ $SI_OBJET ]; then
		TYPE=`echo $SI_OBJET | sed 's/\/\*\-\=_//; s/_\=\-\*\///;'`
		echo Creating : save_$TYPE'()'
		echo 'int save_'$TYPE'('$TYPE' * target)
{' >> sav_autocode.zc
		echo 'fprintf(zl_savefile, "<'$TYPE' ");' >> sav_autocode.zc 
		echo Creating : read_$TYPE'()'
		echo 'int read_'$TYPE'('$TYPE' * target, int entrynb)
{' >> $AUTOREAD_TMP
		echo '/*int i=0;*/
char *buffer = (char *)calloc(1, 10000);
char temp[1500];
memset(temp, 0, 1500);
	memset(buffer, 0, 10000);
	fgets(buffer, 9999, zl_savefile);

log_msg(3, "Entry %i is %s and we are reading '$TYPE'", entrynb, buffer);' >> $AUTOREAD_TMP	
#		echo 'if( ! strstr(buffer, "'$TYPE'"))
#	{
#	log_msg(0, "Error while reading savegame : was looking for %s, got '$TYPE' at entrynb %i", buffer, entrynb);
#	exit(-1);
#	}' >> $AUTOREAD_TMP
	fi
	#si la ligne indique la fin d'un objet
	SI_FIN=`echo $LIGNE | egrep 'ENDOFSTRUCT'`
	if [ $SI_FIN ]; then
		echo End of function
		echo 'fprintf(zl_savefile, " >\n");' >> sav_autocode.zc
		echo '
return 0;
}
' >> sav_autocode.zc
		echo '
free(buffer);
return 0;
}
' >> $AUTOREAD_TMP
	fi

	if [ ! $SI_OBJET ]; then
		if [ ! $SI_FIN ]; then
			PAS_COMMENTAIRE=`echo $LIGNE | egrep -v '\/\*|\*\/'`
			if [ "${PAS_COMMENTAIRE}" ]; then
				#on vire les qualificatifs
				LIGNE=`echo $LIGNE | sed 's/unsigned //; s/short //'`
				TYPE_VARIABLE=`echo $LIGNE | sed 's/ .*;$//'`
				NOM_VARIABLE=`echo $LIGNE | sed 's/^.* //; s/;//'`

		
				#echo Variable de type $TYPE_VARIABLE, nom $NOM_VARIABLE
				if [ $TYPE_VARIABLE != "char" ]; then
					echo 'save_'$TYPE_VARIABLE'("'$NOM_VARIABLE'", target->'$NOM_VARIABLE');' >> sav_autocode.zc
					if [ $TYPE_VARIABLE != "int" ]; then
						echo 'read_'$TYPE_VARIABLE'(buffer, "'$NOM_VARIABLE'", &(target->'$NOM_VARIABLE'));' >> $AUTOREAD_TMP
					else
						echo 'target->'$NOM_VARIABLE' = atoi(get_level_string(buffer, "'$NOM_VARIABLE'", "0", temp));
memset(temp, 0, strlen(temp));' >> $AUTOREAD_TMP
					fi
				fi
				#on met les char  part  cause des chanes statiques
				if [ $TYPE_VARIABLE = "char" ]; then
					EST_UNE_CHAINE=`echo $NOM_VARIABLE | egrep '\['`
					if [ $EST_UNE_CHAINE ]; then
						VRAI_NOM=`echo $NOM_VARIABLE | sed 's/\[.*\]//'`
						echo 'save_string("'$VRAI_NOM'", target->'$VRAI_NOM');' >> sav_autocode.zc
						echo 'read_string(buffer, "'$VRAI_NOM'", target->'$VRAI_NOM');' >> $AUTOREAD_TMP

					fi
					if [ ! $EST_UNE_CHAINE ]; then
						echo 'save_int("'$NOM_VARIABLE'", target->'$NOM_VARIABLE');' >> sav_autocode.zc
						echo 'target->'$NOM_VARIABLE' = atoi(get_level_string(buffer, "'$NOM_VARIABLE'", "0", temp));
memset(temp, 0, strlen(temp));' >> $AUTOREAD_TMP
					fi
				fi
					
			fi
		fi
	fi


	i=`expr $i + 1`
	done

rm $TEMP1
cat $AUTOREAD_TMP >> sav_autocode.zc
rm $AUTOREAD_TMP
