
/*

Copyright (c) 2003-2005      Arthur Huillet


Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    */

#include "all_inc.h"
#include <math.h>

int make_livewalls()
{
int i,y;
/*move_plvlwl();*/

for(i=0; i < obj_db.nombre_lwalls; i++)
        {

        if(!( obj_db.lwalls[i].parms & LWL_NOMOVE))
                {
                /*we move the livewall and the players on it*/
                if(obj_db.lwalls[i].speed & ZL_DIVIDE_SPD)
                        {
                        if(cyclediv_check(&obj_db.lwalls[i].speed, &obj_db.lwalls[i].idling_for))
                                {
                                move_livewl_with_players(i);
                                }
                        }
                        
                else{
                        for(y=0; y < obj_db.lwalls[i].speed; y++)
                                move_livewl_with_players(i);
                        }
                   
                }
        /*size variation*/
        if(obj_db.lwalls[i].parms & LWL_SIZE_VAR)
                { /*if the size has to be changed*/
                update_livewall_size(i);
                }
            
        /*coord. adjusting*/
        livewall_adj_coord(i);
        handle_lwall_zignals(i);
        }

return 0;
}
  
/**********************************************************/  
void block_pf_move(int counter, int lwlnb, void * parm)
{
livewall * target=&obj_db.lwalls[lwlnb];
parm = (void *) (NULL); /*to avoid the warning*/
if(counter == 1)
    {
    target->state&=~LWL_PAUSE_MVT;
    move_livewl_with_players(lwlnb);
    }

}
    
    
/***************************************************/    
    
int pf_pause_invert(int lwlnb)
{
livewall * target=&obj_db.lwalls[lwlnb];
if(target -> state & LWL_PAUSE_MVT)
        return 1;
add_scheduler_fnct(block_pf_move,lwlnb, NULL, 150);
target->dx=0;
target->dy=0;
target->state|=LWL_PAUSE_MVT;

if(target->parms & LWL_INVERT_CONTACT)
{
        if(target->state & DIRECTION)
            target->state&=~DIRECTION;
        else
            target->state|=DIRECTION;
}

return 0;
}
    
/**************************************************************************************/
int move_livewl_with_players(int lwlnb)
{
livewall *targetlw=&obj_db.lwalls[lwlnb];
int plid, moveplnb=0, pldir;
/*int players_moving_with[obj_db.nombre_perso];*/

float inert_to_set; /*l'inertie qui sera donne aux players*/

if(targetlw->state & LWL_PAUSE_MVT)
    {
    return 0;
    }
    
int players_moving_with[obj_db.nombre_perso + obj_db.nombre_enemies];
for(int a = 0; a < obj_db.nombre_perso + obj_db.nombre_enemies; a ++)
        players_moving_with[a] = 0;
        
/*here, we resolve all the players to move*/
for(plid = 0; plid < obj_db.nombre_perso; plid++)
	{

	if(obj_db.perso[plid].ref_pform - 1 == lwlnb)
		{ /*this player will move with the current livewall*/

		players_moving_with[moveplnb] = plid;
		moveplnb++;		
		}
	}
for(plid = 0; plid < obj_db.nombre_enemies; plid++)
	{

	if(obj_db.enemies[plid].ref_pform - 1 == lwlnb)
		{ /*this enemy will move with the current livewall*/

		players_moving_with[moveplnb]= - plid;
		moveplnb++;		
		}
	}
/*now we calculate the inertia*/
if(targetlw->speed & ZL_DIVIDE_SPD)
	{ /*in case the real speed is inverted*/
	inert_to_set = 1 / ((float)targetlw->speed - ZL_DIVIDE_SPD);
	}
else
	inert_to_set = targetlw->speed;



/*we move the livewall*/
if(targetlw->dx == 1)
	{
    lwl_move_right(lwlnb, 1);
    for(plid = 0; plid < moveplnb; plid++)
    	{
    	liveplayer * target = &obj_db.perso[plid];
    	if ((target->current_spd.x <= 0) || (target->current_spd.x < inert_to_set))
    		{ /*si vitesse nulle ou oppose ou infrieure  vitesse lwl*/
    		target->current_spd.x = inert_to_set;
    		}
    	/*pldir = obj_db.perso[players_moving_with[plid]].direction;
    	pl_move_right(players_moving_with[plid], 1);
    	obj_db.perso[players_moving_with[plid]].direction = pldir;*/
    	
    	}
    }
    	
if(targetlw->dx == -1)
	{
    lwl_move_left(lwlnb, 1);
    for(plid = 0; plid < moveplnb; plid++)
    	{
    	liveplayer * target = &obj_db.perso[plid];
		if ((target->current_spd.x >= 0) || (target->current_spd.x > - inert_to_set))
    		{ /*si vitesse nulle ou oppose ou infrieure  vitesse lwl*/
    		target->current_spd.x = -inert_to_set;
    		}
    	/*pldir = obj_db.perso[players_moving_with[plid]].direction; 
    	pl_move_left(players_moving_with[plid], 1);
    	obj_db.perso[players_moving_with[plid]].direction = pldir;*/
    	
    	}
    }
    
if(targetlw->dy == 1)
	{
    lwl_move_down(lwlnb, 1);
    for(plid = 0; plid < moveplnb; plid++)
    	{
    	/*liveplayer * target = &obj_db.perso[plid];*/
    	pldir = obj_db.perso[players_moving_with[plid]].direction;
    	pl_move_down(&obj_db.perso[players_moving_with[plid]], 1);
    	obj_db.perso[players_moving_with[plid]].direction = pldir;
    	
		}
    }
      
if(targetlw->dy==-1)
	{
    lwl_move_up(lwlnb,1);   
    for(plid = 0; plid < moveplnb; plid++)
    	{
    	/*liveplayer * target = &obj_db.perso[plid];*/
    	pldir = obj_db.perso[players_moving_with[plid]].direction;
    	pl_move_up(&obj_db.perso[players_moving_with[plid]], 1);
    	obj_db.perso[players_moving_with[plid]].direction = pldir;
    	
    	}
    }
    
    
/*then we calculate the next dx/dy*/
if(targetlw->mvt_ysize)
    { /*vertical movement*/
    
    if(!(targetlw->state & DIRECTION))
        { /*if we go to the final refpt*/
        if(targetlw->refpt.y <= (targetlw->base_mvt.y + targetlw->mvt_ysize))
            { /*if the current refpoint is still less than the final refpoint we wanna get to*/
            targetlw->dy=1;
            targetlw->dx=0;
            }
    
        else { /*if we reached that refpoint*/
            targetlw->dy=-1;
            targetlw->dx=0;
            targetlw->state|=DIRECTION;
            raise_zignal(&targetlw->zignals, ZIGNAL_LWLMOVE_BOUND, 0, 0); /*the first zero stands for vertical movement, could be used later*/
            }
        }
    else { /*if we come back from final refpt*/
        if(targetlw->refpt.y > targetlw->base_mvt.y)
            {
            targetlw->dy=-1;
            targetlw->dx=0;
            }
        else { /*if we reach the basemvt point*/
            targetlw->dy=1;
            targetlw->dx=0;
            targetlw->state&=~DIRECTION;
            raise_zignal(&targetlw->zignals, ZIGNAL_LWLMOVE_BOUND, 0, 1);
            }
        }
    }
     
    
if(targetlw->mvt_xsize) { /*if horizontal movement*/
    if(!(targetlw->state & DIRECTION))
        { /*if we go to the final refpt*/
        if(targetlw->refpt.x <= (targetlw->base_mvt.x + targetlw->mvt_xsize))
            { /*if the current refpoint is still less than the final refpoint we wanna get to*/
            targetlw->dx=1;
            targetlw->dy=0;
            }
    
        else { /*if we reached that refpoint*/
            targetlw->dx=-1;
            targetlw->dy=0;
            targetlw->state|=DIRECTION;
            raise_zignal(&targetlw->zignals, ZIGNAL_LWLMOVE_BOUND, 1, 0);
            }
        }
    else { /*if we are coming back from final refpt*/
        if(targetlw->refpt.x > targetlw->base_mvt.x)
            {
            targetlw->dx=-1;
            targetlw->dy=0;
            }
        else { /*if we reach the basemvt point*/
            targetlw->dx=1;
            targetlw->dy=0;
            targetlw->state&=~DIRECTION;
            raise_zignal(&targetlw->zignals, ZIGNAL_LWLMOVE_BOUND, 1, 1);
            }
        }
    }

return 0;
}
/**************************************************************************************/

int update_livewall_size(int lwlnb)
{
        short int xvar=0, yvar=0;
        float real_xvar=0, real_yvar=0;
        livewall * target = &obj_db.lwalls[lwlnb];
        colldet();
        if((! target->sizevarspd.x) && (! target->sizevarspd.y))
                return 0;
        if(target->sizevarspd.x)
        { /*calculate x size variation*/
                real_xvar = target->sizevarspd.x * (target-> max_size.x - target->min_size.x);
                if(!(target->state & LWL_SZVAR_X))
                        real_xvar = -real_xvar;
                xvar = nearbyintf(real_xvar); /*actual variation*/ 
                if(xvar < 0 && abs(xvar) > target->xsize)
                        xvar = - target->xsize;
        }
        if(target->sizevarspd.y)
        { /*see comments above*/
                real_yvar = target->sizevarspd.y * (target-> max_size.y - target->min_size.y);
                if(!(target->state & LWL_SZVAR_X))
                        real_yvar = -real_yvar;
                yvar = nearbyintf(real_yvar);

        }
        
        if( (!(target-> no_xxx & NO_LEFT)) && (!(target->no_xxx & NO_RIGHT)))
        {
                target->xsize += xvar; /*xsize varies*/
                if(! target->xsize)
                        target->size_add_x += 0;
                else
                        {
                        target->size_add_x += real_xvar - xvar; /*decimal variation*/
                        target->refpt.x -= nearbyintf(real_xvar/2);
                        target->add_x -= (real_xvar/2) - nearbyintf(real_xvar/2);
                        }
                colldet();
        }
        if(target->xsize >= target->max_size.x)
        {
                target->state &= ~LWL_SZVAR_X;
                target->xsize = target->max_size.x;
        }
        if(target->xsize <= target->min_size.x)
        {
                target->state |= LWL_SZVAR_X;
                target->xsize = target->min_size.x;
                if(target->min_size.x == 0)
                                { /*we just disappear*/
                                target->state |= INHIBIT_COLLDET;
                                target->parms &= ~LWL_SIZE_VAR;
                                add_scheduler_fnct(alarm_zignal, LWLEFFECTOR_SZVAR_REAPPEAR, &target->zignals, 150);
                                }
        }
       
       if( (!(target ->no_xxx & NO_DOWN)) && (!(target->no_xxx & NO_UP)))
       {
               target->ysize += yvar; /*ysize varies*/
               target->size_add_y += real_yvar - yvar;
               colldet();
       }

        if(target->ysize >= target->max_size.y)
        {
                target->state &= ~LWL_SZVAR_Y;
                target->ysize = target->max_size.y;
        }
        if(target->ysize <= target->min_size.y)
        {
                target->state |= LWL_SZVAR_Y;
                target->ysize = target->min_size.y;
        }
        
        
        /*now compute decimal variation adjustment*/
        if(target->size_add_x >= 0.5)
	{
                target->xsize ++;
                target->size_add_x -= 1;
	}
        if(target->size_add_x <= -0.5)
	{
                target->xsize --;
                target->size_add_x += 1;
	}
	
        if(target->size_add_y >= 0.5)
	{
                target->ysize ++;
                target->size_add_y -= 1;
	}
        if(target->size_add_y <= -0.5)
	{
                target->ysize --;
                target->size_add_y += 1;
	}
        
        /*now center the players (if needed and if any)*/
        if(target->parms & LWL_CENTER_PL && (!(target->state & LWL_SZVAR_X)))
        {
                int i;
                for (i=0; i < obj_db.nombre_perso; i++)
                {
                        if((obj_db.perso[i].ref_pform == lwlnb + 1) && obj_db.perso[i].state & ZL_PLAYER_IDLE)
                        { /*then the player is on the livewall*/
                                center_player(lwlnb, i);
                        }
                }
        }
        
target->state |= LWL_REDRAW;
return 0;
}

/***************************************************/

int livewall_adj_coord(int lwlnb)
{
        livewall * target = &obj_db.lwalls[lwlnb];
        if(target->add_x >= 0.5)
	{
                if ( !(target->no_xxx & NO_RIGHT))
                target->refpt.x++;
                colldet();
                target->add_x-=1;
                return 1;
	}
        if(target->add_x <= -0.5)
	{
                if ( !(target->no_xxx & NO_LEFT))
                target->refpt.x--;
                colldet();
                target->add_x+=1;
                return 1;
	}
	
        if(target->add_y >= 0.5)
	{
                if ( !(target->no_xxx & NO_DOWN))
                lwl_move_down(lwlnb, 1);
                target->add_y-=1;
                return 1;
	}
        if(target->add_y <= -0.5)
	{
                if ( !(target->no_xxx & NO_UP))
                lwl_move_up(lwlnb, 1);
                target->add_y+=1;
                return 1;
	}
return 0;
}

/********************************************************/

int center_player(int lwlnb, int playernb)
{
        liveplayer * target = &obj_db.perso[playernb];
        livewall * ref = &obj_db.lwalls[lwlnb];
        int i;
        
       int target_cx = target->refpt.x - ref->refpt.x + target->xsize / 2;
       
        /*si le player dpasse sur la gauche de plus la moiti de sa largeur*/
        if(target_cx < 0)
        {
                for(i=0; i < - target_cx; i ++)
                {
                        if ( !(target->no_xxx & NO_RIGHT))
                                target->refpt.x++;
                        colldet();
                }
                return 0;
        }
        
        target_cx = (target->refpt.x + target->xsize) - (ref->refpt.x + ref->xsize);
        
        if( target_cx > target->xsize/2)
        {
                        if ( !(target->no_xxx & NO_LEFT))
                                target->refpt.x--;
                        colldet();
        }
        
return 0;
}
