/*

Copyright (c) 2003-2005      Arthur Huillet


Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    */

#include "all_inc.h"


static char * object_options[30];

int open_lvl_file(const char *lvlfile)
{
level_xml_file = fopen(lvlfile,"r");
if(level_xml_file == NULL)
    return -1;
return 0;
}

int close_lvl_file()
{
fclose(level_xml_file);
return 0;
}

int register_level_objects()
{
/*
on rcupre une ligne non vide
on vrifie si elle dfinit un player ou un wall 
on ReturnxxxXml
on cre avec Register, on assigne,
delete temporaire 
et boucle*/

int nbr_pl = 0;
int nbr_wl = 0;
int nbr_lwl = 0;
int nbr_kl = 0;
int nbr_portals = 0;
int nbr_enn = 0;

int done = 0;
char *TempLine;
int GetLineState;

log_msg(3, "parse_register_level() called");

TempLine = (char *)calloc(1, 5000);
GetLineState = get_level_line(TempLine);

while(!done)
        {
        if(strstr(TempLine,"<player") || strstr(TempLine, "<liveplayer"))
                nbr_pl++;
        if(strstr(TempLine,"<wall"))
                nbr_wl++;
        if(strstr(TempLine,"<platform") || strstr(TempLine, "<livewall"))
                nbr_lwl++;  
        if(strstr(TempLine,"<kline") || strstr(TempLine, "<killing_line"))
                nbr_kl++;
        if(strstr(TempLine, "<portal"))
                nbr_portals++;
        if(strstr(TempLine, "<enemy"))
                nbr_enn++;
                
        if(strstr(TempLine, "< "))
                {
                log_msg(0, "\"< \" not allowed in levelfile - please, remove the blanks");
                return -1;
                }
        GetLineState = get_level_line(TempLine);

        if(strstr(TempLine,"EndOfFile")||GetLineState)
                done = 1;
        }
        


obj_db.nombre_perso = nbr_pl;
obj_db.nombre_enemies = nbr_enn;
obj_db.nombre_walls = nbr_wl;
obj_db.nombre_lwalls = nbr_lwl;
obj_db.nombre_klines = nbr_kl;
obj_db.nombre_portals = nbr_portals;

log_msg(1,"%i players in levelfile",nbr_pl);
log_msg(1,"%i enemies in levelfile",nbr_enn);
log_msg(1,"%i walls in levelfile",nbr_wl);
log_msg(1,"%i platforms in levelfile",nbr_lwl);
log_msg(1,"%i klines in levelfile",nbr_kl);
log_msg(1,"%i portals in levelfile",nbr_portals);

free(TempLine);
alloue_objdb();
log_msg(2, "Level objects registered successfully");
return 0;
}

int parse_level_data()
{
int NewPlNb, NewWlNb, NewlWlNb, NewKlNb, NewPortalNb;
liveplayer *PlToRegister;
wall *WlToRegister;
livewall * lWlToRegister;
killing_line * KlToRegister;
portal * PortalToRegister;

int done = 0;
int GetLineState;
char *TempLine;
TempLine = (char *)calloc(1, 5000);
PlToRegister = (liveplayer *)calloc(1, sizeof(liveplayer));
WlToRegister = (wall *)calloc(1, sizeof(wall));
lWlToRegister = (livewall *)calloc(1, sizeof(livewall));
KlToRegister = (killing_line*)calloc(1, sizeof(killing_line));
PortalToRegister = (portal *)calloc(1, sizeof(portal));

rewind(level_xml_file);
GetLineState = get_level_line(TempLine);
while(!done)
    {
    
    
    if(strstr(TempLine,"fileinfo"))
        {
        log_msg(3, "Parsing and displaying fileinfo from line %s", TempLine);
        display_level_info(TempLine);
        }

    if(strstr(TempLine,"<player") || strstr(TempLine, "<liveplayer"))
        {       
        log_msg(3, "Parsing player information");
        NewPlNb = register_new_player(ZL_PLAYER_HUMAN);  /*on enregistre un nouveau player*/
        return_player(TempLine, PlToRegister, ZL_PLAYER_HUMAN); /*on rcupre les infos sur lui*/
        obj_db.perso[NewPlNb] = *PlToRegister;	/*et on copie dans la base de donnes finale*/
        }
        
    if(strstr(TempLine,"<enemy"))
        {       
        log_msg(3, "Parsing enemy information");
        NewPlNb = register_new_player(ZL_PLAYER_ENNEMY);  /*on enregistre un nouveau player*/
        return_player(TempLine, PlToRegister, ZL_PLAYER_ENNEMY); /*on rcupre les infos sur lui*/
        obj_db.enemies[NewPlNb] = *PlToRegister;	/*et on copie dans la base de donnes finale*/
        }
        
    if(strstr(TempLine,"<wall"))
        {
        log_msg(3, "Parsing wall information");
        NewWlNb = register_new_wall(); /*voir au dessus*/
        return_wall(TempLine, WlToRegister);
        obj_db.walls[NewWlNb] = *WlToRegister;
        }
     
    
    if(strstr(TempLine,"<kline") || strstr(TempLine, "<killing_line"))
    	{	
        log_msg(3, "Parsing kline information");
    	NewKlNb = register_new_kl();
    	return_kl(TempLine, KlToRegister);
    	obj_db.klines[NewKlNb] = *KlToRegister;
    	}

    if(strstr(TempLine,"<platform") || strstr(TempLine, "<livewall"))
        {
                log_msg(3, "Parsing platform information");
		NewlWlNb = register_new_lwall();
		return_lwall(TempLine, lWlToRegister);
		obj_db.lwalls[NewlWlNb] = * lWlToRegister;
        }

    
    if(strstr(TempLine, "<portal"))
       {
               log_msg(3, "Parsing portal information");
               NewPortalNb = register_new_portal();
               log_msg(3, "NewPortalNb is %i", NewPortalNb);
               return_portal(TempLine, PortalToRegister);
               obj_db.portals[NewPortalNb] = * PortalToRegister;
       }
   
    GetLineState=get_level_line(TempLine);
    
    if(strstr(TempLine,"EndOfFile")|| GetLineState)
        {
        done=1;
        }
        
        
    }
    
    
free(TempLine);
free(PlToRegister);
free(WlToRegister);
free(lWlToRegister);
free(KlToRegister);
free(PortalToRegister);
return 0;
        
}


/**************************************************************/

int register_new_player(char pltype)
{
int plrot;
liveplayer * target;
int nombre_targets;
switch(pltype) {
        case ZL_PLAYER_HUMAN : target = obj_db.perso; 
        nombre_targets = obj_db.nombre_perso;
        break;
        case ZL_PLAYER_ENNEMY : target = obj_db.enemies;
        nombre_targets = obj_db.nombre_enemies;
        break;
        default : return -1;
        }
        
for(plrot=0; plrot < nombre_targets; plrot++)
    if(target[plrot].used == ZL_PLAYER_UNUSED)
        {
        target[plrot].used = pltype;
        return plrot;
        }
        
log_msg(0, "Erreur d'enregistrement de player - %i joueurs tous utiliss, %i", nombre_targets, plrot);
exit(255);
return -1;

}

/***************************************************/
int register_new_kl()
{
int klrot;
if(obj_db.nombre_klines)
    {
    for(klrot=0; klrot < obj_db.nombre_klines; klrot++)
        if(! (obj_db.klines[klrot].state & EXISTS))
            {
            obj_db.klines[klrot].state |= EXISTS;
            return klrot;
            }
            
    }
    

log_msg(0, "Erreur d'enregistrement de kline");

exit(255);
return -1;
}
/**************************************************/
int register_new_portal()
{

int portalrot;
if(obj_db.nombre_portals)
    {
    for(portalrot=0; portalrot < obj_db.nombre_portals; portalrot++)
        if(! (obj_db.portals[portalrot].state & EXISTS))
            {
            obj_db.portals[portalrot].state |= EXISTS;
            return portalrot;
            }
            
    }
    

log_msg(0, "Erreur d'enregistrement de kline");

exit(255);
return -1;
}
/**************************************************/

int register_new_wall()
{
int wlrot;
if(obj_db.nombre_walls)
    {
    for(wlrot=0; wlrot < obj_db.nombre_walls; wlrot++)
        if(! (obj_db.walls[wlrot].state & EXISTS))
            {
            obj_db.walls[wlrot].state |= EXISTS;
            return wlrot;
            }
            
    }
    

log_msg(0, "Erreur d'enregistrement de mur");

exit(255);
return -1;
}


/************************************************/

int register_new_lwall()
{
int lwlrot;
if(obj_db.nombre_lwalls)
    {
    for(lwlrot=0; lwlrot < obj_db.nombre_lwalls; lwlrot++)
        if(!(obj_db.lwalls[lwlrot].state & EXISTS))
            {
            obj_db.lwalls[lwlrot].state|=EXISTS;
            return lwlrot;
            }
            
    }
    

log_msg(0, "Erreur d'enregistrement de lwall");
exit(255);
return -1;
}



/************************************************/

int display_level_info(char * InfoLine)
{
char *temp2;

temp2=(char *)calloc(1, 100);


log_msg(3, "Tampon temporaire allou, appel de get_level_string()");
get_level_string(InfoLine, "version", "0", temp2);
log_msg(2,"Level file version is %s", temp2);
memset(temp2, 0, strlen(temp2));

get_level_string(InfoLine, "desc", "no description", temp2);
log_msg(2,"Level description : \n%s", temp2);

free(temp2);
return 0;
}
/***********************************************/

int return_player(char *DefineLine, liveplayer * target, char pltype)
{
char *temp2=(char *)calloc(1, 4096);
/*char temp2[4096];*/

memset(target,0,sizeof(liveplayer));
memset(temp2, 0, 4095);
get_level_string(DefineLine, "refpt", "0;0", temp2);
set_refpoint(&target->refpt, temp2);

memset(target->level_def, 0, 149);
strncpy(target->level_def, DefineLine, 149);
                

log_msg(3, "target->level_def %s", target->level_def);
/*valeurs entires lues dans le fichier*/
target->ysize = atoi(get_level_string(DefineLine, "ysize", "60", temp2));
target->xsize = atoi(get_level_string(DefineLine, "xsize", "40", temp2));
target->moving_spd.x = atoi(get_level_string(DefineLine, "x_moving_spd", "3", temp2));
target->moving_spd.y = atoi(get_level_string(DefineLine, "y_moving_spd", "5", temp2));
target->life = atoi(get_level_string(DefineLine, "life", "100", temp2));
target->direction = atoi(get_level_string(DefineLine, "direction", "1", temp2));

/*valeurs relles lues*/
target->inert_max_speed_walk = atof(get_level_string(DefineLine, "max_inert_walk", "0.25", temp2));
target->inert_max_speed_run = atof(get_level_string(DefineLine, "max_inert_run", "0.5", temp2));
target->base_jumping_speed = atof(get_level_string(DefineLine, "base_jumping_speed", "5", temp2));
target->max_jumping_speed = atof(get_level_string(DefineLine, "max_jumping_speed", "10", temp2));

/*valeurs "chaine"*/
strncpy(target->name, get_level_string(DefineLine, "name", "noname", temp2), 25);
if(pltype == ZL_PLAYER_ENNEMY)
        strncpy(target->name, "Enemy", 25);
        
strncpy(target->sprset_key, get_level_string(DefineLine, "spriteset", "stdplayer", temp2), 25);
if(! (target->spriteset = search_spritesetdb_entry(spriteset_db, target->sprset_key)))
        {
        spriteset_db = add_spritesetdb_entry(spriteset_db, target->sprset_key, PLAYER_SPRSET);
        target->spriteset = search_spritesetdb_entry(spriteset_db, target->sprset_key);
        }
switch (target->direction)
        {
        case GAUCHE : target->current_sprite = target->spriteset[SPRSET_GOING_LEFT]; break;
        case DROITE : target->current_sprite = target->spriteset[SPRSET_GOING_RIGHT]; break;
        }


/*valeurs par dfaut*/
target->jtime = 1;
target->no_xxx = 0;
target->used = 1;
target->ref_pform = 0;
target->moving_spd.y =  target->base_jumping_speed;
/*target->target = TARGET_PLAYER(0);      */

if(pltype == ZL_PLAYER_ENNEMY)
        {
        char *optstr;
        target->effectors.armed |= PLEFFECTOR_MOVE_ENNEMY;
        get_level_string(DefineLine, "state", "", temp2);
        optstr = temp2;
        init_object_options(optstr);
        target->parms |= get_object_option("clever", ZL_ENNEMY_CLEVER);
        }
free(temp2);
return 0;
}




/**********************/

int return_wall(char *DefineLine, wall * target)
{

char *temp2=(char *)calloc(1, strlen(DefineLine)+1);

memset(target, 0, sizeof(wall));


get_level_string(DefineLine, "refpt", "0;0", temp2);
set_refpoint(&target->refpt, temp2);

/*valeurs entires*/
target->ysize = atoi(get_level_string(DefineLine, "ysize", "15", temp2));
target->xsize = atoi(get_level_string(DefineLine, "xsize", "100", temp2));

/*valeurs relles*/
target->resist_inert = atof(get_level_string(DefineLine, "resist_inert", "0.005", temp2));

/*state*/
get_level_string(DefineLine, "state", "", temp2);
if(strstr(temp2, "invisible"))
        target->parms |= WL_IS_INVISIBLE;

/*valeurs par dfaut*/
target->state |= EXISTS;

strncpy(target->spriteset, get_level_string(DefineLine, "spriteset", "stdpform", temp2), 25);
free(temp2);
return 0;
}



/*******************************************************/

int return_kl(char *DefineLine, killing_line * target)
{

char *temp2=(char *)calloc(1, strlen(DefineLine) + 1);

memset(target, 0, sizeof(killing_line));

log_msg(3, "Looking for position in %s", DefineLine);
get_level_string(DefineLine, "position", "0;0", temp2);

log_msg(3, "Found : %s", temp2);
set_refpoint(&target->position, temp2);

target->taille = atoi(get_level_string(DefineLine, "taille", "65535", temp2));
target->to_disp = atoi(get_level_string(DefineLine, "display", "0", temp2));
target->state |= EXISTS;


free(temp2);
return 0;
}
/**********************************************************************/
int return_portal(char *DefineLine, portal * target)
{

char *temp2=(char *)calloc(1, strlen(DefineLine) + 1);

memset(target, 0, sizeof(portal));

log_msg(3, "Looking for position in %s", DefineLine);
get_level_string(DefineLine, "position", "0;0", temp2);

log_msg(3, "Found : %s", temp2);
set_refpoint(&target->position, temp2);

target->ysize = atoi(get_level_string(DefineLine, "ysize", "100", temp2));
target->xsize = atoi(get_level_string(DefineLine, "xsize", "50", temp2));
get_level_string(DefineLine, "target_level", "none", temp2);
strncpy(target->target_level, temp2, 149);
target->state |= EXISTS;


free(temp2);
return 0;
}

/********************************************************************/

int return_lwall(char *DefineLine, livewall * target)
{
char *optstr;
char *temp2=(char *)calloc(1, strlen(DefineLine) + 1);

memset(target,0,sizeof(livewall));
memset(temp2, 0, strlen(DefineLine));
log_msg(3, "Looking for refpt in %s", DefineLine);
get_level_string(DefineLine, "refpt", "0;0", temp2);
log_msg(3, "Found : %s", temp2);
set_refpoint(&target->refpt, temp2);

if(!strcmp(get_level_string(DefineLine, "mvt_base", "nothing", temp2), "nothing"))
        {
        log_msg(3, "Platform has no base_mvt defined. Setting it to %i;%i", target->refpt.x, target->refpt.y);
        target->base_mvt = target->refpt;
        }
        else
                set_refpoint(&target->base_mvt, temp2);
        
get_level_string(DefineLine, "template", "0", temp2);
if(! atoi(temp2)) /*no template*/
        target->template = 0;
if(! strcmp(temp2, "elevator"))
        set_template(target, ZL_TEMPLATE_ELEVATOR);
        
/*valeurs entires*/
target->ysize = atoi(get_level_string(DefineLine, "wl_ysize", "15", temp2));
target->xsize = atoi(get_level_string(DefineLine, "wl_xsize", "100", temp2));
target->speed = atoi(get_level_string(DefineLine, "speed", "1", temp2));
target->trigger_flagmask = atoi(get_level_string(DefineLine, "trigger_flags", "0", temp2));
target->max_size.x = atoi(get_level_string(DefineLine, "maxsize_x", "200", temp2));
target->max_size.y = atoi(get_level_string(DefineLine, "maxsize_y", "20", temp2));
target->mvt_ysize = atoi(get_level_string(DefineLine, "mvt_ysize", "300", temp2));
target->mvt_xsize = atoi(get_level_string(DefineLine, "mvt_xsize", "0", temp2));
if(target->mvt_ysize && target->mvt_xsize)
    {
    log_msg(0,"Pform %i;%i mvt_ysize %i mvt_xsize %i",target->refpt.x, target->refpt.y, target->mvt_ysize,\
        target->mvt_xsize);
    log_msg(0,"Platform at %i %i movement has both vertical and horizontal direction defined, keeping only horizontal move.", target->refpt.x, target->refpt.y);
    target->mvt_xsize = 0;
    }

/*valeurs relles*/
target->resist_inert = atof(get_level_string(DefineLine, "resist_inert", "0.005", temp2));
target->sizevarspd.x = atof(get_level_string(DefineLine, "xsizevarspd", "0.007", temp2));
target->sizevarspd.y = atof(get_level_string(DefineLine, "ysizevarspd", "0.007", temp2));
    
/*valeurs par dfaut*/
target->idling_for=0;

target->state |= EXISTS;
target->parms|=LWL_INVERT_CONTACT;
target->min_size.x = target->xsize;
target->min_size.y = target->ysize;

strncpy(target->spriteset, get_level_string(DefineLine, "spriteset", "stdpform", temp2), 25);

/*state*/
get_level_string(DefineLine, "state", "", temp2);
optstr = temp2;
init_object_options(optstr);

target->parms |= get_object_option("invisible", WL_IS_INVISIBLE);
target->parms &=  ~ get_object_option("noinvert", LWL_INVERT_CONTACT);
target->parms |= get_object_option("sizevar", LWL_SIZE_VAR);
target->parms |= get_object_option("centerpl", LWL_CENTER_PL);
target->parms |= get_object_option("nomove", LWL_NOMOVE);        
target->effectors.armed |= get_object_option("triggerflags", LWLEFFECTOR_TRIGGER_FLAG);


free(temp2);
return 0;
}

/************************************************************************/
int set_template(livewall * target, int template)
{
target->template = template;

switch(template) {
        case ZL_TEMPLATE_ELEVATOR :
                return 0;
        default : return -1;
        };
}


/**********************************************************************/
int return_value(char * LineToProcess)
{

char end[10]={0,0,0,0,0,0,0,0,0,0};
int ipos=0;
int vpos=0;


while(!isdigit(LineToProcess[vpos]))
    vpos++;



while(isdigit(LineToProcess[ipos+vpos]))
    {
    end[ipos]=LineToProcess[ipos+vpos];
    ipos++;
    }

return atoi(end);
}

/********************************************************/
char *get_level_string(const char *line, const char *parameter, char *def, char *cible)
{
	char * temp = NULL; /*temporary pointer*/
	unsigned int ipos=0, vpos=0;
	
	temp=strstr(line,parameter); /*search the parameter*/
        memset(cible, 0, strlen(cible));
        if(temp)
        { /*if we have it*/
                /*log_msg(3, "Found %s : %s", parameter, temp);*/
                ipos=0; 
                /*now go to the first "*/
                while(temp[ipos]!='"' && (ipos < strlen(line)))
                        ipos++;
                if(ipos > strlen(line))
                        {
                        log_msg(0, "Unable to find \" while parsing level line %s, looking for parameter %s", line, parameter);
                        exit(255);
                        }
                ipos++;
                temp += ipos;
                /*vpos = ipos;*/
                
                /*search the second "*/
                while(temp[vpos]!='"' && (vpos < strlen(line)))
                        vpos++;
                if(vpos > strlen(line))
                        {
                        log_msg(0, "Unable to find \" while parsing level line %s, looking for parameter %s", line, parameter);
                        exit(255);
                        }
                vpos++;
                
                /*memset(cible, 0, strlen(cible));*/
                strncpy(cible, temp, vpos-1);
                return cible;
        }
else 
        {
        /*memset(cible, 0, strlen(cible)); */
        strncpy(cible, def, strlen(def));
        return cible;
        }
}

/**********************************************************/

int set_refpoint(point * target, char *value)
{
char *temp = value;
char coord[10];
unsigned int pos1=0;

memset(coord, 0, 10);

while(temp[pos1] != ';' && pos1 < strlen(value))
	pos1++;

if (pos1 >= strlen(value))
	{
	log_msg(0, "Unable to find \";\" while parsing reference point definition %s", value);
    exit(255);
	}



strncpy(coord, temp, pos1);
target->x = atoi(coord);

temp += pos1;
temp ++;

memset(coord, 0, strlen(coord));
strncpy(coord, temp, 10);
target->y = atoi(coord);
return 0;
}



/**************************************************************/
int make_level_file(char *File_Out, char *DescriptionFmt, ...)
{

FILE * targetfile;
va_list args;
char LvlVersionStr[]=VERSION;
char *Description=(char *)calloc(1, 500);

int obj_rot=0;
va_start(args,DescriptionFmt);
vsprintf(Description,DescriptionFmt,args);
va_end(args);

log_msg(0, "make_level_file IS DEPRECATED AND SHALL NOT BE USED");
return 0;

targetfile=fopen(File_Out,"w+");
if(!targetfile)
     { perror("Opening target levelfile ");
     exit(-1);
     }
     
fprintf(targetfile,"/*\nLevel created using MakeLevelFile(%s,%s,...)\n*/\n",File_Out, DescriptionFmt);
fprintf(targetfile,"<fileinfo versionstr=\"%s\" desc=\"%s\" >\n", LvlVersionStr, Description);

free(Description); /*we don't need that anymore*/

fprintf(targetfile,"\n\n\n/*Player information\n*/\n");

/*we put player information into the file*/
for(obj_rot=0; obj_rot < obj_db.nombre_perso; obj_rot++)
    {
    fprintf(targetfile,"<player refpt=\"%i;%i\" xsize=\"%i\" ysize=\"%i\" life=\"%i\" name=\"%s\">\n",\
         obj_db.perso[obj_rot].refpt.x, obj_db.perso[obj_rot].refpt.y, obj_db.perso[obj_rot].xsize,\
         obj_db.perso[obj_rot].ysize, obj_db.perso[obj_rot].life, obj_db.perso[obj_rot].name);
    }

fprintf(targetfile,"\n\n\n/*Wall information\n*/\n");

/*we put information about walls*/
for(obj_rot=0; obj_rot < obj_db.nombre_walls; obj_rot++)
    {
    fprintf(targetfile,"<wall refpt=\"%i;%i\" xsize=\"%i\" ysize=\"%i\">\n", obj_db.walls[obj_rot].refpt.x,\
        obj_db.walls[obj_rot].refpt.y, obj_db.walls[obj_rot].xsize, obj_db.walls[obj_rot].ysize);
    }
    
fprintf(targetfile,"\n\n\n/*Liveplatforms information\n*/\n");

for(obj_rot=0; obj_rot < obj_db.nombre_lwalls; obj_rot++)
    {
    fprintf(targetfile,"<platform refpt=\"%i;%i\" wl_xsize=\"%i\" wl_ysize=\"%i\" speed=\"%i\" mvt_ysize=\"%i\" mvt_xsize=\"%i\">\n",\
         obj_db.lwalls[obj_rot].base_mvt.x, obj_db.lwalls[obj_rot].base_mvt.y, obj_db.lwalls[obj_rot].xsize,\
         obj_db.lwalls[obj_rot].ysize, obj_db.lwalls[obj_rot].speed, obj_db.lwalls[obj_rot].mvt_ysize,\
               obj_db.lwalls[obj_rot].mvt_xsize);
    }



fprintf(targetfile,"\n\n\n/*Finished !\n*/\n");
fclose(targetfile);
return 0;
}

/************************************************************************/

int runtime_level_loader(char * level_file)
{
log_msg(1,"Loading a levelfile while the game is running.");


if(level_file)
    {
    if(! open_lvl_file(level_file))
        {
        log_msg(2,"Cleaning memory");
        fin_instances(1); /*1 stands for "only level-related stuff*/
        log_msg(2, "Now processing levelfile loading.");
        log_msg(3, "Parsing levelfile");
        register_level_objects();
        parse_level_data();
        close_lvl_file();
	log_msg(3, "Levelfile closed...");
        log_msg(2, "Rendering platforms");
        render_platforms();
        update_liveplatforms_sprites();
        }
    else
        {
        log_msg(0, "The program was unable to load the specified levelfile %s", level_file);
        return -2;
        }
    }
return 0;
}

/**************************************************************************/
 
int get_level_line(char * target)
{

int done=0;
int is_comment=0;
    if(!target)
    {
    exit(5);
    }
    



while(!done)
    {
    memset(target, 0, strlen(target));
    fgets(target,4999,level_xml_file);
         
               
    if(!is_comment && strstr(target,"/*"))
        is_comment=1;
        
        
    if(!is_comment)
        if(strchr(target,'<'))
           done=1;
                    
        
        
    if(is_comment==1)
        if(strstr(target,"*/"))
            is_comment=0;            
         
           
/*        target[strlen(target)-1]='\0';*/
        
    if(feof(level_xml_file))
        {
        log_msg(2,"get_level_line() : EOF reached");
/*        memset(target,0,strlen(target));*/
        return 1;
        }
    
    
    }
/*remove last \n*/
if(target[strlen(target) - 1] == '\n')
        target[strlen(target) - 1] = 0;
return 0;
}
     
/*************************************************************/


int init_object_options(char * line)
{
int i;
/*erase the array*/
for(i=0; i < 30; i++)
        object_options[i] = NULL;

if(! strlen(line))
        return 1;
        
object_options[0] = strtok(line, " ,;:!");

for(i=1; i <29; i++)
        object_options[i] = strtok(NULL, " ,;:!");

return 0;
}


/***********************************************************/
short int get_object_option(const char * option_name, short int if_present)
{
int i;

for(i = 0; i < 30; i++)
{
        if(object_options[i])
        {
              if( ! strcmp(object_options[i], option_name))
                {

                        return if_present;
                }
        }
}

return 0;
}
                                
