/*

Copyright (c) 2003-2004      Arthur Huillet


Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    */
    
#include "all_inc.h"
extern int use_hardconfig;

int retr_cfg(const char *config_file)
	{
	int loopctrl;
	const char * key_value; 
        /*char * playersection; */
        char *temp2 = (char *)calloc(1, 1024);
        char *cline = (char *)calloc(1, 1024);
	/*est-ce qu'on a un fichier de config ?*/
	if(config_file[0] && !use_hardconfig)
                log_msg(1,"Using configfile %s",config_file);
        else
    	{
                log_msg(0, "Using hardcoded configuration, see getconf.c set_default_conf()");
                set_default_conf();
                return 1;
    	}
        
        log_msg(3,  "Opening file %s", config_file);
        open_lvl_file(config_file);

        get_level_line(cline);
        /*playersection =  (char *) calloc(1,50);*/
        pl_with_kbinds = atoi (get_level_string(cline, "player_nb", "1", temp2));
        log_msg(1,  "%i player(s) with keybindings", pl_with_kbinds);
        if(pl_with_kbinds > 0 && pl_with_kbinds < 4)
        {
                log_msg(2,  "Allocating memory for keybindings");
                for(loopctrl=0; loopctrl < 15; loopctrl++)
                        pl_kbinds[loopctrl] = (short int *) calloc (pl_with_kbinds + 1, sizeof(short int));
        }
        else
        {
                log_msg(0, "%i player(s) with keybindings is not a valid number. Please define at least one player, at most 3.", pl_with_kbinds);
                exit(5);
        }
        fontsize=8;

        
        /*general keybindings*/
        get_level_line(cline);
        log_msg(2, "General keybindings");
        key_value = get_level_string(cline, "quit", "esc", temp2);
	key_quit=give_key_value(key_value);
	log_msg(2, "Quit key : %s", key_value);
	
	key_value = get_level_string(cline, "console", "C", temp2);
	key_console=give_key_value(key_value);
        log_msg(2,  "Console key : %s", key_value);
        
        key_value = get_level_string(cline, "pause", "P", temp2);
        key_pause = give_key_value(key_value);
        
        /*player keybindings*/
        log_msg(2, "Player keybindings");
        for (loopctrl = 0; loopctrl < pl_with_kbinds; loopctrl++)
        {
                log_msg(2,  "Player %i keybindings", loopctrl);
                get_level_line(cline);
                
                key_value = get_level_string(cline, "go_left", "none", temp2);
                pl_kbinds[GAUCHE][loopctrl]=give_key_value(key_value);
                log_msg(2,"Go_left key : %i",pl_kbinds[GAUCHE][loopctrl]);

                key_value = get_level_string(cline, "go_right", "none", temp2);
                pl_kbinds[DROITE][loopctrl]=give_key_value(key_value);
                log_msg(2,"Go_right key : %i",pl_kbinds[DROITE][loopctrl]);
                
                key_value = get_level_string(cline, "jump", "not_defined", temp2);
                pl_kbinds[SAUT][loopctrl]=give_key_value(key_value);
                log_msg(2,"Jump key :  %i",pl_kbinds[SAUT][loopctrl]);
                
                key_value = get_level_string(cline, "crouch", "not_defined", temp2);
                pl_kbinds[CROUCH][loopctrl]=give_key_value(key_value);
                log_msg(2,"Crouch key :  %i",pl_kbinds[CROUCH][loopctrl]);
                
                key_value = get_level_string(cline, "fire", "not_defined", temp2);
                pl_kbinds[TIR][loopctrl]=give_key_value(key_value);
                log_msg(2,"Fire key :  %i",pl_kbinds[TIR][loopctrl]);
                
                key_value = get_level_string(cline, "change_weapon", "not_defined", temp2);
                pl_kbinds[CH_WEAP][loopctrl]=give_key_value(key_value);
                log_msg(2,"Change weapon key :  %i",pl_kbinds[CH_WEAP][loopctrl]);
                
                key_value = get_level_string(cline, "run", "not_defined", temp2);
                pl_kbinds[RUN][loopctrl]=give_key_value(key_value);
                log_msg(2,"Run key : %i", pl_kbinds[RUN][loopctrl]);
        }
        
        /*free(playersection);*/
        
        /******************EXPERIMENTAL CODE*******************/
        
        /*for(loopctrl=0; loopctrl < 15; loopctrl++)
                free(pl_kbinds[loopctrl]);
        set_default_conf();*/

        free(temp2);
        free(cline);
        return 0;
        }
        
        
        /******************************************************************************/
        
int set_default_conf()
{
        int loopctrl;
        log_msg(3,  "Entering set_default_conf()");
        fontsize=8;
        for(loopctrl=0; loopctrl < 15; loopctrl++)
                pl_kbinds[loopctrl] = (short int *) calloc (2, sizeof(short int));
        key_quit = give_key_value("esc");
        key_pause = give_key_value("P");
        key_console = give_key_value("C");
        pl_kbinds[GAUCHE][0] = give_key_value("left");
        pl_kbinds[DROITE][0] = give_key_value("right");
        pl_kbinds[SAUT][0] = give_key_value("up");
        pl_kbinds[CROUCH][0] = give_key_value("down");
        pl_kbinds[TIR][0] = give_key_value("space");
        pl_kbinds[CH_WEAP][0] = give_key_value("tabulation");
        pl_kbinds[RUN][0] = give_key_value("R");
        return 0;
}
        
        /*****************************************************************************/
        
int give_key_value(const char *valuestr)
        {
        char testingmn='a';
        char testingmj='A';
        int i=1;
        
        if(strstr(valuestr,"none"))
                return -1;
        if(strstr(valuestr,"not_defined"))
                return 0;
        if(strstr(valuestr,"left"))
                return KEY_LEFT;
        if(strstr(valuestr,"right"))
                return KEY_RIGHT;
        if(strstr(valuestr,"up"))
                return KEY_UP;
        if(strstr(valuestr,"down"))
                return KEY_DOWN;
        if(strstr(valuestr,"tabulation"))
                return KEY_TAB;
        if(strstr(valuestr,"space"))
                return KEY_SPACE;
        if(strstr(valuestr,"esc"))
                return KEY_ESC;
        if(strstr(valuestr,"backspace"))
                return KEY_BACKSPACE;
        if(strstr(valuestr,"asterisk"))
                return KEY_ASTERISK;
        if(strstr(valuestr,"pad_plus"))
                return KEY_PLUS_PAD;
        if(strstr(valuestr,"pad_moins"))
                return KEY_MINUS_PAD;
        if(strstr(valuestr,"pad_slash"))
                return KEY_SLASH_PAD;
        
        if(strlen(valuestr)>1)
                {
                log_msg(0,"Error while setting key configuration : %s unknown.",valuestr);
                exit(250);
                }
        /* A = 1 .... Z=26 ...9=36*/
        
        
        while(i!=27)
                {
                if(valuestr[0]==testingmn)
                        return i;
                if(valuestr[0]==testingmj)
                        return i;
                
                testingmn++;
                testingmj++;
                i++;
                }
        
        testingmn='0';
        while(i!=37)
                {
                if(valuestr[0]==testingmn)
                        return i;
               testingmn++;
               i++;
               }
        
        log_msg(0,"Error parsing %s : no corresponding token.",valuestr);
        exit(10);
        
        }
        
        
        /*********************************************************************************/
        
char * give_key_name(const char keyvalue, char * target)
        {
        char valeur='A';
        int is_letter=1;
        memset(target, 0, strlen(target));
            switch(keyvalue){
                    case -1 : sprintf(target, "%s", "none"); is_letter=0; break;
                    case 0 : sprintf(target, "%s","not_defined"); is_letter=0; break;
                    case KEY_LEFT : sprintf(target, "%s","left"); is_letter=0; break;
                    case KEY_RIGHT : sprintf(target, "%s","right"); is_letter=0; break;
                    case KEY_DOWN : sprintf(target, "%s","down"); is_letter=0; break;
                    case KEY_UP : sprintf(target, "%s","up"); is_letter=0; break;
                    case KEY_TAB : sprintf(target, "%s","tabulation"); is_letter=0; break;
                    case KEY_SPACE : sprintf(target, "%s","space"); is_letter=0; break;
                    case KEY_ESC : sprintf(target, "%s","esc"); is_letter=0; break;
                    case KEY_BACKSPACE : sprintf(target, "%s","backspace"); is_letter=0; break;
                    case KEY_ASTERISK : sprintf(target, "%s","asterisk"); is_letter=0; break;
                    case KEY_PLUS_PAD : sprintf(target, "%s","pad_plus"); is_letter=0; break;
                    case KEY_MINUS_PAD : sprintf(target, "%s","pad_moins"); is_letter=0; break;
                    case KEY_SLASH_PAD : sprintf(target, "%s","pad_slash"); is_letter=0; break;
                    }
            /* A = 1 .... Z=26 ...9=36*/
            
            if(is_letter)
            {
                    if(keyvalue <= 26)
                        valeur+=keyvalue-1;
                    else if(keyvalue <= 36)
                        {
                        valeur='0';
                        valeur+=keyvalue-27;
                        }
                    sprintf(target,"%c",valeur);
            }
        return target;
        }
                
        
        
        /**********************************************/

        /*******************************************/
        
        
int make_configfile(const char *name)
        {
        int playerrotate;
        char * keyname = (char *)calloc(1, 10);
        FILE *outconf=fopen(name,"w");
        
        log_msg(2,"make_configfile() called");

        if(outconf == NULL)
                return -1;
        
        log_msg(2,"Writing %s upon current parameters",name);
        log_msg(2,"\tGeneral informations");
    
        fprintf(outconf, "<configuration player_nb=\"%i\">\n", obj_db.nombre_perso);
        fprintf(outconf, "<general ");
        fprintf(outconf,"quit=\"%s\" ",give_key_name(key_quit, keyname));
        fprintf(outconf,"console=\"%s\" ",give_key_name(key_console, keyname));
        fprintf(outconf,"gravite_plus=\"%s\" ",give_key_name(graviteplus, keyname));
        fprintf(outconf,"gravite_moins=\"%s\" ",give_key_name(gravitemoins, keyname));
        fprintf(outconf,">\n");
    
    log_msg(2,"\tPlayer config. ");
    
    
    for(playerrotate = 0; playerrotate < obj_db.nombre_perso; playerrotate ++)
        {
        fprintf(outconf,"<player%i ",playerrotate);
        
        
        fprintf(outconf,"go_left=\"%s\" ",\
                        give_key_name(pl_kbinds[GAUCHE][playerrotate], keyname));
        fprintf(outconf,"go_right=\"%s\" ",\
                        give_key_name(pl_kbinds[DROITE][playerrotate], keyname));
        fprintf(outconf,"jump=\"%s\" ",\
                        give_key_name(pl_kbinds[SAUT][playerrotate], keyname));
        fprintf(outconf,"crouch=\"%s\" ",\
                        give_key_name(pl_kbinds[CROUCH][playerrotate], keyname));
        fprintf(outconf,"fire=\"%s\" ",\
                        give_key_name(pl_kbinds[TIR][playerrotate], keyname));
        fprintf(outconf,"change_weapon=\"%s\" ",\
                        give_key_name(pl_kbinds[CH_WEAP][playerrotate], keyname));
        
     
        fprintf(outconf,">\n");
        } /*fin du for*/
    free(keyname);
    fclose(outconf);
    return(0);
}

