/*

Copyright (c) 2005      Arthur Huillet


Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#include "all_inc.h"

int update_enemies()
{
update_enemies_targets();
move_enemies();
return 0;
}

int move_enemies()
{
int enrot;
liveplayer *en;
liveplayer * en_target;
for(enrot = 0; enrot < obj_db.nombre_enemies; enrot ++)
        {
        en = &obj_db.enemies[enrot];
        en_target = get_liveplayer_target(en);

        if(en->effectors.is_active & PLEFFECTOR_MOVE_ENNEMY)
                {
                if((!(en->parms & ZL_ENNEMY_CLEVER)) || ! en_target)
                        { /*mario brosse*/
                                /*the enemy has no target and just wanders around*/
                        point ref = { 0 , 0 };
                        int width = 0;
                        if(en->ref_pform > 0)
                                {
                                ref = obj_db.lwalls[en->ref_pform - 1].refpt;
                                width = obj_db.lwalls[en->ref_pform - 1].xsize;
                                }
                        else if(en->ref_pform < 0)
                                {
                                ref = obj_db.walls[- en->ref_pform - 1].refpt;
                                width = obj_db.walls[- en->ref_pform - 1].xsize;
                                }

                        if(en->no_xxx & NO_LEFT || ((en->refpt.x < ref.x) && (ref.x > 0)))
                                pl_move_right(en, 0);
                        if(en->no_xxx & NO_RIGHT || ((en->refpt.x + en->xsize) > (ref.x + width) && (ref.x > 0)))
                                pl_move_left(en, 0);
                        
                        if(en->direction == GAUCHE)
                                {
                                pl_move_left(en, (float)en->moving_spd.x);
                                }
                                        
                        else if (en->direction == DROITE)
                                {
                                pl_move_right(en, (float)en->moving_spd.x);
                                }
                        
                        }
                if((en->parms & ZL_ENNEMY_CLEVER) && en_target)
                        { /*mickey mousse !*/
                        /*if he has a target, and if this target is at range (on the same platform), attack him*/
                                if(en->ref_pform == en_target->ref_pform && en->ref_pform)
                                        {
                                        if(en->refpt.x < en_target->refpt.x - 2)
                                                pl_move_right(en, (float)en->moving_spd.x);
                                        if(en->refpt.x > en_target->refpt.x + 2)
                                                pl_move_left(en, (float)en->moving_spd.x);
                                        }
                                else /*if the enemy is not on the same platform as its target*/
                                        {
                                  /*we'll just do nothing*/
                                        }
                        }
                                
                }
         else 
                {
                /*direction de l'enemi*/
                if(en_target)
                        {
                        if(en->refpt.x < en_target->refpt.x)
                                 {
                                 pl_move_right(en, 0);
                                 }
                        else pl_move_left(en, 0);
                        }                        
                }
         

         
         
        
        }


return 0;
}


int update_enemies_targets()
{
for(int i = 0; i < obj_db.nombre_enemies; i ++)
        {
        liveplayer * en = &obj_db.enemies[i];
        for(int y = 0; y < obj_db.nombre_perso; y ++)
                {
                liveplayer * pl = &obj_db.perso[y];
                
                 /*vrification distance*/
                 /*si player prs de l'enemi, on rveille ce dernier*/
                if(abs(en->refpt.x - pl->refpt.x) < 1000 && abs(en->refpt.y - pl->refpt.y) < 500 && !(en->effectors.is_active & PLEFFECTOR_MOVE_ENNEMY))
                        {
                        raise_zignal(&en->zignals, ZIGNAL_PLAYER_INCOMING, y, 0);
                        log_msg(3, "Sent incoming player %i zignal to enemy %i", y, i);
                        }
                /*si player trop loin  on arrte de bouger*/
                if((abs(en->refpt.x - pl->refpt.x) > 1000 || abs(en->refpt.y - pl->refpt.y) > 500) && (en->effectors.is_active & PLEFFECTOR_MOVE_ENNEMY))
                         {
                         raise_zignal(&en->zignals, ZIGNAL_PLAYER_GETTINGAWAY, y, 0);
                         log_msg(3, "Sent zignal \"Player %i getting away\" to enemy %i", y, i);
                         }
                }
        }
return 0;
}


liveplayer * get_liveplayer_target(liveplayer * pl)
{
if(pl->target > 0)
        if(pl->target - 1 < obj_db.nombre_perso)
                return &obj_db.perso[pl->target - 1];
if(pl->target < 0)
        if(- pl->target + 1 < obj_db.nombre_enemies)
                return &obj_db.enemies[- pl->target + 1];

return NULL;
}
