/*

Copyright (c) 2003-2004      Arthur Huillet

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    */

#define CONSOLE_TARGET_UNKN 0
#define CONSOLE_TARGET_INT 1
#define CONSOLE_TARGET_sINT 2
#define CONSOLE_TARGET_CHAR 3
#define CONSOLE_TARGET_FLOAT 4
#define CONSOLE_TARGET_point 5
#define CONSOLE_TARGET_speed 6


BITMAP *console_frame[2]; /*subbitmaps of game_frame*/


void bring_console(); /*brings up the console : 
sets clipping on game_frame
changes CONSOLE_DOWN flag
*/
void stop_console(); /*exactly the opposite as above*/

int allocate_console_memory(); /*allocates memory to our struct*/
int free_console(); /*frees everything it has to*/

int get_console_input();
int parse_console_command(char *);
int console_command_needs_parameter_and_value(char *); /*checks whether we should look for 2 or 3 tokens in the command*/
int handle_console_command(char *, char *, char *); /*it is passed the three tokens of the input line, and 
takes action according to the command*/
int get_console_cmd_target(char *); /*this is an automatically generated function 
which returns the target designed by the parameter string*/


typedef struct {
        char * content;
        struct console_history * NEXT;
        }console_history;

typedef struct {
        char * currentcmd; /*the actual commandline*/
        console_history  * cmd_history; /*linked list of the command and answer history*/
        unsigned short int cur_pos; /*current position of the cursor*/ 
        unsigned short int cur_histnb;
        unsigned short int console_size; /*vertical size*/
        unsigned char target_type; /*type of the target*/
        char * ctarget; /*the different possible targets*/
        int *itarget;
        short int *sitarget;
        speed * speed_target;
        point * point_target;
}console_t;


console_history * add_console_history_entry(console_history *, char * content, ...);
int del_console_history_entry(console_history *);
int free_console_history(console_history *);
char * get_console_history_entry(console_history *, int);
console_t zl_console;


int cslparm_retrieve_speed(speed *, char *);
int cslparm_retrieve_point(point *, char *);

#include "csl_autocode.zh"

