/*

Copyright (c) 2003-2004      Arthur Huillet


Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    */

#include "all_inc.h"

extern int fini; /*the game ended flag*/

int allocate_console_memory()
{
zl_console.currentcmd = (char *)calloc(1, 105);
zl_console.cur_pos = 0;
zl_console.cur_histnb = 1;
zl_console.cmd_history = NULL;
return 0;
}

int free_console()
{
if(zl_console.currentcmd)
        free(zl_console.currentcmd);
zl_console.currentcmd = NULL;
free_console_history(zl_console.cmd_history);
return 0;
}




void bring_console()
{
        /*mettre le clipping sur game_frame
        mettre le flag  1*/
log_msg(1, "Bringing up console !");
CONSOLE_IS_ACTIVE = 1;
set_clip_rect(game_frame[0], 1, zl_console.console_size + 1, zlogframe.L, zlogframe.l);
set_clip_rect(game_frame[1], 1, zl_console.console_size + 1, zlogframe.L, zlogframe.l);
clear_keybuf();
}


void stop_console()
{
        /*virer le clipping sur game_frame
        mettre le flag  0*/
log_msg(1, "Stopping console !");
CONSOLE_IS_ACTIVE = 0;
set_clip_rect(game_frame[0], 1, 1, zlogframe.L, zlogframe.l);
set_clip_rect(game_frame[1], 1, 1, zlogframe.L, zlogframe.l);
}

int get_console_input()
{
if(key[key_quit]) fini=1;         /*endgame*/
if (key [key_pause] && !(pltoggle_ispressed_flag & 2) && key[KEY_LSHIFT] && key[KEY_LCONTROL])
        {
        pltoggle_ispressed_flag |= 2;        
        fini=pause();
        }
if(!key[key_pause])
        pltoggle_ispressed_flag &= ~2;

if(key[key_console] && key[KEY_LSHIFT] && key[KEY_LCONTROL])
        {
        if(!(pltoggle_ispressed_flag & 16))
                {
                pltoggle_ispressed_flag |= 16;
                stop_console();
                return 0;
                }
        }
if(!key[key_console])
        pltoggle_ispressed_flag &= ~16;
        
/* all the special keys are treated above, now just make the input routine*/
if(keypressed())
        {
        int pressed_key = readkey();
        char pkey_ASCII = pressed_key & 0xff;
        char pkey_scode = pressed_key >> 8;
        
        if(pkey_scode == key_console && (pltoggle_ispressed_flag & 16))
                /*check that the key_console wasn't pressed the cycle before*/
                return 0;
                
        
        if(pkey_ASCII >= 32 && pkey_ASCII <= 126)
                {
                if(zl_console.cur_pos < 100)
                        { /*add the char to the line*/
                        zl_console.currentcmd[zl_console.cur_pos] = pkey_ASCII;
                        zl_console.cur_pos ++;
                        }
                }
        if(pkey_scode == KEY_BACKSPACE)
                if(zl_console.cur_pos)
                        {
                        zl_console.cur_pos --;
                        zl_console.currentcmd[zl_console.cur_pos] = '\0';
                        }

        if(pkey_scode == KEY_DEL)
                if((unsigned int)(zl_console.cur_pos) < strlen(zl_console.currentcmd))
                        {
                        zl_console.currentcmd[zl_console.cur_pos] = '\0';
                        strcat(zl_console.currentcmd, zl_console.currentcmd + zl_console.cur_pos + 1);
                        }
        
        if(pkey_scode == KEY_ENTER)
                {
                if(strlen(zl_console.currentcmd))
                        {
                        zl_console.cmd_history = add_console_history_entry(zl_console.cmd_history, zl_console.currentcmd);
                        parse_console_command(zl_console.currentcmd);
                        memset(zl_console.currentcmd, 0, strlen(zl_console.currentcmd));
                        zl_console.cur_pos = 0;
                        }
                }
        
        if(pkey_scode == KEY_HOME)
                zl_console.cur_pos = 0;
        if(pkey_scode == KEY_END)
                zl_console.cur_pos = strlen(zl_console.currentcmd);
        if(pkey_scode == KEY_LEFT)
                if(zl_console.cur_pos) zl_console.cur_pos --;
        if(pkey_scode == KEY_RIGHT)
                if(zl_console.cur_pos < strlen(zl_console.currentcmd))
                        zl_console.cur_pos ++;
        if(pkey_scode == KEY_UP || pkey_scode == KEY_DOWN)
                        {
                        if(pkey_scode == KEY_DOWN) 
                                if(zl_console.cur_histnb >= 2) zl_console.cur_histnb -= 2;
                        char * hist = get_console_history_entry(zl_console.cmd_history, zl_console.cur_histnb); 
                        if(hist)
                                {
                                log_msg(3, "Hist %s", hist);
                                memset(zl_console.currentcmd, 0, strlen(zl_console.currentcmd));
                                sprintf(zl_console.currentcmd, "%s", hist);
                                zl_console.cur_pos = strlen(hist);
                                if(pkey_scode == KEY_UP) zl_console.cur_histnb += 2;
                                }
                        else zl_console.cur_histnb = 1;
                        
                        }
                        
        if(pkey_scode == KEY_PGDN)
                {
                zl_console.cur_histnb = 1;
                memset(zl_console.currentcmd, 0, strlen(zl_console.currentcmd));
                zl_console.cur_pos = 0;
                }
        }
                

return 0;        
}

/****************************************************************************
linked list handling
**************************************************************************/
console_history * add_console_history_entry(console_history * target, char * content, ...)
{
va_list ap;
va_start(ap, content);
        /*create the new node*/
console_history *new_obj = (console_history *)calloc(1, sizeof(console_history));
new_obj->content = (char *)calloc(1, 250);
vsprintf(new_obj->content, content, ap);
/*strncpy(new_obj->content, content, strlen(content));*/
new_obj->NEXT = (struct console_history *)target;

target = new_obj;
va_end(ap);
return new_obj;
}

int del_console_history_entry(console_history * target)
{
        /*we automatically remove the last entry*/
console_history * entry_rot = target;
console_history * last_address = target;

while(last_address->NEXT)
        last_address = (console_history *)last_address->NEXT;

free(last_address->content);

while(entry_rot->NEXT != (struct console_history *)last_address)
        entry_rot = (console_history *)entry_rot->NEXT;

entry_rot->NEXT=NULL;
return 0;
}

int free_console_history(console_history * target)
{
console_history * entry_rot = target;
console_history * nextptr;

while(entry_rot)
        {
        free(entry_rot->content);
        nextptr = (console_history *)entry_rot->NEXT;
        free(entry_rot);
        entry_rot = nextptr;
        }

return 0;
}



char * get_console_history_entry(console_history * target, int entrynb)
{
int i = 0;
console_history * entry_rot = target;
if( !entry_rot) return NULL;
while(entry_rot -> NEXT && i < entrynb)
        {
        entry_rot = (console_history *)entry_rot->NEXT;
        i++;
        }
if(i == entrynb)
        return entry_rot->content;
else return NULL;
}





/*********************************************************************/
int console_command_needs_parameter_and_value(char * command)
{
        
if(! strcmp(command, "set"))
        return 1;
if((! strcmp(command, "debug")) || (!strcmp(command, "dbg")))
        return 0;
if(! strcmp(command, "print"))
        return 0;
return -1;
}
/*********************************************************************/
int parse_console_command(char * source)
{
if(!source)
        return 0;
if(!strlen(source))
        return 0;

/*get rid off leading spaces*/
while(source[0] == ' ')
        source++;
        
if(!strcmp(source, "exit"))
        {
        stop_console();
        return 0;
        }
        
/*on repre le premire lexme (commande)*/
/*on transmet la suite  une fonction spcifique  la commande, qui selon la valeur retourne, fera son boulot*/
char * command;
char * parameter = NULL;
char * value = NULL; /*to ensure it is NULL if no memory is allocated to it, so as not to free garbage*/
unsigned int string_offset=1;


if(!strchr(source, ' '))
        {
                /*one-word commands can be parsed above, that's better*/
        zl_console.cmd_history = add_console_history_entry(zl_console.cmd_history, "! Unrecognized command or missing parameter : %s", source);
        return 1;
        }

/*retrieve the first token corresponding to the command*/ 
while(source[string_offset] != ' ' && string_offset < strlen(source))
        string_offset++;

/*allocate memory to char * command*/
command = (char *) calloc(1, string_offset + 2);
strncpy(command, source, string_offset);
log_msg(3, "Console command : %s", command);
source += string_offset + 1;
string_offset = 1;
/*we're dealing with a command wich needs a parameter, otherwise it would already have been treated (see at
the beginning of this function)*/
while(source[0] == ' ')
        source++; /*remove any extra spaces between command and parameter*/

if(console_command_needs_parameter_and_value(command) == 1)
        { /*lets look for a parameter and a value*/
        if(!strchr(source, ' '))
                {
                /*we _need_ a parameter*/
                zl_console.cmd_history = add_console_history_entry(zl_console.cmd_history, "! Missing value  : %s", command);
                free(command);
                return 2;
                }
        while(source[string_offset] != ' ' && string_offset < strlen(source))
                string_offset++;
        parameter = (char *)calloc(1, string_offset + 2);
        strncpy(parameter, source, string_offset);
        value = (char *)calloc(1, strlen(source) - string_offset + 2);
        strncpy(value, source + string_offset + 1, strlen(source) - string_offset);
        log_msg(3, "Console command parameter %s, value %s", parameter, value);
        handle_console_command(command, parameter, value);
        }
if(console_command_needs_parameter_and_value(command) == 0) 
        { /*no need for a value, everything that is not the command is considered as a parameter*/
        parameter = (char *)calloc(1, strlen(source) + 1);
        strncpy(parameter, source, strlen(source));
        log_msg(3, "Console command parameter %s", parameter);
        handle_console_command(command, parameter, NULL);
        }
if(console_command_needs_parameter_and_value(command) == -1)
        { /*this is an unknown command*/
        zl_console.cmd_history = add_console_history_entry(zl_console.cmd_history, "! Unkown command %s", command);
        free(command);
        return 3;
        }
        

        
/*zl_console.cmd_history = add_console_history_entry(zl_console.cmd_history, "! %s ok", command);*/
free(command);
free(parameter);
if(value) free(value);
return 0;
}


int handle_console_command(char *command, char * parameter, char *value)
{
/*deux commandes pour l'instant : set et print
chaque commande est traite avec des strcmp et des if
on s'occupe manuellement des variables globales (gravite,etc.) puis 
on appelle une fonction gnre automatiquement*/

get_console_cmd_target(parameter); /*target pointer of the parameter*/

        
if((!strcmp(command, "debug")) || (!strcmp(command, "dbg")))
        {
        if(!strcmp(parameter, "off"))
                {
                MODE_DEBUG_ACTIF = 0;
                zl_console.cmd_history = add_console_history_entry(zl_console.cmd_history, "! Debug mode disabled", parameter);
                }
        if((!strcmp(parameter, "on")) && ((perso_to_debug >=0) || (pform_to_debug >=0)))
                {
                zl_console.cmd_history = add_console_history_entry(zl_console.cmd_history, "! Debug mode now enabled", parameter);
                MODE_DEBUG_ACTIF = 1;
                }
                
        int objectnb;
        char objecttype[15];
        memset(objecttype, 0, 15);
        int i = 0;
        while(!isdigit(parameter[i]) && i < 15)
                {
                objecttype[i] = parameter[i];
                i++;
                }
        objectnb = atoi(parameter + i);
        if((!strcmp(objecttype, "pl")) || (!strcmp(objecttype, "player")))
                {
                if(objectnb < obj_db.nombre_perso)
                        {
                        MODE_DEBUG_ACTIF = 1;
                        perso_to_debug = objectnb;
                        pform_to_debug = -1;
                        zl_console.cmd_history = add_console_history_entry(zl_console.cmd_history, "! Debugging player %i", objectnb);
                        }
                else zl_console.cmd_history = add_console_history_entry(zl_console.cmd_history, "! Player %i does not exist.", objectnb);
                }
        if((!strcmp(objecttype, "lwl")) || (!strcmp(objecttype, "livewall")))
                {
                if(objectnb < obj_db.nombre_lwalls)
                        {
                        MODE_DEBUG_ACTIF = 1;
                        perso_to_debug = -1;
                        pform_to_debug = objectnb;
                        zl_console.cmd_history = add_console_history_entry(zl_console.cmd_history, "! Debugging livewall %i", objectnb);
                        }
                else zl_console.cmd_history = add_console_history_entry(zl_console.cmd_history, "! Livewall %i does not exist.", objectnb);
                }
        return 0;
        }

        
if(zl_console.target_type == CONSOLE_TARGET_UNKN)
        {
        zl_console.cmd_history = add_console_history_entry(zl_console.cmd_history, "! Unknown parameter %s", parameter);
        return 1;
        }        
        
        
if(!strcmp(command, "set"))
        {
        switch(zl_console.target_type)
                {
                case CONSOLE_TARGET_CHAR :
                        zl_console.ctarget = value;
                        zl_console.cmd_history = add_console_history_entry(zl_console.cmd_history, "! %s set to  %s", parameter, value);
                        break;
                case CONSOLE_TARGET_INT :
                        *(zl_console.itarget) = atoi(value);
                        zl_console.cmd_history = add_console_history_entry(zl_console.cmd_history, "! %s set to  %i", parameter, atoi(value));
                        break;
                case CONSOLE_TARGET_sINT : 
                        *(zl_console.sitarget) = (short int)atoi(value);
                        zl_console.cmd_history = add_console_history_entry(zl_console.cmd_history, "! %s set to  %i", parameter, atoi(value));
                        break;
                case CONSOLE_TARGET_FLOAT :
                        *((float *)(zl_console.itarget)) = atof(value);
                        zl_console.cmd_history  = add_console_history_entry(zl_console.cmd_history, "! %s set to %f", parameter, atof(value));
                        break;
                };
        return 0;
        }
if(!strcmp(command, "print"))
        {
        switch(zl_console.target_type)
                {
                case CONSOLE_TARGET_CHAR :
                        zl_console.cmd_history = add_console_history_entry(zl_console.cmd_history, "! %s = %s", parameter, zl_console.ctarget);
                        break;
                case CONSOLE_TARGET_INT :
                        log_msg(3, "itarget %i", *(zl_console.itarget));
                        zl_console.cmd_history = add_console_history_entry(zl_console.cmd_history, "! %s = %i", parameter, *(zl_console.itarget));
                        break;
                case CONSOLE_TARGET_sINT : 
                        log_msg(3, "sitarget %i", *(zl_console.sitarget));
                        zl_console.cmd_history = add_console_history_entry(zl_console.cmd_history, "! %s = %i", parameter, *(zl_console.sitarget));
                        break;
                case CONSOLE_TARGET_FLOAT :
                        zl_console.cmd_history = add_console_history_entry(zl_console.cmd_history, "! %s = %f", parameter, *((float *)(zl_console.itarget)));
                        break;
                case CONSOLE_TARGET_speed :
                        zl_console.cmd_history = add_console_history_entry(zl_console.cmd_history, "! %s = { x = %f ; y = %f }", parameter, (zl_console.speed_target->x), (zl_console.speed_target->y));
                        break;
                case CONSOLE_TARGET_point :
                        zl_console.cmd_history = add_console_history_entry(zl_console.cmd_history, "! %s = { x = %i ; y = %i }", parameter, (zl_console.point_target->x), (zl_console.point_target->y));
                        break;
                };
        return 0;
        }
        
return 0;
}

int cslparm_retrieve_speed(speed * target, char *source)
{
if(!strcmp(source, "x"))
        {
        zl_console.target_type = CONSOLE_TARGET_FLOAT;
        zl_console.itarget = (int *)&(target->x);
        }
if(!strcmp(source, "y"))
        {
        zl_console.target_type = CONSOLE_TARGET_FLOAT;
        zl_console.itarget = (int *)&(target->y);
        }
return 0;
}


int cslparm_retrieve_point(point *target, char * source)
{
if(!strcmp(source, "x"))
        {
        zl_console.target_type = CONSOLE_TARGET_INT;
        zl_console.itarget = (int *)&(target->x);
        }
if(!strcmp(source, "y"))
        {
        zl_console.target_type = CONSOLE_TARGET_INT;
        zl_console.itarget = (int *)&(target->y);
        }
return 0;
}

#include "csl_autocode.zc"
