/*

Copyright (c) 2003-2004    Arthur Huillet

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    */  
#include "all_inc.h"
#include <getopt.h>
extern int page_flip;
extern int USE_TIMERS;
extern message_hdl ruletoadd;
extern char level_file[250];
extern int gfxmode;
extern int ask_gfx;
extern int use_hardconfig;


void usage()
{
    
fprintf(stderr,
	     "Usage : zlog-core [options]\nOptions are :\n"
	     "-V, --version : displays version number then exits\n"
	     "-h, --help : displays this help message\n"
	     "-d : do not display gfx mode dialogbox, runs the game directly (default)\n"
	     "-s : display gfx mode selection box\n");
fprintf(stderr,
	     "-p <playernb>, --player <playernb> : gives debug info about player #nb\n"
	     "-w <wallnb>, --wall <wallnb> : actually does nothing\n"
	     "-f <lwallnb>, --lwall <lwallnb> : gives debug info about livewall #nb\n"
	     "-L <levelfile> : uses specified levelfile\n"
	     "-C <configfile> : uses specified configfile\n");
fprintf(stderr,
	     "-l <level>, --debuglevel <level> : debug level to issue messages\n"
	     "-G <mode>, --gfx-mode <mode> : use either \n\t\"safe\" : Safe Mode, not recommanded\n"
	     "\t\"autodetect\" or \"auto\" : autodetect best mode (fullscreen most of the time)\n"
	     "\t\"fullscreen\" or \"fs\" : try to set a fullscreen mode\n"
	     "\t\"window\" or \"win\" : play in a window (default, recommanded)\n"
	     "--no-page-flip : disable pageflipping\n"
	     "--do-page-flip : forces pageflipping (default)\n"
	     "--no-timers : do not use timers (dangerous and useless)\n");
fprintf(stderr,
		 "--use-deadzone : screen scrolling using a deadzone system (default)\n"
		 "--no-deadzone : don't you like deadzone ?\n"
                 "--hard-config : use hardcoded configuration - default on non-Linux - workaround for bug#2\n");
		 
exit(0);

}




int parse_commandline(int argc, char **argv)
{
    int option;
    int longindex;
    int addnewrule = 0;
    int give_vers = 0;
    extern int use_deadzone;

    struct option longopts[] = {

	/*name                  arg             flag                    val */

	/*version */
	{"version", 			0, 				NULL, 					'V'},

	/*vrif config, obsolte */
	{"no-page-flip", 		0, 				&page_flip, 			0},
	{"do-page-flip", 		0, 				&page_flip, 			1},

	/*redirection stderr */
	/*--to-stderr*/
	/*redirection stdout, inutile */
	/*--to-stdout*/

	/*help */
	{"help", 				0, 				NULL, 					'h'},


	/*player  debug */
	{"player", 1, NULL, 'p'},
	{"wall", 1, NULL, 'w'},
	{"lwall", 1, NULL, 'f'},

	/*pas de timers */
	{"no-timers", 0, &USE_TIMERS, 0},
	/*niveau de debug */
	{"debuglevel", 1, NULL, 'l'},

	/*redirection sur un fichier */
	/*--to-file <"path"|file#>*/

	/*changement mode gfx */
	{"gfx-mode", 1, NULL, 'G'},
	
	/*utilisation deadzone*/
	
	{"use-deadzone", 0, &use_deadzone, 1},
	{"no-deadzone", 0, &use_deadzone, 0},
        /*utilisation config hardcode*/
        {"hard-config", 0, &use_hardconfig, 1},
	{NULL, 0, NULL, 0},

    };


    char *optstring = "Vhdsp:w:f:L:C:l:G:";

    while ((option =
	    getopt_long(argc, argv, optstring, longopts,
			&longindex)) != -1) {

	switch (option) {

	case 'V':
		give_vers = 1;
	    break;
	case 'h':
	    usage();
	    break;
	case 'd':
		ask_gfx=0;
	    break;
	case 's':
		ask_gfx=1;
		break;
	case 'p':
	    MODE_DEBUG_ACTIF = 1;
	    perso_to_debug = atoi(optarg);
	    log_msg(1, "Debugging player %i", perso_to_debug);
	    pform_to_debug = -1;
	    break;
	case 'w':
	    break;
	case 'f':
	    MODE_DEBUG_ACTIF = 1;
	    perso_to_debug = -1;
	    pform_to_debug = atoi(optarg);
	    log_msg(1, "Debugging pform %i", pform_to_debug);
	    break;
	case 'l':
	    addnewrule = 1;
	    ruletoadd.debuglvl = atoi(optarg);
	    break;
	
	case 'L':
	    strncpy(level_file, optarg, 249);
	    break;
	case 'C':
	    strncpy(newconf, optarg, 249);
	    break;
	case 'G':
		printf("%s",optarg);
	    if (strstr(optarg,"autodetect"))
			gfxmode = GFX_AUTODETECT;
		if (strstr(optarg,"fullscreen"))
			gfxmode = GFX_AUTODETECT_FULLSCREEN;
		if (strstr(optarg,"fs"))
			gfxmode = GFX_AUTODETECT_FULLSCREEN;	
	    if (strstr(optarg,"safe"))
			gfxmode = GFX_SAFE;
	    if (strstr(optarg,"window"))
			gfxmode = GFX_AUTODETECT_WINDOWED;
	    if (strstr(optarg,"win"))
			gfxmode = GFX_AUTODETECT_WINDOWED;
	    break;
	case '?':
		log_msg(0, "Quitting !");
		exit(5);
	    break;

	}
    }



log_msg(1,"{Zl0g} version number %s",VERSION);
log_msg(2,"Zlog %s",VERSION);
log_msg(1,"Using log file %s","zlog_log.txt");
log_msg(1,"Using %s",allegro_id);    

if (give_vers)
	{
	exit(0);
	}
                

if (addnewrule)
	
	{
	
	    /*retr_rule_str(add_rule(ruletoadd),temp); */ 
	    add_rule(ruletoadd);
	
	    /*log_msg(1, "Added rule whose description is : \n %s",temp); */ 
	}
    
return 0;

}
