/*

Copyright (c) 2005      Arthur Huillet

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    */
    
#include "all_inc.h"    
    
/*temporary animation function*/    
int cycle_object_sprites()
{
int objrot;

for (objrot = 0; objrot < obj_db.nombre_perso; objrot ++)
        animate_player(&obj_db.perso[objrot]);
for (objrot = 0; objrot < obj_db.nombre_enemies; objrot ++)
        animate_player(&obj_db.enemies[objrot]);
return 0;        
}

int animate_player(liveplayer *target)
{
/*cycle sprites*/
if(target->state & ZL_SPRITE_ANIMATE)
        {
        target->sprite_delay++;
        if(target->sprite_delay == 10)
                {
                target->sprite_delay = 0;
                if(target->current_sprite->NEXT && !(target->spritecycling_parms & SPR_REVERSE))
                        {
                        /*log_msg(3, "Cycling sprite of player at %x to NEXT : %x -> %x", target, target->current_sprite, target->current_sprite->NEXT);*/
                        target->current_sprite = (zl_sprite *)target->current_sprite->NEXT;
                        if( !target->current_sprite->NEXT)
                                target->spritecycling_parms |= SPR_REVERSE;
                        }
                else
                        {
                        /*log_msg(3, "Cycling sprite of player at %x to PREV : %x -> %x", target, target->current_sprite, target->current_sprite->PREV);*/
                        target->current_sprite = (zl_sprite *)target->current_sprite->PREV;
                        if( !target->current_sprite->PREV)
                                target->spritecycling_parms &= ~SPR_REVERSE;

                        }
               }
        }
return 0;
}

int render_platforms()
{
for(int wlrot = 0; wlrot < obj_db.nombre_walls; wlrot ++)
        {
        wall * target = &obj_db.walls[wlrot];
        sprset pool;
        /*create the bitmap*/
        platform_sprites[wlrot] = create_bitmap(target->xsize, target->ysize);
        clear_bitmap(platform_sprites[wlrot]);
        /*link to it*/
        target->sprite = &platform_sprites[wlrot];
        
        if(!(pool = search_spritesetdb_entry(spriteset_db, target->spriteset)))
                {
                spriteset_db = add_spritesetdb_entry(spriteset_db, target->spriteset, PFORM_SPRSET);
                pool = search_spritesetdb_entry(spriteset_db, target->spriteset);
                }
                
        /*whitespace filling*/
   /*     rectfill(platform_sprites[wlrot], 0, 0, target->xsize, target->ysize, wlrot + 8);
        line(platform_sprites[wlrot], 0, target->ysize/2, target->xsize, target->ysize/2, 4);*/
        
        /*the edges*/
        blit(pool[SPRSET_EDGE_LEFT][0].spr, platform_sprites[wlrot], 0, 0, 0, 0, pool[SPRSET_EDGE_LEFT][0].spr->w, pool[SPRSET_EDGE_LEFT][0].spr->h);

        
        /*now proceed to the center*/
        for(int xpos = pool[SPRSET_EDGE_LEFT][0].spr->w; xpos < platform_sprites[wlrot]->w - pool[SPRSET_EDGE_LEFT][0].spr->w;)
                {
                zl_sprite * std;
                zl_sprite * rd1;
                zl_sprite * rd2;
                BITMAP * source;
                std = &pool[SPRSET_CENTER][0];
                rd1 = (zl_sprite *)std->NEXT;
                if(! rd1) rd1 = std;
                rd2 = (zl_sprite *)rd1->NEXT;
                if(! rd2) rd2 = rd1;
                
                source = std->spr;
                if((rand() % 20) >= 18) 
                        {
                        source = rd1->spr;
                        }
                else if((rand() % 20) == 19)
                                source = rd2->spr;

                blit(source, platform_sprites[wlrot], 0, 0, xpos, 0, source->w, source->h);
                xpos += source->w;
                }
                blit(pool[SPRSET_EDGE_RIGHT][0].spr, platform_sprites[wlrot], 0, 0, platform_sprites[wlrot]->w - pool[SPRSET_EDGE_RIGHT][0].spr->w , 0, pool[SPRSET_EDGE_RIGHT][0].spr->w, pool[SPRSET_EDGE_RIGHT][0].spr->h);
        }
        
return 0;
}


int render_lwall(int lwlnb)
{
livewall * target = &obj_db.lwalls[lwlnb];
sprset pool;
liveplatform_centralsprites[lwlnb] = create_bitmap(target->max_size.x, target->max_size.y);
clear_bitmap(liveplatform_centralsprites[lwlnb]);


/*link to it*/
target->sprite = &liveplatform_centralsprites[lwlnb];

if(!(pool = search_spritesetdb_entry(spriteset_db, target->spriteset)))
        {
        spriteset_db = add_spritesetdb_entry(spriteset_db, target->spriteset, PFORM_SPRSET);
        pool = search_spritesetdb_entry(spriteset_db, target->spriteset);
        }

/*the edges*/
target->edgeleft = &pool[SPRSET_EDGE_LEFT][0].spr;
target->edgeright = &pool[SPRSET_EDGE_RIGHT][0].spr;

/*now proceed to the center*/

int xpos = 0;
while( xpos < liveplatform_centralsprites[lwlnb]->w)
        {
        zl_sprite * std;
        zl_sprite * rd1;
        zl_sprite * rd2;
        BITMAP * source;
        std = &pool[SPRSET_CENTER][0];
        rd1 = (zl_sprite *)std->NEXT;
        if(! rd1) rd1 = std;
        rd2 = (zl_sprite *)rd1->NEXT;
        if(! rd2) rd2 = rd1;
        
        source = std->spr;
        if((rand() % 20) >= 18) 
                {
                source = rd1->spr;
                }
        else if((rand() % 20) == 19)
                        source = rd2->spr;
        
        blit(source, liveplatform_centralsprites[lwlnb], 0, 0, xpos, 0, source->w, source->h);
        xpos += source->w;
        }

return 0;
}

int update_liveplatforms_sprites()
{
livewall * target;
for(int i = 0; i < obj_db.nombre_lwalls; i++)
        { /*for each lpform, check whether it has to be redrawn and do it*/
        target = &obj_db.lwalls[i];
        if(!liveplatform_centralsprites[i])
                render_lwall(i);
        if(target->state & LWL_REDRAW)
                {
                }
        target->state &= ~LWL_REDRAW;
        }
return 0;
}

/******************************************************************************
SPRITES DATABASE HANDLING
*******************************************************************************/
/*SPRITESET LEVEL 2*/

/*allocation mmoire, libration*/

/*search an entry with its key in the database*/
sprset search_spritesetdb_entry(sprset_entry * db, char * clef)
{
sprset_entry * cur = db;
log_msg(3, "Spriteset level 2 function : search_spritesetdb_entry. Looking for an entry with key %s", clef);
if(! db)
        return 0;
        
while(1)
        {
        if(!strcmp(cur->key, clef))
                return cur->dataset;
        if(cur->NEXT)
                cur = (sprset_entry *)cur->NEXT;
        else
                return 0;
        }
return 0;
}

sprset_entry * add_spritesetdb_entry(sprset_entry * target, char * clef, int type)
{
log_msg(3, "Spriteset level 2 function : add_spritesetdb_entry. Adding entry with key %s", clef);
sprset_entry * newset = (sprset_entry *)calloc(1, sizeof(sprset_entry));
strncpy(newset->key, clef, 25);
newset->NEXT = (struct sprset_entry *)target;
newset->type = type;
fill_sprset(&newset->dataset, clef, type);
target = newset;
return newset;
}


int free_spritesetdb(sprset_entry * db)
{
log_msg(3, "Spriteset level 2 function : free_spritesetdb. Freeing database.");
sprset_entry * cur = db;
sprset_entry * next;
while(cur)
        {
        next = (sprset_entry *)cur->NEXT;
        free_sprset(&cur->dataset, cur->type);
        free(cur);
        cur = next;
        }
return 0;
}

/*SPRITE SET LEVEL 1*/
int fill_sprset(sprset * target, char * dir, int type)
{

char path[250];
memset(path, 0, 250);
sprintf(path, "%s/%s/", TILESDIR, dir);
switch(type)
        {
        case PLAYER_SPRSET :
        log_msg(3, "Spriteset level 1 function : fill_sprset. Filling player spriteset.");
        (*target) = (zl_sprite **)calloc(2, sizeof(zl_sprite *));
        (*target)[SPRSET_GOING_RIGHT] = add_zl_sprite_entry((*target)[SPRSET_GOING_RIGHT], path, "d1.bmp", USE_FALLBACK);
        (*target)[SPRSET_GOING_RIGHT] = add_zl_sprite_entry((*target)[SPRSET_GOING_RIGHT], path, "d2.bmp", USE_FALLBACK);
        (*target)[SPRSET_GOING_RIGHT] = add_zl_sprite_entry((*target)[SPRSET_GOING_RIGHT], path, "d3.bmp", USE_FALLBACK);
        (*target)[SPRSET_GOING_RIGHT] = add_zl_sprite_entry((*target)[SPRSET_GOING_RIGHT], path, "d4.bmp", USE_FALLBACK);
        (*target)[SPRSET_GOING_RIGHT] = add_zl_sprite_entry((*target)[SPRSET_GOING_RIGHT], path, "d5.bmp", USE_FALLBACK);
        (*target)[SPRSET_GOING_RIGHT] = add_zl_sprite_entry((*target)[SPRSET_GOING_RIGHT], path, "d6.bmp", USE_FALLBACK);
        (*target)[SPRSET_GOING_LEFT] = add_zl_sprite_entry((*target)[SPRSET_GOING_LEFT], path, "g1.bmp", USE_FALLBACK);
        (*target)[SPRSET_GOING_LEFT] = add_zl_sprite_entry((*target)[SPRSET_GOING_LEFT], path, "g2.bmp", USE_FALLBACK);
        (*target)[SPRSET_GOING_LEFT] = add_zl_sprite_entry((*target)[SPRSET_GOING_LEFT], path, "g3.bmp", USE_FALLBACK);
        (*target)[SPRSET_GOING_LEFT] = add_zl_sprite_entry((*target)[SPRSET_GOING_LEFT], path, "g4.bmp", USE_FALLBACK);
        (*target)[SPRSET_GOING_LEFT] = add_zl_sprite_entry((*target)[SPRSET_GOING_LEFT], path, "g5.bmp", USE_FALLBACK);
        (*target)[SPRSET_GOING_LEFT] = add_zl_sprite_entry((*target)[SPRSET_GOING_LEFT], path, "g6.bmp", USE_FALLBACK);
        return 0;
        
        case PFORM_SPRSET :
        log_msg(3, "Spriteset level 1 function : fill_sprset. Filling platform spriteset.");
        (*target) = (zl_sprite **)calloc(3, sizeof(zl_sprite *));
        (*target)[SPRSET_EDGE_LEFT] = add_zl_sprite_entry((*target)[SPRSET_EDGE_LEFT], path, "edgeleft.bmp", NO_FALLBACK);
        (*target)[SPRSET_EDGE_RIGHT] = add_zl_sprite_entry((*target)[SPRSET_EDGE_RIGHT], path, "edgeright.bmp", NO_FALLBACK);
        (*target)[SPRSET_CENTER] = add_zl_sprite_entry((*target)[SPRSET_CENTER], path, "centerdeco2.bmp", NO_FALLBACK);
        (*target)[SPRSET_CENTER] = add_zl_sprite_entry((*target)[SPRSET_CENTER], path, "centerdeco1.bmp", NO_FALLBACK);
        (*target)[SPRSET_CENTER] = add_zl_sprite_entry((*target)[SPRSET_CENTER], path, "centerstd.bmp", NO_FALLBACK);
        return 0;
        }


return 1;
}




int free_sprset(sprset * target, int type)
{
switch(type)
        {
        case PLAYER_SPRSET :
        log_msg(3, "Spriteset level 1 function : free_sprset. Freeing player spriteset.");
        free_zl_sprite((*target)[SPRSET_GOING_LEFT]);
        free_zl_sprite((*target)[SPRSET_GOING_RIGHT]);
        free(*target);
        return 0;
        
        case PFORM_SPRSET : 
        log_msg(3, "Spriteset level 1 function : free_sprset. Freeing platform spriteset.");
        free_zl_sprite((*target)[SPRSET_EDGE_LEFT]);
        free_zl_sprite((*target)[SPRSET_EDGE_RIGHT]);
        free_zl_sprite((*target)[SPRSET_CENTER]);
        free(*target);
        return 0;
        }
        
return 0;
}    
    
    
    

/*SPRITE SET LEVEL 0*/    
/*linked list handling*/

zl_sprite * add_zl_sprite_entry(zl_sprite * target, char * path, char * file, int opt)
{
log_msg(3, "Spriteset level 0 function : add_zl_sprite_entry. Adding sprite %s%s to the set.", path, file);
char * final_path = (char *)calloc(1, strlen(path) + strlen(file) + 10);
sprintf(final_path, "%s%s", path, file);
        /*create the new node*/
zl_sprite *new_obj = (zl_sprite *)calloc(1, sizeof(zl_sprite));
        /*load the specified bitmap*/
if( ! (new_obj->spr = load_bitmap(final_path, NULL)))
        {
        if(opt == USE_FALLBACK)
                {
                log_msg(0, "Bitmap loading of %s failed, falling back to default sprite (level 0 fallback)", final_path);
                memset(final_path, 0, strlen(final_path));
                sprintf(final_path, "%sfallback.bmp", path);
                if(! (new_obj->spr = load_bitmap(final_path, NULL)))
                        {
                                log_msg(0, "Fallback bitmap not loaded, using emergency fallback bitmap !");
                                new_obj->spr = create_bitmap(80, 90);
                                clear_bitmap(new_obj->spr);
                                textout_ex(new_obj->spr, font, "FALLBACK", 0, 0, 4, 255);
                                textout_ex(new_obj->spr, font, "FALLBACK", 0, 0, 4, 255);
                                textout_ex(new_obj->spr, font, "FALLBACK", 0, 15, 4, 255);
                                textout_ex(new_obj->spr, font, "FALLBACK", 0, 30, 4, 255);
                                textout_ex(new_obj->spr, font, "FALLBACK", 0, 45, 4, 255);
                                textout_ex(new_obj->spr, font, "FALLBACK", 0, 60, 4, 255);
                                textout_ex(new_obj->spr, font, "FALLBACK", 0, 75, 4, 255);
                        }
                }
        else 
                {
                log_msg(0, "Loading of bitmap %s failed", final_path);
                new_obj->spr = NULL;
                }
        }
        

if(target)
        {
        new_obj->NEXT = (struct zl_sprite *)target;
        target->PREV = (struct zl_sprite *)new_obj;
        }
target = new_obj;
free(final_path);
return new_obj;
}



int del_zl_sprite_entry(zl_sprite * target)
{
log_msg(3, "Spriteset level 0 function : del_zl_sprite_entry. Deleting last in set. NOT SUPPOSED TO BE USED.");
        /*we automatically remove the last entry*/
zl_sprite * entry_rot = target;
zl_sprite * last_address = target;

while(last_address->NEXT)
        last_address = (zl_sprite *)last_address->NEXT;

destroy_bitmap(last_address->spr);

while(entry_rot->NEXT != (struct zl_sprite *)last_address)
        entry_rot = (zl_sprite *)entry_rot->NEXT;

entry_rot->NEXT=NULL;
return 0;
}

int free_zl_sprite(zl_sprite * target)
{
log_msg(3, "Spriteset level 0 function : free_zl_sprite. Freeing spriteset.");
zl_sprite * entry_rot = target;
zl_sprite * nextptr;

while(entry_rot)
        {
        nextptr = (zl_sprite *)entry_rot->NEXT;
        free(entry_rot);
        entry_rot = nextptr;
        }

return 0;
}    
