/*

Copyright (c) 1999, 2002-2005    Arthur Huillet

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    */


#include "all_inc.h"
#include <string.h>
#include <signal.h>
#include "zlog.h"





#ifdef ALLEGRO_LINUX
char * strsignal(int sig);

void zlog_signal_handler(int num)
{
        fprintf(stderr, "Got signal %i (%s), quitting !\n", num, strsignal(num));
        fprintf(stderr, "Emergency exit : 1-fin_instances()..");
        fin_instances(0);
        fprintf(stderr, "OK  2-destroy_bitmap()'s..");
        destroy_bitmap(game_frame[0]);
        destroy_bitmap(game_frame[1]);
        destroy_bitmap(ecranv[0]);
        destroy_bitmap(ecranv[1]);
        fprintf(stderr, "OK 3-free(stars)..");
        free(stars);
        fprintf(stderr, "OK 4-allegro_exit()..");
        allegro_exit();
        fprintf(stderr, "OK 5-exit_logfac()..");
        exit_logfac();
        fprintf(stderr, "OK\nEmergency exit procedure ended, now exit(10)\n");
        exit(10);
}
#endif


int main(int argc, char **argv)
{
int L, l;

FILE *test;




allegro_init();
install_keyboard();
install_mouse();
/*install_timer();*/
set_uformat(U_ASCII);

init_logfac();


open_newlog("zlog_log.txt");

/* first rule handles common end-user information*/
ruletoadd.filedest=0;
ruletoadd.debuglvl=1;
ruletoadd.log_action=LOGTO_STDOUT;
add_rule(ruletoadd);

/* second rule handles more precise information*/
ruletoadd.filedest=0;
ruletoadd.debuglvl=2;
ruletoadd.log_action=LOGTO_FILE;
add_rule(ruletoadd);

/*the third rule is only added if --debuglevel is specified */
ruletoadd.filedest=0;
ruletoadd.debuglvl=3;
ruletoadd.log_action=LOGTO_STDOUT;


log_msg(1,"Zlog initialisation");
switch(os_type){
	case OSTYPE_WIN95 : 
	case OSTYPE_WIN98 :
	case OSTYPE_WINME :
	case OSTYPE_WINNT : 
	case OSTYPE_WIN2000 :
	case OSTYPE_WINXP :
	page_flip=0; log_msg(1, "Disabling pageflipping ! (default - override with --do-page-flip)");
       /* use_hardconfig=1; log_msg(1,"Using hardcoded configuration ! (see --help)\n");*/
	break;
	case OSTYPE_LINUX : log_msg(1, "Detected Linux-like OS. Great !"); break;
		}

parse_commandline(argc, argv);
          


#ifdef ALLEGRO_LINUX
log_msg(1,"Setting up Zlog signal handler");
signal(SIGABRT, zlog_signal_handler);
signal(SIGFPE, zlog_signal_handler);
signal(SIGILL, zlog_signal_handler);
signal(SIGSEGV, zlog_signal_handler);
signal(SIGTERM, zlog_signal_handler);
signal(SIGINT, zlog_signal_handler);
signal(SIGQUIT, zlog_signal_handler);
#endif


log_msg(2, "Looking for configfile");
if(newconf[0])
    {
            if( strstr(newconf,"none"))
                    memset(config_file, 0, strlen(config_file));
            else
            {
                    log_msg(1, "Using alternate configuration file : %s", newconf);
                    memset(config_file,0,strlen(config_file));
                    strcpy(config_file,newconf);
            }
    }


if(config_file[0])
    {
    log_msg(2,"Checking if \"%s\" is present...",config_file);
    test = fopen(config_file,"r");
	if(test == NULL){
	    log_msg(0,"Unable to open configfile %s",config_file);
	    exit(-1);
	    }
	else{
	    fclose(test);
	    log_msg(2,"OK");
	    }
    }



log_msg(2,"Saving default font");    
original_font=font;

log_msg(1,"Parsing configfile");
retr_cfg(config_file);




log_msg(1, "Allocating console memory");
allocate_console_memory();
zl_console.console_size = 150;

log_msg(2,"Defining default resolution 800*600");    
if(!RESOL_X)
    RESOL_X=800;
if(!RESOL_Y)
    RESOL_Y=600;



log_msg(1,"Requesting refresh rate, color depth, then calling set_gfx_mode()");

set_color_depth(8);
log_msg(3,"Color depth requested : 8");
request_refresh_rate(85);
log_msg(3,"Refresh rate requested : 85Hz");


bpp=8;

if(ask_gfx)
	{
	log_msg(3,"set_gfx_mode(GFX_SAFE, 320, 240, 0, 0)");
	if (set_gfx_mode(GFX_SAFE, 320, 240, 0, 0) != 0) {
    	set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
    	allegro_message("Unable to set any graphic mode\n%s\n", allegro_error);
    	return 1;
   		}

	rectfill(screen,1,1,800,600,4);


	log_msg(2,"Calling gfx_mode_select_ex() !");
	if (!gfx_mode_select_ex(&gfxmode,(int*)&RESOL_X,(int*)&RESOL_Y,&bpp)) {
    	set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
  		allegro_message("Error setting graphics mode\n%s\n", allegro_error);
    	return 1;
   		}


	} /*ask_gfx*/
	
log_msg(1,"Requesting mode %i %i*%i %i bpp",gfxmode,RESOL_X,RESOL_Y, bpp);
 #ifdef ALLEGRO_MINGW32
if(gfxmode == GFX_GDI)
    page_flip=0;
#endif

set_color_depth(bpp);
#ifdef ALLEGRO_MINGW32

if( set_gfx_mode(gfxmode, RESOL_X, RESOL_Y, 0, 0) != 0)
   	{
   	log_msg(2,"set_gfx_mode(gfxmode, RESOL_X, RESOL_Y, 0, 0) failed, using another driver.");
   	if (set_gfx_mode(GFX_SAFE, RESOL_X, RESOL_Y, 0, 0) != 0) 
   	    {
   	    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
   	    allegro_message("Error setting graphics mode\n%s\n", allegro_error);
   	    return 1;
   	    }
   	}
#else

if( set_gfx_mode(gfxmode, RESOL_X, RESOL_Y, 0, 2*RESOL_Y) != 0)
   	{
   	log_msg(2,"set_gfx_mode(c, RESOL_X, RESOL_Y, 0, 2*RESOL_Y) failed, using another driver.");
   	if (set_gfx_mode(GFX_SAFE, RESOL_X, RESOL_Y, 0, 0) != 0) 
   	    {
   	    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
   	    allegro_message("Error setting graphics mode\n%s\n", allegro_error);
   	    return 1;
   	    }
   	}
#endif



log_msg(3,"set_gfx_mode() is okay ! Enjoy GFX :)");
log_msg(2,"Setting color conversion..");
set_color_conversion(COLORCONV_TOTAL | COLORCONV_KEEP_TRANS);
log_msg(1,"Now loading levelfile");
if(!strstr(level_file,"none"))
    {
    if(!open_lvl_file(level_file))
        {
        log_msg(2,"Parsing levelfile");
        if(register_level_objects())
                log_msg(0, "register_level_objects() seems to have aborted");
        if(parse_level_data())
                log_msg(0, "parse_level_data() seems to have aborted");
        close_lvl_file();
	log_msg(1,"Levelfile closed...");
        }
    else
        {
        perror("Opening level file ");
        exit(-1);
        }
    }

log_msg(2, "Generating background");
int backgenx;
int backgeny;
int stars_rot=0;
background_offset_x = 0;
background_offset_y = 0;
stars = (star *) calloc(1000, sizeof(star));
nombre_stars = 0;
for(backgenx=0; backgenx < 384; backgenx ++)
        for(backgeny = 0; backgeny < 384; backgeny ++)
                if(((rand()) & 0xFF) == 255 && ((rand()) & 0xFF) > 190) 
                        {
                        
                        if(stars_rot >= 1000)
                                break;
                        stars[stars_rot].x = backgenx;
                        stars[stars_rot].y = backgeny;
                        stars[stars_rot].color = rand() & ((1 << bpp) - 1);
                        stars_rot ++;
                        nombre_stars ++;
                                
                        }


log_msg(2, "Rendering platforms");
render_platforms();
update_liveplatforms_sprites();

log_msg(2,"Creating memory pages");
if(page_flip)
{
    log_msg(3,"Pages are video bitmaps");
    ecranv[0]=create_video_bitmap(RESOL_X,RESOL_Y);
    ecranv[1]=create_video_bitmap(RESOL_X,RESOL_Y);
}


else
{
    log_msg(3,"Pages are memory bitmaps");
    ecranv[0]=create_bitmap(RESOL_X,RESOL_Y);
    ecranv[1]=create_bitmap(RESOL_X,RESOL_Y);
}

if(!ecranv[0]&&!ecranv[1])
    {
    set_gfx_mode(GFX_TEXT,0,0,0,0);
    
    log_msg(0,"Error with bitmaps : %s",allegro_error);
    return 2;
    }
    
if(is_memory_bitmap(ecranv[0]))
    {
    log_msg(2,"Clearing bitmaps");
    clear_bitmap(ecranv[0]);
    clear_bitmap(ecranv[1]);
    }

log_msg(2,"Frame init.");
init_frame();

L=zlogframe.L;
l=zlogframe.l;

log_msg(2,"Creating subbitmaps");
game_frame[0] = create_sub_bitmap(ecranv[0], 1, 1, L, l);
game_frame[1] = create_sub_bitmap(ecranv[1], 1, 1, L, l);
log_msg(2,"Game_frame is okay");
console_frame[0] = create_sub_bitmap(game_frame[0], 1, 1, L, zl_console.console_size);
console_frame[1] = create_sub_bitmap(game_frame[1], 1, 1, L, zl_console.console_size);
log_msg(2, "Console_frame is okay");

if(!game_frame[0] && !game_frame[1])
    {
    set_gfx_mode(GFX_TEXT,0,0,0,0);
    
    log_msg(0,"Error with bitmaps : %s",allegro_error);
    return 3;
    }
    

if(is_memory_bitmap(game_frame[0]) && is_memory_bitmap(console_frame[0]))
    {
    log_msg(2,"Clearing subbitmaps");
    clear_bitmap(game_frame[0]);
    clear_bitmap(game_frame[1]);
    clear_bitmap(console_frame[0]);
    clear_bitmap(console_frame[1]);
    }



if(USE_TIMERS)
{
        log_msg(1,"Calling game()");
        game();
}
else
{
        log_msg(1,"Calling game_no_timers()");
        game_no_timers();
}


log_msg(2, "Free-ing memory");
fin_instances(0);
free(stars);
log_msg(2, "Destroying bitmaps");
log_msg(3, "Console frame subbitmap");
destroy_bitmap(console_frame[0]);
destroy_bitmap(console_frame[1]);
log_msg(3, "Game frame subbitmap");
destroy_bitmap(game_frame[0]);
destroy_bitmap(game_frame[1]);
log_msg(3, "Virtual screen");
destroy_bitmap(ecranv[0]);
destroy_bitmap(ecranv[1]);

/*allegro_message("This was Zlog version "VERSION". \n\nAs you may have seen, there is still much to do, and any help or feedback would be welcome.\nYou can contact me using ahuillet AT users.sourceforge.net. Thanks.\n");*/
log_msg(1,"Exiting Allegro");
allegro_exit();

log_msg(1,"Exiting logging facility then returning 0");
exit_logfac(); 
return 0;
}

END_OF_MAIN()

/*****************************************/

int leveledit()
{
/*leveledit doesn't use any interruption handler*/
/*it sucks anyway*/
int end_get_touche=0;
log_msg(2,"game() initiated");
init_player();
init_weapons();
init_bullets();
init_walls();


log_msg(2,"All objects are now defined ");

display_all();
log_msg(2,"First display...done !");

while(!end_get_touche){
    end_get_touche=main_loop();
    display_all();
    }

return 0;
}


/*************************************************/

void init_frame()
{
zlogframe.cadrehg.x=1;
zlogframe.cadrehg.y=1;


zlogframe.cadrebd.x=RESOL_X-1;
zlogframe.cadrebd.y=RESOL_Y-100;
zlogframe.L=abs(zlogframe.cadrehg.x-zlogframe.cadrebd.x);
zlogframe.l=abs(zlogframe.cadrehg.y-zlogframe.cadrebd.y);

GAMESCR_RESOL_X = zlogframe.L;
GAMESCR_RESOL_Y = zlogframe.l;

}

/*******************************************/

void init_player()
{
}

/******************************************/
void init_weapons()
{
int i;
    for(i=0;i<30;i++)
        {
        obj_db.arme_pj[i].damage=5;
        obj_db.arme_pj[i].largeur=25;
        obj_db.arme_pj[i].longueur=8;
        obj_db.arme_pj[i].speed=1;
        obj_db.arme_pj[i].range=RESOL_X;
        }
    
}

/***************************************/

void init_walls()
{
}

/**************************************/

void init_bullets()
{
/*
int y;
for(y=0; y < obj_db.nombre_perso; y++)
    memset(obj_db.coups_de_feu[y],0,MAXBLTS*sizeof(bullet));
*/
}

/***************************************************/

int get_leveledit_action()
{
get_keypress();
return 0;
}	

/***************************************************/	
	

	


void memory_error_exit()
{
 log_msg(0,"Error while allocating memory.");
 exit(-1);
 }
	
/********************************************************/



int alloue_objdb()
{
log_msg(1,"Allocating memory");

    
log_msg(3,  "Allocation obj_db.perso si nul");
if(obj_db.nombre_perso  && ! obj_db.perso)
        {
        obj_db.perso = (liveplayer *)calloc(obj_db.nombre_perso, sizeof(liveplayer));
        if(!obj_db.perso)
                        memory_error_exit();
        }
        
log_msg(3,  "Allocation obj_db.perso si nul");
if(obj_db.nombre_enemies && ! obj_db.enemies)
        {
        obj_db.enemies = (liveplayer *)calloc(obj_db.nombre_enemies, sizeof(liveplayer));
        if(!obj_db.enemies)
                memory_error_exit();
        }
        
log_msg(3,  "Allocation obj_db.walls si nul");
if(obj_db.nombre_walls && ! obj_db.walls)
        {
        obj_db.walls = (wall *)calloc(obj_db.nombre_walls, sizeof(wall));
        if(!obj_db.walls)
                memory_error_exit();
        platform_sprites = (BITMAP **)calloc(obj_db.nombre_walls, sizeof(BITMAP *));
        }

log_msg(3,  "Allocation obj_db.lwalls si nul");
if(obj_db.nombre_lwalls && ! obj_db.lwalls)
        {
        obj_db.lwalls = (livewall *)calloc(obj_db.nombre_lwalls,sizeof(livewall));
        if(!obj_db.lwalls)
                memory_error_exit();
        liveplatform_centralsprites = (BITMAP **)calloc(obj_db.nombre_lwalls, sizeof(BITMAP *));
        }
        
log_msg(3,  "Allocation obj_db.klines si nul");
if(obj_db.nombre_klines && ! obj_db.klines)
        {
        obj_db.klines = (killing_line *)calloc(obj_db.nombre_klines,sizeof(killing_line));
        if(!obj_db.klines)
                memory_error_exit();
        }
        
log_msg(3,  "Allocation obj_db.portals si nul");
if(obj_db.nombre_portals && ! obj_db.portals)
        {
        obj_db.portals = (portal *)calloc(obj_db.nombre_portals,sizeof(portal));
        if(!obj_db.portals)
                memory_error_exit();
        }

        
return 0;
}

/**************************/



void fin_instances(int target)
{

/*destroy only level-related structures*/        
if(platform_sprites)
        {
        for(int i = 0; i < obj_db.nombre_walls; i ++)
                if(platform_sprites[i])
                        {
                        destroy_bitmap(platform_sprites[i]);   
                        platform_sprites[i] = NULL;
                        }
        free(platform_sprites);
        platform_sprites = NULL;
        }
        
if(liveplatform_centralsprites)
        {
        for(int i = 0; i < obj_db.nombre_lwalls; i ++)
                {
                if(liveplatform_centralsprites[i])
                        {
                        destroy_bitmap(liveplatform_centralsprites[i]);   
                        liveplatform_centralsprites[i] = NULL;
                        }
                }
        free(liveplatform_centralsprites);               
        liveplatform_centralsprites = NULL;
        }


if(obj_db.perso)
        free(obj_db.perso);
if(obj_db.enemies)
        free(obj_db.enemies);
if(obj_db.walls)
        free(obj_db.walls);
if(obj_db.lwalls)
        free(obj_db.lwalls);
if(obj_db.klines)
        free(obj_db.klines);
if(obj_db.portals)
        free(obj_db.portals);


obj_db.perso = NULL;
obj_db.enemies = NULL;
obj_db.walls = NULL;
obj_db.lwalls = NULL;
obj_db.klines = NULL;
obj_db.portals= NULL;


                
if(target == 0) 
        /*destroy everything*/
        {
        for(int i=0; i < 15; i++)
                if(pl_kbinds[i])
                        {
                        free(pl_kbinds[i]);
                        pl_kbinds[i] = NULL;
                        }
        free_console();
        free_spritesetdb(spriteset_db);
        }
        
obj_db.nombre_perso = 0;
obj_db.nombre_enemies = 0;
obj_db.nombre_walls = 0;
obj_db.nombre_lwalls = 0;
obj_db.nombre_klines = 0;
obj_db.nombre_portals = 0;
}



