/*

Copyright (c) 2003-2004 Arthur Huillet 

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#ifndef SCHEDULE_H
#define SCHEDULE_H

#define MAX_SCHED_FNCTS 20
typedef struct{
void (*scheduled_fnct)(int, int, void *); /*the function to execute*/
int nbcycles;  /*number of cycles (ie how long )*/
int iparm;
void * pparm;
}schedule;

schedule functions_to_run[MAX_SCHED_FNCTS];
schedule disp_functions_to_run[MAX_SCHED_FNCTS];




/*Scheduler : the function that runs all the functions added to the scheduler*/
/*returns always 0 o*/
int scheduler();
int scheduler_disp();



/*AddFnct : adds a function to the scheduler list, provided there is enough place
in the array. Return -1 on fail, or the Function#*/
int add_scheduler_fnct(void (*FnctToAdd)(int, int, void *),int iparm, void * pparm, int how_long);
int add_scheduler_dispfnct(void (*FnctToAdd)(int, int, void *), int iparm, void * pparm, int how_long);


/*DelFnct : dels the function whose number is FunctionNB*/
int rem_scheduler_fnct(int FunctionNB);
int rem_scheduler_dispfnct(int FunctionNB);

/*SchedInfo : prints information about currently scheduled functions*/
int sched_info(int);
int dispsched_info(int);





#endif
