/*

Copyright (c) 2003-2004      Arthur Huillet

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    */
    
    
/* Command scheduler.*/
#include "all_inc.h"


#define SCHEDULER(FNCT_ARRAY) { int i;                           \
        for(i=0; i< MAX_SCHED_FNCTS; i++)                       \
                if(FNCT_ARRAY[i].nbcycles)                              \
                {                                                                               \
                FNCT_ARRAY[i].scheduled_fnct(FNCT_ARRAY[i].nbcycles, FNCT_ARRAY[i].iparm, FNCT_ARRAY[i].pparm); \
                FNCT_ARRAY[i].nbcycles--;                                               \
                }                                       \
                return 0;                       \
                }
        
        
        
int scheduler()
{
SCHEDULER(functions_to_run);
}

int scheduler_disp()
{
SCHEDULER(disp_functions_to_run);
}

#define ADD_SCHEDULER(FNCT_ARRAY) { int i;                              \
        log_msg(3,"AddFnct() : looking for free space in array...");  \
        for(i=0; i< MAX_SCHED_FNCTS; i++)                                               \
                if(!FNCT_ARRAY[i].nbcycles)                                                  \
                {                                                                                                       \
        log_msg(3,"AddFnct() : using position %i to store information", i);\
        FNCT_ARRAY[i].scheduled_fnct=FnctToAdd;                           \
        FNCT_ARRAY[i].nbcycles=how_long;                                                  \
        FNCT_ARRAY[i].iparm = iparm;                                                      \
        FNCT_ARRAY[i].pparm = pparm;                                                      \
        log_msg(3,"AddFnct() : added function, running %i cycles, iparm is %i, pparm is %s", how_long, iparm, pparm);\
        return i;\
        }\
        return -1;\
        }

int add_scheduler_fnct(void (*FnctToAdd)(int, int, void *),int iparm, void * pparm,int how_long)
{
ADD_SCHEDULER(functions_to_run);
}

int add_scheduler_dispfnct(void (*FnctToAdd)(int, int, void *),int iparm, void * pparm,int how_long)
{
ADD_SCHEDULER(disp_functions_to_run);
}

#define REM_SCHEDULER(FNCT_ARRAY) { if(FunctionNB>MAX_SCHED_FNCTS -1)\
        return -1;                                                                                                              \
        FNCT_ARRAY[FunctionNB].nbcycles=0;                                                                \
        return 0;                                                                                                                    \
        }

int rem_scheduler_fnct(int FunctionNB)
{
REM_SCHEDULER(functions_to_run);
}

int rem_scheduler_dispfnct(int FunctionNB)
{
REM_SCHEDULER(disp_functions_to_run);
}        

#define INFO_SCHEDULE(FNCT_ARRAY) { int sthdisp=0, i=0;\
for(i=0; i < MAX_SCHED_FNCTS; i++)\
	if(FNCT_ARRAY[i].nbcycles)\
	        {\
        	log_msg(DebugLvl,"[Function %i] will be run %i times, iparm %i, pparm %s",i,\
        	    FNCT_ARRAY[i].nbcycles, FNCT_ARRAY[i].iparm, FNCT_ARRAY[i].pparm);\
        	sthdisp=1;\
        	}\
\
if(!sthdisp)\
    log_msg(DebugLvl,"SchedInfo : nothing running..");\
return 0;\
        }
        
int sched_info(int DebugLvl)
{
INFO_SCHEDULE(functions_to_run);
}

int dispsched_info(int DebugLvl)
{
INFO_SCHEDULE(disp_functions_to_run);
}

