/*

Copyright (c) 2003-2005      Arthur Huillet


Permission is hereby granted, free of charge, to any person obtaining a copy of this software and 
associated documentation files (the "Software"), to deal in the Software without restriction, including
 without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is furnished to do so, 
 subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial 
portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE
 FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    */

#include <stdio.h> /*we need it for FILE * */


#ifndef OBJECTS_H
#define OBJECTS_H
#define VERSION "0.3.3"


/*********************************************************
configuration
**********************************************************/
/*keybinds names (getconf)*/
#define GAUCHE 1
#define DROITE 2
#define SAUT 3
#define CROUCH 4
#define TIR 5
#define RUN 6
#define CH_WEAP 9


/**********************************************************
objects parameters (flags but not only)
**********************************************************/
/*state stands for a state-related flag, ie realtime flag whereas
parms refers to an object parameter wich should not be modified
during game*/
/*used by all objects*/
#define EXISTS 1
/*used by all moving objects (players and livewalls)*/
#define DIRECTION 2

/*players only*/
#define ZL_PLAYER_UNUSED 0
#define ZL_PLAYER_HUMAN 1
#define ZL_PLAYER_ENNEMY 2
/*state*/
#define ZL_PLAYER_IDLE 1
#define ZL_PLAYER_JUMPING 2
#define ZL_PLAYER_JPRESSED 4
#define ZL_PLAYER_RUNNING 8
#define ZL_PLAYER_INVINCIBLE 16
#define ZL_SPRITE_ANIMATE 32
/*parms*/
/*this is the "mickey mousse" mode*/
#define ZL_ENNEMY_CLEVER 1 

/*used by *walls*/
/*parms*/
#define WL_IS_INVISIBLE 1

/*used only by livewalls*/
/*state*/
#define LWL_PAUSE_MVT 128 /*is the livewall currently paused*/
#define LWL_REDRAW 256 /*must redraw the livewall on next cycle*/
#define LWL_SZVAR_X 1024 /*positive increment of size x*/ 
#define LWL_SZVAR_Y 2048 /*same as above, y axis*/
#define INHIBIT_COLLDET 4096
/*parms*/
#define LWL_SIZE_VAR 256 /*size variation*/
#define LWL_CENTER_PL 512 /*if a size reducing is likely to make the player fall, center it*/
#define LWL_INVERT_CONTACT 1024 /*does it invert movement after having waited ?*/
#define LWL_NOMOVE 2048

#define SPR_REVERSE 1

/*this is not a flag. Added to _speed_ variable*/
#define ZL_DIVIDE_SPD 128

/***********************************************************
collision detection
**********************************************************/
#define NO_LEFT 4
#define NO_UP 8
#define NO_DOWN 16
#define NO_RIGHT 32


/*defines for unit_toggle_forbid()*/
#define FORBID 1
#define ALLOW 0
/********************/

/**screen scrolling**/
#define NO_SCROLL 0
#define SCROLL_UP 1
#define SCROLL_DOWN 2
#define SCROLL_RIGHT 3
#define SCROLL_LEFT 4

/*?????*/
#define DOWN 4
#define UP 5

/*number of bullets*/
#define MAXBLTS 35
/*deadzone size, in percent*/
#define DEADZONE_RATE 30

/*do not alter what follows, it is parsed by a script !!!!!!*/
/*do not even touch the comments ! 
YOU HAVE BEEN WARNED */

/*-=typedef structures=-*/


typedef struct{
        unsigned int x,y;
        } point;

typedef struct{
        float x,y;
        } speed; /*basically, this is a vector*/

typedef struct{
        unsigned int x,y;
        short int color;
        } star;


typedef struct{
        point cadrehg,cadrebd;
        unsigned short int L, l;
        } gamescreen;

typedef struct {
        struct zl_sprite * NEXT;
        struct zl_sprite * PREV;
        BITMAP * spr;
        } zl_sprite;
        
typedef zl_sprite ** sprset; /*a sprite set*/

typedef struct {
        char key[25];
        sprset dataset;
        struct sprset_entry * NEXT;
        int type;
        } sprset_entry; /*an entry in the db looks like this*/

typedef struct {
        short int mask; /*bitmask*/
        int parm[16][2]; /*paramtres associs*/
        } zignals_t;

typedef struct{
        int is_active;
        int armed;
        } effectors_t;

/*what is a weapon ? */
typedef struct{
unsigned short int damage;
unsigned char name[15];
unsigned short int longueur, largeur;
unsigned short int speed;
unsigned short int idling_for;
unsigned short int range;
}weapon;

/*do not alter what follows, it is parsed by a script !!!!!!*/
/*do not even touch the comments ! 
YOU HAVE BEEN WARNED */
/*-=AUTOCODE OBJECT LIST BEGINS HERE=-*/
/*-=_liveplayer_=-*/
typedef struct{
char no_xxx;
unsigned char dofire;
unsigned char direction; 
point refpt; 
unsigned short int xsize;
unsigned short int ysize;
unsigned short int speed;
float base_jumping_speed;
float max_jumping_speed;
short int state;
short int parms;
short int trigger_flagmask;
float add_x;
float add_y; 
float jtime;
speed current_spd;
speed moving_spd;
short int life;
int score;
char name[25];
char level_def[150];
char used; 
short int armenb;
int ref_pform;
float inert_max_speed_walk;
float inert_max_speed_run;
zignals_t zignals;
effectors_t effectors;
short int target; 
short int sprite_delay;
char spritecycling_parms;
char sprset_key[25];
/*-=ENDOFSTRUCT=-*/
/*not to be saved*/zl_sprite * current_sprite;
/*the same*/sprset spriteset;
}liveplayer;


/*this is a duplicate that is to be used for autocode. Sorry for the mess*/
/*-=_enemy_=-*/
/*typedef struct{
char no_xxx;
unsigned char dofire;
unsigned char direction; 
point refpt; 
unsigned short int xsize;
unsigned short int ysize;
unsigned short int speed;
float base_jumping_speed;
float max_jumping_speed;
short int state;
short int parms;
short int trigger_flagmask;
float add_x;
float add_y; 
float jtime;
speed current_spd;
speed moving_spd;
short int life;
int score;
char name[25];
char level_def[150];
char used; 
short int armenb;
int ref_pform;
float inert_max_speed_walk;
float inert_max_speed_run;
zignals_t zignals;
effectors_t effectors;
short int target;
short int sprite_delay;
char spritecycling_parms;
char sprset_key[25];
}liveplayer;*/
/*-=ENDOFSTRUCT=-*/

/*-=_livewall_=-*/
typedef struct{
/*reference point used for colldet and display*/
point refpt;
float add_x;
float add_y;
/*current size (may vary)*/
unsigned short int xsize;
unsigned short int ysize;
/*bitfields*/
short int state;
short int parms;
short int trigger_flagmask;
char no_xxx;
/*current speed (may vary)*/
unsigned short int speed;
/*used by cyclediv*/
unsigned short int idling_for;
/*moving direction for next cycle*/
char dx; 
char dy;
/*base point for movement, usually refpt*/
point base_mvt; 
short int mvt_xsize; 
short int mvt_ysize;
/*only one of these value is allowed, ie horizontal or vertical movement but NOT both
well, maybe later... I mean, for sure.*/
/*resistance to player inertia (frottement)*/
float resist_inert;
/*size variation speed, in full variation cycles by game loop*/
speed sizevarspd;
/*maximum  and minimum size - this is obviously not a point but the structure is appropriate*/
point max_size;
point min_size;
float size_add_x;
float size_add_y;
zignals_t zignals;
effectors_t effectors;
char template;
char spriteset[25];
/*-=ENDOFSTRUCT=-*/
/*we don't save those*/BITMAP ** sprite;
/**/BITMAP ** edgeleft;
/**/BITMAP ** edgeright;
}livewall;


/*-=_wall_=-*/
typedef struct{
point refpt;
unsigned short int xsize;
unsigned short int ysize;
float resist_inert;
short int state;
short int parms;
char spriteset[25];
/*-=ENDOFSTRUCT=-*/
/*no*/BITMAP ** sprite;
}wall;


/*-=_killing_line_=-*/
typedef struct{
point position;
int taille;
short int state;
char to_disp;
}killing_line;
/*-=ENDOFSTRUCT=-*/

/*-=_portal_=-*/
typedef struct{
point position;
unsigned short int xsize;
unsigned short int ysize;
char target_level[150];
char state;
}portal;
/*-=ENDOFSTRUCT=-*/



/*-=OBJ DATABASE BEGINS=-*/
typedef liveplayer enemy;
typedef struct{
liveplayer * perso;
int nombre_perso;
enemy  * enemies;
int nombre_enemies;
weapon arme_pj[30];
point screen_pos;
wall * walls;
int nombre_walls;
livewall * lwalls;
int nombre_lwalls;
killing_line * klines;
int nombre_klines;
portal * portals;
int nombre_portals;
}basededonnees;

/*-=AUTOCODE OBJECT LIST ENDS HERE=-*/


/***************
structures
**************/

gamescreen zlogframe; 
basededonnees obj_db;
BITMAP ** platform_sprites;
BITMAP ** liveplatform_centralsprites;

/**************
objets globaux
***************/
BITMAP *ecranv[2]; 
BITMAP *game_frame[2]; /*subbitmap*/
star * stars;
int nombre_stars;
PALETTE pal;
int MODE_DEBUG_ACTIF; /*are we debugging a player ? */
int CONSOLE_IS_ACTIVE;
int perso_to_debug; /*wich player do we debug ? */
int pform_to_debug;
int statsplayer; /* whose stats are we going to display ? */
short int *pl_kbinds[15]; /*keybindings*/
short int pl_with_kbinds; /*number of players with keybindings*/
short int pltoggle_ispressed_flag;
int delay_to_deadzone;
point last_mouse_pos;
int rel_mouse_pos_x;
int rel_mouse_pos_y;
int bpp;
int background_offset_x;
float add_bgoffsetx, add_bgoffsety;
int background_offset_y;
extern unsigned int RESOL_X; /*defined in zlog.c*/
extern unsigned int RESOL_Y;
extern unsigned int GAMESCR_RESOL_X; /*defined in zlog.c*/
extern unsigned int GAMESCR_RESOL_Y;

extern int page_num;





/*configuration file variables */
extern char config_file[250]; /*what is the configfile to use ?*/
extern char newconf[250]; /*new configfile specified by -C*/
extern char fontfile[250]; /*fontfile - not really used*/

/************************/


extern float gravite;


FONT * original_font; /*as we will alter the original font, must save a copy
somewhere*/
DATAFILE * fontdata; /*pointer to the font datafile - not really used by now*/



/*************
fonctions globales
*************/

int alloue_objdb(); /* memory allocation for the objects database - returns number of bytes allocated*/
void increment_speed_counter();


#endif
